package im.zego.zegoexpress.utils;


import android.os.Build;
import android.util.Log;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Objects;

import im.zego.zegoexpress.ZegoMediaPlayer;
import im.zego.zegoexpress.constants.ZegoPublishChannel;
import im.zego.zegoexpress.constants.ZegoRemoteDeviceState;
import im.zego.zegoexpress.constants.ZegoVideoFlipMode;
import im.zego.zegoexpress.entity.ZegoVideoEncodedFrameParam;
import im.zego.zegoexpress.entity.ZegoVideoFrameParam;

public class ZegoCallbackHelpers {

    private static final String TAG = "ZegoCallbackHelpers";

    static Method zegoMediaPlayerVideoHandlerOnVideoFrameMethod = null;
    static Method CustomVideoCaptureOnStartMethod = null;
    static Method CustomVideoCaptureOnStopMethod = null;
    static Method CustomVideoRenderOnCapturedVideoFrameRawDataMethod = null;
    static Method CustomVideoRenderOnCustomVideoRenderRemoteFrameDataMethod = null;
    static Method CustomVideoRenderOnRemoteVideoFrameEncodedDataMethod = null;
    static Method OnPlayerVideoSizeChangedMethod = null;
    static Method OnPublishVideoSizeChangedMethod = null;
    static Method OnPlayerRenderVideoFirstFrameMethod = null;
    static Method OnPlayerRecvVideoFirstFrameMethod = null;
    static Method OnRemoteCameraStateUpdateMethod = null;
    static Method OnPlayerRecvSEIMethodMethod = null;
    static Method OnPublisherCapturedVideoFirstFrameMethod = null;

    static {
        initVideoFrameMethod();
        initCaptureVideoFrameRawDataMethod();
        initCustomVideoRenderRemoteFrameDataMethod();
        initCustomVideoRenderOnRemoteVideoFrameEncodedDataMethod();
    }

    private static void initCustomVideoRenderOnRemoteVideoFrameEncodedDataMethod() {
        try {
            Class aClass = Class.forName("im.zego.zegoexpress.callback.IZegoCustomVideoRenderHandler");
            CustomVideoRenderOnRemoteVideoFrameEncodedDataMethod = aClass.getDeclaredMethod("onRemoteVideoFrameEncodedData", ByteBuffer.class, int.class, ZegoVideoEncodedFrameParam.class, long.class, String.class);
            CustomVideoRenderOnRemoteVideoFrameEncodedDataMethod.setAccessible(true);
        } catch (ClassNotFoundException e) {

        } catch (NoSuchMethodException e) {

        }
    }


    private static void initCustomVideoRenderRemoteFrameDataMethod() {

        Class iZegoMediaPlayerVideoHandler = null;
        try {
            iZegoMediaPlayerVideoHandler = Class.forName("im.zego.zegoexpress.callback.IZegoCustomVideoRenderHandler");
            CustomVideoRenderOnCustomVideoRenderRemoteFrameDataMethod = iZegoMediaPlayerVideoHandler.getDeclaredMethod("onRemoteVideoFrameRawData", ByteBuffer[].class, int[].class, ZegoVideoFrameParam.class, String.class);
            CustomVideoRenderOnCustomVideoRenderRemoteFrameDataMethod.setAccessible(true);
        } catch (ClassNotFoundException e) {

        } catch (NoSuchMethodException e) {

        }
    }

    private static void initCaptureVideoFrameRawDataMethod() {
        try {
            Class iZegoMediaPlayerVideoHandler = Class.forName("im.zego.zegoexpress.callback.IZegoCustomVideoRenderHandler");
            CustomVideoRenderOnCapturedVideoFrameRawDataMethod = iZegoMediaPlayerVideoHandler.getDeclaredMethod("onCapturedVideoFrameRawData", ByteBuffer[].class, int[].class, ZegoVideoFrameParam.class, ZegoVideoFlipMode.class, ZegoPublishChannel.class);
            CustomVideoRenderOnCapturedVideoFrameRawDataMethod.setAccessible(true);
        } catch (ClassNotFoundException e) {

        } catch (NoSuchMethodException e) {

        }
    }

    private static void initVideoFrameMethod() {
        try {
            Class iZegoMediaPlayerVideoHandler = Class.forName("im.zego.zegoexpress.callback.IZegoMediaPlayerVideoHandler");
            zegoMediaPlayerVideoHandlerOnVideoFrameMethod = iZegoMediaPlayerVideoHandler.getDeclaredMethod("onVideoFrame", ZegoMediaPlayer.class, ByteBuffer[].class, int[].class, ZegoVideoFrameParam.class);
            zegoMediaPlayerVideoHandlerOnVideoFrameMethod.setAccessible(true);
        } catch (ClassNotFoundException e) {

        } catch (NoSuchMethodException e) {

        }
    }


    public static void callMediaVideoFrameMethod(Object thiz, ZegoMediaPlayer mediaPlayer, ByteBuffer[] data, int[] dataLength, ZegoVideoFrameParam param) {
        try {
            if (zegoMediaPlayerVideoHandlerOnVideoFrameMethod == null) return;
            zegoMediaPlayerVideoHandlerOnVideoFrameMethod.invoke(thiz, mediaPlayer, data, dataLength, param);
        } catch (IllegalAccessException e) {

        } catch (InvocationTargetException e) {

        }
    }


    public static void callOnPlayerRenderVideoFirstFrameMethod(Object thiz, String streamID) {
        try {
            if (OnPlayerRenderVideoFirstFrameMethod == null) {
                OnPlayerRenderVideoFirstFrameMethod = thiz.getClass().getDeclaredMethod("onPlayerRenderVideoFirstFrame", String.class);
                OnPlayerRenderVideoFirstFrameMethod.setAccessible(true);
            }
            OnPlayerRenderVideoFirstFrameMethod.invoke(thiz, streamID);
        } catch (NoSuchMethodException e) {

        } catch (IllegalAccessException e) {

        } catch (InvocationTargetException e) {

        }
    }

    public static void callOnPlayerRecvVideoFirstFrameMethod(Object thiz, String streamID) {
        try {
            if (OnPlayerRecvVideoFirstFrameMethod == null) {
                OnPlayerRecvVideoFirstFrameMethod = thiz.getClass().getDeclaredMethod("onPlayerRecvVideoFirstFrame", String.class);
                OnPlayerRecvVideoFirstFrameMethod.setAccessible(true);
            }
            OnPlayerRecvVideoFirstFrameMethod.invoke(thiz, streamID);
        } catch (NoSuchMethodException e) {

        } catch (IllegalAccessException e) {

        } catch (InvocationTargetException e) {

        }
    }

    public static void callOnRemoteCameraStateUpdateMethod(Object thiz, String streamID, ZegoRemoteDeviceState state) {
        try {
            if (OnRemoteCameraStateUpdateMethod == null) {
                OnRemoteCameraStateUpdateMethod = thiz.getClass().getDeclaredMethod("onRemoteCameraStateUpdate", String.class, ZegoRemoteDeviceState.class);
                OnRemoteCameraStateUpdateMethod.setAccessible(true);
            }
            OnRemoteCameraStateUpdateMethod.invoke(thiz, streamID, state);
        } catch (NoSuchMethodException e) {

        } catch (IllegalAccessException e) {

        } catch (InvocationTargetException e) {

        }
    }

    public static void callCustomVideoCaptureOnStartMethod(Object thiz, ZegoPublishChannel channel) {
        try {
            if (CustomVideoCaptureOnStartMethod == null) {
                CustomVideoCaptureOnStartMethod = thiz.getClass().getDeclaredMethod("onStart", ZegoPublishChannel.class);
                CustomVideoCaptureOnStartMethod.setAccessible(true);
            }
            CustomVideoCaptureOnStartMethod.invoke(thiz, channel);
        } catch (NoSuchMethodException e) {

        } catch (IllegalAccessException e) {

        } catch (InvocationTargetException e) {

        }
    }

    public static void callCustomVideoCaptureOnStopMethod(Object thiz, ZegoPublishChannel channel) {
        try {
            if (CustomVideoCaptureOnStopMethod == null) {
                CustomVideoCaptureOnStopMethod = thiz.getClass().getDeclaredMethod("onStop", ZegoPublishChannel.class);
                CustomVideoCaptureOnStopMethod.setAccessible(true);
            }
            CustomVideoCaptureOnStopMethod.invoke(thiz, channel);
        } catch (NoSuchMethodException e) {

        } catch (IllegalAccessException e) {

        } catch (InvocationTargetException e) {

        }
    }

    public static void callOnPlayerRecvSEIMethodMethod(Object thiz, String streamID, byte[] data) {
        try {
            if (OnPlayerRecvSEIMethodMethod == null) {
                OnPlayerRecvSEIMethodMethod = thiz.getClass().getDeclaredMethod("onPlayerRecvSEI", String.class, byte[].class);
                OnPlayerRecvSEIMethodMethod.setAccessible(true);
            }
            OnPlayerRecvSEIMethodMethod.invoke(thiz, streamID, data);
        } catch (NoSuchMethodException e) {

        } catch (IllegalAccessException e) {

        } catch (InvocationTargetException e) {

        }
    }


    public static void callOnPublisherCapturedVideoFirstFrameMethod(Object thiz, ZegoPublishChannel channel) {
        try {
            if (OnPublisherCapturedVideoFirstFrameMethod == null) {
                OnPublisherCapturedVideoFirstFrameMethod = thiz.getClass().getDeclaredMethod("onPublisherCapturedVideoFirstFrame", ZegoPublishChannel.class);
                OnPublisherCapturedVideoFirstFrameMethod.setAccessible(true);
            }
            OnPublisherCapturedVideoFirstFrameMethod.invoke(thiz, channel);
        } catch (NoSuchMethodException e) {

        } catch (IllegalAccessException e) {

        } catch (InvocationTargetException e) {

        }
    }


    public static void callOnPlayerVideoSizeChangedMethod(Object thiz, String streamID, int width, int height) {
        try {
            if (OnPlayerVideoSizeChangedMethod == null) {
                OnPlayerVideoSizeChangedMethod = thiz.getClass().getDeclaredMethod("onPlayerVideoSizeChanged", String.class, int.class, int.class);
                OnPlayerVideoSizeChangedMethod.setAccessible(true);
            }
            OnPlayerVideoSizeChangedMethod.invoke(thiz, streamID, width, height);
        } catch (NoSuchMethodException e) {

        } catch (IllegalAccessException e) {

        } catch (InvocationTargetException e) {

        }
    }

    public static void callOnPublisherVideoSizeChangedMethod(Object thiz, int width, int height, ZegoPublishChannel channel) {
        try {
            if (OnPublishVideoSizeChangedMethod == null) {
                OnPublishVideoSizeChangedMethod = thiz.getClass().getDeclaredMethod("onPublisherVideoSizeChanged", int.class, int.class, ZegoPublishChannel.class);
                OnPublishVideoSizeChangedMethod.setAccessible(true);
            }
            OnPublishVideoSizeChangedMethod.invoke(thiz, width, height, channel);
        } catch (NoSuchMethodException e) {

        } catch (IllegalAccessException e) {

        } catch (InvocationTargetException e) {

        }
    }


    public static void callCustomVideoRenderOnCapturedVideoFrameRawDataMethod(Object thiz, ByteBuffer[] data, int[] dataLength, ZegoVideoFrameParam param, ZegoVideoFlipMode flipMode, ZegoPublishChannel channel) {
        try {
            if (CustomVideoRenderOnCapturedVideoFrameRawDataMethod == null) return;
            CustomVideoRenderOnCapturedVideoFrameRawDataMethod.invoke(thiz, data, dataLength, param, flipMode, channel);
        } catch (IllegalAccessException e) {

        } catch (InvocationTargetException e) {

        }
    }

    public static void callCustomVideoRenderOnCustomVideoRenderRemoteFrameDataMethod(Object thiz, ByteBuffer[] data, int[] dataLength, ZegoVideoFrameParam param, String streamID) {
        try {
            if (CustomVideoRenderOnCustomVideoRenderRemoteFrameDataMethod == null) return;
            CustomVideoRenderOnCustomVideoRenderRemoteFrameDataMethod.invoke(thiz, data, dataLength, param, streamID);
        } catch (IllegalAccessException e) {

        } catch (InvocationTargetException e) {
          
        }
    }



    public static void callCustomVideoRenderOnRemoteVideoFrameEncodedDataMethod(Object thiz, ByteBuffer buffers, int dataLen, ZegoVideoEncodedFrameParam param, long referenceTimeMillisecond, String streamID) {
        try {
            if (CustomVideoRenderOnRemoteVideoFrameEncodedDataMethod == null) return;
            CustomVideoRenderOnRemoteVideoFrameEncodedDataMethod.invoke(thiz, buffers, dataLen, param, referenceTimeMillisecond, streamID);
        } catch (IllegalAccessException e) {

        } catch (InvocationTargetException e) {

        }
    }
}
