package im.zego.zegoexpress.constants;

/** Reverberation preset value */
public enum ZegoReverbPreset {
    /** No Reverberation */
    NONE(0),
    /** Soft Room Mode */
    SOFT_ROOM(1),
    /** Large Room Mode */
    LARGE_ROOM(2),
    /** Concer Hall Mode */
    CONCER_HALL(3),
    /** Valley Mode */
    VALLEY(4);

    private int value;

    private ZegoReverbPreset(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ZegoReverbPreset getZegoReverbPreset(int value) {
        try {

            if (NONE.value == value) {
                return NONE;
            }

            if (SOFT_ROOM.value == value) {
                return SOFT_ROOM;
            }

            if (LARGE_ROOM.value == value) {
                return LARGE_ROOM;
            }

            if (CONCER_HALL.value == value) {
                return CONCER_HALL;
            }

            if (VALLEY.value == value) {
                return VALLEY;
            }

        } catch (Exception e) {
            throw new RuntimeException("The enumeration cannot be found");
        }
        return null;
    }
}