package im.zego.zegoexpress;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import android.app.Application;
import android.graphics.*;

/**
 * Zego MediaPlayer
 *
 * Yon can use ZegoMediaPlayer to play media resource files on the local or remote server, and can mix the sound of the media resource files that are played into the publish stream to achieve the effect of background music.
 */
public class ZegoMediaPlayer {

    /**
     * Create a media player instance object
     *
     * Currently, a maximum of 4 instances can be created, after which it will return null.
     *
     * @deprecated This interface is deprecated, please use the [createMediaPlayer] method in ZegoExpressEngine instead.
     * @return Media player instance, null will be returned when the maximum number is exceeded.
     */
    @Deprecated
    public static ZegoMediaPlayer createMediaPlayer(){
        return ZegoMediaPlayerJni.createMediaPlayer();
    }

    /**
     * Destroy a media player instance object
     *
     * @deprecated This interface is deprecated, please use the [destroyMediaPlayer] method in ZegoExpressEngine instead.
     */
    @Deprecated
    public void destroyMediaPlayer(){
        ZegoMediaPlayerJni.destroyMediaPlayer(this);
    }

    /**
     * Set event callback handler for media player
     *
     * You can change the player UI widget according to the related event callback of the media player
     *
     * @param handler Media player event callback object
     */
    public void setEventHandler(IZegoMediaPlayerEventHandler handler){
        ZegoMediaPlayerJni.setEventHandler(this, handler);
    }

    /**
     * Set audio callback handler
     *
     * You can set this callback to throw the audio data of the media resource file played by the media player
     *
     * @param handler Audio event callback object for media player
     */
    public void setAudioHandler(IZegoMediaPlayerAudioHandler handler){
        ZegoMediaPlayerJni.setAudioHandler(this, handler);
    }

    /**
     * Load media resource
     *
     * Yon can pass the absolute path of the local resource or the URL of the network resource
     *
     * @param path the absolute path of the local resource or the URL of the network resource
     * @param callback Notification of resource loading results
     */
    public void loadResource(String path, IZegoMediaPlayerLoadResourceCallback callback){
        ZegoMediaPlayerJni.loadResource(this, path, callback);
    }

    /**
     * Start playing
     *
     * You need to load resources before playing
     */
    public void start(){
        ZegoMediaPlayerJni.start(this);
    }

    /**
     * Stop playing
     */
    public void stop(){
        ZegoMediaPlayerJni.stop(this);
    }

    /**
     * Pause playing
     */
    public void pause(){
        ZegoMediaPlayerJni.pause(this);
    }

    /**
     * resume playing
     */
    public void resume(){
        ZegoMediaPlayerJni.resume(this);
    }

    /**
     * Set the specified playback progress
     *
     * Unit is millisecond
     *
     * @param millisecond Point in time of specified playback progress
     * @param callback the result notification of set the specified playback progress
     */
    public void seekTo(long millisecond, IZegoMediaPlayerSeekToCallback callback){
        ZegoMediaPlayerJni.seekTo(this, millisecond, callback);
    }

    /**
     * Whether to repeat playback
     *
     * @param enable repeat playback flag. The default is false.
     */
    public void enableRepeat(boolean enable){
        ZegoMediaPlayerJni.enableRepeat(this, enable);
    }

    /**
     * Whether to mix the player's sound into the stream being published
     *
     * @param enable Aux audio flag. The default is false.
     */
    public void enableAux(boolean enable){
        ZegoMediaPlayerJni.enableAux(this, enable);
    }

    /**
     * Whether to play locally silently
     *
     * If [enableAux] switch is turned on, there is still sound in the publishing stream. The default is false.
     *
     * @param mute Mute local audio flag, The default is false.
     */
    public void muteLocal(boolean mute){
        ZegoMediaPlayerJni.muteLocal(this, mute);
    }

    /**
     * Set player volume
     *
     * @param volume The range is 0 ~ 100. The default is 50.
     */
    public void setVolume(int volume){
        ZegoMediaPlayerJni.setVolume(this, volume);
    }

    /**
     * Set playback progress callback interval
     *
     * This interface can control the callback frequency of [onMediaPlayerPlayingProgress]. When the callback interval is set to 0, the callback is stopped. The default callback interval is 1s
     * This callback are not returned exactly at the set callback interval, but rather at the frequency at which the audio or video frames are processed to determine whether the callback is needed to call
     *
     * @param millisecond Interval of playback progress callback in milliseconds
     */
    public void setProgressInterval(long millisecond){
        ZegoMediaPlayerJni.setProgressInterval(this, millisecond);
    }

    /**
     * Get the current volume
     *
     * The range is 0 ~ 100. The default is 50
     */
    public int getVolume(){
        return ZegoMediaPlayerJni.getVolume(this);
    }

    /**
     * Get the total progress of your media resources
     *
     * You should load resource before invoking this API, otherwise the return value is 0
     *
     * @return Unit is millisecond
     */
    public long getTotalDuration(){
        return ZegoMediaPlayerJni.getTotalDuration(this);
    }

    /**
     * Get current playing progress
     *
     * You should load resource before invoking this API, otherwise the return value is 0
     */
    public long getCurrentProgress(){
        return ZegoMediaPlayerJni.getCurrentProgress(this);
    }

    /**
     * Get the current playback status
     */
    public ZegoMediaPlayerState getCurrentState(){
        return ZegoMediaPlayerJni.getCurrentState(this);
    }

    /**
     * Get media player index
     */
    public int getIndex(){
        return ZegoMediaPlayerJni.getIndex(this);
    }

    ZegoMediaPlayer(){
    }

}
