/*
 * Decompiled with CFR 0.152.
 */
package hu.kole.cleversectionviewadapter;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.PointF;
import android.os.Handler;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import hu.kole.cleversectionviewadapter.R;
import hu.kole.cleversectionviewadapter.draganddrop.DragInfo;
import hu.kole.cleversectionviewadapter.draganddrop.DragManager;
import hu.kole.cleversectionviewadapter.listeners.EndlessScrollListener;
import hu.kole.cleversectionviewadapter.model.BaseSectionItemModel;
import hu.kole.cleversectionviewadapter.model.BaseSectionModel;
import hu.kole.cleversectionviewadapter.model.LoaderSectionItem;
import hu.kole.cleversectionviewadapter.viewholder.BaseDragAndDropViewHolder;
import hu.kole.cleversectionviewadapter.viewholder.LoaderItemViewHolder;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseCleverSectionAdapter<TSection extends BaseSectionModel, TSectionItem extends BaseSectionItemModel, TItemViewHolder extends BaseDragAndDropViewHolder, THeaderViewHolder extends RecyclerView.ViewHolder, TFooterViewHolder extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int CORRECTION = 1;
    private static final double FILLED_SECTION_IN_PERCENT = 0.8;
    protected List<TSection> sections = new ArrayList<TSection>();
    private List<TSectionItem> allRowItems = new ArrayList<TSectionItem>();
    protected RecyclerView mConnectedRecyclerView;
    protected OnItemClickListener<TSectionItem> mOnSectionItemClickListener;
    protected EndlessScrollListener mEndlessScrollListener;
    private boolean isEndlessScrollListenerAdded = false;
    private boolean isLoadMoreProgressVisible = false;
    private boolean isDragAndDropEnabled = true;
    private final int SCROLL_AMOUNT;
    private DragManager dragManager;
    private int scrollState;
    private final PointF lastTouchPoint;
    private Handler mDelayHandler;
    private long mLastUpdateTime;
    private long DELAY_BETWEEN_UPDATES;

    public BaseCleverSectionAdapter(List<TSection> sectionList) {
        this.SCROLL_AMOUNT = (int)(2.0f * Resources.getSystem().getDisplayMetrics().density);
        this.scrollState = 0;
        this.lastTouchPoint = new PointF();
        this.mDelayHandler = new Handler();
        this.mLastUpdateTime = -1L;
        this.DELAY_BETWEEN_UPDATES = 0L;
        this.setHasStableIds(true);
        this.isLoadMoreProgressVisible = false;
        this.sections.clear();
        this.sections.addAll(sectionList);
        this.allRowItems.clear();
        this.allRowItems.addAll(this.copySectionsIntoRealObjects());
        this.addEndlessScrollListener();
    }

    protected final List<TSectionItem> copySectionsIntoRealObjects() {
        List<TSection> temp = this.cloneSectionList(this.sections);
        ArrayList sectionItems = new ArrayList();
        for (BaseSectionModel section : temp) {
            List sectionItemModels = section.getSectionItems().size() > 0 ? section.getSectionItems().subList(0, section.getSectionItemCount()) : section.getSectionItems();
            if (sectionItemModels == null) continue;
            if (section.isHeaderVisible() && !section.isHeaderItemAtFirstPosition()) {
                Object header = BaseSectionItemModel.createHeaderItem(section.getId());
                ((BaseSectionItemModel)header).setParentId(section.getId());
                sectionItemModels.add(0, header);
            }
            if (section.isFooterVisible() && !section.isFooterItemAtLastPosition()) {
                Object footer = BaseSectionItemModel.createFooterItem(section.getId());
                ((BaseSectionItemModel)footer).setParentId(section.getId());
                sectionItemModels.add(footer);
            }
            for (BaseSectionItemModel item : sectionItemModels) {
                item.setParentId(section.getId());
            }
            sectionItems.addAll(sectionItemModels);
        }
        return sectionItems;
    }

    public void updateDataSet(final List<TSection> data) {
        this.mDelayHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                BaseCleverSectionAdapter.this.isLoadMoreProgressVisible = false;
                BaseCleverSectionAdapter.this.sections.clear();
                BaseCleverSectionAdapter.this.sections.addAll(data);
                BaseCleverSectionAdapter.this.updateDataSetAfterChanged();
                BaseCleverSectionAdapter.this.addEndlessScrollListener();
            }
        }, this.calculateDelay());
    }

    public void updateDataSetAfterChanged() {
        this.allRowItems.clear();
        this.allRowItems.addAll(this.copySectionsIntoRealObjects());
        this.notifyDataSetChanged();
    }

    public synchronized long calculateDelay() {
        long currentTime = System.currentTimeMillis();
        if (this.mLastUpdateTime == -1L || currentTime > this.mLastUpdateTime) {
            this.mLastUpdateTime = currentTime + this.DELAY_BETWEEN_UPDATES;
            return 0L;
        }
        this.mLastUpdateTime += this.DELAY_BETWEEN_UPDATES;
        return this.mLastUpdateTime - currentTime + this.DELAY_BETWEEN_UPDATES;
    }

    public void setDelayBetweenUpdates(long delay) {
        this.DELAY_BETWEEN_UPDATES = delay;
    }

    public long getDelayBetweenUpdates() {
        return this.DELAY_BETWEEN_UPDATES;
    }

    public List<TSection> getDataSet() {
        return this.sections;
    }

    public final void addShowMoreProgress() {
        BaseSectionModel lastSection;
        if (!(this.isLoadMoreProgressVisible || this.sections.size() <= 0 || (lastSection = (BaseSectionModel)this.sections.get(this.sections.size() - 1)) == null || lastSection.getSectionItems().size() != 0 && ((BaseSectionItemModel)lastSection.getSectionItems().get(0)).getViewType() == -30000)) {
            LoaderSectionItem loader = new LoaderSectionItem();
            this.sections.add(loader);
            this.updateDataSetAfterChanged();
            this.isLoadMoreProgressVisible = true;
        }
    }

    private final void removeShowMoreProgress() {
        BaseSectionModel lastSection;
        if (this.isLoadMoreProgressVisible && this.sections.size() > 0 && (lastSection = (BaseSectionModel)this.sections.get(this.sections.size() - 1)) != null && lastSection.getSectionItems().size() > 0 && ((BaseSectionItemModel)lastSection.getSectionItems().get(0)).getViewType() == -30000) {
            this.sections.remove(this.sections.size() - 1);
            this.updateDataSetAfterChanged();
            this.isLoadMoreProgressVisible = false;
        }
    }

    public TSectionItem getItemAtPosition(int position) {
        if (this.allRowItems.size() == 0) {
            this.updateDataSetAfterChanged();
        }
        if (position < 0) {
            return null;
        }
        return (TSectionItem)((BaseSectionItemModel)this.allRowItems.get(position));
    }

    public synchronized void removeItem(TSectionItem content) {
        int index = -1;
        int section = -1;
        int j = 0;
        for (BaseSectionModel proposer : this.getDataSet()) {
            for (int i = 0; i < proposer.getSectionItems().size(); ++i) {
                if (!((BaseSectionItemModel)content).equals((BaseSectionItemModel)proposer.getSectionItems().get(i))) continue;
                index = i;
                section = j;
            }
            ++j;
        }
        if (section > -1 && index > -1) {
            ((BaseSectionModel)this.getDataSet().get(section)).getSectionItems().remove(index);
        }
        this.updateDataSetAfterChanged();
    }

    public synchronized void addItemsToSection(String sectionId, List<TSectionItem> items) {
        for (BaseSectionModel section : this.sections) {
            if (!section.getId().equalsIgnoreCase(sectionId)) continue;
            section.setSectionItems(items);
        }
        this.updateDataSetAfterChanged();
    }

    public final TSection getSectionOfItem(TSectionItem item) {
        for (BaseSectionModel section : this.sections) {
            if (!section.getId().equalsIgnoreCase(((BaseSectionItemModel)item).getParentId())) continue;
            return (TSection)section;
        }
        return null;
    }

    private final List<TSection> cloneSectionList(List<TSection> list) {
        ArrayList<BaseSectionModel> temp = new ArrayList<BaseSectionModel>();
        for (BaseSectionModel model : this.sections) {
            temp.add((BaseSectionModel)model.clone());
        }
        return temp;
    }

    private void initDragAndDrop(RecyclerView recyclerView) {
        this.mConnectedRecyclerView = recyclerView;
        this.dragManager = new DragManager(this.mConnectedRecyclerView, this);
        this.mConnectedRecyclerView.setOnDragListener((View.OnDragListener)this.dragManager);
        this.mConnectedRecyclerView.addOnItemTouchListener(new RecyclerView.OnItemTouchListener(){

            public boolean onInterceptTouchEvent(RecyclerView rv, MotionEvent e) {
                BaseCleverSectionAdapter.this.lastTouchPoint.set(e.getX(), e.getY());
                return false;
            }

            public void onRequestDisallowInterceptTouchEvent(boolean b) {
            }

            public void onTouchEvent(RecyclerView rv, MotionEvent e) {
            }
        });
        this.mConnectedRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(final RecyclerView recyclerView, int dx, int dy) {
                recyclerView.post(new Runnable(){

                    @Override
                    public void run() {
                        BaseCleverSectionAdapter.this.handleScroll(recyclerView);
                    }
                });
            }

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                BaseCleverSectionAdapter.this.scrollState = newState;
                switch (newState) {
                    case 0: {
                        BaseCleverSectionAdapter.this.handleScroll(recyclerView);
                        break;
                    }
                }
            }
        });
    }

    public long getItemId(int position) {
        return ((BaseSectionItemModel)this.getItemAtPosition(position)).getId().hashCode();
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.initDragAndDrop(recyclerView);
    }

    public int getItemCount() {
        return this.allRowItems.size();
    }

    public int getItemViewType(int position) {
        TSectionItem item = this.getItemAtPosition(position);
        if (((BaseSectionItemModel)item).getLayoutType() == ((BaseSectionItemModel)item).getViewType()) {
            return ((BaseSectionItemModel)item).getViewType() + 1;
        }
        return Math.abs(((BaseSectionItemModel)item).getViewType()) + Math.abs(((BaseSectionItemModel)item).getLayoutType()) + 1;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        int type = viewType - 1;
        if (type == -10000) {
            return this.onCreateHeaderViewHolder(parent, this.convertToLayoutType(viewType));
        }
        if (type == -20000) {
            return this.onCreateFooterViewHolder(parent, this.convertToLayoutType(viewType));
        }
        if (type == -30000) {
            return this.onCreateLoaderViewHolder(parent, this.convertToLayoutType(viewType));
        }
        return this.onCreateItemViewHolder(parent, this.convertToLayoutType(viewType));
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        TSectionItem item = this.getItemAtPosition(position);
        TSection section = this.getSectionOfItem(item);
        int viewType = ((BaseSectionItemModel)item).getViewType();
        if (viewType == -10000) {
            this.onBindHeaderViewHolder(holder, section, ((BaseSectionItemModel)item).getLayoutType());
        } else if (viewType == -20000) {
            this.onBindFooterViewHolder(holder, section, ((BaseSectionItemModel)item).getLayoutType());
        } else if (viewType == -30000) {
            this.onBindLoaderViewHolder((LoaderItemViewHolder)holder, section, ((BaseSectionItemModel)item).getLayoutType());
        } else {
            this.onBindItemViewHolder((BaseDragAndDropViewHolder)holder, item, ((BaseSectionItemModel)item).getLayoutType());
            ((BaseDragAndDropViewHolder)holder).setOnSectionItemClickListener(this.mOnSectionItemClickListener);
            if (this.isDragAndDropEnabled && this.isDraggingEnabledAtItemPosition(section, item, item)) {
                holder.itemView.setOnLongClickListener((View.OnLongClickListener)((BaseDragAndDropViewHolder)holder));
                holder.itemView.setVisibility(this.getDraggingId() == (long)((BaseSectionItemModel)item).getId().hashCode() ? 4 : 0);
                holder.itemView.postInvalidate();
            } else {
                holder.itemView.setOnLongClickListener(null);
            }
        }
    }

    private final int convertToLayoutType(int rawViewType) {
        int type = rawViewType - 1;
        if (type < 0) {
            return type;
        }
        return type % 10000;
    }

    public abstract THeaderViewHolder onCreateHeaderViewHolder(ViewGroup var1, int var2);

    public abstract TItemViewHolder onCreateItemViewHolder(ViewGroup var1, int var2);

    public abstract TFooterViewHolder onCreateFooterViewHolder(ViewGroup var1, int var2);

    public abstract void onBindHeaderViewHolder(THeaderViewHolder var1, TSection var2, int var3);

    public abstract void onBindItemViewHolder(TItemViewHolder var1, TSectionItem var2, int var3);

    public abstract void onBindFooterViewHolder(TFooterViewHolder var1, TSection var2, int var3);

    public LoaderItemViewHolder onCreateLoaderViewHolder(ViewGroup parent, int layoutType) {
        View view = LayoutInflater.from((Context)this.mConnectedRecyclerView.getContext()).inflate(R.layout.view_progress, parent, false);
        return new LoaderItemViewHolder(view);
    }

    public void onBindLoaderViewHolder(LoaderItemViewHolder holder, TSection section, int layoutType) {
    }

    public RecyclerView getConnectedRecyclerView() {
        return this.mConnectedRecyclerView;
    }

    public final void setOnSectionItemClickListener(OnItemClickListener listener) {
        this.mOnSectionItemClickListener = listener;
    }

    public final void setOnEndlessScrollListener(EndlessScrollListener listener) {
        this.mEndlessScrollListener = listener;
    }

    public final void setLoadMoreProgressEnabled(boolean isEnabled) {
        this.mEndlessScrollListener.setEndlessScrollEnabled(isEnabled);
    }

    public final void setDragAndDropEnabled(boolean isEnabled) {
        this.isDragAndDropEnabled = isEnabled;
    }

    public final void hideLoadMoreProgress() {
        this.removeShowMoreProgress();
    }

    private final void addEndlessScrollListener() {
        if (!this.isEndlessScrollListenerAdded && this.mEndlessScrollListener != null) {
            int countOfFilledSection = 0;
            for (BaseSectionModel section : this.sections) {
                if (section.getSectionItems().size() <= 0) continue;
                ++countOfFilledSection;
            }
            if ((double)this.sections.size() * 0.8 < (double)countOfFilledSection) {
                this.mConnectedRecyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this.mEndlessScrollListener);
                this.isEndlessScrollListenerAdded = true;
            }
        }
    }

    private View.OnClickListener handleOnItemClick() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                if (BaseCleverSectionAdapter.this.mOnSectionItemClickListener != null) {
                    int absolutePos = BaseCleverSectionAdapter.this.mConnectedRecyclerView.getChildViewHolder(v).getAdapterPosition();
                    BaseCleverSectionAdapter.this.mOnSectionItemClickListener.onItemClick(v, (BaseSectionItemModel)BaseCleverSectionAdapter.this.allRowItems.get(absolutePos));
                }
            }
        };
    }

    public boolean isDraggingEnabledAtItemPosition(TSection section, TSectionItem fromItem, TSectionItem toItem) {
        return true;
    }

    public void onDrop() {
    }

    public int getPositionForId(long id2) {
        int pos = 0;
        for (BaseSectionItemModel item : this.allRowItems) {
            if ((long)item.getId().hashCode() == id2) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public boolean move(int fromPosition, int toPosition) {
        TSection toSection;
        TSectionItem itemAtFromPosition = this.getItemAtPosition(fromPosition);
        TSectionItem itemAtToPosition = this.getItemAtPosition(toPosition);
        if (itemAtFromPosition == null || itemAtToPosition == null) {
            return false;
        }
        TSection fromSection = this.getSectionOfItem(itemAtFromPosition);
        if (((BaseSectionModel)fromSection).equals((BaseSectionModel)(toSection = this.getSectionOfItem(itemAtToPosition))) && ((BaseSectionItemModel)itemAtFromPosition).getViewType() == -40000 && ((BaseSectionItemModel)itemAtToPosition).getViewType() == -40000 && this.isDraggingEnabledAtItemPosition(toSection, itemAtFromPosition, itemAtToPosition)) {
            ((BaseSectionModel)toSection).getSectionItems().add(((BaseSectionModel)toSection).getItemIndexInSection(itemAtToPosition), ((BaseSectionModel)toSection).getSectionItems().remove(((BaseSectionModel)toSection).getItemIndexInSection(itemAtFromPosition)));
            this.allRowItems.add(toPosition, this.allRowItems.remove(fromPosition));
            return true;
        }
        return false;
    }

    public long getDraggingId() {
        return this.dragManager.getDraggingId();
    }

    public PointF getLastTouchPoint() {
        return new PointF(this.lastTouchPoint.x, this.lastTouchPoint.y);
    }

    public void handleDragScroll(RecyclerView rv, DragInfo dragInfo) {
        if (rv.getLayoutManager().canScrollHorizontally()) {
            if (rv.canScrollHorizontally(-1) && dragInfo.shouldScrollLeft()) {
                rv.scrollBy(-this.SCROLL_AMOUNT, 0);
                this.dragManager.clearNextMove();
            } else if (rv.canScrollHorizontally(1) && dragInfo.shouldScrollRight(rv.getWidth())) {
                rv.scrollBy(this.SCROLL_AMOUNT, 0);
                this.dragManager.clearNextMove();
            }
        } else if (rv.getLayoutManager().canScrollVertically()) {
            if (rv.canScrollVertically(-1) && dragInfo.shouldScrollUp()) {
                rv.scrollBy(0, -this.SCROLL_AMOUNT);
                this.dragManager.clearNextMove();
            } else if (rv.canScrollVertically(1) && dragInfo.shouldScrollDown(rv.getHeight())) {
                rv.scrollBy(0, this.SCROLL_AMOUNT);
                this.dragManager.clearNextMove();
            }
        }
    }

    private void handleScroll(RecyclerView recyclerView) {
        if (this.scrollState != 0) {
            return;
        }
        DragInfo lastDragInfo = this.dragManager.getLastDragInfo();
        if (lastDragInfo != null) {
            this.handleDragScroll(recyclerView, lastDragInfo);
        }
    }

    public static interface OnItemClickListener<TModelItem extends BaseSectionItemModel> {
        public void onItemClick(View var1, TModelItem var2);
    }
}

