/*
 * Decompiled with CFR 0.152.
 */
package hu.kole.cleversectionviewadapter.viewholder;

import android.graphics.Point;
import android.graphics.PointF;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import hu.kole.cleversectionviewadapter.BaseCleverSectionAdapter;
import hu.kole.cleversectionviewadapter.draganddrop.DragInfo;
import hu.kole.cleversectionviewadapter.draganddrop.NoForegroundShadowBuilder;
import hu.kole.cleversectionviewadapter.model.BaseSectionItemModel;

public class BaseDragAndDropViewHolder
extends RecyclerView.ViewHolder
implements View.OnLongClickListener,
View.OnClickListener {
    private final BaseCleverSectionAdapter<?, ?, ?, ?, ?> mAdapter;
    private BaseCleverSectionAdapter.OnItemClickListener<BaseSectionItemModel> mOnSectionItemClickListener;

    public BaseDragAndDropViewHolder(View itemView, BaseCleverSectionAdapter adapter) {
        super(itemView);
        this.mAdapter = adapter;
        itemView.setOnClickListener((View.OnClickListener)this);
    }

    public void setOnSectionItemClickListener(BaseCleverSectionAdapter.OnItemClickListener<BaseSectionItemModel> listener) {
        this.mOnSectionItemClickListener = listener;
    }

    public View.DragShadowBuilder getShadowBuilder(View itemView, Point touchPoint) {
        return new NoForegroundShadowBuilder(itemView, touchPoint);
    }

    public final void startDrag() {
        PointF touchPoint = this.mAdapter.getLastTouchPoint();
        int x = (int)(touchPoint.x - this.itemView.getX());
        int y = (int)(touchPoint.y - this.itemView.getY());
        this.startDrag(this.getShadowBuilder(this.itemView, new Point(x, y)));
    }

    public final void startDrag(View.DragShadowBuilder dragShadowBuilder) {
        Point shadowSize = new Point();
        Point shadowTouchPoint = new Point();
        dragShadowBuilder.onProvideShadowMetrics(shadowSize, shadowTouchPoint);
        this.itemView.startDrag(null, dragShadowBuilder, (Object)new DragInfo(this.getItemId(), shadowSize, shadowTouchPoint, this.mAdapter.getLastTouchPoint()), 0);
        this.mAdapter.notifyItemChanged(this.getAdapterPosition());
    }

    public boolean onLongClick(View v) {
        this.startDrag();
        return true;
    }

    public void onClick(View v) {
        int position = this.getAdapterPosition();
        if (this.mOnSectionItemClickListener != null && position > -1) {
            this.mOnSectionItemClickListener.onItemClick(v, (BaseSectionItemModel)this.mAdapter.getItemAtPosition(position));
        }
    }
}

