package hk.ids.gws.android.afragment.ui.fragment;

import android.support.annotation.AnimatorRes;

public interface IRootFragment {
    void setAnimations(@AnimatorRes int enterAnimation, @AnimatorRes int exitAnimation);

    @AnimatorRes
    int getEnterAnimation();

    @AnimatorRes
    int getExitAnimation();


    /**
     * Called when the parent has detected the user's press of the back
     * key, and the fragment should currently handle it.
     *
     * @return true if accept back action, false if not
     */
    boolean canBack();

    /**
     * Called when the parent has detected the user's press of the back
     * key, and the fragment should currently handle it.
     *
     * @return true if event consumed, false if not handled
     */
    boolean onBackPressed();

    /**
     * Called when the fragment is on top most or no longer top most,
     * it may not get called if setting is disabled
     */
    void onTopmostChanged(boolean topMost);

    boolean isTopMost();
}
