/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.serializer.GroupSerializerObjectArray;

public class SerializerStringAscii
extends GroupSerializerObjectArray<String> {
    @Override
    public void serialize(DataOutput2 out, String value) throws IOException {
        int size2 = value.length();
        out.packInt(size2);
        for (int i = 0; i < size2; ++i) {
            out.write(value.charAt(i));
        }
    }

    @Override
    public String deserialize(DataInput2 in, int available) throws IOException {
        int size2 = in.unpackInt();
        StringBuilder result = new StringBuilder(size2);
        for (int i = 0; i < size2; ++i) {
            result.append((char)in.readUnsignedByte());
        }
        return result.toString();
    }

    @Override
    public boolean isTrusted() {
        return true;
    }

    @Override
    public int hashCode(@NotNull String s2, int seed) {
        return STRING.hashCode(s2, seed);
    }
}

