/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import java.util.Comparator;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.serializer.SerializerLong;

public class SerializerLongDelta
extends SerializerLong {
    @Override
    public void serialize(DataOutput2 out, Long value) throws IOException {
        out.packLong(value);
    }

    @Override
    public Long deserialize(DataInput2 in, int available) throws IOException {
        return new Long(in.unpackLong());
    }

    @Override
    public void valueArraySerialize(DataOutput2 out, Object vals) throws IOException {
        long[] keys2 = (long[])vals;
        long prev = keys2[0];
        out.packLong(prev);
        for (int i = 1; i < keys2.length; ++i) {
            long curr = keys2[i];
            out.packLong(curr - prev);
            if (curr < prev) {
                throw new AssertionError((Object)"not sorted");
            }
            prev = curr;
        }
    }

    public long[] valueArrayDeserialize(DataInput2 in, int size2) throws IOException {
        return in.unpackLongArrayDeltaCompression(size2);
    }

    @Override
    public Long valueArrayBinaryGet(DataInput2 input, int keysLen, int pos) throws IOException {
        long a = 0L;
        while (pos-- >= 0) {
            a += input.unpackLong();
        }
        return a;
    }

    @Override
    public int valueArrayBinarySearch(Long key, DataInput2 input, int keysLen, Comparator comparator) throws IOException {
        if (comparator != this) {
            return super.valueArrayBinarySearch(key, input, keysLen, comparator);
        }
        long key2 = key;
        long from = 0L;
        for (int pos = 0; pos < keysLen; ++pos) {
            if (key2 > (from += input.unpackLong())) continue;
            input.unpackLongSkip(keysLen - pos - 1);
            return key2 == from ? pos : -(pos + 1);
        }
        return -(keysLen + 1);
    }

    @Override
    public int fixedSize() {
        return -1;
    }
}

