/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.eclipse.collections.impl.stack.mutable.primitive.LongArrayStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.mapdb.Store;
import org.mapdb.Utils;
import shadow.kotlin.Metadata;
import shadow.kotlin.Unit;
import shadow.kotlin.collections.LongIterator;
import shadow.kotlin.jvm.internal.ArrayIteratorsKt;
import shadow.kotlin.jvm.internal.DefaultConstructorMarker;
import shadow.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 D2\u00020\u0001:\u0001DB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0015\u001a\u00020\u0016J\r\u0010\u0017\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\u0016H\u0016J\b\u0010\u001a\u001a\u00020\u0016H\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0016J=\u0010\u001c\u001a\u00020\u0003\"\u0004\b\u0000\u0010\u001d2\u0006\u0010\u001e\u001a\u00020\u00112\b\u0010\u001f\u001a\u0004\u0018\u0001H\u001d2\b\u0010 \u001a\u0004\u0018\u0001H\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001d0\"H\u0016\u00a2\u0006\u0002\u0010#J$\u0010$\u001a\u00020\u0016\"\u0004\b\u0000\u0010\u001d2\u0006\u0010\u001e\u001a\u00020\u00112\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001d0\"H\u0016J\u0013\u0010%\u001a\u00020\u00032\b\u0010&\u001a\u0004\u0018\u00010'H\u0096\u0002J\u0010\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u0011H\u0004J\b\u0010*\u001a\u00020\u0011H\u0004J\b\u0010+\u001a\u00020\u0003H\u0016J+\u0010,\u001a\u0004\u0018\u0001H\u001d\"\u0004\b\u0000\u0010\u001d2\u0006\u0010\u001e\u001a\u00020\u00112\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001d0\"H\u0016\u00a2\u0006\u0002\u0010-J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0016J\b\u00101\u001a\u000202H\u0016J\u000e\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u000205J\u0010\u00106\u001a\u00020\u00162\u0006\u00104\u001a\u000205H\u0004J\b\u00107\u001a\u00020\u0011H\u0016J\b\u00108\u001a\u00020\u0011H\u0002J+\u00109\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u001d2\b\u0010:\u001a\u0004\u0018\u0001H\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001d0\"H\u0016\u00a2\u0006\u0002\u0010;J\u000e\u0010<\u001a\u00020\u00162\u0006\u0010=\u001a\u00020>J+\u0010?\u001a\u00020\u0014\"\u0004\b\u0000\u0010\u001d2\b\u0010:\u001a\u0004\u0018\u0001H\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001d0\"H\u0002\u00a2\u0006\u0002\u0010@J3\u0010A\u001a\u00020\u0016\"\u0004\b\u0000\u0010\u001d2\u0006\u0010\u001e\u001a\u00020\u00112\b\u0010:\u001a\u0004\u0018\u0001H\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001d0\"H\u0016\u00a2\u0006\u0002\u0010BJ\b\u0010C\u001a\u00020\u0016H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\nR\u0016\u0010\f\u001a\u0004\u0018\u00010\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u00118\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lorg/mapdb/StoreTrivial;", "Lorg/mapdb/Store;", "isThreadSafe", "", "(Z)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "freeRecids", "Lorg/eclipse/collections/impl/stack/mutable/primitive/LongArrayStack;", "isClosed", "()Z", "isReadOnly", "lock", "Ljava/util/concurrent/locks/ReadWriteLock;", "getLock", "()Ljava/util/concurrent/locks/ReadWriteLock;", "maxRecid", "", "records", "Lorg/eclipse/collections/impl/map/mutable/primitive/LongObjectHashMap;", "", "clear", "", "clearInternal", "clearInternal$mapdb", "close", "commit", "compact", "compareAndSwap", "R", "recid", "expectedOldRecord", "newRecord", "serializer", "Lorg/mapdb/Serializer;", "(JLjava/lang/Object;Ljava/lang/Object;Lorg/mapdb/Serializer;)Z", "delete", "equals", "other", "", "fileHeaderCheck", "header", "fileHeaderCompose", "fileLoad", "get", "(JLorg/mapdb/Serializer;)Ljava/lang/Object;", "getAllFiles", "", "", "getAllRecids", "Lshadow/kotlin/collections/LongIterator;", "loadFrom", "inStream", "Ljava/io/InputStream;", "loadFromInternal", "preallocate", "preallocateInternal", "put", "record", "(Ljava/lang/Object;Lorg/mapdb/Serializer;)J", "saveTo", "outStream", "Ljava/io/OutputStream;", "toByteArray", "(Ljava/lang/Object;Lorg/mapdb/Serializer;)[B", "update", "(JLjava/lang/Object;Lorg/mapdb/Serializer;)V", "verify", "Companion", "mapdb"})
public class StoreTrivial
implements Store {
    @Nullable
    private final ReadWriteLock lock;
    private final AtomicBoolean closed;
    private final LongArrayStack freeRecids;
    private volatile long maxRecid;
    private final LongObjectHashMap<byte[]> records;
    private final boolean isReadOnly = false;
    private final boolean isThreadSafe;
    private static final byte[] NULL_RECORD;
    public static final Companion Companion;

    @Nullable
    protected final ReadWriteLock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadFrom(@NotNull InputStream inStream) {
        Intrinsics.checkParameterIsNotNull(inStream, "inStream");
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            this.loadFromInternal(inStream);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    protected final void loadFromInternal(@NotNull InputStream inStream) {
        long size2;
        long recid2;
        Intrinsics.checkParameterIsNotNull(inStream, "inStream");
        Utils.INSTANCE.assertWriteLock(this.lock);
        this.fileHeaderCheck(new DataInputStream(inStream).readLong());
        long maxRecid2 = 0L;
        this.freeRecids.clear();
        this.records.clear();
        while ((recid2 = DataIO.unpackLong(inStream)) != 0L) {
            maxRecid2 = Math.max(maxRecid2, recid2);
            size2 = DataIO.unpackLong(inStream) - 1L;
            byte[] data = NULL_RECORD;
            if (size2 >= 0L) {
                data = new byte[(int)size2];
                DataIO.readFully(inStream, data);
            }
            this.records.put(recid2, data);
        }
        recid2 = 1L;
        size2 = maxRecid2;
        if (recid2 <= size2) {
            while (true) {
                if (!this.records.containsKey(recid2)) {
                    this.freeRecids.push(recid2);
                }
                if (recid2 == size2) break;
                ++recid2;
            }
        }
        this.maxRecid = maxRecid2;
        Utils this_$iv = Utils.INSTANCE;
        if (this_$iv.getLOG().isLoggable(Level.FINE)) {
            Level level = Level.FINE;
            Logger logger = this_$iv.getLOG();
            String string = "Loaded " + this.records.size() + " objects";
            logger.log(level, string);
        }
    }

    protected final void fileHeaderCheck(long header) {
        if (header >>> 56 != 74L) {
            throw (Throwable)new DBException.WrongFormat("Wrong file header, not MapDB file");
        }
        if ((header >>> 48 & 0xFFL) != 20L) {
            throw (Throwable)new DBException.WrongFormat("Wrong file header, not StoreTrivial file");
        }
        if ((header >>> 32 & 0xFFFFL) != 0L) {
            throw (Throwable)new DBException.NewMapDBFormat("Store was created with newer format, some new features are not supported");
        }
        if ((header & 0xFFFFFFFFL) != 0L) {
            throw (Throwable)new DBException.NewMapDBFormat("Store was created with newer format, some new features are not supported");
        }
    }

    protected final long fileHeaderCompose() {
        return 5337891458340880384L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveTo(@NotNull OutputStream outStream) {
        Intrinsics.checkParameterIsNotNull(outStream, "outStream");
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.readLock().lock();
        }
        try {
            new DataOutputStream(outStream).writeLong(this.fileHeaderCompose());
            MutableLongIterator recidIter = this.records.keySet().longIterator();
            while (recidIter.hasNext()) {
                long recid2 = recidIter.next();
                byte[] bytes = this.records.get(recid2);
                DataIO.packLong(outStream, recid2);
                long sizeToWrite = bytes == NULL_RECORD ? -1L : (long)bytes.length;
                DataIO.packLong(outStream, sizeToWrite + 1L);
                if (sizeToWrite < 0L) continue;
                outStream.write(bytes);
            }
            DataIO.packLong(outStream, 0L);
            Utils this_$iv = Utils.INSTANCE;
            if (this_$iv.getLOG().isLoggable(Level.FINE)) {
                Level level = Level.FINE;
                Logger logger = this_$iv.getLOG();
                String string = "Saved " + this.records.size() + " records";
                logger.log(level, string);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long preallocate() {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            long l = this.preallocateInternal();
            return l;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    private final long preallocateInternal() {
        long l;
        Utils.INSTANCE.assertWriteLock(this.lock);
        if (this.freeRecids.isEmpty()) {
            StoreTrivial storeTrivial = this;
            l = ++storeTrivial.maxRecid;
        } else {
            l = this.freeRecids.pop();
        }
        long recid2 = l;
        byte[] old = this.records.put(recid2, NULL_RECORD);
        if (old != null) {
            throw (Throwable)new DBException.DataCorruption("Old data were not null");
        }
        return recid2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> long put(@Nullable R record, @NotNull Serializer<R> serializer) {
        Intrinsics.checkParameterIsNotNull(serializer, "serializer");
        byte[] bytes = this.toByteArray(record, serializer);
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            long recid2 = this.preallocateInternal();
            byte[] old = this.records.put(recid2, bytes);
            if (Intrinsics.areEqual(old, NULL_RECORD) ^ true) {
                throw (Throwable)((Object)new AssertionError((Object)"wrong preallocation"));
            }
            long l = recid2;
            return l;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> void update(long recid2, @Nullable R record, @NotNull Serializer<R> serializer) {
        Intrinsics.checkParameterIsNotNull(serializer, "serializer");
        byte[] bytes = this.toByteArray(record, serializer);
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            byte[] byArray = this.records.get(recid2);
            if (byArray == null) {
                throw (Throwable)new DBException.GetVoid(recid2);
            }
            byte[] old = byArray;
            byte[] byArray2 = this.records.put(recid2, bytes);
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> boolean compareAndSwap(long recid2, @Nullable R expectedOldRecord, @Nullable R newRecord, @NotNull Serializer<R> serializer) {
        Intrinsics.checkParameterIsNotNull(serializer, "serializer");
        byte[] expectedOld = this.toByteArray(expectedOldRecord, serializer);
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            byte[] byArray = this.records.get(recid2);
            if (byArray == null) {
                throw (Throwable)new DBException.GetVoid(recid2);
            }
            byte[] old = byArray;
            if (expectedOldRecord == null && old != NULL_RECORD) {
                boolean bl = false;
                return bl;
            }
            if (!Arrays.equals(expectedOld, old)) {
                boolean bl = false;
                return bl;
            }
            this.records.put(recid2, this.toByteArray(newRecord, serializer));
            boolean bl = true;
            return bl;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> void delete(long recid2, @NotNull Serializer<R> serializer) {
        Intrinsics.checkParameterIsNotNull(serializer, "serializer");
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            byte[] byArray = this.records.get(recid2);
            if (byArray == null) {
                throw (Throwable)new DBException.GetVoid(recid2);
            }
            byte[] old = byArray;
            this.records.remove(recid2);
            this.freeRecids.push(recid2);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    @Override
    public void commit() {
    }

    @Override
    public void compact() {
    }

    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <R> R get(long recid2, @NotNull Serializer<R> serializer) {
        byte[] byArray;
        Intrinsics.checkParameterIsNotNull(serializer, "serializer");
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.readLock().lock();
        }
        try {
            byArray = this.records.get(recid2);
        }
        finally {
            if (lock$iv != null) {
                lock$iv.readLock().unlock();
            }
        }
        byte[] bytes = byArray;
        if (bytes == null) {
            throw (Throwable)new DBException.GetVoid(recid2);
        }
        if (bytes == NULL_RECORD) {
            return null;
        }
        DataInput2.ByteArray dataIn = new DataInput2.ByteArray(bytes);
        return serializer.deserialize(dataIn, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            this.clearInternal$mapdb();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    public final void clearInternal$mapdb() {
        Utils.INSTANCE.assertWriteLock(this.lock);
        this.records.clear();
        this.freeRecids.clear();
        this.maxRecid = 0L;
    }

    private final <R> byte[] toByteArray(R record, Serializer<R> serializer) {
        if (record == null) {
            return NULL_RECORD;
        }
        DataOutput2 out = new DataOutput2();
        serializer.serialize(out, record);
        byte[] byArray = out.copyBytes();
        Intrinsics.checkExpressionValueIsNotNull(byArray, "out.copyBytes()");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof StoreTrivial)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.readLock().lock();
        }
        try {
            if (this.records.size() != ((StoreTrivial)other).records.size()) {
                boolean bl = false;
                return bl;
            }
            MutableLongIterator recidIter = this.records.keySet().longIterator();
            while (recidIter.hasNext()) {
                byte[] b2;
                long recid2 = recidIter.next();
                byte[] b1 = this.records.get(recid2);
                if (b1 == (b2 = ((StoreTrivial)other).records.get(recid2))) continue;
                if (b1 != b2 && !Arrays.equals(b1, b2)) {
                    boolean bl = false;
                    return bl;
                }
                if (b1 != NULL_RECORD) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = this.freeRecids.equals(((StoreTrivial)other).freeRecids);
            return bl;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public LongIterator getAllRecids() {
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.lock;
        if (lock$iv != null) {
            lock$iv.readLock().lock();
        }
        try {
            LongIterator longIterator = ArrayIteratorsKt.iterator(this.records.keySet().toArray());
            return longIterator;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.readLock().unlock();
            }
        }
    }

    @Override
    public void verify() {
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public boolean fileLoad() {
        return false;
    }

    @Override
    @NotNull
    public Iterable<String> getAllFiles() {
        return new ArrayList();
    }

    @Override
    public boolean isThreadSafe() {
        return this.isThreadSafe;
    }

    public StoreTrivial(boolean isThreadSafe) {
        this.isThreadSafe = isThreadSafe;
        this.lock = Utils.INSTANCE.newReadWriteLock(this.isThreadSafe());
        this.closed = new AtomicBoolean(false);
        this.freeRecids = new LongArrayStack();
        this.records = new LongObjectHashMap();
    }

    public /* synthetic */ StoreTrivial(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    public StoreTrivial() {
        this(false, 1, null);
    }

    static {
        Companion = new Companion(null);
        NULL_RECORD = new byte[0];
    }

    @Override
    public void checkThreadSafe() {
        Store.DefaultImpls.checkThreadSafe(this);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/mapdb/StoreTrivial$Companion;", "", "()V", "NULL_RECORD", "", "mapdb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

