/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableLongStack;
import org.eclipse.collections.api.stack.primitive.MutableLongStack;
import org.eclipse.collections.impl.factory.primitive.LongStacks;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.stack.mutable.ArrayStack;
import org.eclipse.collections.impl.stack.mutable.primitive.SynchronizedLongStack;
import org.eclipse.collections.impl.stack.mutable.primitive.UnmodifiableLongStack;
import org.eclipse.collections.impl.stack.primitive.AbstractLongStack;

public class LongArrayStack
extends AbstractLongStack
implements MutableLongStack,
Externalizable {
    private static final long serialVersionUID = 1L;
    private transient LongArrayList delegate;

    public LongArrayStack() {
        this.delegate = new LongArrayList();
    }

    private LongArrayStack(int size2) {
        this.delegate = new LongArrayList(size2);
    }

    private LongArrayStack(long ... items) {
        this.delegate = new LongArrayList(items);
    }

    public static LongArrayStack newStackFromTopToBottom(long ... items) {
        LongArrayStack stack = new LongArrayStack(items.length);
        for (int i = items.length - 1; i >= 0; --i) {
            stack.push(items[i]);
        }
        return stack;
    }

    public static LongArrayStack newStackWith(long ... items) {
        return new LongArrayStack(items);
    }

    public static LongArrayStack newStack(LongIterable items) {
        LongArrayStack stack = new LongArrayStack(items.size());
        stack.delegate = LongArrayList.newList(items);
        return stack;
    }

    public static LongArrayStack newStackFromTopToBottom(LongIterable items) {
        LongArrayStack stack = new LongArrayStack(items.size());
        stack.delegate = LongArrayList.newList(items).reverseThis();
        return stack;
    }

    @Override
    protected LongArrayList getDelegate() {
        return this.delegate;
    }

    @Override
    public void push(long item) {
        this.delegate.add(item);
    }

    @Override
    public long pop() {
        this.checkEmptyStack();
        return this.delegate.removeAtIndex(this.delegate.size() - 1);
    }

    @Override
    public LongList pop(int count2) {
        this.checkPositiveValueForCount(count2);
        this.checkSizeLessThanCount(count2);
        if (count2 == 0) {
            return new LongArrayList(0);
        }
        LongArrayList subList = new LongArrayList(count2);
        while (count2 > 0) {
            subList.add(this.pop());
            --count2;
        }
        return subList;
    }

    @Override
    public MutableLongStack select(LongPredicate predicate) {
        return LongArrayStack.newStackFromTopToBottom(this.delegate.asReversed().select(predicate));
    }

    @Override
    public MutableLongStack reject(LongPredicate predicate) {
        return LongArrayStack.newStackFromTopToBottom(this.delegate.asReversed().reject(predicate));
    }

    @Override
    public <V> MutableStack<V> collect(LongToObjectFunction<? extends V> function) {
        return ArrayStack.newStackFromTopToBottom(this.delegate.asReversed().collect((LongToObjectFunction)function));
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public MutableLongList toSortedList() {
        return LongArrayList.newList(this).sortThis();
    }

    @Override
    public MutableLongStack asUnmodifiable() {
        return new UnmodifiableLongStack(this);
    }

    @Override
    public MutableLongStack asSynchronized() {
        return new SynchronizedLongStack(this);
    }

    @Override
    public ImmutableLongStack toImmutable() {
        return LongStacks.immutable.withAll(this.delegate);
    }

    @Override
    public LongArrayStack newEmpty() {
        return new LongArrayStack();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        LongIterator iterator2 = this.delegate.asReversed().longIterator();
        while (iterator2.hasNext()) {
            long each2 = iterator2.next();
            out.writeLong(each2);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size2 = in.readInt();
        long[] array = new long[size2];
        for (int i = size2 - 1; i >= 0; --i) {
            array[i] = in.readLong();
        }
        this.delegate = LongArrayList.newListWith(array);
    }
}

