/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.stack.primitive.ImmutableIntStack;
import org.eclipse.collections.api.stack.primitive.MutableIntStack;
import org.eclipse.collections.impl.factory.primitive.IntStacks;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.stack.mutable.ArrayStack;
import org.eclipse.collections.impl.stack.mutable.primitive.SynchronizedIntStack;
import org.eclipse.collections.impl.stack.mutable.primitive.UnmodifiableIntStack;
import org.eclipse.collections.impl.stack.primitive.AbstractIntStack;

public class IntArrayStack
extends AbstractIntStack
implements MutableIntStack,
Externalizable {
    private static final long serialVersionUID = 1L;
    private transient IntArrayList delegate;

    public IntArrayStack() {
        this.delegate = new IntArrayList();
    }

    private IntArrayStack(int size2) {
        this.delegate = new IntArrayList(size2);
    }

    private IntArrayStack(int ... items) {
        this.delegate = new IntArrayList(items);
    }

    public static IntArrayStack newStackFromTopToBottom(int ... items) {
        IntArrayStack stack = new IntArrayStack(items.length);
        for (int i = items.length - 1; i >= 0; --i) {
            stack.push(items[i]);
        }
        return stack;
    }

    public static IntArrayStack newStackWith(int ... items) {
        return new IntArrayStack(items);
    }

    public static IntArrayStack newStack(IntIterable items) {
        IntArrayStack stack = new IntArrayStack(items.size());
        stack.delegate = IntArrayList.newList(items);
        return stack;
    }

    public static IntArrayStack newStackFromTopToBottom(IntIterable items) {
        IntArrayStack stack = new IntArrayStack(items.size());
        stack.delegate = IntArrayList.newList(items).reverseThis();
        return stack;
    }

    @Override
    protected IntArrayList getDelegate() {
        return this.delegate;
    }

    @Override
    public void push(int item) {
        this.delegate.add(item);
    }

    @Override
    public int pop() {
        this.checkEmptyStack();
        return this.delegate.removeAtIndex(this.delegate.size() - 1);
    }

    @Override
    public IntList pop(int count2) {
        this.checkPositiveValueForCount(count2);
        this.checkSizeLessThanCount(count2);
        if (count2 == 0) {
            return new IntArrayList(0);
        }
        IntArrayList subList = new IntArrayList(count2);
        while (count2 > 0) {
            subList.add(this.pop());
            --count2;
        }
        return subList;
    }

    @Override
    public MutableIntStack select(IntPredicate predicate) {
        return IntArrayStack.newStackFromTopToBottom(this.delegate.asReversed().select(predicate));
    }

    @Override
    public MutableIntStack reject(IntPredicate predicate) {
        return IntArrayStack.newStackFromTopToBottom(this.delegate.asReversed().reject(predicate));
    }

    @Override
    public <V> MutableStack<V> collect(IntToObjectFunction<? extends V> function) {
        return ArrayStack.newStackFromTopToBottom(this.delegate.asReversed().collect((IntToObjectFunction)function));
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public MutableIntList toSortedList() {
        return IntArrayList.newList(this).sortThis();
    }

    @Override
    public MutableIntStack asUnmodifiable() {
        return new UnmodifiableIntStack(this);
    }

    @Override
    public MutableIntStack asSynchronized() {
        return new SynchronizedIntStack(this);
    }

    @Override
    public ImmutableIntStack toImmutable() {
        return IntStacks.immutable.withAll(this.delegate);
    }

    @Override
    public IntArrayStack newEmpty() {
        return new IntArrayStack();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        IntIterator iterator2 = this.delegate.asReversed().intIterator();
        while (iterator2.hasNext()) {
            int each2 = iterator2.next();
            out.writeInt(each2);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size2 = in.readInt();
        int[] array = new int[size2];
        for (int i = size2 - 1; i >= 0; --i) {
            array[i] = in.readInt();
        }
        this.delegate = IntArrayList.newListWith(array);
    }
}

