/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.set.primitive.FloatSet;
import org.eclipse.collections.api.set.primitive.ImmutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.FloatSets;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;
import org.eclipse.collections.impl.set.primitive.AbstractFloatSet;

public abstract class AbstractImmutableFloatSet
extends AbstractFloatSet
implements ImmutableFloatSet {
    @Override
    public ImmutableFloatSet newWith(float element) {
        return FloatHashSet.newSet(this).with(element).toImmutable();
    }

    @Override
    public ImmutableFloatSet newWithout(float element) {
        return FloatHashSet.newSet(this).without(element).toImmutable();
    }

    @Override
    public ImmutableFloatSet newWithAll(FloatIterable elements) {
        return FloatHashSet.newSet(this).withAll(elements).toImmutable();
    }

    @Override
    public ImmutableFloatSet newWithoutAll(FloatIterable elements) {
        return FloatHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    @Override
    public FloatSet freeze() {
        return this;
    }

    @Override
    public ImmutableFloatSet toImmutable() {
        return this;
    }

    @Override
    public RichIterable<FloatIterable> chunk(int size2) {
        if (size2 <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size2);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size2) {
                result.add(this);
            } else {
                FloatIterator iterator2 = this.floatIterator();
                while (iterator2.hasNext()) {
                    MutableFloatSet batch = FloatSets.mutable.empty();
                    for (int i = 0; i < size2 && iterator2.hasNext(); ++i) {
                        batch.add(iterator2.next());
                    }
                    result.add(batch.toImmutable());
                }
            }
        }
        return result.toImmutable();
    }
}

