/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.NoSuchElementException;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.primitive.ByteList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyByteIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;

public class ReverseByteIterable
extends AbstractLazyByteIterable {
    private final ByteList adapted;

    public ReverseByteIterable(ByteList newAdapted) {
        this.adapted = newAdapted;
    }

    public static ReverseByteIterable adapt(ByteList byteList) {
        return new ReverseByteIterable(byteList);
    }

    @Override
    public ByteIterator byteIterator() {
        return new ReverseByteIterator();
    }

    @Override
    public void each(ByteProcedure procedure) {
        ByteIterator iterator2 = this.byteIterator();
        while (iterator2.hasNext()) {
            procedure.value(iterator2.next());
        }
    }

    @Override
    public long sum() {
        return this.adapted.sum();
    }

    @Override
    public byte max() {
        return this.adapted.max();
    }

    @Override
    public byte min() {
        return this.adapted.min();
    }

    @Override
    public byte minIfEmpty(byte defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.min();
    }

    @Override
    public byte maxIfEmpty(byte defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.max();
    }

    @Override
    public double average() {
        return this.adapted.average();
    }

    @Override
    public double median() {
        return this.adapted.median();
    }

    @Override
    public byte[] toSortedArray() {
        return this.adapted.toSortedArray();
    }

    @Override
    public byte[] toArray() {
        byte[] results = new byte[this.adapted.size()];
        int index = 0;
        ByteIterator iterator2 = this.byteIterator();
        while (iterator2.hasNext()) {
            results[index] = iterator2.next();
            ++index;
        }
        return results;
    }

    @Override
    public boolean contains(byte value) {
        return this.adapted.contains(value);
    }

    @Override
    public boolean containsAll(byte ... source) {
        return this.adapted.containsAll(source);
    }

    @Override
    public boolean containsAll(ByteIterable source) {
        return this.adapted.containsAll(source);
    }

    @Override
    public int size() {
        return this.adapted.size();
    }

    @Override
    public boolean isEmpty() {
        return this.adapted.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.adapted.notEmpty();
    }

    @Override
    public MutableByteList toList() {
        return ByteArrayList.newList(this);
    }

    @Override
    public MutableByteSet toSet() {
        return ByteHashSet.newSet(this);
    }

    @Override
    public MutableByteBag toBag() {
        return ByteHashBag.newBag(this);
    }

    @Override
    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter(this);
    }

    private class ReverseByteIterator
    implements ByteIterator {
        private int currentIndex;

        private ReverseByteIterator() {
            this.currentIndex = ReverseByteIterable.this.adapted.size() - 1;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex != -1;
        }

        @Override
        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            byte next = ReverseByteIterable.this.adapted.get(this.currentIndex);
            --this.currentIndex;
            return next;
        }
    }
}

