/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class TakeIterator<T>
implements Iterator<T> {
    private final Iterator<T> iterator;
    private final int count;
    private int currentIndex;

    public TakeIterator(Iterable<T> iterable, int count2) {
        this(iterable.iterator(), count2);
    }

    public TakeIterator(Iterator<T> iterator2, int count2) {
        this.iterator = iterator2;
        this.count = count2;
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.count && this.iterator.hasNext();
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            ++this.currentIndex;
            return this.iterator.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from a take iterator");
    }
}

