/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.gradle.output;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ossindex.gradle.AuditExtensions;
import net.ossindex.gradle.audit.MavenPackageDescriptor;
import net.ossindex.gradle.input.GradleArtifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageTreeReporter {
    private static final Logger logger = LoggerFactory.getLogger(PackageTreeReporter.class);
    private final AuditExtensions settings;

    public PackageTreeReporter(AuditExtensions extensions) {
        this.settings = extensions;
    }

    public void reportDependencyTree(Set<GradleArtifact> topLevelArtifacts, Collection<MavenPackageDescriptor> descriptorsWithVulnerabilities) {
        if (!logger.isInfoEnabled()) {
            return;
        }
        Map<GradleArtifact, List<MavenPackageDescriptor>> artifactsWithVulnerabilities = this.getArtifactsContainingVulnerabilities(topLevelArtifacts, descriptorsWithVulnerabilities);
        artifactsWithVulnerabilities.forEach(this::printDependencyTree);
    }

    private Map<GradleArtifact, List<MavenPackageDescriptor>> getArtifactsContainingVulnerabilities(Set<GradleArtifact> artifacts, Collection<MavenPackageDescriptor> descriptors) {
        HashMap<GradleArtifact, List<MavenPackageDescriptor>> map2 = new HashMap<GradleArtifact, List<MavenPackageDescriptor>>();
        for (GradleArtifact artifact : artifacts) {
            for (MavenPackageDescriptor descriptor : descriptors) {
                if (!artifact.containsPackage(descriptor.getMavenVersionId())) continue;
                if (!map2.containsKey(artifact)) {
                    map2.put(artifact, new ArrayList());
                }
                ((List)map2.get(artifact)).add(descriptor);
            }
        }
        return map2;
    }

    private void printDependencyTree(GradleArtifact artifact, List<MavenPackageDescriptor> descriptors) {
        StringBuilder builder = new StringBuilder();
        builder.append(artifact.getFullDescription());
        if (this.hasVulnerabilities(artifact, descriptors)) {
            builder.append("\u001b[31m <-- vulnerability\u001b[0m");
        }
        builder.append("\n");
        for (GradleArtifact child : artifact.getChildren()) {
            this.printChild(child, descriptors, builder, "-");
        }
        logger.info(builder.toString());
    }

    private void printChild(GradleArtifact artifact, List<MavenPackageDescriptor> descriptors, StringBuilder builder, String prefix) {
        builder.append("|");
        builder.append(prefix);
        builder.append(artifact.getFullDescription());
        if (this.hasVulnerabilities(artifact, descriptors)) {
            builder.append("\u001b[31m <-- vulnerability\u001b[0m");
        }
        builder.append("\n");
        for (GradleArtifact child : artifact.getChildren()) {
            this.printChild(child, descriptors, builder, prefix + "-");
        }
    }

    private boolean hasVulnerabilities(GradleArtifact artifact, List<MavenPackageDescriptor> descriptors) {
        return descriptors.stream().filter(d -> !this.settings.isIgnored((MavenPackageDescriptor)d)).anyMatch(d -> d.getMavenVersionId().equals(artifact.getFullDescription()));
    }
}

