/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.gradle.output;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.ossindex.common.OssiVulnerability;
import net.ossindex.gradle.AuditExtensions;
import net.ossindex.gradle.audit.MavenPackageDescriptor;
import net.ossindex.gradle.input.GradleArtifact;
import net.ossindex.gradle.output.JunitXmlReportWriter;
import org.gradle.api.GradleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditResultReporter {
    private static final Logger logger = LoggerFactory.getLogger(AuditResultReporter.class);
    private static final String OSSI_VULN_PREFIX = "https://ossindex.sonatype.org/vuln/";
    private final Set<GradleArtifact> resolvedTopLevelArtifacts;
    private final AuditExtensions settings;
    private Set<GradleArtifact> allGradleArtifacts;
    private String currentVulnerableArtifact = null;
    ArrayList<String> currentVulnerabilityList = new ArrayList();
    private String currentVulnerabilityTotals = null;
    private String thisTask;
    private JunitXmlReportWriter junitXmlReportWriter;

    public AuditResultReporter(Set<GradleArtifact> resolvedTopLevelArtifacts, AuditExtensions settings, JunitXmlReportWriter junitXmlReportWriter, String thisTask) {
        this.resolvedTopLevelArtifacts = resolvedTopLevelArtifacts;
        this.settings = settings;
        this.junitXmlReportWriter = junitXmlReportWriter;
        this.thisTask = thisTask;
    }

    public void reportResult(Collection<MavenPackageDescriptor> results) {
        int unfilteredVulnerabilities = 0;
        int totalVunerabilities = 0;
        boolean failReported = false;
        int unExcludedVulnerabilities = this.getSumOfUnfilteredVulnerabilities(results);
        int excludedVulnerabilities = this.getSumOfFilteredVulnerabilities(results);
        int ignoredVulnerabilities = this.getIgnoredVulnerabilityCount(results);
        unfilteredVulnerabilities = unExcludedVulnerabilities - ignoredVulnerabilities;
        totalVunerabilities = unfilteredVulnerabilities + excludedVulnerabilities + ignoredVulnerabilities;
        if (totalVunerabilities == 0) {
            return;
        }
        this.currentVulnerabilityTotals = String.format("%s unignored (of %s total) vulnerabilities found", unfilteredVulnerabilities, totalVunerabilities);
        logger.error(this.currentVulnerabilityTotals);
        this.allGradleArtifacts = this.getAllDependencies();
        for (MavenPackageDescriptor descriptor : results) {
            if (descriptor.getVulnerabilities() == null) {
                logger.info("No vulnerabilities in " + descriptor.getMavenVersionId());
                continue;
            }
            if (this.settings.isIgnored(descriptor)) {
                logger.info(descriptor.getMavenVersionId() + " is ignored due to settings");
                continue;
            }
            if (descriptor.getVulnerabilityMatches() == 0) {
                logger.info("Vulnerabilities in " + descriptor.getMavenVersionId() + " are excluded due to settings");
                continue;
            }
            GradleArtifact importingGradleArtifact = null;
            try {
                importingGradleArtifact = this.findImportingArtifactFor(descriptor);
            }
            catch (GradleException gradleException) {
                // empty catch block
            }
            this.reportVulnerableArtifact(importingGradleArtifact, descriptor);
            this.reportIntroducedVulnerabilities(descriptor);
            this.writeTestcaseXml();
            failReported = true;
        }
        if (!failReported) {
            this.writeTestcaseXml();
        }
        if (unfilteredVulnerabilities > 0) {
            throw new GradleException("Too many vulnerabilities (" + unfilteredVulnerabilities + ") found.");
        }
    }

    private void writeTestcaseXml() {
        this.junitXmlReportWriter.updateJunitReport(this.currentVulnerabilityTotals, this.thisTask, this.currentVulnerableArtifact, this.currentVulnerabilityList);
    }

    private void reportVulnerableArtifact(GradleArtifact importingArtifact, MavenPackageDescriptor descriptor) {
        this.currentVulnerableArtifact = importingArtifact == null ? String.format("%s introduces %s which has %s vulnerabilities", descriptor.getMavenVersionId(), descriptor.getMavenVersionId(), descriptor.getVulnerabilityMatches()) : String.format("%s introduces %s which has %s vulnerabilities", importingArtifact.getFullDescription(), descriptor.getMavenVersionId(), descriptor.getVulnerabilityMatches());
        logger.error(this.currentVulnerableArtifact);
    }

    private int reportIntroducedVulnerabilities(MavenPackageDescriptor descriptor) {
        this.currentVulnerabilityList.clear();
        List<OssiVulnerability> vulns = descriptor.getVulnerabilities();
        vulns.forEach(v -> this.reportVulnerability(String.format("=> %s (see %s)", v.getTitle(), this.getUriString((OssiVulnerability)v))));
        return vulns.size();
    }

    private String getUriString(OssiVulnerability v) {
        return OSSI_VULN_PREFIX + v.getId();
    }

    private void reportVulnerability(String line) {
        logger.error(line);
        this.currentVulnerabilityList.add(line);
    }

    private GradleArtifact findImportingArtifactFor(MavenPackageDescriptor mavenPackageDescriptor) {
        return this.allGradleArtifacts.stream().filter(a -> a.getFullDescription().equals(mavenPackageDescriptor.getMavenVersionId())).map(GradleArtifact::getTopMostParent).findAny().orElseThrow(() -> new GradleException("Couldn't find importing artifact for " + mavenPackageDescriptor.getMavenVersionId()));
    }

    private Set<GradleArtifact> getAllDependencies() {
        HashSet<GradleArtifact> results = new HashSet<GradleArtifact>();
        for (GradleArtifact artifact : this.resolvedTopLevelArtifacts) {
            this.buildDependencies(results, artifact);
        }
        return results;
    }

    private void buildDependencies(Set<GradleArtifact> results, GradleArtifact parent) {
        results.add(parent);
        Set<GradleArtifact> children = parent.getChildren();
        for (GradleArtifact child : children) {
            if (results.contains(child)) continue;
            this.buildDependencies(results, child);
        }
    }

    private int getSumOfUnfilteredVulnerabilities(Collection<MavenPackageDescriptor> results) {
        return results.stream().mapToInt(MavenPackageDescriptor::getVulnerabilityMatches).sum();
    }

    private int getSumOfFilteredVulnerabilities(Collection<MavenPackageDescriptor> results) {
        int count2 = 0;
        for (MavenPackageDescriptor pkg : results) {
            count2 += pkg.getAllVulnerabilityCount() - pkg.getVulnerabilityMatches();
        }
        return count2;
    }

    private int getIgnoredVulnerabilityCount(Collection<MavenPackageDescriptor> results) {
        int count2 = 0;
        for (MavenPackageDescriptor pkg : results) {
            if (!this.settings.isIgnored(pkg)) continue;
            count2 += pkg.getVulnerabilityMatches();
        }
        return count2;
    }
}

