/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.gradle.audit;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ossindex.common.IPackageRequest;
import net.ossindex.common.OssIndexApi;
import net.ossindex.common.OssiPackage;
import net.ossindex.common.PackageCoordinate;
import net.ossindex.common.filter.IVulnerabilityFilter;
import net.ossindex.common.filter.VulnerabilityFilterFactory;
import net.ossindex.gradle.AuditExclusion;
import net.ossindex.gradle.AuditExtensions;
import net.ossindex.gradle.audit.MavenIdWrapper;
import net.ossindex.gradle.audit.MavenPackageDescriptor;
import net.ossindex.gradle.audit.Proxy;
import net.ossindex.gradle.input.GradleArtifact;
import org.gradle.api.GradleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyAuditor {
    private static final Logger logger = LoggerFactory.getLogger(DependencyAuditor.class);
    private final AuditExtensions config;
    private Map<OssiPackage, OssiPackage> parents = new HashMap<OssiPackage, OssiPackage>();
    private IPackageRequest request;

    public DependencyAuditor(AuditExtensions auditConfig, Set<GradleArtifact> gradleArtifacts, List<Proxy> proxies) {
        this.config = auditConfig;
        switch (proxies.size()) {
            case 0: {
                logger.info("Direct OSSI connection (" + proxies.size() + " proxies configured)");
                break;
            }
            default: {
                logger.info("Using proxy (" + proxies.size() + ")");
                for (Proxy proxy : proxies) {
                    logger.info("  * " + proxy);
                    OssIndexApi.addProxy(proxy.getScheme(), proxy.getHost(), proxy.getPort(), proxy.getUser(), proxy.getPassword());
                }
            }
        }
        this.request = OssIndexApi.createPackageRequest();
        this.configure();
        this.addArtifactsToAudit(gradleArtifacts);
    }

    private void configure() {
        if (this.config != null) {
            IVulnerabilityFilter filter = VulnerabilityFilterFactory.getInstance().createVulnerabilityFilter();
            Collection<AuditExclusion> exclusions = this.config.getExclusions();
            for (AuditExclusion exclusion : exclusions) {
                exclusion.apply(filter);
            }
            this.request.addVulnerabilityFilter(filter);
            if (!Strings.isNullOrEmpty(this.config.cache)) {
                File parentDir;
                File file = new File(this.config.cache);
                if (file.exists()) {
                    if (!file.isFile()) {
                        throw new GradleException("cache option must specify a file (" + this.config.cache + ")");
                    }
                    if (!file.canWrite()) {
                        throw new GradleException("cannot write to the specified cache file (" + this.config.cache + ")");
                    }
                }
                if ((parentDir = file.getParentFile()).exists()) {
                    if (!parentDir.canWrite()) {
                        throw new GradleException("cannot write to cache dir (" + this.config.cache + ")");
                    }
                    if (!parentDir.canExecute()) {
                        throw new GradleException("cannot access cache dir, need execute permissions on dir (" + this.config.cache + ")");
                    }
                } else if (!parentDir.mkdirs()) {
                    throw new GradleException("cannot create dir for cache (" + this.config.cache + ")");
                }
                this.request.setCacheFile(file.getAbsolutePath());
            }
            if (!Strings.isNullOrEmpty(this.config.user) && !Strings.isNullOrEmpty(this.config.token)) {
                this.request.setCredentials(this.config.user, this.config.token);
            }
            if (this.config.packagesPerRequest != null) {
                this.request.setMaximumPackagesPerRequest(this.config.packagesPerRequest);
            }
            if (this.config.cacheTimeout != null) {
                this.request.setCacheTimeout(this.config.cacheTimeout);
            }
        }
    }

    public Collection<MavenPackageDescriptor> runAudit() {
        try {
            HashSet<MavenPackageDescriptor> results = new HashSet<MavenPackageDescriptor>();
            Collection<OssiPackage> packages = this.request.run();
            for (OssiPackage pkg : packages) {
                OssiPackage parent;
                MavenPackageDescriptor mvnPkg = new MavenPackageDescriptor(pkg);
                if (this.parents.containsKey(pkg) && (parent = this.parents.get(pkg)) != null) {
                    mvnPkg.setParent(new MavenIdWrapper(parent));
                }
                if (mvnPkg.getAllVulnerabilityCount() <= 0) continue;
                results.add(mvnPkg);
            }
            return results;
        }
        catch (IOException e) {
            if (e.getMessage().contains("(429)")) {
                if (Strings.isNullOrEmpty(this.config.user)) {
                    throw new GradleException("Too many requests (429): Use OSS Index credentials for increased rate limit.", (Throwable)e);
                }
                if (Boolean.FALSE.equals(this.config.rateLimitAsError)) {
                    logger.info("Too many requests (429) trying to get audit results. Current results have been cached,");
                    logger.info("wait 60+ minutes then run again to audit more packages. If you run builds once a day");
                    logger.info("and always see this message, you may want to run the build more often or increase the");
                    logger.info("cache timeout to 48 or more hours.");
                    return Collections.emptyList();
                }
                throw new GradleException("Error trying to get audit results: " + e.getMessage(), (Throwable)e);
            }
            throw new GradleException("Error trying to get audit results: " + e.getMessage(), (Throwable)e);
        }
    }

    private void addArtifactsToAudit(Set<GradleArtifact> gradleArtifacts) {
        gradleArtifacts.forEach(this::addArtifact);
    }

    private void addArtifact(GradleArtifact gradleArtifact) {
        PackageCoordinate parentCoordinate = this.buildCoordinate(gradleArtifact);
        OssiPackage parent = this.request.add(Collections.singletonList(parentCoordinate));
        this.parents.put(parent, null);
        gradleArtifact.getAllChildren().forEach(c -> this.addPackageDependencies(parent, parentCoordinate, (GradleArtifact)c));
    }

    private void addPackageDependencies(OssiPackage parent, PackageCoordinate parentCoordinate, GradleArtifact gradleArtifact) {
        OssiPackage pkgDep = new OssiPackage("maven", gradleArtifact.getGroup(), gradleArtifact.getName(), gradleArtifact.getVersion());
        if (!this.parents.containsKey(pkgDep)) {
            PackageCoordinate childCoordinate = this.buildCoordinate(gradleArtifact);
            pkgDep = this.request.add(Arrays.asList(parentCoordinate, childCoordinate));
            this.parents.put(pkgDep, parent);
        }
    }

    private PackageCoordinate buildCoordinate(GradleArtifact gradleArtifact) {
        return PackageCoordinate.newBuilder().withFormat("maven").withNamespace(gradleArtifact.getGroup()).withName(gradleArtifact.getName()).withVersion(gradleArtifact.getVersion()).build();
    }

    private String toString(PackageCoordinate pkg) {
        return pkg.getNamespace() + ":" + pkg.getNamespace() + ":" + pkg.getName() + ":" + pkg.getVersion();
    }
}

