/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.gradle;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.ossindex.gradle.AuditExtensions;
import net.ossindex.gradle.audit.AuditorFactory;
import net.ossindex.gradle.audit.DependencyAuditor;
import net.ossindex.gradle.audit.MavenPackageDescriptor;
import net.ossindex.gradle.audit.Proxy;
import net.ossindex.gradle.input.ArtifactGatherer;
import net.ossindex.gradle.input.GradleArtifact;
import net.ossindex.gradle.output.AuditResultReporter;
import net.ossindex.gradle.output.JunitXmlReportWriter;
import net.ossindex.gradle.output.PackageTreeReporter;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OssIndexPlugin
implements Plugin<Project> {
    private JunitXmlReportWriter junitXmlReportWriter = new JunitXmlReportWriter();
    public static String junitReport = null;
    private static AuditExtensions settings = null;
    private static final Logger logger = LoggerFactory.getLogger(OssIndexPlugin.class);
    private List<Proxy> proxies = new LinkedList<Proxy>();
    private Project project = null;
    private AuditorFactory factory = new AuditorFactory();

    public void setAuditorFactory(AuditorFactory factory) {
        this.factory = factory;
    }

    public synchronized void apply(Project project) {
        logger.info("Apply OSS Index Plugin");
        this.project = project;
        project.getExtensions().create("audit", AuditExtensions.class, new Object[]{project});
        Task audit = project.task("audit");
        Proxy proxy = this.getProxy(project, "http");
        if (proxy != null) {
            this.proxies.add(proxy);
        }
        if ((proxy = this.getProxy(project, "https")) != null) {
            this.proxies.add(proxy);
        }
        audit.doLast(this::doAudit);
    }

    private Proxy getProxy(Project project, String scheme) {
        Object port;
        Proxy proxy = new Proxy();
        if (settings != null && scheme.equals(OssIndexPlugin.settings.proxyScheme) && OssIndexPlugin.settings.proxyHost != null) {
            proxy = new Proxy();
            proxy.setHost(OssIndexPlugin.settings.proxyHost);
            proxy.setPort(OssIndexPlugin.settings.proxyPort);
            proxy.setUser(OssIndexPlugin.settings.proxyUser);
            proxy.setPassword(OssIndexPlugin.settings.proxyPassword);
            proxy.setNonProxyHosts(OssIndexPlugin.settings.nonProxyHosts);
        }
        if (!proxy.isValid() && project.hasProperty(scheme + ".proxyHost")) {
            proxy = new Proxy();
            proxy.setHost((String)project.findProperty(scheme + ".proxyHost"));
            port = project.findProperty(scheme + ".proxyPort");
            proxy.setPort(port == null ? null : Integer.valueOf(Integer.parseInt((String)port)));
            proxy.setUser((String)project.findProperty(scheme + ".proxyUser"));
            proxy.setPassword((String)project.findProperty(scheme + ".proxyPassword"));
            proxy.setNonProxyHosts((String)project.findProperty(scheme + ".nonProxyHosts"));
        }
        if (!proxy.isValid() && project.hasProperty("systemProp." + scheme + ".proxyHost")) {
            proxy = new Proxy();
            proxy.setHost((String)project.findProperty("systemProp." + scheme + ".proxyHost"));
            port = project.findProperty("systemProp." + scheme + ".proxyPort");
            proxy.setPort(port == null ? null : Integer.valueOf(Integer.parseInt((String)port)));
            proxy.setUser((String)project.findProperty("systemProp." + scheme + ".proxyUser"));
            proxy.setPassword((String)project.findProperty("systemProp." + scheme + ".proxyPassword"));
            proxy.setNonProxyHosts((String)project.findProperty("systemProp." + scheme + ".nonProxyHosts"));
        }
        if (proxy.isValid()) {
            return proxy;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doAudit(Task task) {
        ArtifactGatherer gatherer;
        if (settings == null) {
            settings = this.getAuditExtensions(task.getProject());
        }
        String string = junitReport = settings != null ? OssIndexPlugin.settings.junitReport : null;
        if (settings != null) {
            this.junitXmlReportWriter.init(junitReport);
        }
        Set<GradleArtifact> gradleArtifacts = (gatherer = this.factory.getGatherer()) != null ? gatherer.gatherResolvedArtifacts(task.getProject()) : null;
        AuditExtensions auditConfig = this.getAuditExtensions(task.getProject());
        DependencyAuditor auditor = this.factory.getDependencyAuditor(auditConfig, gradleArtifacts, this.proxies);
        String tmpTask = this.project.getDisplayName().split(" ")[1].replaceAll("'", "") + ":audit";
        AuditResultReporter reporter = new AuditResultReporter(gradleArtifacts, this.getAuditExtensions(task.getProject()), this.junitXmlReportWriter, this.project.getDisplayName().split(" ")[1].replaceAll("'", "") + ":audit");
        logger.info(String.format("Found %s gradleArtifacts to audit", gradleArtifacts.size()));
        Collection<MavenPackageDescriptor> packagesWithVulnerabilities = auditor.runAudit();
        try {
            reporter.reportResult(packagesWithVulnerabilities);
        }
        catch (GradleException e) {
            if (this.shouldFailOnError(task.getProject())) {
                throw e;
            }
        }
        finally {
            PackageTreeReporter treeReporter = new PackageTreeReporter(auditConfig);
            treeReporter.reportDependencyTree(gradleArtifacts, packagesWithVulnerabilities);
            if (junitReport != null) {
                try {
                    this.junitXmlReportWriter.writeXmlReport(junitReport);
                    this.junitXmlReportWriter = null;
                }
                catch (Exception e) {
                    logger.error("ERROR: Failed to create JUnit Plugin report: " + e.getMessage());
                }
            }
        }
    }

    private boolean shouldFailOnError(Project project) {
        return this.getAuditExtensions((Project)project).failOnError;
    }

    private AuditExtensions getAuditExtensions(Project project) {
        return (AuditExtensions)project.getExtensions().getByName("audit");
    }
}

