/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.gradle;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.ossindex.gradle.AuditExclusion;
import net.ossindex.gradle.audit.MavenPackageDescriptor;
import org.gradle.api.Project;

public class AuditExtensions {
    private final Project project;
    public String junitReport;
    public boolean failOnError = true;
    public List<String> ignore = new ArrayList<String>();
    Collection<AuditExclusion> exclusion = new ArrayList<AuditExclusion>();
    public String proxyScheme;
    public String proxyHost;
    public Integer proxyPort;
    public String proxyUser;
    public String proxyPassword;
    public String nonProxyHosts;
    public String cache;
    public String user;
    public String token;
    public Integer packagesPerRequest;
    public Boolean rateLimitAsError;
    public Integer cacheTimeout;

    public AuditExtensions(Project project) {
        this.project = project;
    }

    public boolean isIgnored(MavenPackageDescriptor descriptor) {
        return this.isWholeArtifactIgnored(descriptor) || this.isSpecificVersionIgnored(descriptor);
    }

    private boolean isSpecificVersionIgnored(MavenPackageDescriptor descriptor) {
        return this.ignore.stream().anyMatch(ignored -> ignored.equals(descriptor.getMavenVersionId()));
    }

    private boolean isWholeArtifactIgnored(MavenPackageDescriptor descriptor) {
        return this.ignore.stream().anyMatch(ignored -> ignored.equals(descriptor.getMavenPackageId()));
    }

    public AuditExclusion exclusion(Closure closure) {
        AuditExclusion exclusion = (AuditExclusion)this.project.configure((Object)new AuditExclusion(), closure);
        this.exclusion.add(exclusion);
        return exclusion;
    }

    public Collection<AuditExclusion> getExclusions() {
        return this.exclusion;
    }
}

