/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.gradle;

import java.util.LinkedList;
import java.util.List;
import net.ossindex.common.PackageCoordinate;
import net.ossindex.common.filter.IVulnerabilityFilter;

public class AuditExclusion {
    private String vid;
    private List<String> packages;

    public String getVid() {
        return this.vid;
    }

    public void setVid(String vid) {
        this.vid = vid;
    }

    public List<String> getPackages() {
        return this.packages;
    }

    public void setPackages(List<String> packages) {
        this.packages = packages;
    }

    public void apply(IVulnerabilityFilter filter) {
        List<PackageCoordinate> list = this.getPackageList();
        if (this.vid == null) {
            filter.ignorePackage(list);
        } else {
            filter.ignoreVulnerability(list, this.vid);
        }
    }

    private List<PackageCoordinate> getPackageList() {
        LinkedList<PackageCoordinate> list = new LinkedList<PackageCoordinate>();
        if (this.packages != null) {
            for (String def : this.packages) {
                PackageCoordinate pkg = this.buildPackage(def);
                if (pkg == null) continue;
                list.add(pkg);
            }
        }
        return list;
    }

    private PackageCoordinate buildPackage(String def) {
        String[] tokens = def.split("/");
        if (tokens.length >= 2) {
            String[] nameTokens = tokens[1].split(":");
            PackageCoordinate.Builder builder = PackageCoordinate.newBuilder().withFormat("maven").withNamespace(tokens[0]).withName(nameTokens[0]);
            if (nameTokens.length > 1) {
                builder = builder.withVersion(nameTokens[1]);
            }
            return builder.build();
        }
        return null;
    }

    public String toString() {
        return "AuditExclusion{vid='" + this.vid + '\'' + ", packages=" + this.packages + '}';
    }

    public boolean hasPackage(String name) {
        if (this.packages != null) {
            for (String def : this.packages) {
                if (!def.startsWith(name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasVid(String myVid) {
        if (this.vid != null) {
            return this.vid.equals(myVid);
        }
        return false;
    }
}

