/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.entity.ErrorMessage;
import core.entity.InfoMessage;
import core.entity.Log;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0003\u001a*\u0010\b\u001a\u00020\u0003\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\n*\u0016\u0012\u0006\u0012\u0004\u0018\u0001H\n\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\f0\u000b\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u001a\u0014\u0010\u0011\u001a\u00020\u000e*\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u001a\f\u0010\u0012\u001a\u0004\u0018\u00010\u0007*\u00020\u0013\u001a\u0012\u0010\u0014\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0003\u001a\f\u0010\u0016\u001a\u0004\u0018\u00010\u0007*\u00020\u0007\u001a\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u0007*\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u001a\u0015\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001d*\u00020\u0007\u00a2\u0006\u0002\u0010\u001e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"COMMAND_TIMEOUT", "", "HUNDRED", "", "THOUSAND", "", "blankOrNum", "", "entryChildrenSum", "T", "V", "", "", "isNotGreaterThan", "", "", "number", "isNotLessThan", "readAndClose", "Ljava/io/InputStream;", "round", "scale", "run", "runCommand", "workingDir", "Ljava/io/File;", "log", "Lcore/entity/Log;", "toCommandArgs", "", "(Ljava/lang/String;)[Ljava/lang/String;", "BuildChecks"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncore/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,67:1\n1#2:68\n37#3,2:69\n76#4:71\n96#4,5:72\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncore/UtilsKt\n*L\n47#1:69,2\n65#1:71\n65#1:72,5\n*E\n"})
public final class UtilsKt {
    public static final double THOUSAND = 1000.0;
    public static final int HUNDRED = 100;
    public static final long COMMAND_TIMEOUT = 5L;

    public static final double round(double $this$round, int scale) {
        return new BigDecimal($this$round).setScale(scale, 4).doubleValue();
    }

    @Nullable
    public static final String runCommand(@NotNull String $this$runCommand, @NotNull File workingDir, @Nullable Log log) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$runCommand, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Log log2 = log;
        if (log2 != null) {
            log2.info(new InfoMessage("Running command: " + $this$runCommand).toString());
        }
        try {
            String string2;
            String it;
            String string3;
            String[] stringArray = UtilsKt.toCommandArgs($this$runCommand);
            Process proc = new ProcessBuilder(Arrays.copyOf(stringArray, stringArray.length)).directory(workingDir).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.PIPE).start();
            proc.waitFor(5L, TimeUnit.MINUTES);
            InputStream inputStream = proc.getErrorStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"proc.errorStream");
            String string4 = UtilsKt.readAndClose(inputStream);
            if (string4 != null) {
                it = string3 = string4;
                boolean bl = false;
                Log log3 = log;
                if (log3 != null) {
                    log3.info(new ErrorMessage(((Object)StringsKt.trim((CharSequence)it)).toString()).toString());
                }
            }
            InputStream inputStream2 = proc.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"proc.inputStream");
            String string5 = UtilsKt.readAndClose(inputStream2);
            if (string5 != null) {
                it = string3 = string5;
                boolean bl = false;
                Log log4 = log;
                if (log4 != null) {
                    log4.debug(new InfoMessage(((Object)StringsKt.trim((CharSequence)it)).toString()).toString());
                }
                string2 = string3;
            } else {
                string2 = null;
            }
            string = string2;
        }
        catch (IOException e) {
            e.printStackTrace();
            string = null;
        }
        return string;
    }

    @Nullable
    public static final String readAndClose(@NotNull InputStream $this$readAndClose) {
        Intrinsics.checkNotNullParameter((Object)$this$readAndClose, (String)"<this>");
        InputStream inputStream = $this$readAndClose;
        Charset charset = Charsets.UTF_8;
        Closeable closeable = inputStream;
        closeable = new InputStreamReader((InputStream)closeable, charset);
        int n = 8192;
        String v = TextStreamsKt.readText((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)));
        inputStream = $this$readAndClose;
        charset = Charsets.UTF_8;
        closeable = inputStream;
        closeable = new InputStreamReader((InputStream)closeable, charset);
        n = 8192;
        (closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)).close();
        return StringsKt.isBlank((CharSequence)v) ? null : v;
    }

    @NotNull
    public static final String[] toCommandArgs(@NotNull String $this$toCommandArgs) {
        Intrinsics.checkNotNullParameter((Object)$this$toCommandArgs, (String)"<this>");
        List parts = new ArrayList();
        Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher($this$toCommandArgs);
        while (m.find()) {
            String string = m.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"m.group(1)");
            parts.add(StringsKt.replace$default((String)string, (String)"\"", (String)"", (boolean)false, (int)4, null));
        }
        Collection $this$toTypedArray$iv = parts;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray;
    }

    @Nullable
    public static final String run(@NotNull String $this$run) {
        Intrinsics.checkNotNullParameter((Object)$this$run, (String)"<this>");
        String string = UtilsKt.runCommand($this$run, new File("."), null);
        return string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
    }

    public static final boolean isNotGreaterThan(@NotNull Number $this$isNotGreaterThan, @Nullable Number number) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotGreaterThan, (String)"<this>");
        if (number == null) {
            return true;
        }
        return $this$isNotGreaterThan.doubleValue() <= number.doubleValue();
    }

    public static final boolean isNotLessThan(@NotNull Number $this$isNotLessThan, @Nullable Number number) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotLessThan, (String)"<this>");
        if (number == null) {
            return true;
        }
        return $this$isNotLessThan.doubleValue() >= number.doubleValue();
    }

    @NotNull
    public static final String blankOrNum(int $this$blankOrNum) {
        return $this$blankOrNum == 0 ? "" : String.valueOf($this$blankOrNum);
    }

    /*
     * WARNING - void declaration
     */
    public static final <T, V> int entryChildrenSum(@NotNull Map<V, ? extends List<? extends T>> $this$entryChildrenSum) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$entryChildrenSum, (String)"<this>");
        Map<V, ? extends List<? extends T>> $this$flatMap$iv = $this$entryChildrenSum;
        boolean $i$f$flatMap = false;
        Map<V, ? extends List<? extends T>> map2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void var6_6 = $this$flatMapTo$iv$iv;
        Iterator iterator2 = var6_6.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator2.next();
            boolean bl = false;
            Iterable list$iv$iv = CollectionsKt.listOf((Object)((Collection)entry.getValue()).size());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv));
    }
}

