/*
 * Decompiled with CFR 0.152.
 */
package com.simonharrer.modernizer;

import com.simonharrer.modernizer.ModernizerPluginExtension;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.gaul.modernizer_maven_plugin.ModernizerWrapper;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskAction;

public class ModernizerTask
extends DefaultTask {
    @TaskAction
    public void modernizer() throws Exception {
        ModernizerPluginExtension extension = this.getExtension();
        if (extension.getJavaVersion() == null || extension.getJavaVersion().trim().isEmpty()) {
            extension.setJavaVersion(this.getJavaVersion());
        }
        SourceSetContainer sourceSets = (SourceSetContainer)this.getProject().getProperties().get("sourceSets");
        this.executeForSourceSet(extension, (SourceSet)sourceSets.getByName("main"));
        if (extension.isIncludeTestClasses()) {
            this.executeForSourceSet(extension, (SourceSet)sourceSets.getByName("test"));
        }
    }

    private void executeForSourceSet(ModernizerPluginExtension extension, SourceSet mainSourceSet) throws Exception {
        List classesDirs = mainSourceSet.getOutput().getClassesDirs().getFiles().stream().map(File::toPath).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).collect(Collectors.toList());
        for (Path classesDir : classesDirs) {
            List<Path> sourceDirs = mainSourceSet.getJava().getSrcDirs().stream().map(File::toPath).collect(Collectors.toList());
            ModernizerWrapper.execute(extension, classesDir, sourceDirs, this.getLogger());
        }
    }

    @Internal
    private String getJavaVersion() {
        return this.getProject().getProperties().get("targetCompatibility").toString();
    }

    @Internal
    private ModernizerPluginExtension getExtension() {
        ModernizerPluginExtension extension = (ModernizerPluginExtension)this.getProject().getExtensions().findByType(ModernizerPluginExtension.class);
        if (extension == null) {
            extension = new ModernizerPluginExtension();
        }
        return extension;
    }
}

