/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.sonos.listener;

import com.github.kilianB.sonos.SonosDevice;
import com.github.kilianB.sonos.listener.SonosEventListener;
import com.github.kilianB.sonos.model.QueueEvent;
import com.github.kilianB.uPnPClient.UPnPEvent;
import com.github.kilianB.uPnPClient.UPnPEventAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class MediaRendererQueueListener
extends UPnPEventAdapter {
    private static final Namespace upnpQueueNamespace = Namespace.getNamespace((String)"urn:schemas-sonos-com:metadata-1-0/Queue/");
    private final List<SonosEventListener> listeners;

    public MediaRendererQueueListener(String servicePath, SonosDevice device) {
        this.listeners = device.getEventListener();
    }

    @Override
    public void initialEventReceived(UPnPEvent event) {
    }

    @Override
    public void eventReceived(UPnPEvent event) {
        for (Element e : event.getProperties()) {
            List modifiedQueues = e.getChild("Event", upnpQueueNamespace).getChildren("QueueID", upnpQueueNamespace);
            ArrayList<QueueEvent> queuesAffected = new ArrayList<QueueEvent>();
            for (Element ee : modifiedQueues) {
                int queueId = Integer.parseInt(ee.getAttributeValue("val"));
                int updatedId = -1;
                Element updateID = ee.getChild("UpdateID", upnpQueueNamespace);
                if (updateID != null) {
                    updatedId = Integer.parseInt(updateID.getAttributeValue("val"));
                }
                QueueEvent queue = new QueueEvent(queueId, updatedId);
                Element curated = ee.getChild("Curated", upnpQueueNamespace);
                if (curated != null) {
                    queue.setCurated(Optional.of(Integer.parseInt(curated.getAttributeValue("val")) != 0));
                }
                queuesAffected.add(queue);
            }
            for (SonosEventListener listener : this.listeners) {
                listener.queueChanged(queuesAffected);
            }
        }
    }
}

