/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import com.squareup.javawriter.JavaWriter;
import fr.xebia.extras.selma.codegen.InOutType;
import java.io.IOException;
import java.util.EnumSet;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

public abstract class MappingSourceNode {
    MappingSourceNode body;
    MappingSourceNode child;

    abstract void writeNode(JavaWriter var1) throws IOException;

    public void write(JavaWriter writer) throws IOException {
        this.writeNode(writer);
        if (this.child != null) {
            this.child.write(writer);
        }
    }

    public void writeBody(JavaWriter writer) throws IOException {
        if (this.body != null) {
            this.body.write(writer);
        }
    }

    public MappingSourceNode lastChild() {
        MappingSourceNode ptr = this;
        while (ptr.child != null) {
            ptr = ptr.child;
        }
        return ptr;
    }

    public MappingSourceNode body(MappingSourceNode body) {
        if (this.body != null) {
            return this.child(body);
        }
        this.body = body;
        return body;
    }

    public MappingSourceNode child(MappingSourceNode child) {
        this.child = child;
        return child;
    }

    public static final MappingSourceNode blank() {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
            }
        };
    }

    public static MappingSourceNode mapMethod(final String inType, final String outType, final String name, final boolean override) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.emitJavadoc("Mapping method overridden by Selma", new Object[0]);
                if (override) {
                    writer.emitAnnotation(Override.class);
                }
                writer.beginMethod(outType, name, EnumSet.of(Modifier.PUBLIC, Modifier.FINAL), new String[]{inType, "in"});
                this.writeBody(writer);
                writer.emitStatement("return out", new Object[0]);
                writer.endMethod();
                writer.emitEmptyLine();
            }
        };
    }

    public static MappingSourceNode mapMethod(final InOutType inOutType, final String name, final boolean override) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.emitJavadoc("Mapping method overridden by Selma", new Object[0]);
                if (override) {
                    writer.emitAnnotation(Override.class);
                }
                if (inOutType.isOutPutAsParam()) {
                    writer.beginMethod(inOutType.out().toString(), name, EnumSet.of(Modifier.PUBLIC, Modifier.FINAL), new String[]{inOutType.in().toString(), "in", inOutType.out().toString(), "out"});
                } else {
                    writer.beginMethod(inOutType.out().toString(), name, EnumSet.of(Modifier.PUBLIC, Modifier.FINAL), new String[]{inOutType.in().toString(), "in"});
                }
                this.writeBody(writer);
                writer.emitStatement("return out", new Object[0]);
                writer.endMethod();
                writer.emitEmptyLine();
            }
        };
    }

    public static MappingSourceNode mapMethodNotFinal(final InOutType inOutType, final String name, final boolean override) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.emitJavadoc("Mapping method overridden by Selma", new Object[0]);
                if (override) {
                    writer.emitAnnotation(Override.class);
                }
                if (inOutType.isOutPutAsParam()) {
                    writer.beginMethod(inOutType.out().toString(), name, EnumSet.of(Modifier.PUBLIC), new String[]{inOutType.in().toString(), "in", inOutType.out().toString(), "out"});
                } else {
                    writer.beginMethod(inOutType.out().toString(), name, EnumSet.of(Modifier.PUBLIC), new String[]{inOutType.in().toString(), "in"});
                }
                this.writeBody(writer);
                writer.emitStatement("return out", new Object[0]);
                writer.endMethod();
                writer.emitEmptyLine();
            }
        };
    }

    public static MappingSourceNode controlNotNull(final String field, final boolean outPutAsParam) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.beginControlFlow(String.format("if (%s != null)", field), new Object[0]);
                this.writeBody(writer);
                if (outPutAsParam) {
                    writer.nextControlFlow("else", new Object[0]);
                    writer.emitStatement("out = null", new Object[0]);
                }
                writer.endControlFlow();
            }
        };
    }

    public static MappingSourceNode controlNull(final String field) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.beginControlFlow(String.format("if (%s == null)", field), new Object[0]);
                this.writeBody(writer);
                writer.endControlFlow();
            }
        };
    }

    public static MappingSourceNode controlNullElse() {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.beginControlFlow("else", new Object[0]);
                this.writeBody(writer);
                writer.endControlFlow();
            }
        };
    }

    public static MappingSourceNode set(final String outField, final String inField) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.emitStatement("%s(%s)", new Object[]{outField, inField});
            }
        };
    }

    public static MappingSourceNode assign(final String outField, final String inField) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.emitStatement("%s = %s", new Object[]{outField, inField});
            }
        };
    }

    public static MappingSourceNode assignOutPrime() {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.emitStatement("out = in", new Object[0]);
            }
        };
    }

    public static MappingSourceNode declareOut(final TypeMirror outType) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.emitStatement("%s out %s", new Object[]{outType, outType.getKind().isPrimitive() ? "= fr.xebia.extras.selma.SelmaConstants.DEFAULT_" + (Object)((Object)outType.getKind()) : "= null"});
            }
        };
    }

    public static MappingSourceNode notSupported(final String message) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.emitJavadoc("Throw notSupportedExeption because we failed to generate the mapping code: \n" + message, new Object[0]);
                writer.emitStatement("throw new UnsupportedOperationException(\"%s\")", new Object[]{message});
            }
        };
    }

    public static MappingSourceNode mapArray(final String indexVar, final String inField) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.beginControlFlow(String.format("for (int %s = 0 ; %s < %s.length; %s++)", indexVar, indexVar, inField, indexVar), new Object[0]);
                this.writeBody(writer);
                writer.endControlFlow();
            }
        };
    }

    public static MappingSourceNode mapArrayBis(final String indexVar, final String totalCount) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.beginControlFlow(String.format("for (int %s = 0 ; %s < %s; %s++)", indexVar, indexVar, totalCount, indexVar), new Object[0]);
                this.writeBody(writer);
                writer.endControlFlow();
            }
        };
    }

    public static MappingSourceNode mapCollection(final String itemVar, final String in, final String inField) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.beginControlFlow(String.format("for (%s %s : %s)", in, itemVar, inField), new Object[0]);
                this.writeBody(writer);
                writer.endControlFlow();
            }
        };
    }

    public static MappingSourceNode mapMap(final String itemVar, final String keyType, final String valueType, final String inField) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.beginControlFlow(String.format("for (java.util.Map.Entry<%s,%s> %s : %s.entrySet())", keyType, valueType, itemVar, inField), new Object[0]);
                this.writeBody(writer);
                writer.endControlFlow();
            }
        };
    }

    public static MappingSourceNode mapEnumBlock(final String inField) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.beginControlFlow(String.format("switch (%s)", inField), new Object[0]);
                this.writeBody(writer);
                writer.endControlFlow();
            }
        };
    }

    public static MappingSourceNode mapEnumCase(final String value) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.beginControlFlow(String.format("case %s : ", value), new Object[0]);
                this.writeBody(writer);
                writer.emitStatement("break", new Object[0]);
                writer.endControlFlow();
            }
        };
    }

    public static MappingSourceNode mapDefaultCase() {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.beginControlFlow(" default : ", new Object[0]);
                this.writeBody(writer);
                writer.emitStatement("break", new Object[0]);
                writer.endControlFlow();
            }
        };
    }

    public static MappingSourceNode statement(final String statement) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.emitStatement(statement, new Object[0]);
            }
        };
    }

    public static MappingSourceNode instantiateOut(final InOutType inOutType, final String params) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                if (inOutType.isOutPutAsParam()) {
                    writer.beginControlFlow("if (out == null)", new Object[0]);
                    writer.emitStatement("out = new %s(%s)", new Object[]{inOutType.out().toString(), params});
                    writer.endControlFlow();
                } else {
                    writer.emitStatement("out = new %s(%s)", new Object[]{inOutType.out().toString(), params});
                }
            }
        };
    }

    public static MappingSourceNode callStaticFactoryOut(final InOutType inOutType, final String factoryCall) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                if (inOutType.isOutPutAsParam()) {
                    writer.beginControlFlow("if (out == null)", new Object[0]);
                    writer.emitStatement("out = %s()", new Object[]{factoryCall});
                    writer.endControlFlow();
                } else {
                    writer.emitStatement("out = %s()", new Object[]{factoryCall});
                }
            }
        };
    }

    public static MappingSourceNode callGenericFactoryOut(final InOutType inOutType, final String factoryCall) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                if (inOutType.isOutPutAsParam()) {
                    writer.beginControlFlow("if (out == null)", new Object[0]);
                    writer.emitStatement("out = %s(%s.class)", new Object[]{factoryCall, inOutType.out()});
                    writer.endControlFlow();
                } else {
                    writer.emitStatement("out = %s(%s.class)", new Object[]{factoryCall, inOutType.out()});
                }
            }
        };
    }

    public static MappingSourceNode put(final String outCollection, final String itemVar) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.emitStatement("%s.put(%s.getKey(), %s.getValue())", new Object[]{outCollection, itemVar, itemVar});
            }
        };
    }

    public static MappingSourceNode arrayCopy(final String inGetterFor, final String outGetterFor) {
        return new MappingSourceNode(){

            @Override
            void writeNode(JavaWriter writer) throws IOException {
                writer.emitStatement("System.arraycopy(%s, 0, %s, 0, %s.length)", new Object[]{inGetterFor, outGetterFor, inGetterFor});
            }
        };
    }
}

