/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import fr.xebia.extras.selma.codegen.CustomMapperWrapper;
import fr.xebia.extras.selma.codegen.EnumMappersWrapper;
import fr.xebia.extras.selma.codegen.FieldsWrapper;
import fr.xebia.extras.selma.codegen.ImmutableTypesWrapper;
import fr.xebia.extras.selma.codegen.InOutType;
import fr.xebia.extras.selma.codegen.MapperGeneratorContext;
import fr.xebia.extras.selma.codegen.MappingBuilder;
import java.util.HashMap;
import java.util.Map;

public class MappingRegistry {
    final Map<InOutType, MappingBuilder> registryMap;
    final Map<InOutType, MappingBuilder> interceptorMap;
    final MapperGeneratorContext context;
    private FieldsWrapper fields;
    private CustomMapperWrapper customMappers;
    private EnumMappersWrapper enumMappers;
    private ImmutableTypesWrapper immutableTypes;

    public MappingRegistry(MapperGeneratorContext context) {
        this.registryMap = new HashMap<InOutType, MappingBuilder>();
        this.interceptorMap = new HashMap<InOutType, MappingBuilder>();
        this.context = context;
    }

    public MappingRegistry(MappingRegistry registry) {
        this.registryMap = new HashMap<InOutType, MappingBuilder>(registry.registryMap);
        this.interceptorMap = new HashMap<InOutType, MappingBuilder>(registry.interceptorMap);
        this.context = registry.context;
        this.customMappers = registry.customMappers;
        this.enumMappers = registry.enumMappers;
        this.immutableTypes = registry.immutableTypes;
        this.fields = registry.fields;
    }

    public MappingBuilder findMappingFor(InOutType inOutType) {
        MappingBuilder res = this.customMappers.getMapper(inOutType);
        if (res == null) {
            res = this.enumMappers.get(inOutType);
        }
        if (res == null) {
            res = this.registryMap.get(inOutType);
        }
        if (res == null) {
            res = this.immutableTypes.get(inOutType);
        }
        if (res == null && (res = MappingBuilder.getBuilderFor(this.context, inOutType)) != null && !inOutType.areDeclared()) {
            this.registryMap.put(inOutType, res);
        }
        return res;
    }

    public MappingBuilder mappingInterceptor(InOutType inOutType) {
        return this.customMappers.getMappingInterceptor(inOutType);
    }

    public void fields(FieldsWrapper fields) {
        this.fields = fields;
    }

    public FieldsWrapper fields() {
        return this.fields;
    }

    public void customMappers(CustomMapperWrapper customMapers) {
        this.customMappers = customMapers;
    }

    public void enumMappers(EnumMappersWrapper enumMappers) {
        this.enumMappers = enumMappers;
    }

    public void immutableTypes(ImmutableTypesWrapper immutablesMapper) {
        this.immutableTypes = immutablesMapper;
    }

    public EnumMappersWrapper getEnumMappers() {
        return this.enumMappers;
    }
}

