/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import fr.xebia.extras.selma.codegen.CollectionsRegistry;
import fr.xebia.extras.selma.codegen.InOutType;
import fr.xebia.extras.selma.codegen.MapperGeneratorContext;
import fr.xebia.extras.selma.codegen.MappingSourceNode;
import fr.xebia.extras.selma.codegen.SourceNodeVars;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleTypeVisitor6;

public abstract class MappingBuilder {
    private static final List<MappingSpecification> mappingSpecificationList = new LinkedList<MappingSpecification>();
    private boolean nullSafe = false;
    public static final String JAVA_TIME_LOCAL_DATE_CLASS = "java.time.LocalDate";
    public static final String JAVA_TIME_DURATION_CLASS = "java.time.Duration";
    public static final String JAVA_TIME_INSTANT_CLASS = "java.time.Instant";
    public static final String JAVA_TIME_LOCAL_DATE_TIME_CLASS = "java.time.LocalDateTime";
    private static final Set<String> immutableTypes = new HashSet<String>(Arrays.asList(BigInteger.class.getName(), BigDecimal.class.getName(), UUID.class.getName(), "java.time.LocalDate", "java.time.Duration", "java.time.Instant", "java.time.LocalDateTime", "java.time.LocalTime", "java.time.MonthDay", "java.time.OffsetDateTime", "java.time.OffsetTime", "java.time.Period", "java.time.Year", "java.time.YearMonth", "java.time.ZonedDateTime", "java.time.ZoneOffset"));
    MappingSourceNode root;

    private static boolean areMatchingBoxedToPrimitive(InOutType inOutType, MapperGeneratorContext context) {
        boolean res = false;
        if (inOutType.isDeclaredToPrimitive()) {
            PrimitiveType inAsPrimitive = MappingBuilder.getUnboxedPrimitive(inOutType.inAsDeclaredType(), context);
            res = inAsPrimitive != null && inAsPrimitive.getKind() == inOutType.outKind();
        }
        return res;
    }

    private static boolean isMatchingPrimitiveToBoxed(InOutType inOutType, MapperGeneratorContext context) {
        boolean res = false;
        if (inOutType.isPrimitiveToDeclared()) {
            PrimitiveType outAsPrimitive = MappingBuilder.getUnboxedPrimitive(inOutType.outAsDeclaredType(), context);
            res = outAsPrimitive != null && outAsPrimitive.getKind() == inOutType.inKind();
        }
        return res;
    }

    private MappingBuilder() {
        this.root = MappingSourceNode.blank();
    }

    private MappingBuilder(boolean nullSafe) {
        this.nullSafe = nullSafe;
        this.root = MappingSourceNode.blank();
    }

    protected void setOrAssignNestedBean(MapperGeneratorContext context, SourceNodeVars vars, InOutType inOutType) {
        String mappingMethod = context.mappingMethod(inOutType);
        if (inOutType.isOutPutAsParam()) {
            this.root.body(vars.setOrAssignWithOutPut(String.format("%s(%%s, %%s)", mappingMethod)));
        } else {
            this.root.body(vars.setOrAssign(String.format("%s(%%s)", mappingMethod)));
        }
    }

    private static Map.Entry<TypeMirror, Integer> getArrayDimensionsAndType(ArrayType arrayType) {
        int res = 1;
        ArrayType type = arrayType;
        while (type.getComponentType().getKind() == TypeKind.ARRAY) {
            ++res;
            type = (ArrayType)type.getComponentType();
        }
        return new AbstractMap.SimpleEntry<TypeMirror, Integer>(type.getComponentType(), res);
    }

    public static MappingBuilder getBuilderFor(MapperGeneratorContext context, final InOutType inOutType) {
        MappingBuilder res = null;
        for (MappingSpecification specification : mappingSpecificationList) {
            if (!specification.match(context, inOutType)) continue;
            res = specification.getBuilder(context, inOutType);
            break;
        }
        if (res == null && inOutType.areDeclared() && context.depth > 0) {
            res = new MappingBuilder(true){

                @Override
                MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                    this.setOrAssignNestedBean(context, vars, inOutType);
                    return this.root.body;
                }
            };
        }
        return res;
    }

    public static List<String> collectEnumValues(TypeElement typeElement) {
        ArrayList<String> res = new ArrayList<String>();
        List<? extends Element> elementInList = typeElement.getEnclosedElements();
        for (Element element : ElementFilter.fieldsIn(elementInList)) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            res.add(element.getSimpleName().toString());
        }
        return res;
    }

    private static boolean isMap(DeclaredType declaredType, MapperGeneratorContext context) {
        TypeElement typeElement1 = context.elements.getTypeElement("java.util.Map");
        DeclaredType declaredType2 = context.type.getDeclaredType(typeElement1, context.type.getWildcardType(null, null), context.type.getWildcardType(null, null));
        return context.type.isAssignable(declaredType, declaredType2);
    }

    public static boolean isCollection(DeclaredType declaredType, MapperGeneratorContext context) {
        TypeElement typeElement1 = context.elements.getTypeElement("java.util.Collection");
        DeclaredType declaredType2 = context.type.getDeclaredType(typeElement1, context.type.getWildcardType(null, null));
        return declaredType != null && context.type.isAssignable(declaredType, declaredType2);
    }

    private static boolean isBoxedPrimitive(DeclaredType declaredType, MapperGeneratorContext context) {
        return MappingBuilder.getUnboxedPrimitive(declaredType, context) != null;
    }

    private static PrimitiveType getUnboxedPrimitive(DeclaredType declaredType, MapperGeneratorContext context) {
        PrimitiveType res = null;
        PackageElement typePackage = context.elements.getPackageOf(declaredType.asElement());
        PackageElement javaLang = context.elements.getPackageElement("java.lang");
        if (typePackage.getSimpleName().equals(javaLang.getSimpleName())) {
            try {
                res = context.type.unboxedType(declaredType);
            }
            catch (IllegalArgumentException ignored) {
                // empty catch block
            }
        }
        return res;
    }

    private static MappingSourceNode notNullInField(SourceNodeVars vars) {
        return MappingSourceNode.controlNotNull(vars.inGetter(), false);
    }

    public static MappingBuilder newCustomMapperImmutableForUpdateGraph(final InOutType inOutType, final String name) {
        return new MappingBuilder(true){

            @Override
            MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                context.mappingMethod(inOutType, name);
                this.root.body(vars.setOrAssignWithOutPut(String.format("%s(%%s, %%s)", name)));
                return this.root.body;
            }
        };
    }

    public static MappingBuilder newCustomMapper(final InOutType inOutType, final String name) {
        return new MappingBuilder(true){

            @Override
            MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                context.mappingMethod(inOutType, name);
                if (inOutType.isOutPutAsParam()) {
                    this.root.body(vars.setOrAssignWithOutPut(String.format("%s(%%s, %%s)", name)));
                } else {
                    this.root.body(vars.setOrAssign(String.format("%s(%%s)", name)));
                }
                return this.root.body;
            }
        };
    }

    public static MappingBuilder newMappingInterceptor(final InOutType inOutType, final String name) {
        return new MappingBuilder(){

            @Override
            MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                context.mappingMethod(inOutType, name);
                this.root.body(MappingSourceNode.statement(String.format("%s(in,out)", name)));
                return this.root.body;
            }
        };
    }

    abstract MappingSourceNode buildNodes(MapperGeneratorContext var1, SourceNodeVars var2) throws IOException;

    public MappingSourceNode build(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
        this.root = MappingSourceNode.blank();
        MappingSourceNode ptr = this.buildNodes(context, vars);
        if (context.depth > 0 && !this.nullSafe) {
            this.root = MappingBuilder.notNullInField(vars);
            this.root.body(ptr);
            if (!vars.isOutPrimitive() && !vars.useGetterForDestination) {
                this.root.child(MappingSourceNode.controlNullElse()).body(vars.setOrAssign("null"));
            }
            return this.root;
        }
        return this.buildNodes(context, vars);
    }

    public static MappingBuilder newCustomEnumMapper(final InOutType inOutType, final String defaultValue) {
        TypeElement typeElement = inOutType.inAsTypeElement();
        List<String> enumInValues = MappingBuilder.collectEnumValues(typeElement);
        List<String> enumOutValues = MappingBuilder.collectEnumValues(inOutType.outAsTypeElement());
        final List<String> valuesIntersection = MappingBuilder.intersection(enumInValues, enumOutValues);
        return new MappingBuilder(){

            @Override
            MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                if (context.depth > 0) {
                    String mappingMethod = context.mappingMethod(inOutType);
                    this.root.body(vars.setOrAssign(String.format("%s(%%s)", mappingMethod)));
                } else {
                    MappingSourceNode node;
                    MappingSourceNode valuesBlock = node = MappingSourceNode.blank();
                    for (String value : valuesIntersection) {
                        node = node.child(MappingSourceNode.mapEnumCase(value));
                        node.body(vars.setOrAssign(String.format("%s.%s", inOutType.out(), value)));
                    }
                    node = node.child(MappingSourceNode.mapDefaultCase());
                    if ("".equals(defaultValue)) {
                        node.body(vars.setOrAssign("null"));
                    } else {
                        node.body(vars.setOrAssign(String.format("%s.%s", inOutType.out(), defaultValue)));
                    }
                    this.root.body(MappingSourceNode.mapEnumBlock(vars.inGetter())).body(valuesBlock.child);
                }
                return this.root.body;
            }
        };
    }

    private static TypeMirror getTypeArgument(final MapperGeneratorContext context, TypeMirror type, final int index) {
        TypeMirror param = type.accept(new SimpleTypeVisitor6<TypeMirror, Void>(){

            @Override
            public TypeMirror visitDeclared(DeclaredType t, Void p) {
                if (t.getTypeArguments().size() > 0) {
                    return t.getTypeArguments().get(index);
                }
                TypeMirror superclass = ((TypeElement)t.asElement()).getSuperclass();
                return MappingBuilder.getTypeArgument(context, superclass, index);
            }
        }, null);
        if (param != null) {
            return param;
        }
        return null;
    }

    public static <T> List<T> intersection(List<T> list1, List<T> list2) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : list1) {
            if (!list2.contains(t)) continue;
            list.add(t);
        }
        return list;
    }

    public boolean isNullSafe() {
        return this.nullSafe;
    }

    public static MappingBuilder newImmutable() {
        return new MappingBuilder(true){

            @Override
            MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                this.root.body(vars.setOrAssign("%s"));
                return this.root.body;
            }
        };
    }

    static {
        mappingSpecificationList.add(new MappingSpecification(){

            @Override
            MappingBuilder getBuilder(MapperGeneratorContext context, InOutType inOutType) {
                return new MappingBuilder(true){

                    @Override
                    public MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                        if (context.depth > 0) {
                            this.root.body(MappingSourceNode.set(vars.outSetterPath(), vars.inGetter()));
                        } else {
                            this.root.body(MappingSourceNode.assignOutPrime());
                        }
                        return this.root.body;
                    }
                };
            }

            @Override
            boolean match(MapperGeneratorContext context, InOutType inOutType) {
                return inOutType.areSamePrimitive() || MappingBuilder.areMatchingBoxedToPrimitive(inOutType, context);
            }
        });
        mappingSpecificationList.add(new MappingSpecification(){

            @Override
            MappingBuilder getBuilder(MapperGeneratorContext context, final InOutType inOutType) {
                TypeElement typeElement = inOutType.inAsTypeElement();
                final List<String> enumValues = MappingBuilder.collectEnumValues(typeElement);
                return new MappingBuilder(true){

                    @Override
                    MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                        if (context.depth > 0) {
                            String mappingMethod = context.mappingMethod(inOutType);
                            this.root.body(vars.setOrAssign(String.format("%s(%%s)", mappingMethod)));
                        } else {
                            MappingSourceNode node;
                            MappingSourceNode valuesBlock = node = MappingSourceNode.blank();
                            for (String value : enumValues) {
                                node = node.child(MappingSourceNode.mapEnumCase(value));
                                node.body(vars.setOrAssign(String.format("%s.%s", inOutType.out(), value)));
                            }
                            this.root.body(MappingSourceNode.mapEnumBlock(vars.inGetter())).body(valuesBlock.child);
                        }
                        return this.root.body;
                    }
                };
            }

            @Override
            boolean match(MapperGeneratorContext context, InOutType inOutType) {
                return inOutType.areDeclared() && inOutType.areEnums() && !inOutType.areSameDeclared();
            }
        });
        mappingSpecificationList.add(new MappingSpecification(){

            @Override
            MappingBuilder getBuilder(MapperGeneratorContext context, InOutType inOutType) {
                TypeElement typeElement = inOutType.inAsTypeElement();
                List<String> enumValues = MappingBuilder.collectEnumValues(typeElement);
                return new MappingBuilder(true){

                    @Override
                    MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                        this.root.body(vars.setOrAssign("%s"));
                        return this.root.body;
                    }
                };
            }

            @Override
            boolean match(MapperGeneratorContext context, InOutType inOutType) {
                return inOutType.areDeclared() && inOutType.areEnums() && inOutType.areSameDeclared();
            }
        });
        mappingSpecificationList.add(new MappingSpecification(){

            @Override
            MappingBuilder getBuilder(MapperGeneratorContext context, InOutType inOutType) {
                return new MappingBuilder(true){

                    @Override
                    MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                        this.root.body(vars.setOrAssign("%s"));
                        return this.root.body;
                    }
                };
            }

            @Override
            boolean match(MapperGeneratorContext context, InOutType inOutType) {
                DeclaredType declaredType;
                boolean res = inOutType.areSameDeclared() ? MappingBuilder.isBoxedPrimitive(declaredType = inOutType.inAsDeclaredType(), context) || String.class.getName().equals(declaredType.toString()) : MappingBuilder.isMatchingPrimitiveToBoxed(inOutType, context);
                return res;
            }
        });
        mappingSpecificationList.add(new SameDeclaredMappingSpecification(){

            @Override
            MappingBuilder getBuilder(MapperGeneratorContext context, InOutType inOutType) {
                return new MappingBuilder(){

                    @Override
                    MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                        this.root.body(vars.setOrAssign("new java.util.Date(%s.getTime())"));
                        return this.root.body;
                    }
                };
            }

            @Override
            boolean match(MapperGeneratorContext context, InOutType inOutType) {
                return super.match(context, inOutType) && Date.class.getName().equals(inOutType.in().toString());
            }
        });
        mappingSpecificationList.add(new SameDeclaredMappingSpecification(){

            @Override
            MappingBuilder getBuilder(MapperGeneratorContext context, InOutType inOutType) {
                return new MappingBuilder(true){

                    @Override
                    MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                        this.root.body(vars.setOrAssign("%s"));
                        return this.root.body;
                    }
                };
            }

            @Override
            boolean match(MapperGeneratorContext context, InOutType inOutType) {
                if (super.match(context, inOutType)) {
                    String inType = inOutType.in().toString();
                    return immutableTypes.contains(inType);
                }
                return false;
            }
        });
        mappingSpecificationList.add(new MappingSpecification(){

            @Override
            boolean match(MapperGeneratorContext context, InOutType inOutType) {
                return inOutType.areDeclared() && MappingBuilder.isCollection(inOutType.inAsDeclaredType(), context) && MappingBuilder.isCollection(inOutType.outAsDeclaredType(), context);
            }

            @Override
            MappingBuilder getBuilder(MapperGeneratorContext context, final InOutType inOutType) {
                final TypeMirror genericIn = MappingBuilder.getTypeArgument(context, inOutType.inAsDeclaredType(), 0);
                final TypeMirror genericOut = MappingBuilder.getTypeArgument(context, inOutType.outAsDeclaredType(), 0);
                String impl = inOutType.outAsTypeElement().getKind() == ElementKind.CLASS ? inOutType.out().toString() : CollectionsRegistry.findImplementationForType(inOutType.outAsTypeElement()) + "<" + genericOut.toString() + ">";
                final String implementation = impl;
                TypeElement outElement = context.elements().getTypeElement(impl.replaceAll("<.*>", ""));
                boolean hasSizeCtr = false;
                List<ExecutableElement> constructors = ElementFilter.constructorsIn(context.elements().getAllMembers(outElement));
                for (ExecutableElement constructor : constructors) {
                    if (constructor.getParameters().size() != 1 || constructor.getParameters().get(0).asType().getKind() != TypeKind.INT) continue;
                    hasSizeCtr = true;
                    break;
                }
                final boolean hasSizeConstructor = hasSizeCtr;
                return new MappingBuilder(){

                    @Override
                    MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                        MappingSourceNode node;
                        String itemVar = vars.itemVar();
                        String tmpVar = vars.tmpVar("Collection");
                        String arg = hasSizeConstructor ? String.format("%s.size()", vars.inGetter()) : "";
                        if (vars.useGetterForDestination) {
                            node = this.root.body(MappingSourceNode.assign(String.format("%s %s", inOutType.inAsTypeElement(), tmpVar), String.format("%s()", vars.outFieldGetter))).child(MappingSourceNode.mapCollection(itemVar, genericIn.toString(), vars.inGetter()));
                        } else {
                            node = this.root.body(MappingSourceNode.assign(String.format("%s %s", implementation, tmpVar), String.format("new %s(%s)", implementation, arg))).child(MappingSourceNode.mapCollection(itemVar, genericIn.toString(), vars.inGetter()));
                            node.child(vars.setOrAssign(tmpVar));
                        }
                        context.pushStackForBody(node, new SourceNodeVars().withInOutType(new InOutType(genericIn, genericOut, false)).withInField(itemVar).withOutField(String.format("%s.add", tmpVar)).withAssign(false).withIndexPtr(vars.nextPtr()));
                        return this.root.body;
                    }
                };
            }
        });
        mappingSpecificationList.add(new MappingSpecification(){

            @Override
            MappingBuilder getBuilder(MapperGeneratorContext context, InOutType inOutType) {
                final TypeMirror genericInKey = MappingBuilder.getTypeArgument(context, inOutType.inAsDeclaredType(), 0);
                final TypeMirror genericOutKey = MappingBuilder.getTypeArgument(context, inOutType.outAsDeclaredType(), 0);
                final TypeMirror genericInValue = MappingBuilder.getTypeArgument(context, inOutType.inAsDeclaredType(), 1);
                final TypeMirror genericOutValue = MappingBuilder.getTypeArgument(context, inOutType.outAsDeclaredType(), 1);
                String impl = inOutType.outAsTypeElement().getKind() == ElementKind.CLASS ? inOutType.out().toString() : CollectionsRegistry.findImplementationForType(inOutType.outAsTypeElement()) + "<" + genericOutKey.toString() + ", " + genericOutValue.toString() + ">";
                final String implementation = impl;
                return new MappingBuilder(){

                    @Override
                    MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                        String itemVar = vars.itemEntry();
                        String tmpVar = vars.tmpVar("Map");
                        String keyVar = vars.tmpVar("Key");
                        MappingSourceNode node = this.root.body(MappingSourceNode.assign(String.format("%s %s", implementation, tmpVar), String.format("new %s()", implementation))).child(vars.setOrAssign(tmpVar)).child(MappingSourceNode.mapMap(itemVar, genericInKey.toString(), genericInValue.toString(), vars.inGetter())).body(MappingSourceNode.assign(String.format("%s %s", genericOutKey, keyVar), "null"));
                        context.pushStackForChild(node, new SourceNodeVars().withInOutType(new InOutType(genericInValue, genericOutValue, false)).withInField(String.format("%s.getValue()", itemVar)).withInFieldPrefix(String.format("%s,", keyVar)).withOutField(String.format("%s.put", tmpVar)).withAssign(false).withIndexPtr(vars.nextPtr()));
                        context.pushStackForChild(node, new SourceNodeVars().withInOutType(new InOutType(genericInKey, genericOutKey, false)).withInField(String.format("%s.getKey()", itemVar)).withOutField(keyVar).withAssign(true).withIndexPtr(vars.nextPtr()));
                        return this.root.body;
                    }
                };
            }

            @Override
            boolean match(MapperGeneratorContext context, InOutType inOutType) {
                return inOutType.areDeclared() && MappingBuilder.isMap(inOutType.inAsDeclaredType(), context) && MappingBuilder.isMap(inOutType.outAsDeclaredType(), context);
            }
        });
        mappingSpecificationList.add(new MappingSpecification(){

            @Override
            MappingBuilder getBuilder(MapperGeneratorContext context, final InOutType inOutType) {
                return new MappingBuilder(){

                    @Override
                    MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                        this.root.body(vars.setOrAssign(String.format("new %s[%%s.length]", inOutType.inArrayComponentType()))).child(MappingSourceNode.arrayCopy(vars.inGetter(), vars.outSetterPath()));
                        return this.root.body;
                    }
                };
            }

            @Override
            boolean match(MapperGeneratorContext context, InOutType inOutType) {
                return inOutType.inIsArray() && inOutType.isInArrayComponentPrimitive() && !inOutType.differs();
            }
        });
        mappingSpecificationList.add(new MappingSpecification(){

            @Override
            MappingBuilder getBuilder(MapperGeneratorContext context, final InOutType inOutType) {
                return new MappingBuilder(){

                    @Override
                    MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                        String indexVar = vars.indexVar();
                        String tmpVar = vars.tmpVar("Array");
                        Map.Entry dims = MappingBuilder.getArrayDimensionsAndType(inOutType.inAsArrayType());
                        String totalCountVar = vars.totalCountVar();
                        String totalCountVal = String.format("%s.length", vars.inGetter());
                        String newArray = String.format("new %s[%s.length]", dims.getKey(), vars.inGetter());
                        for (int i = 1; i < (Integer)dims.getValue(); ++i) {
                            newArray = newArray + "[]";
                        }
                        MappingSourceNode node = this.root.body(MappingSourceNode.assign(String.format("%s %s", inOutType.out().toString(), tmpVar), newArray)).child(MappingSourceNode.assign("int " + totalCountVar, totalCountVal)).child(vars.setOrAssign(tmpVar)).child(MappingSourceNode.mapArrayBis(indexVar, totalCountVar));
                        context.pushStackForBody(node, new SourceNodeVars().withInOutType(new InOutType(inOutType.inArrayComponentType(), inOutType.outArrayComponentType(), false)).withInField(String.format("%s[%s]", vars.inGetter(), indexVar)).withOutField(String.format("%s[%s]", tmpVar, indexVar)).withAssign(true).withIndexPtr(vars.nextPtr()));
                        return this.root.body;
                    }
                };
            }

            @Override
            boolean match(MapperGeneratorContext context, InOutType inOutType) {
                return !inOutType.differs() && inOutType.inIsArray() && inOutType.isInArrayComponentDeclaredOrArray();
            }
        });
    }

    static abstract class SameDeclaredMappingSpecification
    extends MappingSpecification {
        SameDeclaredMappingSpecification() {
        }

        @Override
        boolean match(MapperGeneratorContext context, InOutType inOutType) {
            return !inOutType.differs() && inOutType.areDeclared();
        }
    }

    static abstract class MappingSpecification {
        MappingSpecification() {
        }

        abstract MappingBuilder getBuilder(MapperGeneratorContext var1, InOutType var2);

        abstract boolean match(MapperGeneratorContext var1, InOutType var2);
    }
}

