/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import fr.xebia.extras.selma.Mapper;
import fr.xebia.extras.selma.codegen.MapperClassGenerator;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"fr.xebia.extras.selma.Mapper"})
public final class MapperProcessor
extends AbstractProcessor {
    private final HashMap<String, List<ExecutableElement>> remainingMapperTypes = new HashMap();
    static Types types;
    protected static final Set<ExecutableElement> exclusions;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        TypeElement objectElement = processingEnv.getElementUtils().getTypeElement(Object.class.getName());
        List<ExecutableElement> objectElementsMethods = ElementFilter.methodsIn(objectElement.getEnclosedElements());
        exclusions.clear();
        exclusions.addAll(objectElementsMethods);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean res = true;
        if (annotations.size() > 0) {
            types = this.processingEnv.getTypeUtils();
            this.populateAllMappers(roundEnv);
            try {
                this.generateMappingClassses();
            }
            catch (IOException e) {
                e.printStackTrace();
                StringWriter writer = new StringWriter();
                e.printStackTrace(new PrintWriter(writer));
                this.error(writer.toString(), null);
            }
            this.remainingMapperTypes.clear();
        }
        return res;
    }

    private void generateMappingClassses() throws IOException {
        for (String classe : this.remainingMapperTypes.keySet()) {
            MapperClassGenerator classGenerator = new MapperClassGenerator(classe, (Collection<ExecutableElement>)this.remainingMapperTypes.get(classe), this.processingEnv);
            classGenerator.build();
        }
    }

    private void populateAllMappers(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Mapper.class)) {
            boolean abstractClass = this.isAbstractClass(element);
            if (this.isSelmaGenerated(element) || !this.isValidMapperUse(element)) continue;
            TypeElement typeElement = (TypeElement)element;
            List<? extends Element> allMembers = this.processingEnv.getElementUtils().getAllMembers(typeElement);
            List<ExecutableElement> methods = ElementFilter.methodsIn(allMembers);
            for (Element element2 : methods) {
                ExecutableElement executableElement = (ExecutableElement)element2;
                if (abstractClass && !this.isAbstractMethod(executableElement) || !this.isValidMapperMethod(executableElement)) continue;
                this.putMapper(element, executableElement);
            }
        }
    }

    private boolean isAbstractMethod(ExecutableElement executableElement) {
        return executableElement.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    private boolean isSelmaGenerated(Element element) {
        return ("" + element.getSimpleName()).endsWith("SelmaGeneratedClass");
    }

    private boolean isValidMapperMethod(ExecutableElement executableElement) {
        if (exclusions.contains(executableElement)) {
            return false;
        }
        if (executableElement.getParameters().size() < 1) {
            this.error(executableElement, "@Mapper method %s can not have less than one parameter", executableElement.getSimpleName());
            return false;
        }
        if (executableElement.getParameters().size() > 2) {
            this.error(executableElement, "@Mapper method %s can not have more than two parameters", executableElement.getSimpleName());
            return false;
        }
        if (executableElement.getReturnType().getKind() == TypeKind.VOID) {
            this.error(executableElement, "@Mapper method %s can not return void", executableElement.getSimpleName());
            return false;
        }
        if (executableElement.getParameters().size() == 2) {
            TypeMirror returnType = executableElement.getReturnType();
            VariableElement variableElement = executableElement.getParameters().get(1);
            if (!variableElement.asType().toString().equals(returnType.toString())) {
                this.error(executableElement, "@Mapper method %s second parameter type should be %s as the return type is", executableElement.getSimpleName(), executableElement.getReturnType());
                return false;
            }
        }
        return true;
    }

    private void error(Element element, String templateMessage, Object ... args) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format(templateMessage, args), element);
    }

    private void putMapper(Element element, ExecutableElement executableElement) {
        List<Object> elementList;
        String type = element.asType().toString();
        if (this.remainingMapperTypes.containsKey(type)) {
            elementList = this.remainingMapperTypes.get(type);
        } else {
            elementList = new ArrayList();
            this.remainingMapperTypes.put(type, elementList);
        }
        elementList.add(executableElement);
    }

    private boolean isValidMapperUse(Element element) {
        boolean res = true;
        if (element.getKind() != ElementKind.INTERFACE && !this.isAbstractClass(element)) {
            this.error(element, "@Mapper can only be used on interface or public abstract class", new Object[0]);
            res = false;
        }
        return res;
    }

    private boolean isAbstractClass(Element element) {
        boolean res = false;
        if (element.getKind() == ElementKind.CLASS) {
            TypeElement typeElement = (TypeElement)element;
            res = typeElement.getModifiers().contains((Object)Modifier.ABSTRACT) && typeElement.getModifiers().contains((Object)Modifier.PUBLIC) && !typeElement.getModifiers().contains((Object)Modifier.FINAL);
        }
        return res;
    }

    private void error(String msg, Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element);
    }

    static {
        exclusions = new HashSet<ExecutableElement>();
    }
}

