/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import fr.xebia.extras.selma.codegen.MapperGeneratorContext;
import fr.xebia.extras.selma.codegen.MethodWrapper;
import fr.xebia.extras.selma.codegen.TypeConstructorWrapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class BeanWrapper {
    private static final Set<String> exclusions = new TreeSet<String>(Arrays.asList("getClass"));
    final MapperGeneratorContext context;
    final TypeElement typeElement;
    final Map<String, FieldItem> fieldsGraph;
    private final TypeConstructorWrapper constructors;

    public BeanWrapper(MapperGeneratorContext context, TypeElement typeElement) {
        this.context = context;
        this.typeElement = typeElement;
        this.fieldsGraph = this.buildFieldGraph();
        this.constructors = new TypeConstructorWrapper(context, typeElement);
    }

    private Map<String, FieldItem> buildFieldGraph() {
        HashMap<String, FieldItem> result = new HashMap<String, FieldItem>();
        List<? extends Element> elementInList = this.context.elements.getAllMembers(this.typeElement);
        List<ExecutableElement> methods = ElementFilter.methodsIn(elementInList);
        for (ExecutableElement method : methods) {
            if (exclusions.contains(method.getSimpleName().toString())) continue;
            MethodWrapper methodWrapper = new MethodWrapper(method, (DeclaredType)this.typeElement.asType(), this.context);
            if (methodWrapper.isGetter()) {
                this.putGetterField(methodWrapper, result);
                continue;
            }
            if (!methodWrapper.isSetter()) continue;
            this.putSetterField(methodWrapper, result);
        }
        return result;
    }

    private void putSetterField(MethodWrapper methodWrapper, HashMap<String, FieldItem> result) {
        String field = methodWrapper.getFieldName().toLowerCase();
        FieldItem item = result.get(field);
        item = item != null ? new FieldItem(field, methodWrapper, item.getter) : new FieldItem(field, methodWrapper, null);
        result.put(field, item);
    }

    private void putGetterField(MethodWrapper methodWrapper, HashMap<String, FieldItem> result) {
        String field = methodWrapper.getFieldName().toLowerCase();
        FieldItem item = result.get(field);
        item = item != null ? new FieldItem(item.field, item.setter, methodWrapper) : new FieldItem(field, null, methodWrapper);
        result.put(field, item);
    }

    public Iterable<? extends String> getFields() {
        return this.fieldsGraph.keySet();
    }

    public boolean hasFieldAndSetter(String field) {
        boolean res = false;
        FieldItem item = this.fieldsGraph.get(field);
        if (item != null && item.setter != null) {
            res = true;
        }
        return res;
    }

    public boolean hasFieldAndGetter(String field) {
        boolean res = false;
        FieldItem item = this.fieldsGraph.get(field);
        if (item != null && item.getter != null) {
            res = true;
        }
        return res;
    }

    public String getSetterFor(String field) {
        String res = null;
        FieldItem item = this.fieldsGraph.get(field);
        if (item != null && item.setter != null) {
            res = item.setter.getSimpleName().toString();
        }
        return res;
    }

    public String getOutSetterPathFor(String field) {
        return String.format("out.%s", this.getSetterFor(field));
    }

    public String getOutGetterPathFor(String field) {
        return String.format("out.%s", this.getGetterFor(field));
    }

    public String getGetterFor(String field) {
        String res = null;
        FieldItem item = this.fieldsGraph.get(field);
        if (item != null && item.getter != null) {
            res = item.getter.getSimpleName().toString();
        }
        return res;
    }

    public String getInGetterFor(String field) {
        return String.format("in.%s()", this.getGetterFor(field));
    }

    public Set<String> getSetterFields() {
        TreeSet<String> res = new TreeSet<String>();
        for (String s : this.fieldsGraph.keySet()) {
            if (this.fieldsGraph.get((Object)s).setter == null) continue;
            res.add(s);
        }
        return res;
    }

    public Set<String> getGetterFields() {
        TreeSet<String> res = new TreeSet<String>();
        for (String s : this.fieldsGraph.keySet()) {
            if (this.fieldsGraph.get((Object)s).getter == null) continue;
            res.add(s);
        }
        return res;
    }

    public boolean hasMatchingSourcesConstructor() {
        return this.constructors.hasMatchingSourcesConstructor;
    }

    public boolean hasCallableConstructor() {
        return this.constructors.hasCallableConstructor();
    }

    public TypeMirror getTypeForGetter(String field) {
        TypeMirror result = null;
        FieldItem item = this.fieldsGraph.get(field);
        if (item != null && item.getter != null) {
            result = item.getter.returnType();
        }
        return result;
    }

    public TypeMirror getTypeForSetter(String field) {
        TypeMirror result = null;
        FieldItem item = this.fieldsGraph.get(field);
        if (item != null && item.setter != null) {
            result = item.setter.firstParameterType();
        }
        return result;
    }

    public DeclaredType getDeclaredTypeForGetter(String field) {
        TypeMirror typeForGetter = this.getTypeForGetter(field);
        if (typeForGetter.getKind() == TypeKind.DECLARED) {
            return (DeclaredType)typeForGetter;
        }
        return null;
    }

    class FieldItem {
        final String field;
        final MethodWrapper setter;
        final MethodWrapper getter;

        FieldItem(String field, MethodWrapper setter, MethodWrapper getter) {
            this.field = field;
            this.setter = setter;
            this.getter = getter;
        }
    }
}

