/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx.preprocessor.sax;

import fr.opensagres.xdocreport.document.docx.DocxUtils;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.BookmarkBufferedRegion;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.DocxBufferedDocument;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.FldSimpleBufferedRegion;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.MergefieldBufferedRegion;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.RBufferedRegion;
import fr.opensagres.xdocreport.document.preprocessor.sax.TransformedBufferedDocumentContentHandler;
import fr.opensagres.xdocreport.template.formatter.FieldMetadata;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocXBufferedDocumentContentHandler
extends TransformedBufferedDocumentContentHandler<DocxBufferedDocument> {
    private static final String W_TR = "w:tr";
    private static final String W_TC = "w:tc";
    private boolean instrTextParsing;
    private boolean tParsing = false;
    private int tIndex = -1;

    protected DocXBufferedDocumentContentHandler(String entryName, FieldsMetadata fieldsMetadata, IDocumentFormatter formater, Map<String, Object> sharedContext) {
        super(entryName, fieldsMetadata, formater, sharedContext);
    }

    protected DocxBufferedDocument createDocument() {
        return new DocxBufferedDocument(this);
    }

    protected String getTableRowName() {
        return W_TR;
    }

    protected String getTableCellName() {
        return W_TC;
    }

    public boolean doStartElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        BookmarkBufferedRegion currentBookmark;
        IDocumentFormatter formatter = super.getFormatter();
        RBufferedRegion currentRRegion = ((DocxBufferedDocument)this.bufferedDocument).getCurrentRRegion();
        if (DocxUtils.isFldChar(uri, localName, name) && currentRRegion != null) {
            String fldCharType = attributes.getValue("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "fldCharType");
            currentRRegion.setFldCharType(fldCharType);
            return super.doStartElement(uri, localName, name, attributes);
        }
        if (DocxUtils.isInstrText(uri, localName, name) && currentRRegion != null) {
            this.instrTextParsing = true;
            return super.doStartElement(uri, localName, name, attributes);
        }
        if (DocxUtils.isT(uri, localName, name)) {
            this.tParsing = true;
            ++this.tIndex;
            return super.doStartElement(uri, localName, name, attributes);
        }
        if (DocxUtils.isR(uri, localName, name)) {
            this.tIndex = -1;
        }
        if (DocxUtils.isFldSimple(uri, localName, name)) {
            FldSimpleBufferedRegion currentFldSimpleRegion = ((DocxBufferedDocument)this.bufferedDocument).getCurrentFldSimpleRegion();
            if (currentFldSimpleRegion.getFieldName() == null) {
                super.doStartElement(uri, localName, name, attributes);
                return true;
            }
            return false;
        }
        if (DocxUtils.isBlip(uri, localName, name)) {
            int index;
            BookmarkBufferedRegion currentBookmark2 = ((DocxBufferedDocument)this.bufferedDocument).getCurrentBookmark();
            if (currentBookmark2 != null && formatter != null && (index = attributes.getIndex("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "embed")) >= 0) {
                String embed = attributes.getValue(index);
                String newEmbed = formatter.getFunctionDirective("___ImageRegistry", "getPath", new String[]{"___imageInfo", "'" + embed + "'"});
                AttributesImpl attr = DocXBufferedDocumentContentHandler.toAttributesImpl((Attributes)attributes);
                attr.setValue(index, newEmbed);
                attributes = attr;
            }
        } else if ((DocxUtils.isExtent(uri, localName, name) || DocxUtils.isExt(uri, localName, name)) && (currentBookmark = ((DocxBufferedDocument)this.bufferedDocument).getCurrentBookmark()) != null && formatter != null) {
            int cyIndex;
            String newCX = null;
            String newCY = null;
            int cxIndex = attributes.getIndex("cx");
            if (cxIndex != -1) {
                String oldCX = attributes.getValue(cxIndex);
                newCX = formatter.getFunctionDirective("___ImageRegistry", "getWidth", new String[]{"___imageInfo", "'" + oldCX + "'"});
            }
            if ((cyIndex = attributes.getIndex("cy")) != -1) {
                String oldCY = attributes.getValue(cyIndex);
                newCY = formatter.getFunctionDirective("___ImageRegistry", "getHeight", new String[]{"___imageInfo", "'" + oldCY + "'"});
            }
            if (newCX != null || newCY != null) {
                AttributesImpl attr = DocXBufferedDocumentContentHandler.toAttributesImpl((Attributes)attributes);
                if (newCX != null) {
                    attr.setValue(cxIndex, newCX);
                }
                if (newCY != null) {
                    attr.setValue(cyIndex, newCY);
                }
                attributes = attr;
            }
        }
        return super.doStartElement(uri, localName, name, attributes);
    }

    public void doEndElement(String uri, String localName, String name) throws SAXException {
        RBufferedRegion currentRRegion = ((DocxBufferedDocument)this.bufferedDocument).getCurrentRRegion();
        if (DocxUtils.isInstrText(uri, localName, name) && currentRRegion != null) {
            super.doEndElement(uri, localName, name);
            this.instrTextParsing = false;
            return;
        }
        if (DocxUtils.isT(uri, localName, name)) {
            super.doEndElement(uri, localName, name);
            this.tParsing = false;
            return;
        }
        FldSimpleBufferedRegion currentFldSimpleRegion = ((DocxBufferedDocument)this.bufferedDocument).getCurrentFldSimpleRegion();
        if (DocxUtils.isFldSimple(uri, localName, name) && currentFldSimpleRegion != null) {
            String fieldName = currentFldSimpleRegion.getFieldName();
            if (fieldName == null) {
                super.doEndElement(uri, localName, name);
            }
            return;
        }
        super.doEndElement(uri, localName, name);
    }

    protected void flushCharacters(String characters) {
        FldSimpleBufferedRegion currentFldSimpleRegion = ((DocxBufferedDocument)this.bufferedDocument).getCurrentFldSimpleRegion();
        if (this.tParsing && currentFldSimpleRegion != null) {
            currentFldSimpleRegion.setTContent(characters);
            this.extractListDirectiveInfo(currentFldSimpleRegion);
            this.resetCharacters();
            return;
        }
        RBufferedRegion currentRRegion = ((DocxBufferedDocument)this.bufferedDocument).getCurrentRRegion();
        if (currentRRegion != null) {
            if (this.instrTextParsing) {
                FieldMetadata fieldAsTextStyling = super.getFieldAsTextStyling(characters);
                characters = this.processRowIfNeeded(characters);
                currentRRegion.setInstrText(characters, fieldAsTextStyling);
                this.extractListDirectiveInfo(currentRRegion);
                this.resetCharacters();
                return;
            }
            if (this.tParsing) {
                currentRRegion.setTContent(this.tIndex, characters);
                this.resetCharacters();
                return;
            }
        }
        super.flushCharacters(characters);
    }

    private void extractListDirectiveInfo(MergefieldBufferedRegion mergefield) {
        super.extractListDirectiveInfo(mergefield.getFieldName());
    }
}

