/*
 * Decompiled with CFR 0.152.
 */
package fr.coppernic.lib.splash.base;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

class MetaConfig {
    private static final String TAG = "MetaConfig";
    private static final String KEY_ACTIVITY = "activity";
    private static final String KEY_PACKAGE = "package";
    private static final String KEY_TIMING = "timing";
    private static final int DEFAULT_TIMING = 0;
    private int timing = 0;
    private Intent targetIntent;

    MetaConfig(@NonNull Activity activity) {
        try {
            ActivityInfo info = activity.getPackageManager().getActivityInfo(activity.getComponentName(), 128);
            if (info.metaData == null) {
                throw new RuntimeException("No manifest's metadata found");
            }
            String targetActivity = info.metaData.getString(KEY_ACTIVITY);
            if (targetActivity == null) {
                throw new RuntimeException("Target activity is not defined in manifest's meta data");
            }
            this.timing = info.metaData.getInt(KEY_TIMING, 0);
            String packName = info.metaData.getString(KEY_PACKAGE, activity.getPackageName());
            ComponentName componentName = new ComponentName(packName, targetActivity);
            this.targetIntent = new Intent(activity.getIntent());
            this.targetIntent.setComponent(componentName);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    int getTiming() {
        return this.timing;
    }

    @Nullable
    Intent getTargetIntent() {
        return this.targetIntent;
    }
}

