/*
 * Decompiled with CFR 0.152.
 */
package fr.coppernic.lib.splash;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import fr.coppernic.lib.splash.base.SplashScreenBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionSplashScreen
extends SplashScreenBase
implements ActivityCompat.OnRequestPermissionsResultCallback {
    public static final int UID_SYSTEM = 1000;
    private static final String KEY_REQUEST = "PermissionSplashScreen_request";
    private static final Logger LOG = LoggerFactory.getLogger((String)"SplashScreen");
    private final Set<String> pendingPermissions = new TreeSet<String>();
    private String[] permissionsArray;

    public static String concatString(Collection<String> in, String sep) {
        StringBuilder sb = new StringBuilder();
        for (String tmp : in) {
            sb.append(tmp).append(sep);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - sep.length());
        }
        return sb.toString();
    }

    public static boolean isSharingSystemUid(Context context) {
        return 1000 == PermissionSplashScreen.getPackageUid(context);
    }

    public static int getPackageUid(Context context) {
        int ret = 0;
        String packageName = context.getPackageName();
        PackageManager pm = context.getPackageManager();
        try {
            PackageInfo pi = pm.getPackageInfo(packageName, 256);
            ret = pi.applicationInfo.uid;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            PackageInfo info = this.getPackageManager().getPackageInfo(this.getPackageName(), 4096);
            this.permissionsArray = info.requestedPermissions != null ? info.requestedPermissions : new String[0];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    protected void onStart() {
        super.onStart();
        LOG.trace("onStart, current request : {}", (Object)this.getRequestNumber());
        this.requestPermissions(this.getDeniedPermissions(Arrays.asList(this.permissionsArray)));
    }

    protected void onStop() {
        super.onStop();
        LOG.trace("onStop, current request : {}", (Object)this.getRequestNumber());
    }

    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void onPause() {
        super.onPause();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode != this.getRequestNumber() && PermissionSplashScreen.isSharingSystemUid((Context)this)) {
            LOG.error("Request does not correspond, {} instead of {}", (Object)requestCode, (Object)this.getRequestNumber());
            this.finish();
            return;
        }
        LOG.debug("onRequestPermissionsResult : {}", (Object)requestCode);
        this.clearRequestNumber();
        ArrayList<String> granted = new ArrayList<String>();
        ArrayList<String> denied = new ArrayList<String>();
        for (int i = 0; i < permissions.length; ++i) {
            if (grantResults[i] == -1) {
                denied.add(permissions[i]);
                continue;
            }
            granted.add(permissions[i]);
        }
        LOG.debug("Granted : {}", (Object)PermissionSplashScreen.concatString(granted, ", "));
        LOG.debug("Denied : {}", (Object)PermissionSplashScreen.concatString(denied, ", "));
        this.onPermissionsGranted(granted);
        this.onPermissionsDenied(denied);
        this.pendingPermissions.removeAll(granted);
        this.pendingPermissions.removeAll(denied);
        if (!this.shouldRequestPermissions(this.pendingPermissions)) {
            this.startTargetActivity();
        } else {
            LOG.debug("Waiting for next onRequestPermissionsResult");
        }
    }

    protected void onPermissionsGranted(List<String> granted) {
    }

    protected void onPermissionsDenied(List<String> granted) {
    }

    private List<String> getDeniedPermissions(List<String> permissions) {
        ArrayList<String> ret = new ArrayList<String>();
        if (PermissionSplashScreen.isSharingSystemUid((Context)this)) {
            ret.addAll(permissions);
        } else {
            for (String p : permissions) {
                if (ActivityCompat.checkSelfPermission((Context)this, (String)p) != -1) continue;
                ret.add(p);
            }
        }
        return ret;
    }

    private void requestPermissions(Collection<String> permissions) {
        if (this.shouldRequestPermissions(permissions)) {
            int request = this.getRequestNumber() + 1;
            LOG.info("[" + request + "] Requesting permissions : \n" + PermissionSplashScreen.concatString(permissions, ",\n"));
            this.pendingPermissions.addAll(permissions);
            this.setRequestNumber(request);
            ActivityCompat.requestPermissions((Activity)this, (String[])permissions.toArray(new String[0]), (int)request);
        } else if (this.isRequestOngoing()) {
            LOG.debug("Request is onGoing, waiting for onRequestPermissionsResult");
        } else {
            this.startTargetActivity();
        }
    }

    protected boolean shouldRequestPermissions(Collection<String> permissions) {
        boolean ret = true;
        if (Build.VERSION.SDK_INT < 23) {
            LOG.info("Android OS version is below Marshmallow, do not ask anything");
            ret = false;
        } else if (permissions.isEmpty()) {
            LOG.info("Permissions list is empty, starting target activity...");
            ret = false;
        } else if (this.isRequestOngoing()) {
            LOG.info("Request is ongoing");
            ret = false;
        }
        return ret;
    }

    private boolean isRequestOngoing() {
        return this.getRequestNumber() > 0;
    }

    private int getRequestNumber() {
        return this.model.bundle.getInt(KEY_REQUEST, 0);
    }

    private void setRequestNumber(int i) {
        LOG.trace("Set request number " + i);
        this.model.bundle.putInt(KEY_REQUEST, i);
    }

    private void clearRequestNumber() {
        this.setRequestNumber(0);
    }
}

