/*
 *
 * Copyright (c) 2016-2017 Payara Foundation and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://github.com/payara/Payara/blob/master/LICENSE.txt
 * See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * The Payara Foundation designates this particular file as subject to the "Classpath"
 * exception as provided by the Payara Foundation in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package fish.payara.nucleus.requesttracing.domain;

/**
 * @author mertcaliskan
 */
public class HistoricRequestTracingEvent implements Comparable<HistoricRequestTracingEvent> {

    private long elapsedTime;
    private long occurringTime;
    private String message;

    public HistoricRequestTracingEvent(long occurringTime, long elapsedTime, String message) {
        this.occurringTime = occurringTime;
        this.elapsedTime = elapsedTime;
        this.message = message;
    }

    public long getOccurringTime() {
        return occurringTime;
    }

    public long getElapsedTime() {
        return elapsedTime;
    }

    public String getMessage() {
        return message;
    }

    @Override
    public int compareTo(HistoricRequestTracingEvent e) {
        return Long.compare(e.elapsedTime, elapsedTime);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        HistoricRequestTracingEvent that = (HistoricRequestTracingEvent) o;

        return elapsedTime == that.elapsedTime && (message != null ? message.equals(that.message) : that.message == null);
    }

    @Override
    public int hashCode() {
        int result = (int) (elapsedTime ^ (elapsedTime >>> 32));
        result = 31 * result + (message != null ? message.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "HistoricRequestTracingEvent{" +
                "occurringTime=" + occurringTime +
                ", elapsedTime=" + elapsedTime +
                ", message='" + message + '\'' +
                '}';
    }
}
