// $ANTLR 2.7.7 (20060906): "JDOQLCodeGeneration.g" -> "JDOQLCodeGeneration.java"$

    package com.sun.jdo.spi.persistence.support.ejb.ejbqlc;
    
    import java.util.ResourceBundle;
    import org.glassfish.persistence.common.I18NHelper;
    import com.sun.jdo.spi.persistence.utility.StringHelper;

import antlr.TreeParser;
import antlr.Token;
import antlr.collections.AST;
import antlr.RecognitionException;
import antlr.ANTLRException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.collections.impl.BitSet;
import antlr.ASTPair;
import antlr.collections.impl.ASTArray;


/**
 * This class defines the semantic analysis of the EJBQL compiler.
 * Input of this pass is the AST as produced by the parser,
 * that consists of EJBQLAST nodes.
 * The result is a typed EJBQLAST tree.
 *
 * @author  Michael Bouschen
 * @author  Shing Wai Chan
 */
public class JDOQLCodeGeneration extends antlr.TreeParser       implements JDOQLCodeGenerationTokenTypes
 {

    /** Type helper. */
    protected TypeSupport typeSupport;
    
    /** Parameter helper. */
    protected ParameterSupport paramSupport;
    
    /** I18N support. */
    protected final static ResourceBundle msgs = 
        I18NHelper.loadBundle(JDOQLCodeGeneration.class);
    
    /** The identification variable used for the candidate class. */
    private String candidateClassIdentificationVar;

    /** The name of the candidate class. */
    private String candidateClassName;

    /** The parameter declarations. */
    private StringBuffer parameterDecls;

    /** The variable declarations. */
    private StringBuffer variableDecls;

    /** The filter expression. */
    private StringBuffer filter;

    /** The ordering expression. */
    private StringBuffer ordering;

    /** The result expression. */
    private StringBuffer result;

    /** The result type. */
    private String resultType;

    /** Flag indicating whether the result element is a pc class. */
    private boolean isPCResult;

    /**
     *  Flag indicating whether the result element is associated to an
     *  aggregate function.
     */
    private boolean isAggregate = false;

    /** Counter for variables defined during codegen. */
    private int tmpVarCount = 0;

    /** 
     * Counter indicating how many parenthesis need to be closed 
     * at the end of the filter expr. 
     */
    private int parenCount = 0;
    
    /** Flag indicates whether the select clause has DISTINCT. */
    private boolean isDistinct = false;

    /**
     *
     */
    public void init(TypeSupport typeSupport, ParameterSupport paramSupport)
    {
        this.typeSupport = typeSupport;
        this.paramSupport = paramSupport;
    }

    /** */
    public void reportError(RecognitionException ex) {
        ErrorMsg.fatal(I18NHelper.getMessage(msgs, 
                "ERR_JDOQLCodeGenerationError"), ex); //NOI18N
    }

    /** */
    public void reportError(String s) {
        ErrorMsg.fatal(I18NHelper.getMessage(msgs, 
                "ERR_JDOQLCodeGenerationError") + s); //NOI18N
    }

    /** 
     * Returns the result of an EJBQL compile process. 
     * A JDOQLElements instances represents all the necessary information to 
     * create a JDOQL query instance that corresponds to the EJBQL query.
     * @return JDOQLElements instance representing the JDOQL query.
     */
    public JDOQLElements getJDOQLElements()
    {

        return new JDOQLElements(candidateClassName, parameterDecls.toString(),
            variableDecls.toString(), filter.toString(), ordering.toString(),
            result.toString(), resultType, isPCResult, isAggregate,
            paramSupport.getParameterEjbNames());
    }

    //========= Internal helper methods ==========

    /**
     * Extracts the name of the candidate class of the JDOQL query from the 
     * select- and from-clause of the EJBQL query.
     */
    private void handleCandidateClass(EJBQLAST query)
        throws RecognitionException
    {
        EJBQLAST from = (EJBQLAST)query.getFirstChild();
        EJBQLAST select = (EJBQLAST)from.getNextSibling();
        EJBQLAST var = null;
        var = extractIdentificationVariable(select);
        var = getIdentificationVarDecl(from, var.getText());
        candidateClassIdentificationVar = var.getText();
        candidateClassName = 
            typeSupport.getPCForTypeInfo(var.getTypeInfo());
    }

    /** 
     * Calculates the parameter declarations of the JDOQL query from the 
     * signature of the EJB finsder or selector method.
     */
    private void initParameterDeclarations()
    {
        parameterDecls = new StringBuffer();
        for (int i = 1; i <= paramSupport.getParameterCount(); i++) {
            String name = paramSupport.getParameterName(i);
            Object type = typeSupport.getTypeInfo(paramSupport.getParameterType(i));
            String ejbName = paramSupport.getParameterEjbName(i);
            String pcClassName = null;
            if (ejbName != null) {
                pcClassName = typeSupport.getPCForTypeInfo(ejbName);
            } else if (typeSupport.isLocalInterface(type) ||
                    typeSupport.isRemoteInterface(type)) {
                // This parameter corresponds to an EJB but the ejbName 
                // cannot be determined from query.
                // Since different EJBs may have the same interfaces,
                // the explicit pcClassName cannot be determined.
                pcClassName = "java.lang.Object";
            } else {
                pcClassName = typeSupport.getPCForTypeInfo(type);
            }

            parameterDecls.append(pcClassName);
            parameterDecls.append(" "); //NOI18N
            parameterDecls.append(name);
            parameterDecls.append(", "); //NOI18N
        }
    }

    /** 
     * EJBQL string literals escape a single quote using two single quotes. 
     * In JDOQL string literals single quotes need not to be escaped => 
     * replace '' by '.
     */
    private String convertStringLiteral(String ejbqlStringLiteral)
    {
        // first replace '' by '
        String ret = StringHelper.replace(ejbqlStringLiteral, "''", "'"); //NOI18N
        // Add a hack for a backslash at the end of the literal
        // Note, we might need to escape backslashes in the entire string 
        // literal, if the character following the backslash is an "escaped" 
        // char such as \n, \n, etc. Needs some further investigation.
        if (ret.endsWith("\\")) {
            ret = ret + "\\";
        }
        return ret;
    }
    
    /** */
    private EJBQLAST getIdentificationVarDecl(EJBQLAST from, String varName)
        throws RecognitionException
    {
        // iterate all identification var declarations
        for (EJBQLAST varDecl = (EJBQLAST)from.getFirstChild();
            varDecl != null;
            varDecl = (EJBQLAST)varDecl.getNextSibling()) {
            // domain of the current variable declaration
            EJBQLAST domain = (EJBQLAST)varDecl.getFirstChild();
            // identification variable node
            EJBQLAST varNode = (EJBQLAST)domain.getNextSibling();
            if (varNode.getText().equalsIgnoreCase(varName)) {
                // found the declaration node of the variable we are looking for
                if (domain.getType() == ABSTRACT_SCHEMA_NAME)
                    // the domain is a abstract schema type => found the var decl
                    return varNode;
                else
                    // domain is a collectionMemberDecl => use its var decl
                    return getIdentificationVarDecl(from, 
                        extractIdentificationVariable(domain).getText());
            }
        }
        return null;
    }

    /** 
     * Returns the name of a new variable of the JDOQL query.
     */
    private String getTmpVarName()
    {
        // TBD: The name must not conflict with a defined identification variable
        int no = tmpVarCount++;
        return "_jdoVar" + no; //NOI18N
    }
    
    /**
     * Returns the typeInfo of the element type of a collection valued CMR field.
     */
    private Object getElementTypeOfCollectionValuedCMR(EJBQLAST cmrFieldAccess)
    {
        EJBQLAST classExpr = (EJBQLAST)cmrFieldAccess.getFirstChild();
        EJBQLAST cmrField = (EJBQLAST)classExpr.getNextSibling();
        Object fieldInfo = typeSupport.getFieldInfo(
            classExpr.getTypeInfo(), cmrField.getText());
        return typeSupport.getElementType(fieldInfo);
    }
    
public JDOQLCodeGeneration() {
	tokenNames = _tokenNames;
}

	public final void query(AST _t) throws RecognitionException {
		
		EJBQLAST query_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		EJBQLAST q = null;
		
		AST __t2 = _t;
		q = _t==ASTNULL ? null :(EJBQLAST)_t;
		match(_t,QUERY);
		_t = _t.getFirstChild();
		
		initParameterDeclarations();
		variableDecls = new StringBuffer();
		filter = new StringBuffer();
		ordering = new StringBuffer();
		result = new StringBuffer();
		handleCandidateClass(q);
		
		fromClause(_t);
		_t = _retTree;
		selectClause(_t);
		_t = _retTree;
		whereClause(_t);
		_t = _retTree;
		orderbyClause(_t);
		_t = _retTree;
		_t = __t2;
		_t = _t.getNextSibling();
		_retTree = _t;
	}
	
	public final void fromClause(AST _t) throws RecognitionException {
		
		EJBQLAST fromClause_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		
		AST __t21 = _t;
		EJBQLAST tmp1_AST_in = (EJBQLAST)_t;
		match(_t,FROM);
		_t = _t.getFirstChild();
		{
		int _cnt23=0;
		_loop23:
		do {
			if (_t==null) _t=ASTNULL;
			if ((_t.getType()==IN||_t.getType()==RANGE)) {
				identificationVarDecl(_t);
				_t = _retTree;
			}
			else {
				if ( _cnt23>=1 ) { break _loop23; } else {throw new NoViableAltException(_t);}
			}
			
			_cnt23++;
		} while (true);
		}
		_t = __t21;
		_t = _t.getNextSibling();
		_retTree = _t;
	}
	
	public final void selectClause(AST _t) throws RecognitionException {
		
		EJBQLAST selectClause_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		EJBQLAST p = null;
		
		AST __t30 = _t;
		EJBQLAST tmp2_AST_in = (EJBQLAST)_t;
		match(_t,SELECT);
		_t = _t.getFirstChild();
		distinct(_t,result);
		_t = _retTree;
		p = _t==ASTNULL ? null : (EJBQLAST)_t;
		projection(_t,result);
		_t = _retTree;
		_t = __t30;
		_t = _t.getNextSibling();
		
		isPCResult = typeSupport.isEjbName(p.getTypeInfo());
		resultType = isPCResult ? 
		typeSupport.getPCForTypeInfo(p.getTypeInfo()) :
		typeSupport.getTypeName(p.getTypeInfo());
		
		_retTree = _t;
	}
	
	public final void whereClause(AST _t) throws RecognitionException {
		
		EJBQLAST whereClause_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		
		AST __t41 = _t;
		EJBQLAST tmp3_AST_in = (EJBQLAST)_t;
		match(_t,WHERE);
		_t = _t.getFirstChild();
		
		if (filter.length() > 0) {
		filter.append(" & ("); //NOI18N
		// filter.length() > 0 means there are one or more contains 
		// clauses generated from parsing the from clause => 
		// enclose the where clause expression into parenthesis.
		parenCount++;
		}
		
		expression(_t,filter);
		_t = _retTree;
		
		while (parenCount > 0) {
		filter.append(")"); //NOI18N
		parenCount--;
		}
		
		_t = __t41;
		_t = _t.getNextSibling();
		_retTree = _t;
	}
	
	public final void orderbyClause(AST _t) throws RecognitionException {
		
		EJBQLAST orderbyClause_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case ORDER:
		{
			AST __t43 = _t;
			EJBQLAST tmp4_AST_in = (EJBQLAST)_t;
			match(_t,ORDER);
			_t = _t.getFirstChild();
			{
			int _cnt46=0;
			_loop46:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_tokenSet_0.member(_t.getType()))) {
					
					if (ordering.length() > 0) {
					ordering.append(", ");  
					}
					
					pathExpr(_t,ordering);
					_t = _retTree;
					{
					if (_t==null) _t=ASTNULL;
					switch ( _t.getType()) {
					case ASC:
					{
						EJBQLAST tmp5_AST_in = (EJBQLAST)_t;
						match(_t,ASC);
						_t = _t.getNextSibling();
						ordering.append(" ascending");
						break;
					}
					case DESC:
					{
						EJBQLAST tmp6_AST_in = (EJBQLAST)_t;
						match(_t,DESC);
						_t = _t.getNextSibling();
						ordering.append(" descending");
						break;
					}
					default:
					{
						throw new NoViableAltException(_t);
					}
					}
					}
				}
				else {
					if ( _cnt46>=1 ) { break _loop46; } else {throw new NoViableAltException(_t);}
				}
				
				_cnt46++;
			} while (true);
			}
			_t = __t43;
			_t = _t.getNextSibling();
			break;
		}
		case 3:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
	}
	
	public final EJBQLAST  extractIdentificationVariable(AST _t) throws RecognitionException {
		EJBQLAST var;
		
		EJBQLAST extractIdentificationVariable_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		EJBQLAST i = null;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case SELECT:
		{
			AST __t4 = _t;
			EJBQLAST tmp7_AST_in = (EJBQLAST)_t;
			match(_t,SELECT);
			_t = _t.getFirstChild();
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case DISTINCT:
			{
				EJBQLAST tmp8_AST_in = (EJBQLAST)_t;
				match(_t,DISTINCT);
				_t = _t.getNextSibling();
				break;
			}
			case SELECT:
			case OBJECT:
			case AVG:
			case MAX:
			case MIN:
			case SUM:
			case COUNT:
			case CMP_FIELD_ACCESS:
			case SINGLE_CMR_FIELD_ACCESS:
			case COLLECTION_CMR_FIELD_ACCESS:
			case IDENTIFICATION_VAR:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			var=extractIdentificationVariable(_t);
			_t = _retTree;
			_t = __t4;
			_t = _t.getNextSibling();
			break;
		}
		case CMP_FIELD_ACCESS:
		{
			AST __t6 = _t;
			EJBQLAST tmp9_AST_in = (EJBQLAST)_t;
			match(_t,CMP_FIELD_ACCESS);
			_t = _t.getFirstChild();
			var=extractIdentificationVariable(_t);
			_t = _retTree;
			EJBQLAST tmp10_AST_in = (EJBQLAST)_t;
			if ( _t==null ) throw new MismatchedTokenException();
			_t = _t.getNextSibling();
			_t = __t6;
			_t = _t.getNextSibling();
			break;
		}
		case SINGLE_CMR_FIELD_ACCESS:
		{
			AST __t7 = _t;
			EJBQLAST tmp11_AST_in = (EJBQLAST)_t;
			match(_t,SINGLE_CMR_FIELD_ACCESS);
			_t = _t.getFirstChild();
			var=extractIdentificationVariable(_t);
			_t = _retTree;
			EJBQLAST tmp12_AST_in = (EJBQLAST)_t;
			if ( _t==null ) throw new MismatchedTokenException();
			_t = _t.getNextSibling();
			_t = __t7;
			_t = _t.getNextSibling();
			break;
		}
		case COLLECTION_CMR_FIELD_ACCESS:
		{
			AST __t8 = _t;
			EJBQLAST tmp13_AST_in = (EJBQLAST)_t;
			match(_t,COLLECTION_CMR_FIELD_ACCESS);
			_t = _t.getFirstChild();
			var=extractIdentificationVariable(_t);
			_t = _retTree;
			EJBQLAST tmp14_AST_in = (EJBQLAST)_t;
			if ( _t==null ) throw new MismatchedTokenException();
			_t = _t.getNextSibling();
			_t = __t8;
			_t = _t.getNextSibling();
			break;
		}
		case OBJECT:
		{
			AST __t9 = _t;
			EJBQLAST tmp15_AST_in = (EJBQLAST)_t;
			match(_t,OBJECT);
			_t = _t.getFirstChild();
			var=extractIdentificationVariable(_t);
			_t = _retTree;
			_t = __t9;
			_t = _t.getNextSibling();
			break;
		}
		case AVG:
		{
			AST __t10 = _t;
			EJBQLAST tmp16_AST_in = (EJBQLAST)_t;
			match(_t,AVG);
			_t = _t.getFirstChild();
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case DISTINCT:
			{
				EJBQLAST tmp17_AST_in = (EJBQLAST)_t;
				match(_t,DISTINCT);
				_t = _t.getNextSibling();
				break;
			}
			case SELECT:
			case OBJECT:
			case AVG:
			case MAX:
			case MIN:
			case SUM:
			case COUNT:
			case CMP_FIELD_ACCESS:
			case SINGLE_CMR_FIELD_ACCESS:
			case COLLECTION_CMR_FIELD_ACCESS:
			case IDENTIFICATION_VAR:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			var=extractIdentificationVariable(_t);
			_t = _retTree;
			_t = __t10;
			_t = _t.getNextSibling();
			break;
		}
		case MAX:
		{
			AST __t12 = _t;
			EJBQLAST tmp18_AST_in = (EJBQLAST)_t;
			match(_t,MAX);
			_t = _t.getFirstChild();
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case DISTINCT:
			{
				EJBQLAST tmp19_AST_in = (EJBQLAST)_t;
				match(_t,DISTINCT);
				_t = _t.getNextSibling();
				break;
			}
			case SELECT:
			case OBJECT:
			case AVG:
			case MAX:
			case MIN:
			case SUM:
			case COUNT:
			case CMP_FIELD_ACCESS:
			case SINGLE_CMR_FIELD_ACCESS:
			case COLLECTION_CMR_FIELD_ACCESS:
			case IDENTIFICATION_VAR:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			var=extractIdentificationVariable(_t);
			_t = _retTree;
			_t = __t12;
			_t = _t.getNextSibling();
			break;
		}
		case MIN:
		{
			AST __t14 = _t;
			EJBQLAST tmp20_AST_in = (EJBQLAST)_t;
			match(_t,MIN);
			_t = _t.getFirstChild();
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case DISTINCT:
			{
				EJBQLAST tmp21_AST_in = (EJBQLAST)_t;
				match(_t,DISTINCT);
				_t = _t.getNextSibling();
				break;
			}
			case SELECT:
			case OBJECT:
			case AVG:
			case MAX:
			case MIN:
			case SUM:
			case COUNT:
			case CMP_FIELD_ACCESS:
			case SINGLE_CMR_FIELD_ACCESS:
			case COLLECTION_CMR_FIELD_ACCESS:
			case IDENTIFICATION_VAR:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			var=extractIdentificationVariable(_t);
			_t = _retTree;
			_t = __t14;
			_t = _t.getNextSibling();
			break;
		}
		case SUM:
		{
			AST __t16 = _t;
			EJBQLAST tmp22_AST_in = (EJBQLAST)_t;
			match(_t,SUM);
			_t = _t.getFirstChild();
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case DISTINCT:
			{
				EJBQLAST tmp23_AST_in = (EJBQLAST)_t;
				match(_t,DISTINCT);
				_t = _t.getNextSibling();
				break;
			}
			case SELECT:
			case OBJECT:
			case AVG:
			case MAX:
			case MIN:
			case SUM:
			case COUNT:
			case CMP_FIELD_ACCESS:
			case SINGLE_CMR_FIELD_ACCESS:
			case COLLECTION_CMR_FIELD_ACCESS:
			case IDENTIFICATION_VAR:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			var=extractIdentificationVariable(_t);
			_t = _retTree;
			_t = __t16;
			_t = _t.getNextSibling();
			break;
		}
		case COUNT:
		{
			AST __t18 = _t;
			EJBQLAST tmp24_AST_in = (EJBQLAST)_t;
			match(_t,COUNT);
			_t = _t.getFirstChild();
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case DISTINCT:
			{
				EJBQLAST tmp25_AST_in = (EJBQLAST)_t;
				match(_t,DISTINCT);
				_t = _t.getNextSibling();
				break;
			}
			case SELECT:
			case OBJECT:
			case AVG:
			case MAX:
			case MIN:
			case SUM:
			case COUNT:
			case CMP_FIELD_ACCESS:
			case SINGLE_CMR_FIELD_ACCESS:
			case COLLECTION_CMR_FIELD_ACCESS:
			case IDENTIFICATION_VAR:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			var=extractIdentificationVariable(_t);
			_t = _retTree;
			_t = __t18;
			_t = _t.getNextSibling();
			break;
		}
		case IDENTIFICATION_VAR:
		{
			i = (EJBQLAST)_t;
			match(_t,IDENTIFICATION_VAR);
			_t = _t.getNextSibling();
			var = i;
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
		return var;
	}
	
	public final void identificationVarDecl(AST _t) throws RecognitionException {
		
		EJBQLAST identificationVarDecl_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case IN:
		{
			collectionMemberDecl(_t);
			_t = _retTree;
			break;
		}
		case RANGE:
		{
			rangeVarDecl(_t);
			_t = _retTree;
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
	}
	
	public final void collectionMemberDecl(AST _t) throws RecognitionException {
		
		EJBQLAST collectionMemberDecl_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		EJBQLAST v = null;
		
		AST __t26 = _t;
		EJBQLAST tmp26_AST_in = (EJBQLAST)_t;
		match(_t,IN);
		_t = _t.getFirstChild();
		
		if (filter.length() > 0) {
		// Please note, the FROM clause is processed prior to the 
		// WHERE clause, so a filter of length == 0 means we are 
		// processing the first IN clause of the FROM clause.
		// We need to add an & operator and an open parenthesis for 
		// all IN clauses but the first one. The parenthesis ensure 
		// the resulting filter is portable, meaning the contains 
		// clause must be the left expression of an AND-expression 
		// where the variable is used in the right expression. 
		filter.append(" & ("); //NOI18N
		parenCount++;
		}
		
		pathExpr(_t,filter);
		_t = _retTree;
		v = (EJBQLAST)_t;
		match(_t,IDENTIFICATION_VAR_DECL);
		_t = _t.getNextSibling();
		
		// generate varibale declaration
		variableDecls.append(typeSupport.getPCForTypeInfo(
		v.getTypeInfo()));
		variableDecls.append(' ');
		variableDecls.append(v.getText());
		variableDecls.append("; "); //NOI18N
		// now generate the contains clause
		filter.append(".contains("); //NOI18N
		filter.append(v.getText()); 
		filter.append(')');
		
		_t = __t26;
		_t = _t.getNextSibling();
		_retTree = _t;
	}
	
	public final void rangeVarDecl(AST _t) throws RecognitionException {
		
		EJBQLAST rangeVarDecl_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		EJBQLAST v = null;
		
		AST __t28 = _t;
		EJBQLAST tmp27_AST_in = (EJBQLAST)_t;
		match(_t,RANGE);
		_t = _t.getFirstChild();
		EJBQLAST tmp28_AST_in = (EJBQLAST)_t;
		match(_t,ABSTRACT_SCHEMA_NAME);
		_t = _t.getNextSibling();
		v = (EJBQLAST)_t;
		match(_t,IDENTIFICATION_VAR_DECL);
		_t = _t.getNextSibling();
		_t = __t28;
		_t = _t.getNextSibling();
		
		// Do not generate variable decl for identification variable 
		// that represents the candidate class
		if (!v.getText().equalsIgnoreCase(candidateClassIdentificationVar)) {
		variableDecls.append(typeSupport.getPCForTypeInfo(
		v.getTypeInfo()));
		variableDecls.append(' ');
		variableDecls.append(v.getText());
		variableDecls.append("; "); //NOI18N
		}
		
		_retTree = _t;
	}
	
	public final void pathExpr(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST pathExpr_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		EJBQLAST f1 = null;
		EJBQLAST f2 = null;
		EJBQLAST f3 = null;
		EJBQLAST v = null;
		EJBQLAST dot = null;
		EJBQLAST i = null;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case CMP_FIELD_ACCESS:
		{
			AST __t115 = _t;
			EJBQLAST tmp29_AST_in = (EJBQLAST)_t;
			match(_t,CMP_FIELD_ACCESS);
			_t = _t.getFirstChild();
			pathExpr(_t,buf);
			_t = _retTree;
			buf.append('.');
			f1 = _t==ASTNULL ? null : (EJBQLAST)_t;
			field(_t);
			_t = _retTree;
			buf.append(f1.getText());
			_t = __t115;
			_t = _t.getNextSibling();
			break;
		}
		case SINGLE_CMR_FIELD_ACCESS:
		{
			AST __t116 = _t;
			EJBQLAST tmp30_AST_in = (EJBQLAST)_t;
			match(_t,SINGLE_CMR_FIELD_ACCESS);
			_t = _t.getFirstChild();
			pathExpr(_t,buf);
			_t = _retTree;
			buf.append('.');
			f2 = _t==ASTNULL ? null : (EJBQLAST)_t;
			field(_t);
			_t = _retTree;
			buf.append(f2.getText());
			_t = __t116;
			_t = _t.getNextSibling();
			break;
		}
		case COLLECTION_CMR_FIELD_ACCESS:
		{
			AST __t117 = _t;
			EJBQLAST tmp31_AST_in = (EJBQLAST)_t;
			match(_t,COLLECTION_CMR_FIELD_ACCESS);
			_t = _t.getFirstChild();
			pathExpr(_t,buf);
			_t = _retTree;
			buf.append('.');
			f3 = _t==ASTNULL ? null : (EJBQLAST)_t;
			field(_t);
			_t = _retTree;
			buf.append(f3.getText());
			_t = __t117;
			_t = _t.getNextSibling();
			break;
		}
		case IDENTIFICATION_VAR:
		{
			v = (EJBQLAST)_t;
			match(_t,IDENTIFICATION_VAR);
			_t = _t.getNextSibling();
			
			String name = v.getText();
			if (name.equalsIgnoreCase(candidateClassIdentificationVar))
			name = "this"; //NOI18N
			buf.append(name);
			
			break;
		}
		case DOT:
		{
			AST __t118 = _t;
			dot = _t==ASTNULL ? null :(EJBQLAST)_t;
			match(_t,DOT);
			_t = _t.getFirstChild();
			expression(_t,buf);
			_t = _retTree;
			expression(_t,buf);
			_t = _retTree;
			_t = __t118;
			_t = _t.getNextSibling();
			
			ErrorMsg.fatal(I18NHelper.getMessage(msgs, "ERR_UnexpectedNode", //NOI18N
			dot.getText(), String.valueOf(dot.getType())));
			
			break;
		}
		case IDENT:
		{
			i = (EJBQLAST)_t;
			match(_t,IDENT);
			_t = _t.getNextSibling();
			
			ErrorMsg.fatal(I18NHelper.getMessage(msgs, "ERR_UnexpectedNode", //NOI18N
			i.getText(), String.valueOf(i.getType())));
			
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
	}
	
	public final void distinct(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST distinct_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case DISTINCT:
		{
			EJBQLAST tmp32_AST_in = (EJBQLAST)_t;
			match(_t,DISTINCT);
			_t = _t.getNextSibling();
			isDistinct = true;
			break;
		}
		case OBJECT:
		case AVG:
		case MAX:
		case MIN:
		case SUM:
		case COUNT:
		case IDENT:
		case DOT:
		case CMP_FIELD_ACCESS:
		case SINGLE_CMR_FIELD_ACCESS:
		case COLLECTION_CMR_FIELD_ACCESS:
		case IDENTIFICATION_VAR:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
	}
	
	public final void projection(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST projection_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		EJBQLAST p = null;
		EJBQLAST o = null;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case AVG:
		{
			AST __t34 = _t;
			EJBQLAST tmp33_AST_in = (EJBQLAST)_t;
			match(_t,AVG);
			_t = _t.getFirstChild();
			
			isAggregate = true;
			buf.append("avg(");
			
			aggregateDistinct(_t,buf);
			_t = _retTree;
			pathExpr(_t,buf);
			_t = _retTree;
			buf.append(")");
			_t = __t34;
			_t = _t.getNextSibling();
			break;
		}
		case MAX:
		{
			AST __t35 = _t;
			EJBQLAST tmp34_AST_in = (EJBQLAST)_t;
			match(_t,MAX);
			_t = _t.getFirstChild();
			
			isAggregate = true;
			buf.append("max(");
			
			aggregateDistinct(_t,buf);
			_t = _retTree;
			p = _t==ASTNULL ? null : (EJBQLAST)_t;
			pathExpr(_t,buf);
			_t = _retTree;
			buf.append(")");
			_t = __t35;
			_t = _t.getNextSibling();
			break;
		}
		case MIN:
		{
			AST __t36 = _t;
			EJBQLAST tmp35_AST_in = (EJBQLAST)_t;
			match(_t,MIN);
			_t = _t.getFirstChild();
			
			isAggregate = true;
			buf.append("min(");
			
			aggregateDistinct(_t,buf);
			_t = _retTree;
			pathExpr(_t,buf);
			_t = _retTree;
			buf.append(")");
			_t = __t36;
			_t = _t.getNextSibling();
			break;
		}
		case SUM:
		{
			AST __t37 = _t;
			EJBQLAST tmp36_AST_in = (EJBQLAST)_t;
			match(_t,SUM);
			_t = _t.getFirstChild();
			
			isAggregate = true;
			buf.append("sum(");
			
			aggregateDistinct(_t,buf);
			_t = _retTree;
			pathExpr(_t,buf);
			_t = _retTree;
			buf.append(")");
			_t = __t37;
			_t = _t.getNextSibling();
			break;
		}
		case COUNT:
		{
			AST __t38 = _t;
			EJBQLAST tmp37_AST_in = (EJBQLAST)_t;
			match(_t,COUNT);
			_t = _t.getFirstChild();
			
			isAggregate = true;
			buf.append("count(");
			
			aggregateDistinct(_t,buf);
			_t = _retTree;
			pathExpr(_t,buf);
			_t = _retTree;
			buf.append(")");
			_t = __t38;
			_t = _t.getNextSibling();
			break;
		}
		case IDENT:
		case DOT:
		case CMP_FIELD_ACCESS:
		case SINGLE_CMR_FIELD_ACCESS:
		case COLLECTION_CMR_FIELD_ACCESS:
		case IDENTIFICATION_VAR:
		{
			
			if (isDistinct) {
			buf.append("distinct "); //NOI18N
			}
			
			pathExpr(_t,buf);
			_t = _retTree;
			break;
		}
		case OBJECT:
		{
			
			if (isDistinct) {
			buf.append("distinct "); //NOI18N
			}
			
			AST __t39 = _t;
			o = _t==ASTNULL ? null :(EJBQLAST)_t;
			match(_t,OBJECT);
			_t = _t.getFirstChild();
			pathExpr(_t,buf);
			_t = _retTree;
			_t = __t39;
			_t = _t.getNextSibling();
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
	}
	
	public final void aggregateDistinct(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST aggregateDistinct_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case DISTINCT:
		{
			EJBQLAST tmp38_AST_in = (EJBQLAST)_t;
			match(_t,DISTINCT);
			_t = _t.getNextSibling();
			buf.append("distinct ");
			break;
		}
		case IDENT:
		case DOT:
		case CMP_FIELD_ACCESS:
		case SINGLE_CMR_FIELD_ACCESS:
		case COLLECTION_CMR_FIELD_ACCESS:
		case IDENTIFICATION_VAR:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
	}
	
	public final void expression(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST expression_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case AND:
		case OR:
		{
			conditionalExpr(_t,buf);
			_t = _retTree;
			break;
		}
		case EQUAL:
		case NOT_EQUAL:
		case GE:
		case GT:
		case LE:
		case LT:
		{
			relationalExpr(_t,buf);
			_t = _retTree;
			break;
		}
		case PLUS:
		case MINUS:
		case STAR:
		case DIV:
		{
			binaryArithmeticExpr(_t,buf);
			_t = _retTree;
			break;
		}
		case NOT:
		case UNARY_MINUS:
		case UNARY_PLUS:
		{
			unaryExpr(_t,buf);
			_t = _retTree;
			break;
		}
		case BETWEEN:
		case NOT_BETWEEN:
		{
			betweenExpr(_t,buf);
			_t = _retTree;
			break;
		}
		case LIKE:
		case NOT_LIKE:
		{
			likeExpr(_t,buf);
			_t = _retTree;
			break;
		}
		case IN:
		case NOT_IN:
		{
			inExpr(_t,buf);
			_t = _retTree;
			break;
		}
		case NULL:
		case NOT_NULL:
		{
			nullComparisonExpr(_t,buf);
			_t = _retTree;
			break;
		}
		case EMPTY:
		case NOT_EMPTY:
		{
			emptyCollectionComparisonExpr(_t,buf);
			_t = _retTree;
			break;
		}
		case MEMBER:
		case NOT_MEMBER:
		{
			collectionMemberExpr(_t,buf);
			_t = _retTree;
			break;
		}
		case CONCAT:
		case SUBSTRING:
		case LOCATE:
		case LENGTH:
		case ABS:
		case SQRT:
		case MOD:
		{
			function(_t,buf);
			_t = _retTree;
			break;
		}
		case TRUE:
		case FALSE:
		case STRING_LITERAL:
		case INT_LITERAL:
		case LONG_LITERAL:
		case FLOAT_LITERAL:
		case DOUBLE_LITERAL:
		case IDENT:
		case DOT:
		case INPUT_PARAMETER:
		case CMP_FIELD_ACCESS:
		case SINGLE_CMR_FIELD_ACCESS:
		case COLLECTION_CMR_FIELD_ACCESS:
		case IDENTIFICATION_VAR:
		{
			primary(_t,buf);
			_t = _retTree;
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
	}
	
	public final void conditionalExpr(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST conditionalExpr_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case AND:
		{
			AST __t49 = _t;
			EJBQLAST tmp39_AST_in = (EJBQLAST)_t;
			match(_t,AND);
			_t = _t.getFirstChild();
			buf.append("(");
			expression(_t,buf);
			_t = _retTree;
			buf.append(" & ");
			expression(_t,buf);
			_t = _retTree;
			buf.append(")");
			_t = __t49;
			_t = _t.getNextSibling();
			break;
		}
		case OR:
		{
			AST __t50 = _t;
			EJBQLAST tmp40_AST_in = (EJBQLAST)_t;
			match(_t,OR);
			_t = _t.getFirstChild();
			buf.append("(");
			expression(_t,buf);
			_t = _retTree;
			buf.append(" | ");
			expression(_t,buf);
			_t = _retTree;
			buf.append(")");
			_t = __t50;
			_t = _t.getNextSibling();
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
	}
	
	public final void relationalExpr(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST relationalExpr_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case EQUAL:
		{
			AST __t52 = _t;
			EJBQLAST tmp41_AST_in = (EJBQLAST)_t;
			match(_t,EQUAL);
			_t = _t.getFirstChild();
			buf.append("(");
			expression(_t,buf);
			_t = _retTree;
			buf.append(" == ");
			expression(_t,buf);
			_t = _retTree;
			buf.append(")");
			_t = __t52;
			_t = _t.getNextSibling();
			break;
		}
		case NOT_EQUAL:
		{
			AST __t53 = _t;
			EJBQLAST tmp42_AST_in = (EJBQLAST)_t;
			match(_t,NOT_EQUAL);
			_t = _t.getFirstChild();
			buf.append("(");
			expression(_t,buf);
			_t = _retTree;
			buf.append(" != ");
			expression(_t,buf);
			_t = _retTree;
			buf.append(")");
			_t = __t53;
			_t = _t.getNextSibling();
			break;
		}
		case LT:
		{
			AST __t54 = _t;
			EJBQLAST tmp43_AST_in = (EJBQLAST)_t;
			match(_t,LT);
			_t = _t.getFirstChild();
			buf.append("(");
			expression(_t,buf);
			_t = _retTree;
			buf.append(" < ");
			expression(_t,buf);
			_t = _retTree;
			buf.append(")");
			_t = __t54;
			_t = _t.getNextSibling();
			break;
		}
		case LE:
		{
			AST __t55 = _t;
			EJBQLAST tmp44_AST_in = (EJBQLAST)_t;
			match(_t,LE);
			_t = _t.getFirstChild();
			buf.append("(");
			expression(_t,buf);
			_t = _retTree;
			buf.append(" <= ");
			expression(_t,buf);
			_t = _retTree;
			buf.append(")");
			_t = __t55;
			_t = _t.getNextSibling();
			break;
		}
		case GT:
		{
			AST __t56 = _t;
			EJBQLAST tmp45_AST_in = (EJBQLAST)_t;
			match(_t,GT);
			_t = _t.getFirstChild();
			buf.append("(");
			expression(_t,buf);
			_t = _retTree;
			buf.append(" > ");
			expression(_t,buf);
			_t = _retTree;
			buf.append(")");
			_t = __t56;
			_t = _t.getNextSibling();
			break;
		}
		case GE:
		{
			AST __t57 = _t;
			EJBQLAST tmp46_AST_in = (EJBQLAST)_t;
			match(_t,GE);
			_t = _t.getFirstChild();
			buf.append("(");
			expression(_t,buf);
			_t = _retTree;
			buf.append(" >= ");
			expression(_t,buf);
			_t = _retTree;
			buf.append(")");
			_t = __t57;
			_t = _t.getNextSibling();
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
	}
	
	public final void binaryArithmeticExpr(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST binaryArithmeticExpr_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case PLUS:
		{
			AST __t59 = _t;
			EJBQLAST tmp47_AST_in = (EJBQLAST)_t;
			match(_t,PLUS);
			_t = _t.getFirstChild();
			buf.append("(");
			expression(_t,buf);
			_t = _retTree;
			buf.append(" + ");
			expression(_t,buf);
			_t = _retTree;
			buf.append(")");
			_t = __t59;
			_t = _t.getNextSibling();
			break;
		}
		case MINUS:
		{
			AST __t60 = _t;
			EJBQLAST tmp48_AST_in = (EJBQLAST)_t;
			match(_t,MINUS);
			_t = _t.getFirstChild();
			buf.append("(");
			expression(_t,buf);
			_t = _retTree;
			buf.append(" - ");
			expression(_t,buf);
			_t = _retTree;
			buf.append(")");
			_t = __t60;
			_t = _t.getNextSibling();
			break;
		}
		case STAR:
		{
			AST __t61 = _t;
			EJBQLAST tmp49_AST_in = (EJBQLAST)_t;
			match(_t,STAR);
			_t = _t.getFirstChild();
			buf.append("(");
			expression(_t,buf);
			_t = _retTree;
			buf.append(" * ");
			expression(_t,buf);
			_t = _retTree;
			buf.append(")");
			_t = __t61;
			_t = _t.getNextSibling();
			break;
		}
		case DIV:
		{
			AST __t62 = _t;
			EJBQLAST tmp50_AST_in = (EJBQLAST)_t;
			match(_t,DIV);
			_t = _t.getFirstChild();
			buf.append("(");
			expression(_t,buf);
			_t = _retTree;
			buf.append(" / ");
			expression(_t,buf);
			_t = _retTree;
			buf.append(")");
			_t = __t62;
			_t = _t.getNextSibling();
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
	}
	
	public final void unaryExpr(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST unaryExpr_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case UNARY_PLUS:
		{
			AST __t64 = _t;
			EJBQLAST tmp51_AST_in = (EJBQLAST)_t;
			match(_t,UNARY_PLUS);
			_t = _t.getFirstChild();
			expression(_t,buf);
			_t = _retTree;
			_t = __t64;
			_t = _t.getNextSibling();
			break;
		}
		case UNARY_MINUS:
		{
			AST __t65 = _t;
			EJBQLAST tmp52_AST_in = (EJBQLAST)_t;
			match(_t,UNARY_MINUS);
			_t = _t.getFirstChild();
			buf.append(" -(");
			expression(_t,buf);
			_t = _retTree;
			buf.append(")");
			_t = __t65;
			_t = _t.getNextSibling();
			break;
		}
		case NOT:
		{
			AST __t66 = _t;
			EJBQLAST tmp53_AST_in = (EJBQLAST)_t;
			match(_t,NOT);
			_t = _t.getFirstChild();
			buf.append(" !(");
			expression(_t,buf);
			_t = _retTree;
			buf.append(")");
			_t = __t66;
			_t = _t.getNextSibling();
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
	}
	
	public final void betweenExpr(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST betweenExpr_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		
		StringBuffer tmp = new StringBuffer();
		
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case BETWEEN:
		{
			AST __t68 = _t;
			EJBQLAST tmp54_AST_in = (EJBQLAST)_t;
			match(_t,BETWEEN);
			_t = _t.getFirstChild();
			expression(_t,tmp);
			_t = _retTree;
			
			buf.append('('); 
			buf.append(tmp.toString()); 
			buf.append(" >= "); // NOI18N
			
			expression(_t,buf);
			_t = _retTree;
			
			buf.append(" & "); // NOI18N
			buf.append(tmp.toString());  
			buf.append(" <= "); // NOI18N
			
			expression(_t,buf);
			_t = _retTree;
			buf.append(')');
			_t = __t68;
			_t = _t.getNextSibling();
			break;
		}
		case NOT_BETWEEN:
		{
			AST __t69 = _t;
			EJBQLAST tmp55_AST_in = (EJBQLAST)_t;
			match(_t,NOT_BETWEEN);
			_t = _t.getFirstChild();
			expression(_t,tmp);
			_t = _retTree;
			
			buf.append('('); 
			buf.append(tmp.toString()); 
			buf.append(" < "); // NOI18N
			
			expression(_t,buf);
			_t = _retTree;
			
			buf.append(" | "); // NOI18N
			buf.append(tmp.toString());  
			buf.append(" > "); // NOI18N
			
			expression(_t,buf);
			_t = _retTree;
			buf.append(')');
			_t = __t69;
			_t = _t.getNextSibling();
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
	}
	
	public final void likeExpr(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST likeExpr_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case LIKE:
		{
			AST __t71 = _t;
			EJBQLAST tmp56_AST_in = (EJBQLAST)_t;
			match(_t,LIKE);
			_t = _t.getFirstChild();
			expression(_t,buf);
			_t = _retTree;
			buf.append(".like(");
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case STRING_LITERAL:
			{
				stringLiteral(_t,buf);
				_t = _retTree;
				break;
			}
			case INPUT_PARAMETER:
			{
				parameter(_t,buf);
				_t = _retTree;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			escape(_t,buf);
			_t = _retTree;
			buf.append(')');
			_t = __t71;
			_t = _t.getNextSibling();
			break;
		}
		case NOT_LIKE:
		{
			AST __t73 = _t;
			EJBQLAST tmp57_AST_in = (EJBQLAST)_t;
			match(_t,NOT_LIKE);
			_t = _t.getFirstChild();
			buf.append('!');
			expression(_t,buf);
			_t = _retTree;
			buf.append(".like(");
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case STRING_LITERAL:
			{
				stringLiteral(_t,buf);
				_t = _retTree;
				break;
			}
			case INPUT_PARAMETER:
			{
				parameter(_t,buf);
				_t = _retTree;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			escape(_t,buf);
			_t = _retTree;
			buf.append(')');
			_t = __t73;
			_t = _t.getNextSibling();
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
	}
	
	public final void inExpr(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST inExpr_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		
		StringBuffer expr = new StringBuffer();
		StringBuffer elementExpr = new StringBuffer();
		
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case IN:
		{
			AST __t80 = _t;
			EJBQLAST tmp58_AST_in = (EJBQLAST)_t;
			match(_t,IN);
			_t = _t.getFirstChild();
			expression(_t,expr);
			_t = _retTree;
			buf.append('(');
			primary(_t,elementExpr);
			_t = _retTree;
			
			buf.append('(');
			buf.append(expr.toString());
			buf.append(" == "); //NOI18N
			buf.append(elementExpr.toString());
			buf.append(')');
			
			{
			_loop82:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_tokenSet_1.member(_t.getType()))) {
					
					// create a new StringBuffer for the new elementExpr
					elementExpr = new StringBuffer(); 
					
					primary(_t,elementExpr);
					_t = _retTree;
					
					buf.append(" | "); //NOI18N
					buf.append('(');
					buf.append(expr.toString());
					buf.append(" == "); //NOI18N
					buf.append(elementExpr.toString());
					buf.append(')');
					
				}
				else {
					break _loop82;
				}
				
			} while (true);
			}
			
			buf.append(')'); 
			
			_t = __t80;
			_t = _t.getNextSibling();
			break;
		}
		case NOT_IN:
		{
			AST __t83 = _t;
			EJBQLAST tmp59_AST_in = (EJBQLAST)_t;
			match(_t,NOT_IN);
			_t = _t.getFirstChild();
			expression(_t,expr);
			_t = _retTree;
			buf.append('(');
			primary(_t,elementExpr);
			_t = _retTree;
			
			buf.append('(');
			buf.append(expr.toString());
			buf.append(" != "); //NOI18N
			buf.append(elementExpr.toString());
			buf.append(')');
			
			{
			_loop85:
			do {
				if (_t==null) _t=ASTNULL;
				if ((_tokenSet_1.member(_t.getType()))) {
					
					// create a new StringBuffer for the new elementExpr
					elementExpr = new StringBuffer(); 
					
					primary(_t,elementExpr);
					_t = _retTree;
					
					buf.append(" & "); //NOI18N
					buf.append('(');
					buf.append(expr.toString());
					buf.append(" != "); //NOI18N
					buf.append(elementExpr.toString());
					buf.append(')');
					
				}
				else {
					break _loop85;
				}
				
			} while (true);
			}
			
			buf.append(')'); 
			
			_t = __t83;
			_t = _t.getNextSibling();
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
	}
	
	public final void nullComparisonExpr(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST nullComparisonExpr_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case NULL:
		{
			AST __t87 = _t;
			EJBQLAST tmp60_AST_in = (EJBQLAST)_t;
			match(_t,NULL);
			_t = _t.getFirstChild();
			expression(_t,buf);
			_t = _retTree;
			buf.append(" == null");
			_t = __t87;
			_t = _t.getNextSibling();
			break;
		}
		case NOT_NULL:
		{
			AST __t88 = _t;
			EJBQLAST tmp61_AST_in = (EJBQLAST)_t;
			match(_t,NOT_NULL);
			_t = _t.getFirstChild();
			expression(_t,buf);
			_t = _retTree;
			buf.append(" != null");
			_t = __t88;
			_t = _t.getNextSibling();
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
	}
	
	public final void emptyCollectionComparisonExpr(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST emptyCollectionComparisonExpr_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case EMPTY:
		{
			AST __t90 = _t;
			EJBQLAST tmp62_AST_in = (EJBQLAST)_t;
			match(_t,EMPTY);
			_t = _t.getFirstChild();
			expression(_t,buf);
			_t = _retTree;
			buf.append(".isEmpty()");
			_t = __t90;
			_t = _t.getNextSibling();
			break;
		}
		case NOT_EMPTY:
		{
			AST __t91 = _t;
			EJBQLAST tmp63_AST_in = (EJBQLAST)_t;
			match(_t,NOT_EMPTY);
			_t = _t.getFirstChild();
			buf.append("!");
			expression(_t,buf);
			_t = _retTree;
			buf.append(".isEmpty()");
			_t = __t91;
			_t = _t.getNextSibling();
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
	}
	
	public final void collectionMemberExpr(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST collectionMemberExpr_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		EJBQLAST cmrAccess1 = null;
		EJBQLAST cmrAccess2 = null;
		
		StringBuffer member = new StringBuffer();
		StringBuffer col = new StringBuffer();
		
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case MEMBER:
		{
			AST __t93 = _t;
			EJBQLAST tmp64_AST_in = (EJBQLAST)_t;
			match(_t,MEMBER);
			_t = _t.getFirstChild();
			expression(_t,member);
			_t = _retTree;
			cmrAccess1 = _t==ASTNULL ? null : (EJBQLAST)_t;
			expression(_t,col);
			_t = _retTree;
			
			String varName = getTmpVarName();
			// Use the element type as variable type. The value might be 
			// an input parameter of a local/remote interface which we 
			// cannot uniquely map to a PC class during deployment.
			Object varType = getElementTypeOfCollectionValuedCMR(cmrAccess1);
			// generate varibale declaration
			variableDecls.append(typeSupport.getPCForTypeInfo(varType));
			variableDecls.append(' ');
			variableDecls.append(varName);
			variableDecls.append("; "); //NOI18N
			buf.append("("); //NOI18N
			buf.append(col.toString());
			buf.append(".contains(");  //NOI18N
			buf.append(varName);
			buf.append(") & "); //NOI18N
			buf.append(varName);
			buf.append(" == "); //NOI18N
			buf.append(member.toString());
			buf.append(")"); //NOI18N
			
			_t = __t93;
			_t = _t.getNextSibling();
			break;
		}
		case NOT_MEMBER:
		{
			AST __t94 = _t;
			EJBQLAST tmp65_AST_in = (EJBQLAST)_t;
			match(_t,NOT_MEMBER);
			_t = _t.getFirstChild();
			expression(_t,member);
			_t = _retTree;
			cmrAccess2 = _t==ASTNULL ? null : (EJBQLAST)_t;
			expression(_t,col);
			_t = _retTree;
			
			String varName = getTmpVarName();
			// Use the element type as variable type. The value might be 
			// an input parameter of a local/remote interface which we 
			// cannot uniquely map to a PC class during deployment.
			Object varType = getElementTypeOfCollectionValuedCMR(cmrAccess2);
			// generate varibale declaration
			variableDecls.append(typeSupport.getPCForTypeInfo(varType));
			variableDecls.append(' ');
			variableDecls.append(varName);
			variableDecls.append("; "); //NOI18N
			buf.append("("); //NOI18N
			buf.append(col.toString());
			buf.append(".isEmpty() | (!(");  //NOI18N
			buf.append(col.toString());
			buf.append(".contains(");  //NOI18N
			buf.append(varName);
			buf.append(") & "); //NOI18N
			buf.append(varName);
			buf.append(" == "); //NOI18N
			buf.append(member.toString());
			buf.append(")))"); //NOI18N
			
			_t = __t94;
			_t = _t.getNextSibling();
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
	}
	
	public final void function(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST function_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case CONCAT:
		{
			concat(_t,buf);
			_t = _retTree;
			break;
		}
		case SUBSTRING:
		{
			substring(_t,buf);
			_t = _retTree;
			break;
		}
		case LENGTH:
		{
			length(_t,buf);
			_t = _retTree;
			break;
		}
		case LOCATE:
		{
			locate(_t,buf);
			_t = _retTree;
			break;
		}
		case ABS:
		{
			abs(_t,buf);
			_t = _retTree;
			break;
		}
		case SQRT:
		{
			sqrt(_t,buf);
			_t = _retTree;
			break;
		}
		case MOD:
		{
			mod(_t,buf);
			_t = _retTree;
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
	}
	
	public final void primary(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST primary_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case TRUE:
		case FALSE:
		case STRING_LITERAL:
		case INT_LITERAL:
		case LONG_LITERAL:
		case FLOAT_LITERAL:
		case DOUBLE_LITERAL:
		{
			literal(_t,buf);
			_t = _retTree;
			break;
		}
		case IDENT:
		case DOT:
		case CMP_FIELD_ACCESS:
		case SINGLE_CMR_FIELD_ACCESS:
		case COLLECTION_CMR_FIELD_ACCESS:
		case IDENTIFICATION_VAR:
		{
			pathExpr(_t,buf);
			_t = _retTree;
			break;
		}
		case INPUT_PARAMETER:
		{
			parameter(_t,buf);
			_t = _retTree;
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
	}
	
	public final void stringLiteral(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST stringLiteral_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		EJBQLAST s = null;
		
		s = (EJBQLAST)_t;
		match(_t,STRING_LITERAL);
		_t = _t.getNextSibling();
		
		buf.append('"'); // NOI18N
		buf.append(convertStringLiteral(s.getText())); 
		buf.append('"'); // NOI18N
		
		_retTree = _t;
	}
	
	public final void parameter(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST parameter_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		EJBQLAST param = null;
		
		param = (EJBQLAST)_t;
		match(_t,INPUT_PARAMETER);
		_t = _t.getNextSibling();
		
		buf.append(paramSupport.getParameterName(param.getText()));
		
		_retTree = _t;
	}
	
	public final void escape(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST escape_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case ESCAPE:
		{
			AST __t76 = _t;
			EJBQLAST tmp66_AST_in = (EJBQLAST)_t;
			match(_t,ESCAPE);
			_t = _t.getFirstChild();
			buf.append (", ");
			{
			if (_t==null) _t=ASTNULL;
			switch ( _t.getType()) {
			case STRING_LITERAL:
			{
				singleCharStringLiteral(_t,buf);
				_t = _retTree;
				break;
			}
			case INPUT_PARAMETER:
			{
				parameter(_t,buf);
				_t = _retTree;
				break;
			}
			default:
			{
				throw new NoViableAltException(_t);
			}
			}
			}
			_t = __t76;
			_t = _t.getNextSibling();
			break;
		}
		case 3:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
	}
	
	public final void singleCharStringLiteral(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST singleCharStringLiteral_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		EJBQLAST s = null;
		
		s = (EJBQLAST)_t;
		match(_t,STRING_LITERAL);
		_t = _t.getNextSibling();
		
		buf.append('\'');
		buf.append(convertStringLiteral(s.getText())); 
		buf.append('\'');
		
		_retTree = _t;
	}
	
	public final void concat(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST concat_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		
		AST __t97 = _t;
		EJBQLAST tmp67_AST_in = (EJBQLAST)_t;
		match(_t,CONCAT);
		_t = _t.getFirstChild();
		buf.append("(");
		expression(_t,buf);
		_t = _retTree;
		buf.append(" + ");
		expression(_t,buf);
		_t = _retTree;
		buf.append(")");
		_t = __t97;
		_t = _t.getNextSibling();
		_retTree = _t;
	}
	
	public final void substring(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST substring_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		EJBQLAST start = null;
		EJBQLAST length = null;
		
		AST __t99 = _t;
		EJBQLAST tmp68_AST_in = (EJBQLAST)_t;
		match(_t,SUBSTRING);
		_t = _t.getFirstChild();
		expression(_t,buf);
		_t = _retTree;
		buf.append(".substring(");
		start = (EJBQLAST)_t;
		if ( _t==null ) throw new MismatchedTokenException();
		_t = _t.getNextSibling();
		length = (EJBQLAST)_t;
		if ( _t==null ) throw new MismatchedTokenException();
		_t = _t.getNextSibling();
		_t = __t99;
		_t = _t.getNextSibling();
		
		if ((start.getType() == INT_LITERAL) && 
		(length.getType() == INT_LITERAL)) {
		// Optimization: start and length are constant values =>
		// calulate beginIndex and endIndex of the JDOQL substring 
		// call at compile time.
		int startValue = Integer.parseInt(start.getText());
		int lengthValue = Integer.parseInt(length.getText());
		buf.append(startValue - 1);
		buf.append(", "); //NOI18N
		buf.append(startValue - 1 + lengthValue);
		}
		else {
		StringBuffer startBuf = new StringBuffer();
		expression(start, startBuf);
		buf.append(startBuf.toString()); 
		buf.append(" - 1, "); //NOI18N
		buf.append(startBuf.toString());
		buf.append(" - 1 + "); //NOI18N
		expression(length, buf);
		}
		buf.append(")"); //NOI18N
		
		_retTree = _t;
	}
	
	public final void length(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST length_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		
		AST __t101 = _t;
		EJBQLAST tmp69_AST_in = (EJBQLAST)_t;
		match(_t,LENGTH);
		_t = _t.getFirstChild();
		expression(_t,buf);
		_t = _retTree;
		buf.append(".length()");
		_t = __t101;
		_t = _t.getNextSibling();
		_retTree = _t;
	}
	
	public final void locate(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST locate_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		
		StringBuffer pattern = new StringBuffer();
		
		
		AST __t103 = _t;
		EJBQLAST tmp70_AST_in = (EJBQLAST)_t;
		match(_t,LOCATE);
		_t = _t.getFirstChild();
		buf.append("(");
		expression(_t,pattern);
		_t = _retTree;
		expression(_t,buf);
		_t = _retTree;
		buf.append(".indexOf(");  //NOI18N
		buf.append(pattern.toString());
		locateStartPos(_t,buf);
		_t = _retTree;
		buf.append(") + 1)");
		_t = __t103;
		_t = _t.getNextSibling();
		_retTree = _t;
	}
	
	public final void abs(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST abs_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		
		AST __t106 = _t;
		EJBQLAST tmp71_AST_in = (EJBQLAST)_t;
		match(_t,ABS);
		_t = _t.getFirstChild();
		buf.append ("java.lang.Math.abs(");
		expression(_t,buf);
		_t = _retTree;
		buf.append (")");
		_t = __t106;
		_t = _t.getNextSibling();
		_retTree = _t;
	}
	
	public final void sqrt(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST sqrt_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		
		AST __t108 = _t;
		EJBQLAST tmp72_AST_in = (EJBQLAST)_t;
		match(_t,SQRT);
		_t = _t.getFirstChild();
		buf.append ("java.lang.Math.sqrt(");
		expression(_t,buf);
		_t = _retTree;
		buf.append (")");
		_t = __t108;
		_t = _t.getNextSibling();
		_retTree = _t;
	}
	
	public final void mod(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST mod_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		
		AST __t110 = _t;
		EJBQLAST tmp73_AST_in = (EJBQLAST)_t;
		match(_t,MOD);
		_t = _t.getFirstChild();
		buf.append("(");
		expression(_t,buf);
		_t = _retTree;
		buf.append(" % ");
		expression(_t,buf);
		_t = _retTree;
		buf.append(")");
		_t = __t110;
		_t = _t.getNextSibling();
		_retTree = _t;
	}
	
	public final void locateStartPos(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST locateStartPos_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		EJBQLAST start = null;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case SELECT:
		case FROM:
		case WHERE:
		case DISTINCT:
		case OBJECT:
		case NULL:
		case TRUE:
		case FALSE:
		case NOT:
		case AND:
		case OR:
		case BETWEEN:
		case LIKE:
		case IN:
		case AS:
		case UNKNOWN:
		case EMPTY:
		case MEMBER:
		case OF:
		case IS:
		case ESCAPE:
		case CONCAT:
		case SUBSTRING:
		case LOCATE:
		case LENGTH:
		case ABS:
		case SQRT:
		case MOD:
		case AVG:
		case MAX:
		case MIN:
		case SUM:
		case COUNT:
		case ORDER:
		case BY:
		case ASC:
		case DESC:
		case EQUAL:
		case NOT_EQUAL:
		case GE:
		case GT:
		case LE:
		case LT:
		case PLUS:
		case MINUS:
		case STAR:
		case DIV:
		case STRING_LITERAL:
		case INT_LITERAL:
		case LONG_LITERAL:
		case FLOAT_LITERAL:
		case DOUBLE_LITERAL:
		case IDENT:
		case DOT:
		case INPUT_PARAMETER:
		case LPAREN:
		case RPAREN:
		case COMMA:
		case WS:
		case HEX_DIGIT:
		case EXPONENT:
		case FLOAT_SUFFIX:
		case UNICODE_DIGIT:
		case UNICODE_STR:
		case NEWLINE:
		case ESC:
		case FLOATINGPOINT_SUFFIX:
		case UNICODE_ESCAPE:
		case QUERY:
		case RANGE:
		case CMP_FIELD_ACCESS:
		case SINGLE_CMR_FIELD_ACCESS:
		case COLLECTION_CMR_FIELD_ACCESS:
		case IDENTIFICATION_VAR:
		case IDENTIFICATION_VAR_DECL:
		case ABSTRACT_SCHEMA_NAME:
		case CMP_FIELD:
		case SINGLE_CMR_FIELD:
		case COLLECTION_CMR_FIELD:
		case UNARY_MINUS:
		case UNARY_PLUS:
		case NOT_BETWEEN:
		case NOT_LIKE:
		case NOT_IN:
		case NOT_NULL:
		case NOT_EMPTY:
		case NOT_MEMBER:
		{
			start = (EJBQLAST)_t;
			if ( _t==null ) throw new MismatchedTokenException();
			_t = _t.getNextSibling();
			
			buf.append(", ");  //NOI18N 
			if (start.getType() == INT_LITERAL) {
			// Optimization: start is a constant value =>
			// calulate startIndex of JDOQL indexOf call at compile time.
			buf.append(Integer.parseInt(start.getText()) - 1);
			}
			else {
			expression(start, buf);
			{ buf.append(" - 1"); } //NOI18N
			}
			
			break;
		}
		case 3:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
	}
	
	public final void literal(AST _t,
		StringBuffer buf
	) throws RecognitionException {
		
		EJBQLAST literal_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		EJBQLAST i = null;
		EJBQLAST l = null;
		EJBQLAST f = null;
		EJBQLAST d = null;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case TRUE:
		{
			EJBQLAST tmp74_AST_in = (EJBQLAST)_t;
			match(_t,TRUE);
			_t = _t.getNextSibling();
			buf.append("true");
			break;
		}
		case FALSE:
		{
			EJBQLAST tmp75_AST_in = (EJBQLAST)_t;
			match(_t,FALSE);
			_t = _t.getNextSibling();
			buf.append("false");
			break;
		}
		case STRING_LITERAL:
		{
			stringLiteral(_t,buf);
			_t = _retTree;
			break;
		}
		case INT_LITERAL:
		{
			i = (EJBQLAST)_t;
			match(_t,INT_LITERAL);
			_t = _t.getNextSibling();
			
			buf.append(i.getText()); 
			
			break;
		}
		case LONG_LITERAL:
		{
			l = (EJBQLAST)_t;
			match(_t,LONG_LITERAL);
			_t = _t.getNextSibling();
			
			buf.append(l.getText()); 
			
			break;
		}
		case FLOAT_LITERAL:
		{
			f = (EJBQLAST)_t;
			match(_t,FLOAT_LITERAL);
			_t = _t.getNextSibling();
			
			buf.append(f.getText()); 
			
			break;
		}
		case DOUBLE_LITERAL:
		{
			d = (EJBQLAST)_t;
			match(_t,DOUBLE_LITERAL);
			_t = _t.getNextSibling();
			
			buf.append(d.getText()); 
			
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
	}
	
	public final void field(AST _t) throws RecognitionException {
		
		EJBQLAST field_AST_in = (_t == ASTNULL) ? null : (EJBQLAST)_t;
		
		if (_t==null) _t=ASTNULL;
		switch ( _t.getType()) {
		case CMP_FIELD:
		{
			EJBQLAST tmp76_AST_in = (EJBQLAST)_t;
			match(_t,CMP_FIELD);
			_t = _t.getNextSibling();
			break;
		}
		case COLLECTION_CMR_FIELD:
		{
			EJBQLAST tmp77_AST_in = (EJBQLAST)_t;
			match(_t,COLLECTION_CMR_FIELD);
			_t = _t.getNextSibling();
			break;
		}
		case SINGLE_CMR_FIELD:
		{
			EJBQLAST tmp78_AST_in = (EJBQLAST)_t;
			match(_t,SINGLE_CMR_FIELD);
			_t = _t.getNextSibling();
			break;
		}
		default:
		{
			throw new NoViableAltException(_t);
		}
		}
		_retTree = _t;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"\"select\"",
		"\"from\"",
		"\"where\"",
		"\"distinct\"",
		"\"object\"",
		"\"null\"",
		"\"true\"",
		"\"false\"",
		"\"not\"",
		"\"and\"",
		"\"or\"",
		"\"between\"",
		"\"like\"",
		"\"in\"",
		"\"as\"",
		"\"unknown\"",
		"\"empty\"",
		"\"member\"",
		"\"of\"",
		"\"is\"",
		"\"escape\"",
		"\"concat\"",
		"\"substring\"",
		"\"locate\"",
		"\"length\"",
		"\"abs\"",
		"\"sqrt\"",
		"\"mod\"",
		"\"avg\"",
		"\"max\"",
		"\"min\"",
		"\"sum\"",
		"\"count\"",
		"\"order\"",
		"\"by\"",
		"\"asc\"",
		"\"desc\"",
		"EQUAL",
		"NOT_EQUAL",
		"GE",
		"GT",
		"LE",
		"LT",
		"PLUS",
		"MINUS",
		"STAR",
		"DIV",
		"STRING_LITERAL",
		"INT_LITERAL",
		"LONG_LITERAL",
		"FLOAT_LITERAL",
		"DOUBLE_LITERAL",
		"an identifier",
		"DOT",
		"INPUT_PARAMETER",
		"LPAREN",
		"RPAREN",
		"COMMA",
		"WS",
		"HEX_DIGIT",
		"EXPONENT",
		"FLOAT_SUFFIX",
		"UNICODE_DIGIT",
		"UNICODE_STR",
		"NEWLINE",
		"ESC",
		"FLOATINGPOINT_SUFFIX",
		"UNICODE_ESCAPE",
		"QUERY",
		"RANGE",
		"CMP_FIELD_ACCESS",
		"SINGLE_CMR_FIELD_ACCESS",
		"COLLECTION_CMR_FIELD_ACCESS",
		"IDENTIFICATION_VAR",
		"IDENTIFICATION_VAR_DECL",
		"ABSTRACT_SCHEMA_NAME",
		"CMP_FIELD",
		"SINGLE_CMR_FIELD",
		"COLLECTION_CMR_FIELD",
		"UNARY_MINUS",
		"UNARY_PLUS",
		"NOT_BETWEEN",
		"NOT_LIKE",
		"NOT_IN",
		"NOT_NULL",
		"NOT_EMPTY",
		"NOT_MEMBER"
	};
	
	private static final long[] mk_tokenSet_0() {
		long[] data = { 216172782113783808L, 15360L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
	private static final long[] mk_tokenSet_1() {
		long[] data = { 574208952489741312L, 15360L, 0L, 0L};
		return data;
	}
	public static final BitSet _tokenSet_1 = new BitSet(mk_tokenSet_1());
	}
	
