/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.rewrite;

import com.atlassian.maven.plugins.jgitflow.exception.ProjectRewriteException;
import com.atlassian.maven.plugins.jgitflow.rewrite.ProjectChange;
import com.atlassian.maven.plugins.jgitflow.rewrite.ProjectChangeUtils;
import com.atlassian.maven.plugins.jgitflow.util.NamingUtil;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.project.MavenProject;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Text;

public class ProjectReleaseVersionChange
implements ProjectChange {
    private final Map<String, String> releaseVersions;
    private final boolean consistentProjectVersions;
    private final List<String> workLog;

    private ProjectReleaseVersionChange(Map<String, String> releaseVersions, boolean consistentProjectVersions) {
        this.releaseVersions = releaseVersions;
        this.consistentProjectVersions = consistentProjectVersions;
        this.workLog = new ArrayList<String>();
    }

    public static ProjectReleaseVersionChange projectReleaseVersionChange(Map<String, String> releaseVersions, boolean consistentProjectVersions) {
        return new ProjectReleaseVersionChange(releaseVersions, consistentProjectVersions);
    }

    @Override
    public boolean applyChange(MavenProject project, Element root, String eol) throws ProjectRewriteException {
        boolean modified = false;
        Namespace ns = ProjectChangeUtils.getNamespaceOrNull(root);
        Element versionElement = root.getChild("version", ns);
        String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
        String releaseVersion = this.releaseVersions.get(projectId);
        if (Strings.isNullOrEmpty((String)releaseVersion)) {
            if (this.consistentProjectVersions && this.releaseVersions.size() > 0) {
                releaseVersion = this.releaseVersions.values().iterator().next();
            } else {
                throw new ProjectRewriteException("Release version for " + project.getName() + " was not found");
            }
        }
        if (null == versionElement) {
            MavenProject parent;
            String parentId;
            String parentVersion = null;
            if (project.hasParent() && Strings.isNullOrEmpty((String)(parentVersion = this.releaseVersions.get(parentId = ArtifactUtils.versionlessKey((String)(parent = project.getParent()).getGroupId(), (String)parent.getArtifactId())))) && this.consistentProjectVersions && this.releaseVersions.size() > 0) {
                parentVersion = this.releaseVersions.values().iterator().next();
            }
            if (!releaseVersion.equals(parentVersion)) {
                String siblingText;
                Content prevSibling;
                Element artifactId = root.getChild("artifactId", ns);
                versionElement = new Element("version", ns);
                Text indent = new Text("");
                this.workLog.add("setting version to '" + releaseVersion + "'");
                versionElement.setText(releaseVersion);
                int index = root.indexOf((Content)artifactId);
                List cList = root.getContent();
                if (index > 0 && index < cList.size() && Text.class.isInstance(prevSibling = (Content)cList.get(index - 1)) && (siblingText = ((Text)prevSibling).getText()).matches("^\\s*$")) {
                    indent = new Text("");
                    indent.setText(eol + NamingUtil.afterLastNewline(siblingText));
                }
                root.addContent(index + 1, (Content)indent);
                root.addContent(index + 2, (Content)versionElement);
                modified = true;
            }
        } else {
            this.workLog.add("updating version '" + versionElement.getTextTrim() + " to '" + releaseVersion + "'");
            versionElement.setText(releaseVersion);
            modified = true;
        }
        return modified;
    }

    public String toString() {
        if (this.workLog.isEmpty()) {
            return "[Update Project Release Version]";
        }
        return "[Update Project Release Version]\n - " + Joiner.on((String)"\n - ").join(this.workLog);
    }
}

