/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.naosdk.api;

import com.polestar.naosdk.api.ThreadFunc;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class IPlatformThreadFactory {
    public abstract void createThread(String var1, ThreadFunc var2);

    public abstract boolean isMainThread();

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    private static final class CppProxy
    extends IPlatformThreadFactory {
        private final long nativeRef;
        private final AtomicBoolean a = new AtomicBoolean(false);

        private CppProxy(long l2) {
            if (l2 == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = l2;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean bl = this.a.getAndSet(true);
            if (!bl) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public void createThread(String string, ThreadFunc threadFunc) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_createThread(this.nativeRef, string, threadFunc);
        }

        private native void native_createThread(long var1, String var3, ThreadFunc var4);

        @Override
        public boolean isMainThread() {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_isMainThread(this.nativeRef);
        }

        private native boolean native_isMainThread(long var1);
    }
}

