/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.naosdk.api;

import com.polestar.naosdk.api.DeviceInfo;
import com.polestar.naosdk.api.IAndroidGeofencing;
import com.polestar.naosdk.api.INAOAnalyticsClient;
import com.polestar.naosdk.api.INAOBeaconRegionClient;
import com.polestar.naosdk.api.INAOBeaconReportingClient;
import com.polestar.naosdk.api.INAOGeofencingClient;
import com.polestar.naosdk.api.INAOInternalClient;
import com.polestar.naosdk.api.INAOLocationClient;
import com.polestar.naosdk.api.INAOSyncListener;
import com.polestar.naosdk.api.IPlatformThreadFactory;
import com.polestar.naosdk.api.ISensorObserver;
import com.polestar.naosdk.api.ISensorProxyFactory;
import com.polestar.naosdk.api.ISensorRequestListener;
import com.polestar.naosdk.api.ISynchroBroker;
import com.polestar.naosdk.api.LocationFix;
import com.polestar.naosdk.api.external.TPOWERMODE;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class INAOServiceManager {
    public abstract void synchronizeData(String var1, INAOSyncListener var2);

    public abstract void resetServices();

    public abstract ISensorObserver getSensorObserver();

    public abstract void setAndroidGeofenceInterface(IAndroidGeofencing var1);

    public abstract boolean registerLocationClient(String var1, INAOLocationClient var2, ISensorRequestListener var3);

    public abstract boolean unregisterLocationClient(INAOLocationClient var1);

    public abstract void setLocationClientPowerMode(TPOWERMODE var1, INAOLocationClient var2);

    public abstract boolean registerGeofencingClient(String var1, INAOGeofencingClient var2, ISensorRequestListener var3);

    public abstract boolean unregisterGeofencingClient(INAOGeofencingClient var1);

    public abstract void setGeofencingClientPowerMode(TPOWERMODE var1, INAOGeofencingClient var2);

    public abstract boolean registerBeaconRegionClient(String var1, INAOBeaconRegionClient var2, ISensorRequestListener var3);

    public abstract boolean unregisterBeaconRegionClient(INAOBeaconRegionClient var1);

    public abstract void setBeaconProximityClientPowerMode(TPOWERMODE var1, INAOBeaconRegionClient var2);

    public abstract boolean registerAnalyticsClient(String var1, INAOAnalyticsClient var2, ISensorRequestListener var3);

    public abstract boolean unregisterAnalyticsClient(INAOAnalyticsClient var1);

    public abstract void setAnalyticsClientPowerMode(TPOWERMODE var1, INAOAnalyticsClient var2);

    public abstract boolean registerBeaconReportingClient(String var1, INAOBeaconReportingClient var2, ISensorRequestListener var3);

    public abstract boolean unregisterBeaconReportingClient(INAOBeaconReportingClient var1);

    public abstract void setBeaconReportingClientPowerMode(TPOWERMODE var1, INAOBeaconReportingClient var2);

    public abstract boolean registerInternalClient(INAOInternalClient var1, ISensorRequestListener var2);

    public abstract boolean unregisterInternalClient(INAOInternalClient var1);

    public abstract void start();

    public abstract void stop();

    public abstract void setMainLoopSleepIntervalMs(int var1);

    public abstract void onNewUserLoc(LocationFix var1, int var2);

    public abstract void startLoggingMeasurements(String var1);

    public abstract void stopLoggingMeasurements();

    public abstract void setMemsRecording(boolean var1);

    public abstract void setPowerMode(TPOWERMODE var1);

    public abstract TPOWERMODE getPowerMode();

    public abstract String getDatabaseVersions();

    public abstract String getExternalIBeaconUUID();

    public abstract String getSoftwareVersion();

    public abstract void setRootURL(String var1);

    public abstract String getRootURL();

    public static native INAOServiceManager getInstanceStatic(ISensorProxyFactory var0, IPlatformThreadFactory var1, ISynchroBroker var2, DeviceInfo var3, String var4);

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    private static final class CppProxy
    extends INAOServiceManager {
        private final long nativeRef;
        private final AtomicBoolean a = new AtomicBoolean(false);

        private CppProxy(long l2) {
            if (l2 == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = l2;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean bl = this.a.getAndSet(true);
            if (!bl) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public void synchronizeData(String string, INAOSyncListener iNAOSyncListener) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_synchronizeData(this.nativeRef, string, iNAOSyncListener);
        }

        private native void native_synchronizeData(long var1, String var3, INAOSyncListener var4);

        @Override
        public void resetServices() {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_resetServices(this.nativeRef);
        }

        private native void native_resetServices(long var1);

        @Override
        public ISensorObserver getSensorObserver() {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_getSensorObserver(this.nativeRef);
        }

        private native ISensorObserver native_getSensorObserver(long var1);

        @Override
        public void setAndroidGeofenceInterface(IAndroidGeofencing iAndroidGeofencing) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_setAndroidGeofenceInterface(this.nativeRef, iAndroidGeofencing);
        }

        private native void native_setAndroidGeofenceInterface(long var1, IAndroidGeofencing var3);

        @Override
        public boolean registerLocationClient(String string, INAOLocationClient iNAOLocationClient, ISensorRequestListener iSensorRequestListener) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_registerLocationClient(this.nativeRef, string, iNAOLocationClient, iSensorRequestListener);
        }

        private native boolean native_registerLocationClient(long var1, String var3, INAOLocationClient var4, ISensorRequestListener var5);

        @Override
        public boolean unregisterLocationClient(INAOLocationClient iNAOLocationClient) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_unregisterLocationClient(this.nativeRef, iNAOLocationClient);
        }

        private native boolean native_unregisterLocationClient(long var1, INAOLocationClient var3);

        @Override
        public void setLocationClientPowerMode(TPOWERMODE tPOWERMODE, INAOLocationClient iNAOLocationClient) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_setLocationClientPowerMode(this.nativeRef, tPOWERMODE, iNAOLocationClient);
        }

        private native void native_setLocationClientPowerMode(long var1, TPOWERMODE var3, INAOLocationClient var4);

        @Override
        public boolean registerGeofencingClient(String string, INAOGeofencingClient iNAOGeofencingClient, ISensorRequestListener iSensorRequestListener) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_registerGeofencingClient(this.nativeRef, string, iNAOGeofencingClient, iSensorRequestListener);
        }

        private native boolean native_registerGeofencingClient(long var1, String var3, INAOGeofencingClient var4, ISensorRequestListener var5);

        @Override
        public boolean unregisterGeofencingClient(INAOGeofencingClient iNAOGeofencingClient) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_unregisterGeofencingClient(this.nativeRef, iNAOGeofencingClient);
        }

        private native boolean native_unregisterGeofencingClient(long var1, INAOGeofencingClient var3);

        @Override
        public void setGeofencingClientPowerMode(TPOWERMODE tPOWERMODE, INAOGeofencingClient iNAOGeofencingClient) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_setGeofencingClientPowerMode(this.nativeRef, tPOWERMODE, iNAOGeofencingClient);
        }

        private native void native_setGeofencingClientPowerMode(long var1, TPOWERMODE var3, INAOGeofencingClient var4);

        @Override
        public boolean registerBeaconRegionClient(String string, INAOBeaconRegionClient iNAOBeaconRegionClient, ISensorRequestListener iSensorRequestListener) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_registerBeaconRegionClient(this.nativeRef, string, iNAOBeaconRegionClient, iSensorRequestListener);
        }

        private native boolean native_registerBeaconRegionClient(long var1, String var3, INAOBeaconRegionClient var4, ISensorRequestListener var5);

        @Override
        public boolean unregisterBeaconRegionClient(INAOBeaconRegionClient iNAOBeaconRegionClient) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_unregisterBeaconRegionClient(this.nativeRef, iNAOBeaconRegionClient);
        }

        private native boolean native_unregisterBeaconRegionClient(long var1, INAOBeaconRegionClient var3);

        @Override
        public void setBeaconProximityClientPowerMode(TPOWERMODE tPOWERMODE, INAOBeaconRegionClient iNAOBeaconRegionClient) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_setBeaconProximityClientPowerMode(this.nativeRef, tPOWERMODE, iNAOBeaconRegionClient);
        }

        private native void native_setBeaconProximityClientPowerMode(long var1, TPOWERMODE var3, INAOBeaconRegionClient var4);

        @Override
        public boolean registerAnalyticsClient(String string, INAOAnalyticsClient iNAOAnalyticsClient, ISensorRequestListener iSensorRequestListener) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_registerAnalyticsClient(this.nativeRef, string, iNAOAnalyticsClient, iSensorRequestListener);
        }

        private native boolean native_registerAnalyticsClient(long var1, String var3, INAOAnalyticsClient var4, ISensorRequestListener var5);

        @Override
        public boolean unregisterAnalyticsClient(INAOAnalyticsClient iNAOAnalyticsClient) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_unregisterAnalyticsClient(this.nativeRef, iNAOAnalyticsClient);
        }

        private native boolean native_unregisterAnalyticsClient(long var1, INAOAnalyticsClient var3);

        @Override
        public void setAnalyticsClientPowerMode(TPOWERMODE tPOWERMODE, INAOAnalyticsClient iNAOAnalyticsClient) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_setAnalyticsClientPowerMode(this.nativeRef, tPOWERMODE, iNAOAnalyticsClient);
        }

        private native void native_setAnalyticsClientPowerMode(long var1, TPOWERMODE var3, INAOAnalyticsClient var4);

        @Override
        public boolean registerBeaconReportingClient(String string, INAOBeaconReportingClient iNAOBeaconReportingClient, ISensorRequestListener iSensorRequestListener) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_registerBeaconReportingClient(this.nativeRef, string, iNAOBeaconReportingClient, iSensorRequestListener);
        }

        private native boolean native_registerBeaconReportingClient(long var1, String var3, INAOBeaconReportingClient var4, ISensorRequestListener var5);

        @Override
        public boolean unregisterBeaconReportingClient(INAOBeaconReportingClient iNAOBeaconReportingClient) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_unregisterBeaconReportingClient(this.nativeRef, iNAOBeaconReportingClient);
        }

        private native boolean native_unregisterBeaconReportingClient(long var1, INAOBeaconReportingClient var3);

        @Override
        public void setBeaconReportingClientPowerMode(TPOWERMODE tPOWERMODE, INAOBeaconReportingClient iNAOBeaconReportingClient) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_setBeaconReportingClientPowerMode(this.nativeRef, tPOWERMODE, iNAOBeaconReportingClient);
        }

        private native void native_setBeaconReportingClientPowerMode(long var1, TPOWERMODE var3, INAOBeaconReportingClient var4);

        @Override
        public boolean registerInternalClient(INAOInternalClient iNAOInternalClient, ISensorRequestListener iSensorRequestListener) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_registerInternalClient(this.nativeRef, iNAOInternalClient, iSensorRequestListener);
        }

        private native boolean native_registerInternalClient(long var1, INAOInternalClient var3, ISensorRequestListener var4);

        @Override
        public boolean unregisterInternalClient(INAOInternalClient iNAOInternalClient) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_unregisterInternalClient(this.nativeRef, iNAOInternalClient);
        }

        private native boolean native_unregisterInternalClient(long var1, INAOInternalClient var3);

        @Override
        public void start() {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_start(this.nativeRef);
        }

        private native void native_start(long var1);

        @Override
        public void stop() {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_stop(this.nativeRef);
        }

        private native void native_stop(long var1);

        @Override
        public void setMainLoopSleepIntervalMs(int n2) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_setMainLoopSleepIntervalMs(this.nativeRef, n2);
        }

        private native void native_setMainLoopSleepIntervalMs(long var1, int var3);

        @Override
        public void onNewUserLoc(LocationFix locationFix, int n2) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_onNewUserLoc(this.nativeRef, locationFix, n2);
        }

        private native void native_onNewUserLoc(long var1, LocationFix var3, int var4);

        @Override
        public void startLoggingMeasurements(String string) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_startLoggingMeasurements(this.nativeRef, string);
        }

        private native void native_startLoggingMeasurements(long var1, String var3);

        @Override
        public void stopLoggingMeasurements() {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_stopLoggingMeasurements(this.nativeRef);
        }

        private native void native_stopLoggingMeasurements(long var1);

        @Override
        public void setMemsRecording(boolean bl) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_setMemsRecording(this.nativeRef, bl);
        }

        private native void native_setMemsRecording(long var1, boolean var3);

        @Override
        public void setPowerMode(TPOWERMODE tPOWERMODE) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_setPowerMode(this.nativeRef, tPOWERMODE);
        }

        private native void native_setPowerMode(long var1, TPOWERMODE var3);

        @Override
        public TPOWERMODE getPowerMode() {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_getPowerMode(this.nativeRef);
        }

        private native TPOWERMODE native_getPowerMode(long var1);

        @Override
        public String getDatabaseVersions() {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_getDatabaseVersions(this.nativeRef);
        }

        private native String native_getDatabaseVersions(long var1);

        @Override
        public String getExternalIBeaconUUID() {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_getExternalIBeaconUUID(this.nativeRef);
        }

        private native String native_getExternalIBeaconUUID(long var1);

        @Override
        public String getSoftwareVersion() {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_getSoftwareVersion(this.nativeRef);
        }

        private native String native_getSoftwareVersion(long var1);

        @Override
        public void setRootURL(String string) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_setRootURL(this.nativeRef, string);
        }

        private native void native_setRootURL(long var1, String var3);

        @Override
        public String getRootURL() {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_getRootURL(this.nativeRef);
        }

        private native String native_getRootURL(long var1);
    }
}

