/*
 * Decompiled with CFR 0.152.
 */
package eu.esu.mobilecontrol2.sdk;

import android.annotation.TargetApi;
import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import eu.esu.mobilecontrol2.sdk.MessageServiceFragment;

@TargetApi(value=12)
public class ThrottleFragment
extends MessageServiceFragment {
    public static final int KEYCODE_THROTTLE_WAKEUP = 203;
    private static final int MSG_MOVE_TO = 3;
    private static final int MSG_SET_ZERO_POSITION = 4;
    private static final int MSG_POSITION_CHANGED = 5;
    private static final int MSG_BUTTON_DOWN = 6;
    private static final int MSG_BUTTON_UP = 7;
    private int mZeroPosition;
    private OnThrottleListener mOnThrottleListener;

    public static ThrottleFragment newInstance(int zeroPosition) {
        Bundle args = new Bundle();
        args.putInt("zeroPosition", ThrottleFragment.checkPosition(zeroPosition));
        ThrottleFragment fragment = new ThrottleFragment();
        fragment.setArguments(args);
        return fragment;
    }

    private static int checkPosition(int position) {
        if (position < 0 || position > 255) {
            throw new IllegalArgumentException("position must be >= 0 and <= 255");
        }
        return position;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mZeroPosition = this.getArguments().getInt("zeroPosition");
    }

    public void moveThrottle(int position) {
        if (this.isServiceBound()) {
            Message msg = Message.obtain(null, (int)3, (int)ThrottleFragment.checkPosition(position), (int)0);
            this.sendMessage(msg);
        }
    }

    public void setOnThrottleListener(OnThrottleListener listener) {
        this.mOnThrottleListener = listener;
    }

    @Override
    protected void onServiceConnected() {
        this.sendMessage(Message.obtain(null, (int)4, (int)this.mZeroPosition, (int)0));
    }

    @Override
    protected void onMessageReceived(Message message) {
        if (this.mOnThrottleListener != null) {
            switch (message.what) {
                case 6: {
                    this.onButtonDown();
                    break;
                }
                case 7: {
                    this.onButtonUp();
                    break;
                }
                case 5: {
                    this.onPositionChanged(message.arg1);
                    break;
                }
            }
        }
    }

    private void onButtonDown() {
        if (this.mOnThrottleListener != null) {
            this.mOnThrottleListener.onButtonDown();
        }
    }

    private void onButtonUp() {
        if (this.mOnThrottleListener != null) {
            this.mOnThrottleListener.onButtonUp();
        }
    }

    private void onPositionChanged(int position) {
        if (this.mOnThrottleListener != null) {
            this.mOnThrottleListener.onPositionChanged(position);
        }
    }

    @Override
    protected Intent getServiceIntent() {
        return new Intent("eu.esu.mobilecontrol2.input.THROTTLE_SERVICE");
    }

    public static interface OnThrottleListener {
        public void onButtonDown();

        public void onButtonUp();

        public void onPositionChanged(int var1);
    }
}

