/*
 * Decompiled with CFR 0.152.
 */
package eu.esu.mobilecontrol2.sdk;

public class ThrottleScale {
    private int mZeroOffset;
    private int mStepCount;
    private int[] mLookup;

    public ThrottleScale(int zeroOffset, int stepCount) {
        if (zeroOffset < 0 || zeroOffset > 255) {
            throw new IllegalArgumentException("zeroOffset must be >= 0 and <= 255");
        }
        if (stepCount > 255 - zeroOffset) {
            throw new IllegalArgumentException("More steps than available positions in range");
        }
        this.mZeroOffset = zeroOffset;
        this.mStepCount = stepCount;
        this.createLookup();
    }

    public int stepToPosition(int step) {
        if (step >= this.mStepCount) {
            throw new IllegalArgumentException("step must be <= stepCount");
        }
        return this.mLookup[step];
    }

    public int positionToStep(int position) {
        for (int i = this.mStepCount - 1; i > 0; --i) {
            if (position <= this.mLookup[i]) continue;
            return i;
        }
        return 0;
    }

    private void createLookup() {
        this.mLookup = new int[this.mStepCount];
        double chunkSize = (255.0 - (double)this.mZeroOffset) / (double)this.mStepCount;
        this.mLookup[0] = 0;
        for (int i = 1; i < this.mStepCount; ++i) {
            this.mLookup[i] = (int)Math.round((double)this.mZeroOffset + (double)i * chunkSize);
        }
    }
}

