/*
 * Decompiled with CFR 0.152.
 */
package eu.esu.mobilecontrol2.sdk;

import android.annotation.TargetApi;
import android.os.Build;
import android.util.Log;
import java.io.FileOutputStream;
import java.io.IOException;

@TargetApi(value=12)
public final class MobileControl2 {
    public static final int KEYCODE_STOP = 188;
    public static final int KEY_CODE_RIGHT_TOP = 189;
    public static final int KEY_CODE_RIGHT_BOTTOM = 190;
    public static final int KEY_CODE_LEFT_TOP = 24;
    public static final int KEY_CODE_LEFT_BOTTOM = 25;
    public static final int LED_RED = 1;
    public static final int LED_GREEN = 2;
    private static final String TAG = "Mobile Control II Input";
    private static final String ROOT_RED_LED = "/sys/class/leds/mc2:red:led1";
    private static final String ROOT_GREEN_LED = "/sys/class/leds/mc2:green:led2";
    private static final boolean RUNS_ON_MOBILECONTROL2 = Build.MODEL.equalsIgnoreCase("MobileControlII") || Build.MODEL.equalsIgnoreCase("Mobile Control II") || Build.MODEL.equalsIgnoreCase("SmartController");

    private MobileControl2() {
    }

    public static boolean isMobileControl2() {
        return RUNS_ON_MOBILECONTROL2;
    }

    public static void setLedState(int which, boolean on) {
        if (!RUNS_ON_MOBILECONTROL2) {
            return;
        }
        try {
            MobileControl2.writeText(MobileControl2.ledPath(which, "trigger"), "none");
            MobileControl2.writeText(MobileControl2.ledPath(which, "brightness"), on ? "1" : "0");
        }
        catch (IOException ex) {
            Log.e((String)TAG, (String)"Set brightness failed", (Throwable)ex);
        }
    }

    public static void setLedState(int which, int onMs, int offMs) {
        if (!RUNS_ON_MOBILECONTROL2) {
            return;
        }
        try {
            MobileControl2.writeText(MobileControl2.ledPath(which, "trigger"), "timer");
            MobileControl2.writeText(MobileControl2.ledPath(which, "delay_on"), Integer.toString(onMs));
            MobileControl2.writeText(MobileControl2.ledPath(which, "delay_off"), Integer.toString(offMs));
        }
        catch (IOException ex) {
            Log.e((String)TAG, (String)"Set brightness failed", (Throwable)ex);
        }
    }

    private static String ledPath(int which, String fileName) {
        String root;
        switch (which) {
            case 1: {
                root = ROOT_RED_LED;
                break;
            }
            case 2: {
                root = ROOT_GREEN_LED;
                break;
            }
            default: {
                throw new IllegalArgumentException("\"which\" must be LED_RED or LED_GREEN.");
            }
        }
        return root + "/" + fileName;
    }

    private static void writeText(String fileName, String text) throws IOException {
        FileOutputStream fs = null;
        try {
            fs = new FileOutputStream(fileName);
            fs.write(text.getBytes());
            fs.flush();
        }
        catch (IOException ex) {
            Log.e((String)TAG, (String)"Write to file failed", (Throwable)ex);
            throw new IOException("Write to file failed.", ex);
        }
        finally {
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (IOException ignored) {}
        }
    }
}

