/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.CallSuper;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.util.DiffUtil;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import eu.davidea.flexibleadapter.AnimatorAdapter;
import eu.davidea.flexibleadapter.Payload;
import eu.davidea.flexibleadapter.helpers.ItemTouchHelperCallback;
import eu.davidea.flexibleadapter.helpers.StickyHeaderHelper;
import eu.davidea.flexibleadapter.items.IExpandable;
import eu.davidea.flexibleadapter.items.IFilterable;
import eu.davidea.flexibleadapter.items.IFlexible;
import eu.davidea.flexibleadapter.items.IHeader;
import eu.davidea.flexibleadapter.items.ISectionable;
import eu.davidea.flexibleadapter.utils.LayoutUtils;
import eu.davidea.viewholders.FlexibleViewHolder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class FlexibleAdapter<T extends IFlexible>
extends AnimatorAdapter
implements ItemTouchHelperCallback.AdapterCallback {
    private static final String TAG = FlexibleAdapter.class.getSimpleName();
    private static final String EXTRA_PARENT = TAG + "_parentSelected";
    private static final String EXTRA_CHILD = TAG + "_childSelected";
    private static final String EXTRA_HEADERS = TAG + "_headersShown";
    private static final String EXTRA_STICKY = TAG + "_stickyHeaders";
    private static final String EXTRA_LEVEL = TAG + "_selectedLevel";
    private static final String EXTRA_FILTER = TAG + "_filter";
    private static final long AUTO_SCROLL_DELAY = 150L;
    private List<T> mItems;
    private List<T> mTempItems;
    private List<T> mOriginalList;
    private Set<T> mHashItems;
    private List<Notification> mNotifications;
    private FilterAsyncTask mFilterAsyncTask;
    private long start;
    private long time;
    private boolean useDiffUtil = false;
    private DiffUtil.DiffResult diffResult;
    private DiffUtilCallback diffUtilCallback;
    protected final int UPDATE = 1;
    protected final int FILTER = 2;
    protected final int LOAD_MORE_COMPLETE = 8;
    protected Handler mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)new HandlerCallback());
    private List<RestoreInfo> mRestoreList;
    private List<Integer> mUndoPositions;
    private boolean restoreSelection = false;
    private boolean multiRange = false;
    private boolean unlinkOnRemoveHeader = false;
    private boolean permanentDelete = true;
    private boolean adjustSelected = true;
    private List<T> mScrollableHeaders;
    private List<T> mScrollableFooters;
    private boolean headersShown = false;
    private boolean recursive = false;
    private int mStickyElevation;
    private StickyHeaderHelper mStickyHeaderHelper;
    private ViewGroup mStickyContainer;
    protected LayoutInflater mInflater;
    @SuppressLint(value={"UseSparseArrays"})
    private HashMap<Integer, T> mTypeInstances = new HashMap();
    private boolean autoMap = false;
    private Serializable mFilterEntity = null;
    private Serializable mOldFilterEntity = null;
    private Set<IExpandable> mExpandedFilterFlags;
    private boolean notifyChangeOfUnfilteredItems = true;
    private boolean filtering = false;
    private boolean notifyMoveOfFilteredItems = false;
    private static int ANIMATE_TO_LIMIT = 1000;
    private int mAnimateToLimit = ANIMATE_TO_LIMIT;
    private int mMinCollapsibleLevel = 0;
    private int mSelectedLevel = -1;
    private boolean scrollOnExpand = false;
    private boolean collapseOnExpand = false;
    private boolean collapseSubLevels = false;
    private boolean childSelected = false;
    private boolean parentSelected = false;
    private ItemTouchHelperCallback mItemTouchHelperCallback;
    private ItemTouchHelper mItemTouchHelper;
    private int mEndlessScrollThreshold = 1;
    private int mEndlessTargetCount = 0;
    private int mEndlessPageSize = 0;
    private boolean endlessLoading = false;
    private boolean endlessScrollEnabled = false;
    private boolean mTopEndless = false;
    private T mProgressItem;
    public OnItemClickListener mItemClickListener;
    public OnItemLongClickListener mItemLongClickListener;
    protected OnUpdateListener mUpdateListener;
    protected OnFilterListener mFilterListener;
    protected OnItemMoveListener mItemMoveListener;
    protected OnItemSwipeListener mItemSwipeListener;
    protected EndlessScrollListener mEndlessScrollListener;
    protected OnDeleteCompleteListener mDeleteCompleteListener;
    protected OnStickyHeaderChangeListener mStickyHeaderChangeListener;

    public FlexibleAdapter(@Nullable List<T> items) {
        this(items, null);
    }

    public FlexibleAdapter(@Nullable List<T> items, @Nullable Object listeners) {
        this(items, listeners, false);
    }

    public FlexibleAdapter(@Nullable List<T> items, @Nullable Object listeners, boolean stableIds) {
        super(stableIds);
        this.mItems = items == null ? new ArrayList<T>() : new ArrayList<T>(items);
        this.mScrollableHeaders = new ArrayList<T>();
        this.mScrollableFooters = new ArrayList<T>();
        this.mRestoreList = new ArrayList<RestoreInfo>();
        this.mUndoPositions = new ArrayList<Integer>();
        if (listeners != null) {
            this.addListener(listeners);
        }
        this.registerAdapterDataObserver(new AdapterDataObserver());
    }

    @CallSuper
    public FlexibleAdapter<T> addListener(Object listener) {
        if (listener == null) {
            this.log.e("Invalid listener class: null", new Object[0]);
            return this;
        }
        this.log.i("Adding listener class %s as:", LayoutUtils.getClassName(listener));
        if (listener instanceof OnItemClickListener) {
            this.log.i("- OnItemClickListener", new Object[0]);
            this.mItemClickListener = (OnItemClickListener)listener;
            for (FlexibleViewHolder holder : this.getAllBoundViewHolders()) {
                holder.getContentView().setOnClickListener((View.OnClickListener)holder);
            }
        }
        if (listener instanceof OnItemLongClickListener) {
            this.log.i("- OnItemLongClickListener", new Object[0]);
            this.mItemLongClickListener = (OnItemLongClickListener)listener;
            for (FlexibleViewHolder holder : this.getAllBoundViewHolders()) {
                holder.getContentView().setOnLongClickListener((View.OnLongClickListener)holder);
            }
        }
        if (listener instanceof OnItemMoveListener) {
            this.log.i("- OnItemMoveListener", new Object[0]);
            this.mItemMoveListener = (OnItemMoveListener)listener;
        }
        if (listener instanceof OnItemSwipeListener) {
            this.log.i("- OnItemSwipeListener", new Object[0]);
            this.mItemSwipeListener = (OnItemSwipeListener)listener;
        }
        if (listener instanceof OnDeleteCompleteListener) {
            this.log.i("- OnDeleteCompleteListener", new Object[0]);
            this.mDeleteCompleteListener = (OnDeleteCompleteListener)listener;
        }
        if (listener instanceof OnStickyHeaderChangeListener) {
            this.log.i("- OnStickyHeaderChangeListener", new Object[0]);
            this.mStickyHeaderChangeListener = (OnStickyHeaderChangeListener)listener;
        }
        if (listener instanceof OnUpdateListener) {
            this.log.i("- OnUpdateListener", new Object[0]);
            this.mUpdateListener = (OnUpdateListener)listener;
            this.mUpdateListener.onUpdateEmptyView(this.getMainItemCount());
        }
        if (listener instanceof OnFilterListener) {
            this.log.i("- OnFilterListener", new Object[0]);
            this.mFilterListener = (OnFilterListener)listener;
        }
        return this;
    }

    public final FlexibleAdapter<T> removeListener(Object listener) {
        if (listener == null) {
            this.log.e("No listener class to remove!", new Object[0]);
            return this;
        }
        String className = LayoutUtils.getClassName(listener);
        if (listener instanceof OnItemClickListener || listener == OnItemClickListener.class) {
            this.mItemClickListener = null;
            this.log.i("Removed %s as OnItemClickListener", className);
            for (FlexibleViewHolder holder : this.getAllBoundViewHolders()) {
                holder.getContentView().setOnClickListener(null);
            }
        }
        if (listener instanceof OnItemLongClickListener || listener == OnItemLongClickListener.class) {
            this.mItemLongClickListener = null;
            this.log.i("Removed %s as OnItemLongClickListener", className);
            for (FlexibleViewHolder holder : this.getAllBoundViewHolders()) {
                holder.getContentView().setOnLongClickListener(null);
            }
        }
        if (listener instanceof OnItemMoveListener || listener == OnItemMoveListener.class) {
            this.mItemMoveListener = null;
            this.log.i("Removed %s as OnItemMoveListener", className);
        }
        if (listener instanceof OnItemSwipeListener || listener == OnItemSwipeListener.class) {
            this.mItemSwipeListener = null;
            this.log.i("Removed %s as OnItemSwipeListener", className);
        }
        if (listener instanceof OnDeleteCompleteListener || listener == OnDeleteCompleteListener.class) {
            this.mDeleteCompleteListener = null;
            this.log.i("Removed %s as OnDeleteCompleteListener", className);
        }
        if (listener instanceof OnStickyHeaderChangeListener || listener == OnStickyHeaderChangeListener.class) {
            this.mStickyHeaderChangeListener = null;
            this.log.i("Removed %s as OnStickyHeaderChangeListener", className);
        }
        if (listener instanceof OnUpdateListener || listener == OnUpdateListener.class) {
            this.mUpdateListener = null;
            this.log.i("Removed %s as OnUpdateListener", className);
        }
        if (listener instanceof OnFilterListener || listener == OnFilterListener.class) {
            this.mFilterListener = null;
            this.log.i("Removed %s as OnFilterListener", className);
        }
        return this;
    }

    @Override
    @CallSuper
    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.log.v("Attached Adapter to RecyclerView", new Object[0]);
        if (this.headersShown && this.areHeadersSticky()) {
            this.mStickyHeaderHelper.attachToRecyclerView(this.mRecyclerView);
        }
    }

    @Override
    @CallSuper
    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        if (this.areHeadersSticky()) {
            this.mStickyHeaderHelper.detachFromRecyclerView();
            this.mStickyHeaderHelper = null;
        }
        super.onDetachedFromRecyclerView(recyclerView);
        this.log.v("Detached Adapter from RecyclerView", new Object[0]);
    }

    public FlexibleAdapter<T> expandItemsAtStartUp() {
        this.setScrollAnimate(true);
        this.multiRange = true;
        for (int position = 0; position < this.getItemCount(); ++position) {
            T item = this.getItem(position);
            if (!this.headersShown && this.isHeader(item) && !item.isHidden()) {
                this.headersShown = true;
            }
            if (!this.isExpanded(item)) continue;
            this.expand(position, false, true, false);
        }
        this.multiRange = false;
        this.setScrollAnimate(false);
        return this;
    }

    public boolean isEnabled(int position) {
        T item = this.getItem(position);
        return item != null && item.isEnabled();
    }

    @Override
    public boolean isSelectable(int position) {
        T item = this.getItem(position);
        return item != null && item.isSelectable();
    }

    @Override
    public void toggleSelection(@IntRange(from=0L) int position) {
        T item = this.getItem(position);
        if (item != null && item.isSelectable()) {
            boolean hasParent;
            IExpandable parent = this.getExpandableOf(item);
            boolean bl = hasParent = parent != null;
            if (!(!this.isExpandable(item) && hasParent || this.childSelected)) {
                this.parentSelected = true;
                if (hasParent) {
                    this.mSelectedLevel = parent.getExpansionLevel();
                }
                super.toggleSelection(position);
            } else if (hasParent && (this.mSelectedLevel == -1 || !this.parentSelected && parent.getExpansionLevel() + 1 == this.mSelectedLevel)) {
                this.childSelected = true;
                this.mSelectedLevel = parent.getExpansionLevel() + 1;
                super.toggleSelection(position);
            }
        }
        if (super.getSelectedItemCount() == 0) {
            this.mSelectedLevel = -1;
            this.childSelected = false;
            this.parentSelected = false;
        }
    }

    @Override
    public void selectAll(Integer ... viewTypes) {
        if (this.getSelectedItemCount() > 0 && viewTypes.length == 0) {
            super.selectAll(this.getItemViewType(this.getSelectedPositions().get(0)));
        } else {
            super.selectAll(viewTypes);
        }
    }

    @Override
    @CallSuper
    public void clearSelection() {
        this.childSelected = false;
        this.parentSelected = false;
        super.clearSelection();
    }

    public boolean isAnyParentSelected() {
        return this.parentSelected;
    }

    public boolean isAnyChildSelected() {
        return this.childSelected;
    }

    @CallSuper
    public void updateDataSet(@Nullable List<T> items) {
        this.updateDataSet(items, false);
    }

    @CallSuper
    public void updateDataSet(@Nullable List<T> items, boolean animate) {
        this.mOriginalList = null;
        if (items == null) {
            items = new ArrayList<T>();
        }
        if (animate) {
            this.mHandler.removeMessages(1);
            this.mHandler.sendMessage(Message.obtain((Handler)this.mHandler, (int)1, items));
        } else {
            ArrayList<T> newItems = new ArrayList<T>(items);
            this.prepareItemsForUpdate(newItems);
            this.mItems = newItems;
            this.log.w("updateDataSet with notifyDataSetChanged!", new Object[0]);
            this.notifyDataSetChanged();
            this.onPostUpdate();
        }
    }

    @Nullable
    public T getItem(int position) {
        if (position < 0 || position >= this.getItemCount()) {
            return null;
        }
        return (T)((IFlexible)this.mItems.get(position));
    }

    @Nullable
    public <S extends T> S getItem(int position, Class<S> clazz) {
        return (S)((IFlexible)clazz.cast(this.getItem(position)));
    }

    public long getItemId(int position) {
        T item = this.getItem(position);
        return item != null ? (long)item.hashCode() : -1L;
    }

    public int getItemCount() {
        return this.mItems.size();
    }

    public final int getMainItemCount() {
        return this.hasFilter() ? this.getItemCount() : this.getItemCount() - this.mScrollableHeaders.size() - this.mScrollableFooters.size();
    }

    public final int getItemCountOfTypes(Integer ... viewTypes) {
        List<Integer> viewTypeList = Arrays.asList(viewTypes);
        int count = 0;
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!viewTypeList.contains(this.getItemViewType(i))) continue;
            ++count;
        }
        return count;
    }

    @NonNull
    public final List<T> getCurrentItems() {
        return Collections.unmodifiableList(this.mItems);
    }

    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    public final int getGlobalPositionOf(IFlexible item) {
        return item != null ? this.mItems.indexOf(item) : -1;
    }

    public final int getCardinalPositionOf(@NonNull IFlexible item) {
        int position = this.getGlobalPositionOf(item);
        if (position > this.mScrollableHeaders.size()) {
            position -= this.mScrollableHeaders.size();
        }
        return position;
    }

    public final int getSameTypePositionOf(@NonNull IFlexible item) {
        int position = -1;
        for (IFlexible current : this.mItems) {
            if (current.getItemViewType() != item.getItemViewType()) continue;
            ++position;
            if (!current.equals(item)) continue;
            break;
        }
        return position;
    }

    public boolean contains(@Nullable T item) {
        return item != null && this.mItems.contains(item);
    }

    public int calculatePositionFor(@NonNull Object item, @Nullable Comparator<IFlexible> comparator) {
        ISectionable sectionable;
        Object header;
        if (comparator == null) {
            return 0;
        }
        if (item instanceof ISectionable && (header = (sectionable = (ISectionable)item).getHeader()) != null && !header.isHidden()) {
            List<ISectionable> sortedList = this.getSectionItems((IHeader)header);
            sortedList.add(sectionable);
            Collections.sort(sortedList, comparator);
            int itemPosition = this.getGlobalPositionOf(sectionable);
            int headerPosition = this.getGlobalPositionOf((IFlexible)header);
            int fix = itemPosition != -1 && itemPosition < headerPosition ? 0 : 1;
            int result = headerPosition + sortedList.indexOf(item) + fix;
            this.log.v("Calculated finalPosition=%s sectionPosition=%s relativePosition=%s fix=%s", result, headerPosition, sortedList.indexOf(item), fix);
            return result;
        }
        ArrayList<T> sortedList = new ArrayList<T>(this.mItems);
        if (!sortedList.contains(item)) {
            sortedList.add(item);
        }
        Collections.sort(sortedList, comparator);
        this.log.v("Calculated position %s for item=%s", Math.max(0, sortedList.indexOf(item)), item);
        return Math.max(0, sortedList.indexOf(item));
    }

    @NonNull
    public final List<T> getScrollableHeaders() {
        return Collections.unmodifiableList(this.mScrollableHeaders);
    }

    @NonNull
    public final List<T> getScrollableFooters() {
        return Collections.unmodifiableList(this.mScrollableFooters);
    }

    @Override
    public final boolean isScrollableHeaderOrFooter(int position) {
        T item = this.getItem(position);
        return this.isScrollableHeaderOrFooter(item);
    }

    public final boolean isScrollableHeaderOrFooter(T item) {
        return item != null && this.mScrollableHeaders.contains(item) || this.mScrollableFooters.contains(item);
    }

    public final boolean addScrollableHeader(@NonNull T headerItem) {
        this.log.d("Add scrollable header %s", LayoutUtils.getClassName(headerItem));
        if (!this.mScrollableHeaders.contains(headerItem)) {
            headerItem.setSelectable(false);
            headerItem.setDraggable(false);
            int progressFix = headerItem == this.mProgressItem ? this.mScrollableHeaders.size() : 0;
            this.mScrollableHeaders.add(headerItem);
            this.setScrollAnimate(true);
            this.performInsert(progressFix, Collections.singletonList(headerItem), true);
            this.setScrollAnimate(false);
            return true;
        }
        this.log.w("Scrollable header %s already added", LayoutUtils.getClassName(headerItem));
        return false;
    }

    public final boolean addScrollableFooter(@NonNull T footerItem) {
        if (!this.mScrollableFooters.contains(footerItem)) {
            int progressFix;
            this.log.d("Add scrollable footer %s", LayoutUtils.getClassName(footerItem));
            footerItem.setSelectable(false);
            footerItem.setDraggable(false);
            int n = progressFix = footerItem == this.mProgressItem ? this.mScrollableFooters.size() : 0;
            if (progressFix > 0 && this.mScrollableFooters.size() > 0) {
                this.mScrollableFooters.add(0, footerItem);
            } else {
                this.mScrollableFooters.add(footerItem);
            }
            this.performInsert(this.getItemCount() - progressFix, Collections.singletonList(footerItem), true);
            return true;
        }
        this.log.w("Scrollable footer %s already added", LayoutUtils.getClassName(footerItem));
        return false;
    }

    public final void removeScrollableHeader(@NonNull T headerItem) {
        if (this.mScrollableHeaders.remove(headerItem)) {
            this.log.d("Remove scrollable header %s", LayoutUtils.getClassName(headerItem));
            this.performRemove(headerItem, true);
        }
    }

    public final void removeScrollableFooter(@NonNull T footerItem) {
        if (this.mScrollableFooters.remove(footerItem)) {
            this.log.d("Remove scrollable footer %s", LayoutUtils.getClassName(footerItem));
            this.performRemove(footerItem, true);
        }
    }

    public final void removeAllScrollableHeaders() {
        if (this.mScrollableHeaders.size() > 0) {
            this.log.d("Remove all scrollable headers", new Object[0]);
            this.mItems.removeAll(this.mScrollableHeaders);
            this.notifyItemRangeRemoved(0, this.mScrollableHeaders.size());
            this.mScrollableHeaders.clear();
        }
    }

    public final void removeAllScrollableFooters() {
        if (this.mScrollableFooters.size() > 0) {
            this.log.d("Remove all scrollable footers", new Object[0]);
            this.mItems.removeAll(this.mScrollableFooters);
            this.notifyItemRangeRemoved(this.getItemCount() - this.mScrollableFooters.size(), this.mScrollableFooters.size());
            this.mScrollableFooters.clear();
        }
    }

    public final void addScrollableHeaderWithDelay(@NonNull T headerItem, @IntRange(from=0L) long delay, boolean scrollToPosition) {
        this.log.d("Enqueued adding scrollable header (%sms) %s", delay, LayoutUtils.getClassName(headerItem));
        this.mHandler.postDelayed(new Runnable((IFlexible)headerItem, scrollToPosition){
            final /* synthetic */ IFlexible val$headerItem;
            final /* synthetic */ boolean val$scrollToPosition;
            {
                this.val$headerItem = iFlexible;
                this.val$scrollToPosition = bl;
            }

            @Override
            public void run() {
                if (FlexibleAdapter.this.addScrollableHeader(this.val$headerItem) && this.val$scrollToPosition) {
                    FlexibleAdapter.this.performScroll(FlexibleAdapter.this.getGlobalPositionOf(this.val$headerItem));
                }
            }
        }, delay);
    }

    public final void addScrollableFooterWithDelay(@NonNull T footerItem, @IntRange(from=0L) long delay, boolean scrollToPosition) {
        this.log.d("Enqueued adding scrollable footer (%sms) %s", delay, LayoutUtils.getClassName(footerItem));
        this.mHandler.postDelayed(new Runnable((IFlexible)footerItem, scrollToPosition){
            final /* synthetic */ IFlexible val$footerItem;
            final /* synthetic */ boolean val$scrollToPosition;
            {
                this.val$footerItem = iFlexible;
                this.val$scrollToPosition = bl;
            }

            @Override
            public void run() {
                if (FlexibleAdapter.this.addScrollableFooter(this.val$footerItem) && this.val$scrollToPosition) {
                    FlexibleAdapter.this.performScroll(FlexibleAdapter.this.getGlobalPositionOf(this.val$footerItem));
                }
            }
        }, delay);
    }

    public final void removeScrollableHeaderWithDelay(@NonNull T headerItem, @IntRange(from=0L) long delay) {
        this.log.d("Enqueued removing scrollable header (%sms) %s", delay, LayoutUtils.getClassName(headerItem));
        this.mHandler.postDelayed(new Runnable((IFlexible)headerItem){
            final /* synthetic */ IFlexible val$headerItem;
            {
                this.val$headerItem = iFlexible;
            }

            @Override
            public void run() {
                FlexibleAdapter.this.removeScrollableHeader(this.val$headerItem);
            }
        }, delay);
    }

    public final void removeScrollableFooterWithDelay(@NonNull T footerItem, @IntRange(from=0L) long delay) {
        this.log.d("Enqueued removing scrollable footer (%sms) %s", delay, LayoutUtils.getClassName(footerItem));
        this.mHandler.postDelayed(new Runnable((IFlexible)footerItem){
            final /* synthetic */ IFlexible val$footerItem;
            {
                this.val$footerItem = iFlexible;
            }

            @Override
            public void run() {
                FlexibleAdapter.this.removeScrollableFooter(this.val$footerItem);
            }
        }, delay);
    }

    private void restoreScrollableHeadersAndFooters(List<T> items) {
        for (IFlexible item : this.mScrollableHeaders) {
            if (items.size() > 0) {
                items.add(0, item);
                continue;
            }
            items.add(item);
        }
        items.addAll(this.mScrollableFooters);
    }

    public FlexibleAdapter<T> setUnlinkAllItemsOnRemoveHeaders(boolean unlinkOnRemoveHeader) {
        this.log.i("Set unlinkOnRemoveHeader=%s", unlinkOnRemoveHeader);
        this.unlinkOnRemoveHeader = unlinkOnRemoveHeader;
        return this;
    }

    @NonNull
    public List<IHeader> getHeaderItems() {
        ArrayList<IHeader> headers = new ArrayList<IHeader>();
        for (IFlexible item : this.mItems) {
            if (!this.isHeader(item)) continue;
            headers.add((IHeader)item);
        }
        return headers;
    }

    public boolean isHeader(T item) {
        return item != null && item instanceof IHeader;
    }

    public boolean hasHeader(T item) {
        return this.getHeaderOf(item) != null;
    }

    public boolean hasSameHeader(T item, IHeader header) {
        IHeader current = this.getHeaderOf(item);
        return current != null && header != null && current.equals(header);
    }

    @Nullable
    public IHeader getHeaderOf(T item) {
        if (item != null && item instanceof ISectionable) {
            return ((ISectionable)item).getHeader();
        }
        return null;
    }

    public IHeader getSectionHeader(@IntRange(from=0L) int position) {
        if (!this.headersShown) {
            return null;
        }
        for (int i = position; i >= 0; --i) {
            T item = this.getItem(i);
            if (!this.isHeader(item)) continue;
            return (IHeader)item;
        }
        return null;
    }

    @NonNull
    public List<ISectionable> getSectionItems(@NonNull IHeader header) {
        ArrayList<ISectionable> sectionItems = new ArrayList<ISectionable>();
        int startPosition = this.getGlobalPositionOf(header);
        T item = this.getItem(++startPosition);
        while (this.hasSameHeader(item, header)) {
            sectionItems.add((ISectionable)item);
            item = this.getItem(++startPosition);
        }
        return sectionItems;
    }

    @NonNull
    public List<Integer> getSectionItemPositions(@NonNull IHeader header) {
        ArrayList<Integer> sectionItemPositions = new ArrayList<Integer>();
        int position = this.getGlobalPositionOf(header);
        T item = this.getItem(++position);
        while (this.hasSameHeader(item, header)) {
            sectionItemPositions.add(position);
            item = this.getItem(++position);
        }
        return sectionItemPositions;
    }

    public boolean areHeadersShown() {
        return this.headersShown;
    }

    public boolean areHeadersSticky() {
        return this.mStickyHeaderHelper != null;
    }

    public final int getStickyPosition() {
        return this.areHeadersSticky() ? this.mStickyHeaderHelper.getStickyPosition() : -1;
    }

    public final void ensureHeaderParent() {
        if (this.areHeadersSticky()) {
            this.mStickyHeaderHelper.ensureHeaderParent();
        }
    }

    public FlexibleAdapter<T> setStickyHeaders(boolean sticky) {
        return this.setStickyHeaders(sticky, this.mStickyContainer);
    }

    public FlexibleAdapter<T> setStickyHeaders(final boolean sticky, @Nullable ViewGroup stickyContainer) {
        this.log.i("Set stickyHeaders=%s (in Post!)%s", sticky, stickyContainer != null ? " with user defined Sticky Container" : "");
        this.mStickyContainer = stickyContainer;
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (sticky) {
                    if (FlexibleAdapter.this.mStickyHeaderHelper == null) {
                        FlexibleAdapter.this.mStickyHeaderHelper = new StickyHeaderHelper(FlexibleAdapter.this, FlexibleAdapter.this.mStickyHeaderChangeListener, FlexibleAdapter.this.mStickyContainer);
                        FlexibleAdapter.this.mStickyHeaderHelper.attachToRecyclerView(FlexibleAdapter.this.mRecyclerView);
                        FlexibleAdapter.this.log.i("Sticky headers enabled", new Object[0]);
                    }
                } else if (FlexibleAdapter.this.areHeadersSticky()) {
                    FlexibleAdapter.this.mStickyHeaderHelper.detachFromRecyclerView();
                    FlexibleAdapter.this.mStickyHeaderHelper = null;
                    FlexibleAdapter.this.log.i("Sticky headers disabled", new Object[0]);
                }
            }
        });
        return this;
    }

    public int getStickyHeaderElevation() {
        return this.mStickyElevation;
    }

    public FlexibleAdapter<T> setStickyHeaderElevation(@IntRange(from=0L) int stickyElevation) {
        this.mStickyElevation = stickyElevation;
        return this;
    }

    public FlexibleAdapter<T> setDisplayHeadersAtStartUp(boolean displayHeaders) {
        if (!this.headersShown && displayHeaders) {
            this.showAllHeaders(true);
        }
        return this;
    }

    public FlexibleAdapter<T> setHeadersShown(boolean headersShown) {
        this.headersShown = headersShown;
        return this;
    }

    public FlexibleAdapter<T> showAllHeaders() {
        this.showAllHeaders(false);
        return this;
    }

    private void showAllHeaders(boolean init) {
        if (init) {
            this.log.i("showAllHeaders at startup", new Object[0]);
            this.showAllHeadersWithReset(true);
        } else {
            this.log.i("showAllHeaders with insert notification (in Post!)", new Object[0]);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    int firstVisibleItem;
                    if (FlexibleAdapter.this.headersShown) {
                        FlexibleAdapter.this.log.w("Double call detected! Headers already shown OR the method showAllHeaders() was already called!", new Object[0]);
                        return;
                    }
                    FlexibleAdapter.this.showAllHeadersWithReset(false);
                    if (FlexibleAdapter.this.mRecyclerView != null && (firstVisibleItem = FlexibleAdapter.this.getFlexibleLayoutManager().findFirstCompletelyVisibleItemPosition()) == 0 && FlexibleAdapter.this.isHeader(FlexibleAdapter.this.getItem(0)) && !FlexibleAdapter.this.isHeader(FlexibleAdapter.this.getItem(1))) {
                        FlexibleAdapter.this.mRecyclerView.scrollToPosition(0);
                    }
                }
            });
        }
    }

    private void showAllHeadersWithReset(boolean init) {
        IHeader sameHeader = null;
        for (int position = 0; position < this.getItemCount() - this.mScrollableFooters.size(); ++position) {
            T item = this.getItem(position);
            IHeader header = this.getHeaderOf(item);
            if (header != null && !header.equals(sameHeader) && !this.isExpandable(header)) {
                sameHeader = header;
                header.setHidden(true);
            }
            if (!this.showHeaderOf(position, item, init)) continue;
            ++position;
        }
        this.headersShown = true;
    }

    private boolean showHeaderOf(int position, T item, boolean init) {
        IHeader header = this.getHeaderOf(item);
        if (header == null || this.getPendingRemovedItem(item) != null) {
            return false;
        }
        if (header.isHidden()) {
            this.log.v("Showing header position=%s header=%s", position, header);
            header.setHidden(false);
            this.performInsert(position, Collections.singletonList(header), !init);
            return true;
        }
        return false;
    }

    public void hideAllHeaders() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                FlexibleAdapter.this.multiRange = true;
                for (int position = FlexibleAdapter.this.getItemCount() - FlexibleAdapter.this.mScrollableFooters.size() - 1; position >= Math.max(0, FlexibleAdapter.this.mScrollableHeaders.size() - 1); --position) {
                    Object item = FlexibleAdapter.this.getItem(position);
                    if (!FlexibleAdapter.this.isHeader(item)) continue;
                    FlexibleAdapter.this.hideHeader(position, (IHeader)item);
                }
                FlexibleAdapter.this.headersShown = false;
                if (FlexibleAdapter.this.areHeadersSticky()) {
                    FlexibleAdapter.this.mStickyHeaderHelper.clearHeaderWithAnimation();
                }
                FlexibleAdapter.this.multiRange = false;
            }
        });
    }

    private void hideHeaderOf(T item) {
        IHeader header = this.getHeaderOf(item);
        if (header != null && !header.isHidden()) {
            this.hideHeader(this.getGlobalPositionOf(header), header);
        }
    }

    private void hideHeader(int position, IHeader header) {
        if (position >= 0) {
            this.log.v("Hiding header position=%s header=$s", position, header);
            header.setHidden(true);
            this.mItems.remove(position);
            this.notifyItemRemoved(position);
        }
    }

    private void linkHeaderTo(T item, IHeader header, @Nullable Object payload) {
        if (item != null && item instanceof ISectionable) {
            ISectionable sectionable = (ISectionable)item;
            if (sectionable.getHeader() != null && !sectionable.getHeader().equals(header)) {
                this.unlinkHeaderFrom(sectionable, (Object)Payload.UNLINK);
            }
            if (sectionable.getHeader() == null && header != null) {
                this.log.v("Link header %s to %s", header, sectionable);
                sectionable.setHeader(header);
                if (payload != null) {
                    if (!header.isHidden()) {
                        this.notifyItemChanged(this.getGlobalPositionOf(header), payload);
                    }
                    if (!item.isHidden()) {
                        this.notifyItemChanged(this.getGlobalPositionOf((IFlexible)item), payload);
                    }
                }
            }
        } else {
            this.notifyItemChanged(this.getGlobalPositionOf(header), payload);
        }
    }

    private void unlinkHeaderFrom(T item, @Nullable Object payload) {
        if (this.hasHeader(item)) {
            ISectionable sectionable = (ISectionable)item;
            Object header = sectionable.getHeader();
            this.log.v("Unlink header %s from %s", header, sectionable);
            sectionable.setHeader(null);
            if (payload != null) {
                if (!header.isHidden()) {
                    this.notifyItemChanged(this.getGlobalPositionOf((IFlexible)header), payload);
                }
                if (!item.isHidden()) {
                    this.notifyItemChanged(this.getGlobalPositionOf((IFlexible)item), payload);
                }
            }
        }
    }

    public int getItemViewType(int position) {
        T item = this.getItem(position);
        if (item == null) {
            this.log.e("Item for ViewType not found! position=%s, items=%s", position, this.getItemCount());
            return 0;
        }
        this.mapViewTypeFrom(item);
        this.autoMap = true;
        return item.getItemViewType();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        T item = this.getViewTypeInstance(viewType);
        if (item == null || !this.autoMap) {
            throw new IllegalStateException(String.format("ViewType instance not found for viewType %s. You should implement the AutoMap properly.", viewType));
        }
        if (this.mInflater == null) {
            this.mInflater = LayoutInflater.from((Context)parent.getContext());
        }
        return item.createViewHolder(this.mInflater.inflate(item.getLayoutRes(), parent, false), this);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        this.onBindViewHolder(holder, position, Collections.unmodifiableList(new ArrayList()));
    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position, List payloads) {
        String itemId = this.hasStableIds() ? " itemId=" + holder.getItemId() : "";
        this.log.v("onViewBound    Holder=%s position=%s%s", LayoutUtils.getClassName(holder), position, itemId);
        if (!this.autoMap) {
            throw new IllegalStateException("AutoMap is not active, this method cannot be called. You should implement the AutoMap properly.");
        }
        super.onBindViewHolder(holder, position, payloads);
        T item = this.getItem(position);
        if (item != null) {
            int headerPos;
            holder.itemView.setEnabled(item.isEnabled());
            item.bindViewHolder(this, (RecyclerView.ViewHolder)holder, position, payloads);
            if (this.areHeadersSticky() && !this.isFastScroll && this.mStickyHeaderHelper.getStickyPosition() >= 0 && payloads.isEmpty() && (headerPos = this.getFlexibleLayoutManager().findFirstVisibleItemPosition() - 1) == position && this.isHeader(item)) {
                holder.itemView.setVisibility(4);
            }
        }
        this.onLoadMore(position);
        this.animateView(holder, position);
    }

    @CallSuper
    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        int position = holder.getAdapterPosition();
        T item = this.getItem(position);
        if (item != null) {
            item.onViewAttached(this, (RecyclerView.ViewHolder)holder, position);
        }
    }

    @CallSuper
    public void onViewDetachedFromWindow(RecyclerView.ViewHolder holder) {
        int position = holder.getAdapterPosition();
        T item = this.getItem(position);
        if (item != null) {
            item.onViewDetached(this, (RecyclerView.ViewHolder)holder, position);
        }
    }

    @Override
    @CallSuper
    public void onViewRecycled(RecyclerView.ViewHolder holder) {
        int position;
        T item;
        super.onViewRecycled(holder);
        if (this.areHeadersSticky()) {
            holder.itemView.setVisibility(0);
        }
        if ((item = this.getItem(position = holder.getAdapterPosition())) != null) {
            item.unbindViewHolder(this, (RecyclerView.ViewHolder)holder, position);
        }
    }

    public boolean isTopEndless() {
        return this.mTopEndless;
    }

    public void setTopEndless(boolean topEndless) {
        this.mTopEndless = topEndless;
    }

    public boolean isEndlessScrollEnabled() {
        return this.endlessScrollEnabled;
    }

    public int getEndlessCurrentPage() {
        if (this.mEndlessPageSize > 0) {
            return (int)Math.ceil((double)this.getMainItemCount() / (double)this.mEndlessPageSize);
        }
        return 0;
    }

    public int getEndlessPageSize() {
        return this.mEndlessPageSize;
    }

    public FlexibleAdapter<T> setEndlessPageSize(@IntRange(from=0L) int endlessPageSize) {
        this.log.i("Set endlessPageSize=%s", endlessPageSize);
        this.mEndlessPageSize = endlessPageSize;
        return this;
    }

    public int getEndlessTargetCount() {
        return this.mEndlessTargetCount;
    }

    public FlexibleAdapter<T> setEndlessTargetCount(@IntRange(from=0L) int endlessTargetCount) {
        this.log.i("Set endlessTargetCount=%s", endlessTargetCount);
        this.mEndlessTargetCount = endlessTargetCount;
        return this;
    }

    public FlexibleAdapter<T> setLoadingMoreAtStartUp(boolean enable) {
        this.log.i("Set loadingAtStartup=%s", enable);
        if (enable) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FlexibleAdapter.this.onLoadMore(0);
                }
            });
        }
        return this;
    }

    public FlexibleAdapter<T> setEndlessProgressItem(@Nullable T progressItem) {
        boolean bl = this.endlessScrollEnabled = progressItem != null;
        if (progressItem != null) {
            this.setEndlessScrollThreshold(this.mEndlessScrollThreshold);
            this.mProgressItem = progressItem;
            this.log.i("Set progressItem=%s", LayoutUtils.getClassName(progressItem));
            this.log.i("Enabled EndlessScrolling", new Object[0]);
        } else {
            this.log.i("Disabled EndlessScrolling", new Object[0]);
        }
        return this;
    }

    public FlexibleAdapter<T> setEndlessScrollListener(@Nullable EndlessScrollListener endlessScrollListener, @NonNull T progressItem) {
        this.log.i("Set endlessScrollListener=%s", LayoutUtils.getClassName(endlessScrollListener));
        this.mEndlessScrollListener = endlessScrollListener;
        return this.setEndlessProgressItem(progressItem);
    }

    public FlexibleAdapter<T> setEndlessScrollThreshold(@IntRange(from=1L) int thresholdItems) {
        if (this.mRecyclerView != null) {
            int spanCount = this.getFlexibleLayoutManager().getSpanCount();
            thresholdItems *= spanCount;
        }
        this.mEndlessScrollThreshold = thresholdItems;
        this.log.i("Set endlessScrollThreshold=%s", this.mEndlessScrollThreshold);
        return this;
    }

    protected void onLoadMore(int position) {
        int threshold;
        if (!this.isEndlessScrollEnabled() || this.endlessLoading || this.getItem(position) == this.mProgressItem) {
            return;
        }
        int n = this.mTopEndless ? this.mEndlessScrollThreshold - (this.hasFilter() ? 0 : this.mScrollableHeaders.size()) : (threshold = this.getItemCount() - this.mEndlessScrollThreshold - (this.hasFilter() ? 0 : this.mScrollableFooters.size()));
        if (!this.mTopEndless && (position == this.getGlobalPositionOf((IFlexible)this.mProgressItem) || position < threshold) || this.mTopEndless && position > 0 && position > threshold) {
            return;
        }
        this.log.v("onLoadMore     topEndless=%s, loading=%s, position=%s, itemCount=%s threshold=%s, currentThreshold=%s", this.mTopEndless, this.endlessLoading, position, this.getItemCount(), this.mEndlessScrollThreshold, threshold);
        this.endlessLoading = true;
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                boolean added;
                FlexibleAdapter.this.mHandler.removeMessages(8);
                boolean bl = added = FlexibleAdapter.this.mTopEndless ? FlexibleAdapter.this.addScrollableHeader(FlexibleAdapter.this.mProgressItem) : FlexibleAdapter.this.addScrollableFooter(FlexibleAdapter.this.mProgressItem);
                if (added && FlexibleAdapter.this.mEndlessScrollListener != null) {
                    FlexibleAdapter.this.log.d("onLoadMore     invoked!", new Object[0]);
                    FlexibleAdapter.this.mEndlessScrollListener.onLoadMore(FlexibleAdapter.this.getMainItemCount(), FlexibleAdapter.this.getEndlessCurrentPage());
                } else if (!added) {
                    FlexibleAdapter.this.endlessLoading = false;
                }
            }
        });
    }

    public void onLoadMoreComplete(@Nullable List<T> newItems) {
        this.onLoadMoreComplete(newItems, 0L);
    }

    public void onLoadMoreComplete(@Nullable List<T> newItems, @IntRange(from=-1L) long delay) {
        int newItemsSize = newItems == null ? 0 : newItems.size();
        int totalItemCount = newItemsSize + this.getMainItemCount();
        int progressPosition = this.getGlobalPositionOf((IFlexible)this.mProgressItem);
        if (this.mEndlessPageSize > 0 && newItemsSize < this.mEndlessPageSize || this.mEndlessTargetCount > 0 && totalItemCount >= this.mEndlessTargetCount) {
            this.setEndlessProgressItem(null);
        }
        if (!(delay <= 0L || newItemsSize != 0 && this.isEndlessScrollEnabled())) {
            this.log.v("onLoadMore     enqueued removing progressItem (%sms)", delay);
            this.mHandler.sendEmptyMessageDelayed(8, delay);
        } else {
            this.hideProgressItem();
        }
        if (newItemsSize > 0) {
            this.log.d("onLoadMore     performing adding %s new items on page=%s", newItemsSize, this.getEndlessCurrentPage());
            progressPosition = this.mTopEndless ? this.mScrollableHeaders.size() : progressPosition;
            this.addItems(progressPosition, newItems);
        }
        this.endlessLoading = false;
        if (newItemsSize == 0 || !this.isEndlessScrollEnabled()) {
            this.noMoreLoad(newItemsSize);
        }
    }

    private void hideProgressItem() {
        int positionToNotify = this.getGlobalPositionOf((IFlexible)this.mProgressItem);
        if (positionToNotify >= 0) {
            this.log.v("onLoadMore     remove progressItem", new Object[0]);
            if (this.mTopEndless) {
                this.removeScrollableHeader(this.mProgressItem);
            } else {
                this.removeScrollableFooter(this.mProgressItem);
            }
        }
    }

    private void noMoreLoad(int newItemsSize) {
        this.log.i("noMoreLoad!", new Object[0]);
        int positionToNotify = this.getGlobalPositionOf((IFlexible)this.mProgressItem);
        if (positionToNotify >= 0) {
            this.notifyItemChanged(positionToNotify, (Object)Payload.NO_MORE_LOAD);
        }
        if (this.mEndlessScrollListener != null) {
            this.mEndlessScrollListener.noMoreLoad(newItemsSize);
        }
    }

    public boolean isAutoCollapseOnExpand() {
        return this.collapseOnExpand;
    }

    public FlexibleAdapter<T> setAutoCollapseOnExpand(boolean collapseOnExpand) {
        this.log.i("Set autoCollapseOnExpand=%s", collapseOnExpand);
        this.collapseOnExpand = collapseOnExpand;
        return this;
    }

    public boolean isRecursiveCollapse() {
        return this.collapseSubLevels;
    }

    public FlexibleAdapter<T> setRecursiveCollapse(boolean collapseSubLevels) {
        this.log.i("Set setAutoCollapseSubLevels=%s", collapseSubLevels);
        this.collapseSubLevels = collapseSubLevels;
        return this;
    }

    public boolean isAutoScrollOnExpand() {
        return this.scrollOnExpand;
    }

    public FlexibleAdapter<T> setAutoScrollOnExpand(boolean scrollOnExpand) {
        this.log.i("Set setAutoScrollOnExpand=%s", scrollOnExpand);
        this.scrollOnExpand = scrollOnExpand;
        return this;
    }

    public boolean isExpanded(@IntRange(from=0L) int position) {
        return this.isExpanded(this.getItem(position));
    }

    public boolean isExpanded(@Nullable T item) {
        return this.isExpandable(item) && ((IExpandable)item).isExpanded();
    }

    public boolean isExpandable(@Nullable T item) {
        return item instanceof IExpandable;
    }

    public int getMinCollapsibleLevel() {
        return this.mMinCollapsibleLevel;
    }

    public FlexibleAdapter<T> setMinCollapsibleLevel(int minCollapsibleLevel) {
        this.log.i("Set minCollapsibleLevel=%s", minCollapsibleLevel);
        this.mMinCollapsibleLevel = minCollapsibleLevel;
        return this;
    }

    public boolean hasSubItems(IExpandable expandable) {
        return expandable != null && expandable.getSubItems() != null && expandable.getSubItems().size() > 0;
    }

    @Nullable
    public IExpandable getExpandableOf(int position) {
        return this.getExpandableOf(this.getItem(position));
    }

    @Nullable
    public IExpandable getExpandableOf(T child) {
        for (IFlexible parent : this.mItems) {
            IExpandable expandable;
            if (!this.isExpandable(parent) || !(expandable = (IExpandable)parent).isExpanded() || !this.hasSubItems(expandable)) continue;
            List list = expandable.getSubItems();
            for (IFlexible subItem : list) {
                if (subItem.isHidden() || !subItem.equals(child)) continue;
                return expandable;
            }
        }
        return null;
    }

    public int getExpandablePositionOf(@NonNull T child) {
        return this.getGlobalPositionOf(this.getExpandableOf(child));
    }

    public int getSubPositionOf(@NonNull T child) {
        IHeader header;
        if (child instanceof ISectionable && this.hasHeader(child) && !((header = this.getHeaderOf(child)) instanceof IExpandable)) {
            return this.getGlobalPositionOf((IFlexible)child) - this.getGlobalPositionOf(header) - 1;
        }
        return this.getSiblingsOf(child).indexOf(child);
    }

    @NonNull
    public List<T> getSiblingsOf(@NonNull T child) {
        IExpandable expandable = this.getExpandableOf(child);
        return expandable != null ? expandable.getSubItems() : new ArrayList();
    }

    @NonNull
    public List<T> getExpandedItems() {
        ArrayList<IFlexible> expandedItems = new ArrayList<IFlexible>();
        for (IFlexible item : this.mItems) {
            if (!this.isExpanded(item)) continue;
            expandedItems.add(item);
        }
        return expandedItems;
    }

    @NonNull
    public List<Integer> getExpandedPositions() {
        ArrayList<Integer> expandedPositions = new ArrayList<Integer>();
        int startPosition = Math.max(0, this.mScrollableHeaders.size() - 1);
        int endPosition = this.getItemCount() - this.mScrollableFooters.size() - 1;
        for (int i = startPosition; i < endPosition; ++i) {
            if (!this.isExpanded(this.getItem(i))) continue;
            expandedPositions.add(i);
        }
        return expandedPositions;
    }

    private int getRecursiveSubItemCount(@NonNull IExpandable parent, int subPosition) {
        int count = 0;
        List subItems = parent.getSubItems();
        for (int index = 0; index < subPosition; ++index) {
            IFlexible subItem = (IFlexible)subItems.get(index);
            if (this.isExpanded(subItem)) {
                IExpandable subExpandable = (IExpandable)subItem;
                int size = subExpandable.getSubItems() != null ? subExpandable.getSubItems().size() : 0;
                count += this.getRecursiveSubItemCount(subExpandable, size);
            }
            ++count;
        }
        return count;
    }

    public int expand(@IntRange(from=0L) int position) {
        return this.expand(position, false);
    }

    public int expand(@IntRange(from=0L) int position, boolean notifyParent) {
        return this.expand(position, false, false, notifyParent);
    }

    public int expand(T item) {
        return this.expand(this.getGlobalPositionOf((IFlexible)item), false, false, true);
    }

    public int expand(T item, boolean init) {
        return this.expand(this.getGlobalPositionOf((IFlexible)item), false, init, false);
    }

    private int expand(int position, boolean expandAll, boolean init, boolean notifyParent) {
        T item = this.getItem(position);
        if (!this.isExpandable(item)) {
            return 0;
        }
        IExpandable expandable = (IExpandable)item;
        if (!this.hasSubItems(expandable)) {
            expandable.setExpanded(false);
            this.log.w("No subItems to Expand on position %s expanded %s", position, expandable.isExpanded());
            return 0;
        }
        if (!init && !expandAll) {
            this.log.v("Request to Expand on position=%s expanded=%s anyParentSelected=%s", position, expandable.isExpanded(), this.parentSelected);
        }
        int subItemsCount = 0;
        if (init || !expandable.isExpanded() && (!this.parentSelected || expandable.getExpansionLevel() <= this.mSelectedLevel)) {
            if (this.collapseOnExpand && !expandAll && this.collapseAll(this.mMinCollapsibleLevel) > 0) {
                position = this.getGlobalPositionOf((IFlexible)item);
            }
            List<T> subItems = this.getExpandableList(expandable, true);
            this.mItems.addAll(position + 1, subItems);
            subItemsCount = subItems.size();
            expandable.setExpanded(true);
            if (!init && this.scrollOnExpand && !expandAll) {
                this.autoScrollWithDelay(position, subItemsCount);
            }
            if (notifyParent) {
                this.notifyItemChanged(position, (Object)Payload.EXPANDED);
            }
            this.notifyItemRangeInserted(position + 1, subItemsCount);
            if (!init && this.headersShown) {
                int count = 0;
                for (IFlexible subItem : subItems) {
                    if (!this.showHeaderOf(position + ++count, subItem, false)) continue;
                    ++count;
                }
            }
            if (!this.expandSHF(this.mScrollableHeaders, expandable)) {
                this.expandSHF(this.mScrollableFooters, expandable);
            }
            this.log.v("%s %s subItems on position=%s", init ? "Initially expanded" : "Expanded", subItemsCount, position);
        }
        return subItemsCount;
    }

    private boolean expandSHF(List<T> scrollables, IExpandable expandable) {
        int index = scrollables.indexOf(expandable);
        if (index >= 0) {
            if (index + 1 < scrollables.size()) {
                return scrollables.addAll(index + 1, expandable.getSubItems());
            }
            return scrollables.addAll(expandable.getSubItems());
        }
        return false;
    }

    public int expandAll() {
        return this.expandAll(this.mMinCollapsibleLevel);
    }

    public int expandAll(int level) {
        int startPosition;
        int expanded = 0;
        for (int i = startPosition = Math.max(0, this.mScrollableHeaders.size() - 1); i < this.getItemCount() - this.mScrollableFooters.size(); ++i) {
            IExpandable expandable;
            T item = this.getItem(i);
            if (!this.isExpandable(item) || (expandable = (IExpandable)item).getExpansionLevel() > level || this.expand(i, true, false, true) <= 0) continue;
            i += expandable.getSubItems().size();
            ++expanded;
        }
        return expanded;
    }

    public int collapse(@IntRange(from=0L) int position) {
        return this.collapse(position, false);
    }

    public int collapse(@IntRange(from=0L) int position, boolean notifyParent) {
        T item = this.getItem(position);
        if (!this.isExpandable(item)) {
            return 0;
        }
        IExpandable expandable = (IExpandable)item;
        List<T> subItems = this.getExpandableList(expandable, true);
        int subItemsCount = subItems.size();
        this.log.v("Request to Collapse on position=%s expanded=%s hasSubItemsSelected=%s", position, expandable.isExpanded(), this.hasSubItemsSelected(position, subItems));
        if (expandable.isExpanded() && subItemsCount > 0 && (!this.hasSubItemsSelected(position, subItems) || this.getPendingRemovedItem(item) != null)) {
            if (this.collapseSubLevels) {
                this.recursiveCollapse(position + 1, subItems, expandable.getExpansionLevel());
            }
            this.mItems.removeAll(subItems);
            subItemsCount = subItems.size();
            expandable.setExpanded(false);
            if (notifyParent) {
                this.notifyItemChanged(position, (Object)Payload.COLLAPSED);
            }
            this.notifyItemRangeRemoved(position + 1, subItemsCount);
            if (this.headersShown && !this.isHeader(item)) {
                for (IFlexible subItem : subItems) {
                    this.hideHeaderOf(subItem);
                }
            }
            if (!this.collapseSHF(this.mScrollableHeaders, expandable)) {
                this.collapseSHF(this.mScrollableFooters, expandable);
            }
            this.log.v("Collapsed %s subItems on position %s", subItemsCount, position);
        }
        return subItemsCount;
    }

    private boolean collapseSHF(List<T> scrollables, IExpandable expandable) {
        return scrollables.contains(expandable) && scrollables.removeAll(expandable.getSubItems());
    }

    private int recursiveCollapse(int startPosition, List<T> subItems, int level) {
        int collapsed = 0;
        for (int i = subItems.size() - 1; i >= 0; --i) {
            IExpandable expandable;
            IFlexible subItem = (IFlexible)subItems.get(i);
            if (!this.isExpanded(subItem) || (expandable = (IExpandable)subItem).getExpansionLevel() < level || this.collapse(startPosition + i, true) <= 0) continue;
            ++collapsed;
        }
        return collapsed;
    }

    public int collapseAll() {
        return this.collapseAll(this.mMinCollapsibleLevel);
    }

    public int collapseAll(int level) {
        return this.recursiveCollapse(0, this.mItems, level);
    }

    public void updateItem(@NonNull T item) {
        this.updateItem(item, null);
    }

    public void updateItem(@NonNull T item, @Nullable Object payload) {
        this.updateItem(this.getGlobalPositionOf((IFlexible)item), item, payload);
    }

    public void updateItem(@IntRange(from=0L) int position, @NonNull T item, @Nullable Object payload) {
        if (item == null) {
            this.log.e("updateItem No Item to update!", new Object[0]);
            return;
        }
        int itemCount = this.getItemCount();
        if (position < 0 || position >= itemCount) {
            this.log.e("Cannot updateItem on position out of OutOfBounds!", new Object[0]);
            return;
        }
        this.mItems.set(position, item);
        this.log.d("updateItem notifyItemChanged on position " + position, new Object[0]);
        this.notifyItemChanged(position, payload);
    }

    public void addItemWithDelay(final @IntRange(from=0L) int position, @NonNull T item, @IntRange(from=0L) long delay, boolean scrollToPosition) {
        this.mHandler.postDelayed(new Runnable((IFlexible)item, scrollToPosition){
            final /* synthetic */ IFlexible val$item;
            final /* synthetic */ boolean val$scrollToPosition;
            {
                this.val$item = iFlexible;
                this.val$scrollToPosition = bl;
            }

            @Override
            public void run() {
                if (FlexibleAdapter.this.addItem(position, this.val$item) && this.val$scrollToPosition) {
                    FlexibleAdapter.this.performScroll(position);
                }
            }
        }, delay);
    }

    public boolean addItem(@NonNull T item) {
        return this.addItem(this.getItemCount(), item);
    }

    public boolean addItem(@IntRange(from=0L) int position, @NonNull T item) {
        if (item == null) {
            this.log.e("addItem No item to add!", new Object[0]);
            return false;
        }
        this.log.v("addItem delegates addition to addItems!", new Object[0]);
        return this.addItems(position, Collections.singletonList(item));
    }

    public boolean addItems(@IntRange(from=0L) int position, @NonNull List<T> items) {
        if (items == null || items.isEmpty()) {
            this.log.e("addItems No items to add!", new Object[0]);
            return false;
        }
        int initialCount = this.getMainItemCount();
        if (position < 0) {
            this.log.w("addItems Position is negative! adding items to the end", new Object[0]);
            position = initialCount + this.mScrollableHeaders.size();
        }
        this.performInsert(position, items, true);
        this.showOrUpdateHeaders(items);
        if (!this.recursive && this.mUpdateListener != null && !this.multiRange && initialCount == 0 && this.getItemCount() > 0) {
            this.mUpdateListener.onUpdateEmptyView(this.getMainItemCount());
        }
        return true;
    }

    private void performInsert(int position, List<T> items, boolean notify) {
        int itemCount = this.getItemCount();
        if (position < itemCount) {
            this.mItems.addAll(position, items);
        } else {
            this.mItems.addAll(items);
            position = itemCount;
        }
        if (notify) {
            this.log.d("addItems on position=%s itemCount=%s", position, items.size());
            this.notifyItemRangeInserted(position, items.size());
        }
    }

    private void showOrUpdateHeaders(List<T> items) {
        if (this.headersShown && !this.recursive) {
            this.recursive = true;
            HashSet<IHeader> headersInserted = new HashSet<IHeader>();
            HashSet<IHeader> headersToUpdate = new HashSet<IHeader>();
            for (IFlexible item : items) {
                IHeader header = this.getHeaderOf(item);
                if (header == null) continue;
                if (this.showHeaderOf(this.getGlobalPositionOf(item), item, false)) {
                    headersInserted.add(header);
                    continue;
                }
                headersToUpdate.add(header);
            }
            headersToUpdate.removeAll(headersInserted);
            for (IHeader header : headersToUpdate) {
                this.notifyItemChanged(this.getGlobalPositionOf(header), (Object)Payload.CHANGE);
            }
            this.recursive = false;
        }
    }

    public boolean addSubItem(@IntRange(from=0L) int parentPosition, @IntRange(from=0L) int subPosition, @NonNull T item) {
        return this.addSubItem(parentPosition, subPosition, item, false, (Object)Payload.CHANGE);
    }

    public boolean addSubItem(@IntRange(from=0L) int parentPosition, @IntRange(from=0L) int subPosition, @NonNull T item, boolean expandParent, @Nullable Object payload) {
        if (item == null) {
            this.log.e("addSubItem No items to add!", new Object[0]);
            return false;
        }
        return this.addSubItems(parentPosition, subPosition, Collections.singletonList(item), expandParent, payload);
    }

    public boolean addSubItems(@IntRange(from=0L) int parentPosition, @IntRange(from=0L) int subPosition, @NonNull List<T> items) {
        return this.addSubItems(parentPosition, subPosition, items, false, (Object)Payload.CHANGE);
    }

    public boolean addSubItems(@IntRange(from=0L) int parentPosition, @IntRange(from=0L) int subPosition, @NonNull List<T> items, boolean expandParent, @Nullable Object payload) {
        T parent = this.getItem(parentPosition);
        if (this.isExpandable(parent)) {
            IExpandable expandable = (IExpandable)parent;
            return this.addSubItems(parentPosition, subPosition, expandable, items, expandParent, payload);
        }
        this.log.e("addSubItems Provided parentPosition doesn't belong to an Expandable item!", new Object[0]);
        return false;
    }

    private boolean addSubItems(@IntRange(from=0L) int parentPosition, @IntRange(from=0L) int subPosition, @NonNull IExpandable parent, @NonNull List<T> subItems, boolean expandParent, @Nullable Object payload) {
        boolean added = false;
        if (expandParent && !parent.isExpanded()) {
            this.expand(parentPosition);
        }
        if (parent.isExpanded()) {
            added = this.addItems(parentPosition + 1 + this.getRecursiveSubItemCount(parent, subPosition), subItems);
        }
        if (payload != null && !this.isHeader(parent)) {
            this.notifyItemChanged(parentPosition, payload);
        }
        return added;
    }

    public int addSection(@NonNull IHeader header) {
        return this.addSection(header, null);
    }

    public int addSection(@NonNull IHeader header, @Nullable Comparator<IFlexible> comparator) {
        int position = this.calculatePositionFor(header, comparator);
        this.addItem(position, header);
        return position;
    }

    public int addItemToSection(@NonNull ISectionable sectionable, @Nullable IHeader header, @Nullable Comparator<IFlexible> comparator) {
        int index;
        if (header != null && !header.isHidden()) {
            List<ISectionable> sectionItems = this.getSectionItems(header);
            sectionItems.add(sectionable);
            Collections.sort(sectionItems, comparator);
            index = sectionItems.indexOf(sectionable);
        } else {
            index = this.calculatePositionFor(sectionable, comparator);
        }
        return this.addItemToSection(sectionable, header, index);
    }

    public int addItemToSection(@NonNull ISectionable sectionable, @Nullable IHeader header, @IntRange(from=0L) int index) {
        this.log.d("addItemToSection relativePosition=%s", index);
        int headerPosition = this.getGlobalPositionOf(header);
        if (index >= 0) {
            sectionable.setHeader(header);
            if (headerPosition >= 0 && this.isExpandable(header)) {
                this.addSubItem(headerPosition, index, sectionable, false, (Object)Payload.ADD_SUB_ITEM);
            } else {
                this.addItem(headerPosition + 1 + index, sectionable);
            }
        }
        return this.getGlobalPositionOf(sectionable);
    }

    public void clear() {
        this.log.d("clearAll views", new Object[0]);
        this.removeAllScrollableHeaders();
        this.removeAllScrollableFooters();
        this.removeRange(0, this.getItemCount(), null);
    }

    public void clearAllBut(Integer ... viewTypes) {
        List<Integer> viewTypeList = Arrays.asList(viewTypes);
        this.log.d("clearAll retaining views %s", viewTypeList);
        ArrayList<Integer> positionsToRemove = new ArrayList<Integer>();
        int startPosition = Math.max(0, this.mScrollableHeaders.size());
        int endPosition = this.getItemCount() - this.mScrollableFooters.size();
        for (int i = startPosition; i < endPosition; ++i) {
            if (viewTypeList.contains(this.getItemViewType(i))) continue;
            positionsToRemove.add(i);
        }
        this.removeItems(positionsToRemove);
    }

    public void removeItemWithDelay(@NonNull T item, @IntRange(from=0L) long delay, boolean permanent) {
        this.mHandler.postDelayed(new Runnable((IFlexible)item, permanent){
            final /* synthetic */ IFlexible val$item;
            final /* synthetic */ boolean val$permanent;
            {
                this.val$item = iFlexible;
                this.val$permanent = bl;
            }

            @Override
            public void run() {
                FlexibleAdapter.this.performRemove(this.val$item, this.val$permanent);
            }
        }, delay);
    }

    private void performRemove(T item, boolean permanent) {
        boolean tempPermanent = this.permanentDelete;
        if (permanent) {
            this.permanentDelete = true;
        }
        this.removeItem(this.getGlobalPositionOf((IFlexible)item));
        this.permanentDelete = tempPermanent;
    }

    public void removeItem(@IntRange(from=0L) int position) {
        this.removeItem(position, (Object)Payload.CHANGE);
    }

    public void removeItem(@IntRange(from=0L) int position, @Nullable Object payload) {
        this.collapse(position);
        this.log.v("removeItem delegates removal to removeRange", new Object[0]);
        this.removeRange(position, 1, payload);
    }

    public void removeItems(@NonNull List<Integer> selectedPositions) {
        this.removeItems(selectedPositions, (Object)Payload.REM_SUB_ITEM);
    }

    public void removeItems(@Nullable List<Integer> selectedPositions, @Nullable Object payload) {
        this.log.v("removeItems selectedPositions=%s payload=%s", selectedPositions, payload);
        if (selectedPositions == null || selectedPositions.isEmpty()) {
            return;
        }
        if (selectedPositions.size() > 1) {
            Collections.sort(selectedPositions, new Comparator<Integer>(){

                @Override
                public int compare(Integer lhs, Integer rhs) {
                    return rhs - lhs;
                }
            });
            this.log.v("removeItems after reverse sort selectedPositions=%s", selectedPositions);
        }
        int positionStart = 0;
        int itemCount = 0;
        int lastPosition = selectedPositions.get(0);
        this.multiRange = true;
        for (Integer position : selectedPositions) {
            if (lastPosition - itemCount == position) {
                ++itemCount;
                positionStart = position;
            } else {
                if (itemCount > 0) {
                    this.removeRange(positionStart, itemCount, payload);
                }
                positionStart = lastPosition = position.intValue();
                itemCount = 1;
            }
            this.collapse(position);
        }
        this.multiRange = false;
        if (itemCount > 0) {
            this.removeRange(positionStart, itemCount, payload);
        }
    }

    public void removeItemsOfType(Integer ... viewTypes) {
        int endPosition;
        List<Integer> viewTypeList = Arrays.asList(viewTypes);
        ArrayList<Integer> itemsToRemove = new ArrayList<Integer>();
        int startPosition = Math.max(0, this.mScrollableHeaders.size() - 1);
        for (int i = endPosition = this.getItemCount() - this.mScrollableFooters.size() - 1; i >= startPosition; --i) {
            if (!viewTypeList.contains(this.getItemViewType(i))) continue;
            itemsToRemove.add(i);
        }
        this.removeItems(itemsToRemove);
    }

    public void removeRange(@IntRange(from=0L) int positionStart, @IntRange(from=0L) int itemCount) {
        this.removeRange(positionStart, itemCount, (Object)Payload.REM_SUB_ITEM);
    }

    public void removeRange(@IntRange(from=0L) int positionStart, @IntRange(from=0L) int itemCount, @Nullable Object payload) {
        int parentPosition;
        int initialCount = this.getItemCount();
        this.log.d("removeRange positionStart=%s itemCount=%s", positionStart, itemCount);
        if (positionStart < 0 || positionStart + itemCount > initialCount) {
            this.log.e("Cannot removeRange with positionStart OutOfBounds!", new Object[0]);
            return;
        }
        if (itemCount == 0 || initialCount == 0) {
            this.log.w("removeRange Nothing to delete!", new Object[0]);
            return;
        }
        IFlexible item = null;
        IExpandable parent = null;
        for (int position = positionStart; position < positionStart + itemCount; ++position) {
            item = (IFlexible)this.getItem(positionStart);
            if (item == null) continue;
            if (!this.permanentDelete) {
                if (parent == null) {
                    parent = this.getExpandableOf(item);
                }
                if (parent == null) {
                    this.createRestoreItemInfo(positionStart, item);
                } else {
                    this.createRestoreSubItemInfo(parent, item);
                }
            }
            item.setHidden(true);
            if (this.unlinkOnRemoveHeader && this.isHeader(item)) {
                IHeader header = (IHeader)item;
                List<ISectionable> sectionableList = this.getSectionItems(header);
                for (ISectionable sectionable : sectionableList) {
                    sectionable.setHeader(null);
                    if (payload == null) continue;
                    this.notifyItemChanged(this.getGlobalPositionOf(sectionable), (Object)Payload.UNLINK);
                }
            }
            this.mItems.remove(positionStart);
            if (this.permanentDelete && this.mOriginalList != null) {
                this.mOriginalList.remove(item);
            }
            this.removeSelection(position);
        }
        this.notifyItemRangeRemoved(positionStart, itemCount);
        int headerPosition = this.getGlobalPositionOf(this.getHeaderOf(item));
        if (headerPosition >= 0) {
            this.notifyItemChanged(headerPosition, payload);
        }
        if ((parentPosition = this.getGlobalPositionOf(parent)) >= 0 && parentPosition != headerPosition) {
            this.notifyItemChanged(parentPosition, payload);
        }
        if (this.mUpdateListener != null && !this.multiRange && initialCount > 0 && this.getItemCount() == 0) {
            this.mUpdateListener.onUpdateEmptyView(this.getMainItemCount());
        }
    }

    public void removeAllSelectedItems() {
        this.removeAllSelectedItems(null);
    }

    public void removeAllSelectedItems(@Nullable Object payload) {
        this.removeItems(this.getSelectedPositions(), payload);
    }

    public boolean isPermanentDelete() {
        return this.permanentDelete;
    }

    public FlexibleAdapter<T> setPermanentDelete(boolean permanentDelete) {
        this.log.i("Set permanentDelete=%s", permanentDelete);
        this.permanentDelete = permanentDelete;
        return this;
    }

    public boolean isRestoreWithSelection() {
        return this.restoreSelection;
    }

    public FlexibleAdapter<T> setRestoreSelectionOnUndo(boolean restoreSelection) {
        this.log.i("Set restoreSelectionOnUndo=%s", restoreSelection);
        this.restoreSelection = restoreSelection;
        return this;
    }

    public void restoreDeletedItems() {
        this.multiRange = true;
        int initialCount = this.getItemCount();
        if (this.getSelectedItemCount() > 0) {
            this.clearSelection();
        }
        for (int i = this.mRestoreList.size() - 1; i >= 0; --i) {
            this.adjustSelected = false;
            RestoreInfo restoreInfo = this.mRestoreList.get(i);
            if (restoreInfo.relativePosition >= 0) {
                this.log.d("Restore SubItem %s", restoreInfo);
                this.addSubItem(restoreInfo.getRestorePosition(true), restoreInfo.relativePosition, restoreInfo.item, false, (Object)Payload.UNDO);
            } else {
                this.log.d("Restore Item %s", restoreInfo);
                this.addItem(restoreInfo.getRestorePosition(false), restoreInfo.item);
            }
            restoreInfo.item.setHidden(false);
            if (!this.unlinkOnRemoveHeader || !this.isHeader(restoreInfo.item)) continue;
            IHeader header = (IHeader)restoreInfo.item;
            List<ISectionable> items = this.getSectionItems(header);
            for (ISectionable sectionable : items) {
                this.linkHeaderTo(sectionable, header, (Object)Payload.LINK);
            }
        }
        if (this.restoreSelection && !this.mRestoreList.isEmpty()) {
            if (this.isExpandable(this.mRestoreList.get((int)0).item) || this.getExpandableOf(this.mRestoreList.get((int)0).item) == null) {
                this.parentSelected = true;
            } else {
                this.childSelected = true;
            }
            for (RestoreInfo restoreInfo : this.mRestoreList) {
                if (!restoreInfo.item.isSelectable()) continue;
                this.addSelection(this.getGlobalPositionOf((IFlexible)restoreInfo.item));
            }
            this.log.d("Selected positions after restore %s", this.getSelectedPositions());
        }
        this.multiRange = false;
        if (this.mUpdateListener != null && initialCount == 0 && this.getItemCount() > 0) {
            this.mUpdateListener.onUpdateEmptyView(this.getMainItemCount());
        }
        this.emptyBin();
    }

    public void confirmDeletion() {
        this.log.d("confirmDeletion!", new Object[0]);
        if (this.mOriginalList != null) {
            this.mOriginalList.removeAll(this.getDeletedItems());
        }
        this.emptyBin();
    }

    public synchronized void emptyBin() {
        this.log.d("emptyBin!", new Object[0]);
        this.mRestoreList.clear();
        this.mUndoPositions.clear();
    }

    public final synchronized boolean isRestoreInTime() {
        return this.mRestoreList != null && !this.mRestoreList.isEmpty();
    }

    @NonNull
    public List<T> getDeletedItems() {
        ArrayList deletedItems = new ArrayList();
        for (RestoreInfo restoreInfo : this.mRestoreList) {
            deletedItems.add(restoreInfo.item);
        }
        return deletedItems;
    }

    @NonNull
    public List<Integer> getUndoPositions() {
        return this.mUndoPositions;
    }

    public void saveUndoPositions(@NonNull List<Integer> undoPositions) {
        this.mUndoPositions.addAll(undoPositions);
    }

    public final IExpandable getExpandableOfDeletedChild(@NonNull T child) {
        for (RestoreInfo restoreInfo : this.mRestoreList) {
            if (!restoreInfo.item.equals(child) || !this.isExpandable(restoreInfo.refItem)) continue;
            return (IExpandable)restoreInfo.refItem;
        }
        return null;
    }

    @NonNull
    public final List<T> getDeletedChildren(IExpandable expandable) {
        ArrayList deletedChild = new ArrayList();
        for (RestoreInfo restoreInfo : this.mRestoreList) {
            if (restoreInfo.refItem == null || !restoreInfo.refItem.equals(expandable) || restoreInfo.relativePosition < 0) continue;
            deletedChild.add(restoreInfo.item);
        }
        return deletedChild;
    }

    @NonNull
    public final List<T> getCurrentChildren(@Nullable IExpandable expandable) {
        if (expandable == null || !this.hasSubItems(expandable)) {
            return new ArrayList();
        }
        ArrayList subItems = new ArrayList(expandable.getSubItems());
        if (!this.mRestoreList.isEmpty()) {
            subItems.removeAll(this.getDeletedChildren(expandable));
        }
        return subItems;
    }

    public boolean hasFilter() {
        if (this.mFilterEntity instanceof String) {
            return !this.getFilter(String.class).isEmpty();
        }
        return this.mFilterEntity != null;
    }

    public boolean hasNewFilter(Serializable constraint) {
        if (constraint instanceof String && this.mOldFilterEntity instanceof String) {
            return !((String)((Object)this.mOldFilterEntity)).equalsIgnoreCase((String)((Object)constraint));
        }
        return this.mOldFilterEntity == null || !this.mOldFilterEntity.equals(constraint);
    }

    public void setFilter(@Nullable Serializable filter) {
        if (filter instanceof String) {
            filter = ((String)filter).trim().toLowerCase(Locale.getDefault());
        }
        this.mFilterEntity = filter;
    }

    @Nullable
    public <F extends Serializable> F getFilter(Class<F> clazz) {
        return (F)((Serializable)clazz.cast(this.mFilterEntity));
    }

    public final FlexibleAdapter setNotifyChangeOfUnfilteredItems(boolean notifyChange) {
        this.log.i("Set notifyChangeOfUnfilteredItems=%s", notifyChange);
        this.notifyChangeOfUnfilteredItems = notifyChange;
        return this;
    }

    public final FlexibleAdapter setNotifyMoveOfFilteredItems(boolean notifyMove) {
        this.log.i("Set notifyMoveOfFilteredItems=%s", notifyMove);
        this.notifyMoveOfFilteredItems = notifyMove;
        return this;
    }

    public void filterItems() {
        if (this.mOriginalList == null) {
            this.mOriginalList = this.mItems;
        }
        this.filterItems(this.mOriginalList);
    }

    public void filterItems(@IntRange(from=0L) long delay) {
        if (this.mOriginalList == null) {
            this.mOriginalList = this.mItems;
        }
        this.filterItems(this.mOriginalList, delay);
    }

    public void filterItems(@NonNull List<T> unfilteredItems, @IntRange(from=0L) long delay) {
        this.mHandler.removeMessages(2);
        this.mHandler.sendMessageDelayed(Message.obtain((Handler)this.mHandler, (int)2, unfilteredItems), delay > 0L ? delay : 0L);
    }

    public void filterItems(@NonNull List<T> unfilteredItems) {
        this.mHandler.removeMessages(2);
        this.mHandler.sendMessage(Message.obtain((Handler)this.mHandler, (int)2, unfilteredItems));
    }

    private synchronized void filterItemsAsync(@NonNull List<T> unfilteredItems) {
        this.log.d("filterItems with filterEntity=\"%s\"", this.mFilterEntity);
        List<Object> filteredItems = new ArrayList();
        this.filtering = true;
        if (this.hasFilter() && this.hasNewFilter(this.mFilterEntity)) {
            for (IFlexible item : unfilteredItems) {
                if (this.mFilterAsyncTask != null && this.mFilterAsyncTask.isCancelled()) {
                    return;
                }
                this.filterObject((T)item, (List<T>)filteredItems);
            }
        } else if (this.hasNewFilter(this.mFilterEntity)) {
            filteredItems = unfilteredItems;
            this.resetFilterFlags(filteredItems);
            this.mExpandedFilterFlags = null;
            if (this.mOriginalList == null) {
                this.restoreScrollableHeadersAndFooters(filteredItems);
            }
            this.mOriginalList = null;
        }
        if (this.hasNewFilter(this.mFilterEntity)) {
            this.mOldFilterEntity = this.mFilterEntity;
            this.animateDiff(filteredItems, Payload.FILTER);
        }
        this.filtering = false;
    }

    public boolean isFiltering() {
        return this.filtering;
    }

    private boolean filterObject(T item, List<T> values) {
        if (this.mFilterAsyncTask != null && this.mFilterAsyncTask.isCancelled()) {
            return false;
        }
        if (this.mOriginalList != null && (this.isScrollableHeaderOrFooter(item) || values.contains(item))) {
            return false;
        }
        ArrayList<T> filteredItems = new ArrayList<T>();
        filteredItems.add(item);
        boolean filtered = this.filterExpandableObject(item, filteredItems);
        if (!filtered) {
            filtered = this.filterObject(item, this.getFilter(Serializable.class));
        }
        if (filtered) {
            IHeader header = this.getHeaderOf(item);
            if (this.headersShown && this.hasHeader(item) && !values.contains(header)) {
                header.setHidden(false);
                values.add(header);
            }
            values.addAll(filteredItems);
        }
        item.setHidden(!filtered);
        return filtered;
    }

    private boolean filterExpandableObject(T item, List<T> filteredItems) {
        boolean filtered = false;
        if (this.isExpandable(item)) {
            IExpandable expandable = (IExpandable)item;
            if (expandable.isExpanded()) {
                if (this.mExpandedFilterFlags == null) {
                    this.mExpandedFilterFlags = new HashSet<IExpandable>();
                }
                this.mExpandedFilterFlags.add(expandable);
            }
            for (IFlexible subItem : this.getCurrentChildren(expandable)) {
                if (subItem instanceof IExpandable && this.filterObject(subItem, filteredItems)) {
                    filtered = true;
                    continue;
                }
                subItem.setHidden(!this.filterObject(subItem, this.getFilter(Serializable.class)));
                if (subItem.isHidden()) continue;
                filtered = true;
                filteredItems.add(subItem);
            }
            expandable.setExpanded(filtered);
        }
        return filtered;
    }

    protected boolean filterObject(T item, Serializable constraint) {
        return item instanceof IFilterable && ((IFilterable)item).filter(constraint);
    }

    private void resetFilterFlags(List<T> items) {
        if (items == null) {
            return;
        }
        IHeader sameHeader = null;
        for (int i = 0; i < items.size(); ++i) {
            IHeader header;
            IFlexible item = (IFlexible)items.get(i);
            item.setHidden(false);
            if (this.isExpandable(item)) {
                IExpandable expandable = (IExpandable)item;
                if (this.mExpandedFilterFlags != null) {
                    expandable.setExpanded(this.mExpandedFilterFlags.contains(expandable));
                }
                if (this.hasSubItems(expandable)) {
                    List subItems = expandable.getSubItems();
                    for (IFlexible subItem : subItems) {
                        subItem.setHidden(false);
                        if (!(subItem instanceof IExpandable)) continue;
                        IExpandable subExpandable = (IExpandable)subItem;
                        subExpandable.setExpanded(false);
                        this.resetFilterFlags(subExpandable.getSubItems());
                    }
                    if (expandable.isExpanded() && this.mOriginalList == null) {
                        if (i < items.size()) {
                            items.addAll(i + 1, subItems);
                        } else {
                            items.addAll(subItems);
                        }
                        i += subItems.size();
                    }
                }
            }
            if (!this.headersShown || this.mOriginalList != null || (header = this.getHeaderOf(item)) == null || header.equals(sameHeader) || this.isExpandable(header)) continue;
            header.setHidden(false);
            sameHeader = header;
            items.add(i, header);
            ++i;
        }
    }

    public FlexibleAdapter<T> setAnimateToLimit(int limit) {
        this.log.i("Set animateToLimit=%s", limit);
        this.mAnimateToLimit = limit;
        return this;
    }

    public boolean isAnimateChangesWithDiffUtil() {
        return this.useDiffUtil;
    }

    public FlexibleAdapter setAnimateChangesWithDiffUtil(boolean useDiffUtil) {
        this.useDiffUtil = useDiffUtil;
        return this;
    }

    public FlexibleAdapter setDiffUtilCallback(DiffUtilCallback diffUtilCallback) {
        this.diffUtilCallback = diffUtilCallback;
        return this;
    }

    private synchronized void animateDiff(@Nullable List<T> newItems, Payload payloadChange) {
        if (this.useDiffUtil) {
            Log.v((String)TAG, (String)("Animate changes with DiffUtils! oldSize=" + this.getItemCount() + " newSize=" + newItems.size()));
            if (this.diffUtilCallback == null) {
                this.diffUtilCallback = new DiffUtilCallback();
            }
            this.diffUtilCallback.setItems(this.mItems, newItems);
            this.diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)this.diffUtilCallback, (boolean)this.notifyMoveOfFilteredItems);
        } else {
            this.animateTo(newItems, payloadChange);
        }
    }

    private synchronized void animateTo(@Nullable List<T> newItems, Payload payloadChange) {
        this.mNotifications = new ArrayList<Notification>();
        if (newItems != null && newItems.size() <= this.mAnimateToLimit) {
            this.log.d("Animate changes! oldSize=%s newSize=%s limit=%s", this.getItemCount(), newItems.size(), this.mAnimateToLimit);
            this.mTempItems = new ArrayList<T>(this.mItems);
            this.applyAndAnimateRemovals(this.mTempItems, newItems);
            this.applyAndAnimateAdditions(this.mTempItems, newItems);
            if (this.notifyMoveOfFilteredItems) {
                this.applyAndAnimateMovedItems(this.mTempItems, newItems);
            }
        } else {
            this.log.d("NotifyDataSetChanged! oldSize=%s newSize=%s limit=%s", this.getItemCount(), newItems != null ? Integer.valueOf(newItems.size()) : "0", this.mAnimateToLimit);
            this.mTempItems = newItems;
            this.mNotifications.add(new Notification(-1, 0));
        }
        if (this.mFilterAsyncTask == null) {
            this.executeNotifications(payloadChange);
        }
    }

    @Nullable
    private Map<T, Integer> applyModifications(List<T> from, List<T> newItems) {
        if (this.notifyChangeOfUnfilteredItems) {
            this.mHashItems = new HashSet<T>(from);
            HashMap<IFlexible, Integer> unfilteredItems = new HashMap<IFlexible, Integer>();
            for (int i = 0; !(i >= newItems.size() || this.mFilterAsyncTask != null && this.mFilterAsyncTask.isCancelled()); ++i) {
                IFlexible item = (IFlexible)newItems.get(i);
                if (!this.mHashItems.contains(item)) continue;
                unfilteredItems.put(item, i);
            }
            return unfilteredItems;
        }
        return null;
    }

    private void applyAndAnimateRemovals(List<T> from, List<T> newItems) {
        Map<T, Integer> unfilteredItems = this.applyModifications(from, newItems);
        this.mHashItems = new HashSet<T>(newItems);
        int out = 0;
        int mod = 0;
        for (int i = from.size() - 1; i >= 0; --i) {
            if (this.mFilterAsyncTask != null && this.mFilterAsyncTask.isCancelled()) {
                return;
            }
            IFlexible item = (IFlexible)from.get(i);
            if (!this.mHashItems.contains(item)) {
                this.log.v("calculateRemovals remove position=%s item=%s", i, item);
                from.remove(i);
                this.mNotifications.add(new Notification(i, 3));
                ++out;
                continue;
            }
            if (!this.notifyChangeOfUnfilteredItems) continue;
            assert (unfilteredItems != null);
            IFlexible newItem = (IFlexible)newItems.get(unfilteredItems.get(item));
            if (!this.isFiltering() && !item.shouldNotifyChange(newItem)) continue;
            from.set(i, newItem);
            this.mNotifications.add(new Notification(i, 2));
            ++mod;
        }
        this.mHashItems = null;
        this.log.d("calculateModifications total mod=%s", mod);
        this.log.d("calculateRemovals total out=%s", out);
    }

    private void applyAndAnimateAdditions(List<T> from, List<T> newItems) {
        this.mHashItems = new HashSet<T>(from);
        int in = 0;
        for (int position = 0; position < newItems.size(); ++position) {
            if (this.mFilterAsyncTask != null && this.mFilterAsyncTask.isCancelled()) {
                return;
            }
            IFlexible item = (IFlexible)newItems.get(position);
            if (this.mHashItems.contains(item)) continue;
            this.log.v("calculateAdditions add position=%s item=%s", position, item);
            if (this.notifyMoveOfFilteredItems) {
                from.add(item);
                this.mNotifications.add(new Notification(from.size(), 1));
            } else {
                if (position < from.size()) {
                    from.add(position, item);
                } else {
                    from.add(item);
                }
                this.mNotifications.add(new Notification(position, 1));
            }
            ++in;
        }
        this.mHashItems = null;
        this.log.d("calculateAdditions total new=%s", in);
    }

    private void applyAndAnimateMovedItems(List<T> from, List<T> newItems) {
        int move = 0;
        for (int toPosition = newItems.size() - 1; toPosition >= 0; --toPosition) {
            if (this.mFilterAsyncTask != null && this.mFilterAsyncTask.isCancelled()) {
                return;
            }
            IFlexible item = (IFlexible)newItems.get(toPosition);
            int fromPosition = from.indexOf(item);
            if (fromPosition < 0 || fromPosition == toPosition) continue;
            this.log.v("calculateMovedItems fromPosition=%s toPosition=%s", fromPosition, toPosition);
            IFlexible movedItem = (IFlexible)from.remove(fromPosition);
            if (toPosition < from.size()) {
                from.add(toPosition, movedItem);
            } else {
                from.add(movedItem);
            }
            this.mNotifications.add(new Notification(fromPosition, toPosition, 4));
            ++move;
        }
        this.log.d("calculateMovedItems total move=%s", move);
    }

    private synchronized void executeNotifications(Payload payloadChange) {
        if (this.diffResult != null) {
            Log.i((String)TAG, (String)"Dispatching notifications");
            this.mItems = this.diffUtilCallback.getNewItems();
            this.diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this);
            this.diffResult = null;
        } else {
            this.log.i("Performing %s notifications", this.mNotifications.size());
            this.mItems = this.mTempItems;
            this.setScrollAnimate(false);
            block6: for (Notification notification : this.mNotifications) {
                switch (notification.operation) {
                    case 1: {
                        this.notifyItemInserted(notification.position);
                        continue block6;
                    }
                    case 2: {
                        this.notifyItemChanged(notification.position, (Object)payloadChange);
                        continue block6;
                    }
                    case 3: {
                        this.notifyItemRemoved(notification.position);
                        continue block6;
                    }
                    case 4: {
                        this.notifyItemMoved(notification.fromPosition, notification.position);
                        continue block6;
                    }
                }
                this.log.w("notifyDataSetChanged!", new Object[0]);
                this.notifyDataSetChanged();
            }
            this.mTempItems = null;
            this.mNotifications = null;
            this.setScrollAnimate(true);
        }
        this.time = System.currentTimeMillis() - this.start;
        this.log.i("Animate changes DONE in %sms", this.time);
    }

    public long getTime() {
        return this.time;
    }

    private void initializeItemTouchHelper() {
        if (this.mItemTouchHelper == null) {
            if (this.mRecyclerView == null) {
                throw new IllegalStateException("RecyclerView cannot be null. Enabling LongPressDrag or Swipe must be done after the Adapter is added to the RecyclerView.");
            }
            if (this.mItemTouchHelperCallback == null) {
                this.mItemTouchHelperCallback = new ItemTouchHelperCallback(this);
                this.log.i("Initialized default ItemTouchHelperCallback", new Object[0]);
            }
            this.mItemTouchHelper = new ItemTouchHelper((ItemTouchHelper.Callback)this.mItemTouchHelperCallback);
            this.mItemTouchHelper.attachToRecyclerView(this.mRecyclerView);
        }
    }

    public final ItemTouchHelper getItemTouchHelper() {
        this.initializeItemTouchHelper();
        return this.mItemTouchHelper;
    }

    public final ItemTouchHelperCallback getItemTouchHelperCallback() {
        this.initializeItemTouchHelper();
        return this.mItemTouchHelperCallback;
    }

    public final FlexibleAdapter setItemTouchHelperCallback(ItemTouchHelperCallback itemTouchHelperCallback) {
        this.mItemTouchHelperCallback = itemTouchHelperCallback;
        this.mItemTouchHelper = null;
        this.initializeItemTouchHelper();
        this.log.i("Initialized custom ItemTouchHelperCallback", new Object[0]);
        return this;
    }

    public final boolean isLongPressDragEnabled() {
        return this.mItemTouchHelperCallback != null && this.mItemTouchHelperCallback.isLongPressDragEnabled();
    }

    public final FlexibleAdapter setLongPressDragEnabled(boolean longPressDragEnabled) {
        this.initializeItemTouchHelper();
        this.log.i("Set longPressDragEnabled=%s", longPressDragEnabled);
        this.mItemTouchHelperCallback.setLongPressDragEnabled(longPressDragEnabled);
        return this;
    }

    public final boolean isHandleDragEnabled() {
        return this.mItemTouchHelperCallback != null && this.mItemTouchHelperCallback.isHandleDragEnabled();
    }

    public final FlexibleAdapter setHandleDragEnabled(boolean handleDragEnabled) {
        this.initializeItemTouchHelper();
        this.log.i("Set handleDragEnabled=%s", handleDragEnabled);
        this.mItemTouchHelperCallback.setHandleDragEnabled(handleDragEnabled);
        return this;
    }

    public final boolean isSwipeEnabled() {
        return this.mItemTouchHelperCallback != null && this.mItemTouchHelperCallback.isItemViewSwipeEnabled();
    }

    public final FlexibleAdapter setSwipeEnabled(boolean swipeEnabled) {
        this.log.i("Set swipeEnabled=%s", swipeEnabled);
        this.initializeItemTouchHelper();
        this.mItemTouchHelperCallback.setSwipeEnabled(swipeEnabled);
        return this;
    }

    public void moveItem(int fromPosition, int toPosition) {
        this.moveItem(fromPosition, toPosition, (Object)Payload.MOVE);
    }

    public void moveItem(int fromPosition, int toPosition, @Nullable Object payload) {
        T item;
        boolean expanded;
        this.log.v("moveItem fromPosition=%s toPosition=%s", fromPosition, toPosition);
        if (this.isSelected(fromPosition)) {
            this.removeSelection(fromPosition);
            this.addSelection(toPosition);
        }
        if (expanded = this.isExpanded(item = this.getItem(fromPosition))) {
            this.collapse(toPosition);
        }
        this.mItems.remove(fromPosition);
        this.performInsert(toPosition, Collections.singletonList(item), false);
        this.notifyItemMoved(fromPosition, toPosition);
        if (payload != null) {
            this.notifyItemChanged(toPosition, payload);
        }
        if (this.headersShown) {
            this.showHeaderOf(toPosition, item, false);
        }
        if (expanded) {
            this.expand(toPosition);
        }
    }

    public void swapItems(List<T> list, int fromPosition, int toPosition) {
        int i;
        if (fromPosition < 0 || fromPosition >= this.getItemCount() || toPosition < 0 || toPosition >= this.getItemCount()) {
            return;
        }
        this.log.v("swapItems from=%s [selected? %s] to=%s [selected? %s]", fromPosition, this.isSelected(fromPosition), toPosition, this.isSelected(toPosition));
        if (fromPosition < toPosition && this.isExpandable(this.getItem(fromPosition)) && this.isExpanded(toPosition)) {
            this.collapse(toPosition);
        }
        if (fromPosition < toPosition) {
            for (i = fromPosition; i < toPosition; ++i) {
                this.log.v("swapItems from=%s to=%s", i, i + 1);
                Collections.swap(list, i, i + 1);
                this.swapSelection(i, i + 1);
            }
        } else {
            for (i = fromPosition; i > toPosition; --i) {
                this.log.v("swapItems from=%s to=%s", i, i - 1);
                Collections.swap(list, i, i - 1);
                this.swapSelection(i, i - 1);
            }
        }
        this.notifyItemMoved(fromPosition, toPosition);
        if (this.headersShown) {
            T fromItem = this.getItem(toPosition);
            T toItem = this.getItem(fromPosition);
            if (toItem instanceof IHeader && fromItem instanceof IHeader) {
                if (fromPosition < toPosition) {
                    IHeader header = (IHeader)fromItem;
                    List<ISectionable> items = this.getSectionItems(header);
                    for (ISectionable sectionable : items) {
                        this.linkHeaderTo(sectionable, header, (Object)Payload.LINK);
                    }
                } else {
                    IHeader header = (IHeader)toItem;
                    List<ISectionable> items = this.getSectionItems(header);
                    for (ISectionable sectionable : items) {
                        this.linkHeaderTo(sectionable, header, (Object)Payload.LINK);
                    }
                }
            } else if (toItem instanceof IHeader) {
                int oldPosition = fromPosition < toPosition ? toPosition + 1 : toPosition;
                int newPosition = fromPosition < toPosition ? toPosition : fromPosition + 1;
                this.linkHeaderTo(this.getItem(oldPosition), this.getSectionHeader(oldPosition), (Object)Payload.LINK);
                this.linkHeaderTo(this.getItem(newPosition), (IHeader)toItem, (Object)Payload.LINK);
            } else if (fromItem instanceof IHeader) {
                int oldPosition = fromPosition < toPosition ? fromPosition : fromPosition + 1;
                int newPosition = fromPosition < toPosition ? toPosition + 1 : fromPosition;
                this.linkHeaderTo(this.getItem(oldPosition), this.getSectionHeader(oldPosition), (Object)Payload.LINK);
                this.linkHeaderTo(this.getItem(newPosition), (IHeader)fromItem, (Object)Payload.LINK);
            } else {
                int oldPosition = fromPosition < toPosition ? toPosition : fromPosition;
                int newPosition = fromPosition < toPosition ? fromPosition : toPosition;
                T oldItem = this.getItem(oldPosition);
                IHeader header = this.getHeaderOf(oldItem);
                if (header != null) {
                    IHeader oldHeader = this.getSectionHeader(oldPosition);
                    if (oldHeader != null && !oldHeader.equals(header)) {
                        this.linkHeaderTo(oldItem, oldHeader, (Object)Payload.LINK);
                    }
                    this.linkHeaderTo(this.getItem(newPosition), header, (Object)Payload.LINK);
                }
            }
        }
    }

    @Override
    public void onActionStateChanged(RecyclerView.ViewHolder viewHolder, int actionState) {
        if (this.mItemMoveListener != null) {
            this.mItemMoveListener.onActionStateChanged(viewHolder, actionState);
        } else if (this.mItemSwipeListener != null) {
            this.mItemSwipeListener.onActionStateChanged(viewHolder, actionState);
        }
    }

    @Override
    public boolean shouldMove(int fromPosition, int toPosition) {
        T toItem = this.getItem(toPosition);
        return !this.mScrollableHeaders.contains(toItem) && !this.mScrollableFooters.contains(toItem) && (this.mItemMoveListener == null || this.mItemMoveListener.shouldMoveItem(fromPosition, toPosition));
    }

    @Override
    @CallSuper
    public boolean onItemMove(int fromPosition, int toPosition) {
        this.swapItems(this.mItems, fromPosition, toPosition);
        if (this.mItemMoveListener != null) {
            this.mItemMoveListener.onItemMove(fromPosition, toPosition);
        }
        return true;
    }

    @Override
    @CallSuper
    public void onItemSwiped(int position, int direction) {
        if (this.mItemSwipeListener != null) {
            this.mItemSwipeListener.onItemSwipe(position, direction);
        }
    }

    private void mapViewTypeFrom(@NonNull T item) {
        if (!this.mTypeInstances.containsKey(item.getItemViewType())) {
            this.mTypeInstances.put(item.getItemViewType(), item);
            this.log.i("Mapped viewType %s from %s", item.getItemViewType(), LayoutUtils.getClassName(item));
        }
    }

    private T getViewTypeInstance(int viewType) {
        return (T)((IFlexible)this.mTypeInstances.get(viewType));
    }

    private RestoreInfo getPendingRemovedItem(T item) {
        for (RestoreInfo restoreInfo : this.mRestoreList) {
            if (!restoreInfo.item.equals(item) || restoreInfo.refPosition >= 0) continue;
            return restoreInfo;
        }
        return null;
    }

    private void createRestoreSubItemInfo(IExpandable expandable, T item) {
        List<T> siblings = this.getExpandableList(expandable, false);
        int childPosition = siblings.indexOf(item);
        this.mRestoreList.add(new RestoreInfo(this, (IFlexible)expandable, item, childPosition));
        this.log.v("Recycled SubItem %s with Parent position=%s", this.mRestoreList.get(this.mRestoreList.size() - 1), this.getGlobalPositionOf(expandable));
    }

    private void createRestoreItemInfo(int position, T item) {
        IExpandable expandable;
        Object refItem;
        if (this.isExpanded(item)) {
            this.collapse(position);
        }
        if ((refItem = this.getItem(position - 1)) != null && (expandable = this.getExpandableOf(refItem)) != null) {
            refItem = expandable;
        }
        this.mRestoreList.add(new RestoreInfo(this, refItem, item));
        this.log.v("Recycled Item %s on position=%s", this.mRestoreList.get(this.mRestoreList.size() - 1), position);
    }

    @NonNull
    private List<T> getExpandableList(IExpandable expandable, boolean isRecursive) {
        ArrayList<IFlexible<Object>> subItems = new ArrayList<IFlexible<Object>>();
        if (expandable != null && this.hasSubItems(expandable)) {
            List allSubItems = expandable.getSubItems();
            for (IFlexible subItem : allSubItems) {
                if (subItem.isHidden()) continue;
                subItems.add(subItem);
                if (!isRecursive || !this.isExpanded(subItem) || ((IExpandable)subItem).getSubItems().size() <= 0) continue;
                subItems.addAll(this.getExpandableList((IExpandable)subItem, true));
            }
        }
        return subItems;
    }

    private boolean hasSubItemsSelected(int startPosition, List<T> subItems) {
        for (IFlexible subItem : subItems) {
            if (!this.isSelected(++startPosition) && (!this.isExpanded(subItem) || !this.hasSubItemsSelected(startPosition, this.getExpandableList((IExpandable)subItem, false)))) continue;
            return true;
        }
        return false;
    }

    private void performScroll(int position) {
        if (this.mRecyclerView != null) {
            this.mRecyclerView.smoothScrollToPosition(Math.min(Math.max(0, position), this.getItemCount() - 1));
        }
    }

    private void autoScrollWithDelay(final int position, final int subItemsCount) {
        new Handler(Looper.getMainLooper(), new Handler.Callback(){

            public boolean handleMessage(Message message) {
                if (FlexibleAdapter.this.mRecyclerView == null) {
                    return false;
                }
                int firstVisibleItem = FlexibleAdapter.this.getFlexibleLayoutManager().findFirstCompletelyVisibleItemPosition();
                int lastVisibleItem = FlexibleAdapter.this.getFlexibleLayoutManager().findLastCompletelyVisibleItemPosition();
                int itemsToShow = position + subItemsCount - lastVisibleItem;
                if (itemsToShow > 0) {
                    int scrollMax = position - firstVisibleItem;
                    int scrollMin = Math.max(0, position + subItemsCount - lastVisibleItem);
                    int scrollBy = Math.min(scrollMax, scrollMin);
                    int spanCount = FlexibleAdapter.this.getFlexibleLayoutManager().getSpanCount();
                    if (spanCount > 1) {
                        scrollBy = scrollBy % spanCount + spanCount;
                    }
                    int scrollTo = firstVisibleItem + scrollBy;
                    FlexibleAdapter.this.performScroll(scrollTo);
                } else if (position < firstVisibleItem) {
                    FlexibleAdapter.this.performScroll(position);
                }
                return true;
            }
        }).sendMessageDelayed(Message.obtain((Handler)this.mHandler), 150L);
    }

    private void adjustSelected(int startPosition, int itemCount) {
        List<Integer> selectedPositions = this.getSelectedPositions();
        boolean adjusted = false;
        String diff = "";
        if (itemCount > 0) {
            Collections.sort(selectedPositions, new Comparator<Integer>(){

                @Override
                public int compare(Integer lhs, Integer rhs) {
                    return rhs - lhs;
                }
            });
            diff = "+";
        }
        for (Integer position : selectedPositions) {
            if (position < startPosition) continue;
            this.removeSelection(position);
            this.addAdjustedSelection(Math.max(position + itemCount, startPosition));
            adjusted = true;
        }
        if (adjusted) {
            this.log.v("AdjustedSelected(%s)=%s", diff + itemCount, this.getSelectedPositions());
        }
    }

    public final void invalidateItemDecorations(@IntRange(from=0L) long delay) {
        this.mRecyclerView.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (FlexibleAdapter.this.mRecyclerView != null) {
                    FlexibleAdapter.this.mRecyclerView.invalidateItemDecorations();
                }
            }
        }, delay);
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        if (outState != null) {
            if (this.mScrollableHeaders.size() > 0) {
                this.adjustSelected(0, -this.mScrollableHeaders.size());
            }
            super.onSaveInstanceState(outState);
            outState.putBoolean(EXTRA_CHILD, this.childSelected);
            outState.putBoolean(EXTRA_PARENT, this.parentSelected);
            outState.putInt(EXTRA_LEVEL, this.mSelectedLevel);
            outState.putSerializable(EXTRA_FILTER, this.mFilterEntity);
            outState.putBoolean(EXTRA_HEADERS, this.headersShown);
            outState.putBoolean(EXTRA_STICKY, this.areHeadersSticky());
        }
    }

    @Override
    public void onRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            boolean headersShown = savedInstanceState.getBoolean(EXTRA_HEADERS);
            if (!headersShown) {
                this.hideAllHeaders();
            } else if (!this.headersShown) {
                this.showAllHeadersWithReset(true);
            }
            this.headersShown = headersShown;
            if (savedInstanceState.getBoolean(EXTRA_STICKY) && !this.areHeadersSticky()) {
                this.setStickyHeaders(true);
            }
            super.onRestoreInstanceState(savedInstanceState);
            if (this.mScrollableHeaders.size() > 0) {
                this.adjustSelected(0, this.mScrollableHeaders.size());
            }
            this.parentSelected = savedInstanceState.getBoolean(EXTRA_PARENT);
            this.childSelected = savedInstanceState.getBoolean(EXTRA_CHILD);
            this.mSelectedLevel = savedInstanceState.getInt(EXTRA_LEVEL);
            this.mFilterEntity = savedInstanceState.getSerializable(EXTRA_FILTER);
        }
    }

    private void prepareItemsForUpdate(List<T> newItems) {
        this.restoreScrollableHeadersAndFooters(newItems);
        IHeader sameHeader = null;
        for (int position = 0; position < newItems.size(); ++position) {
            IHeader header;
            IFlexible item = (IFlexible)newItems.get(position);
            if (this.isExpanded(item)) {
                IExpandable expandable = (IExpandable)item;
                expandable.setExpanded(true);
                List<T> subItems = this.getExpandableList(expandable, false);
                int itemCount = newItems.size();
                if (position < itemCount) {
                    newItems.addAll(position + 1, subItems);
                } else {
                    newItems.addAll(subItems);
                }
            }
            if (!this.headersShown && this.isHeader(item) && !item.isHidden()) {
                this.headersShown = true;
            }
            if ((header = this.getHeaderOf(item)) == null || header.equals(sameHeader) || this.isExpandable(header)) continue;
            header.setHidden(false);
            sameHeader = header;
            newItems.add(position, header);
            ++position;
        }
    }

    @CallSuper
    protected void onPostUpdate() {
        if (this.mUpdateListener != null) {
            this.mUpdateListener.onUpdateEmptyView(this.getMainItemCount());
        }
    }

    @CallSuper
    protected void onPostFilter() {
        if (this.mFilterListener != null) {
            this.mFilterListener.onUpdateFilterView(this.getMainItemCount());
        }
    }

    public static class DiffUtilCallback<T extends IFlexible>
    extends DiffUtil.Callback {
        protected List<T> oldItems;
        protected List<T> newItems;

        public final void setItems(List<T> oldItems, List<T> newItems) {
            this.oldItems = oldItems;
            this.newItems = newItems;
        }

        public final List<T> getNewItems() {
            return this.newItems;
        }

        public final int getOldListSize() {
            return this.oldItems.size();
        }

        public final int getNewListSize() {
            return this.newItems.size();
        }

        public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
            IFlexible oldItem = (IFlexible)this.oldItems.get(oldItemPosition);
            IFlexible newItem = (IFlexible)this.newItems.get(newItemPosition);
            return oldItem.equals(newItem);
        }

        public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
            IFlexible newItem;
            IFlexible oldItem = (IFlexible)this.oldItems.get(oldItemPosition);
            return !oldItem.shouldNotifyChange(newItem = (IFlexible)this.newItems.get(newItemPosition));
        }

        @Nullable
        public Object getChangePayload(int oldItemPosition, int newItemPosition) {
            return Payload.CHANGE;
        }
    }

    public class HandlerCallback
    implements Handler.Callback {
        @CallSuper
        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 1: 
                case 2: {
                    if (FlexibleAdapter.this.mFilterAsyncTask != null) {
                        FlexibleAdapter.this.mFilterAsyncTask.cancel(true);
                    }
                    FlexibleAdapter.this.mFilterAsyncTask = new FilterAsyncTask(message.what, (List)message.obj);
                    FlexibleAdapter.this.mFilterAsyncTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
                    return true;
                }
                case 8: {
                    FlexibleAdapter.this.hideProgressItem();
                    return true;
                }
            }
            return false;
        }
    }

    private class FilterAsyncTask
    extends AsyncTask<Void, Void, Void> {
        private final List<T> newItems;
        private final int what;

        FilterAsyncTask(@Nullable int what, List<T> newItems) {
            this.what = what;
            this.newItems = newItems == null ? new ArrayList() : new ArrayList(newItems);
        }

        protected void onPreExecute() {
            if (FlexibleAdapter.this.endlessLoading) {
                FlexibleAdapter.this.log.w("Cannot filter while endlessLoading", new Object[0]);
                this.cancel(true);
            }
            if (FlexibleAdapter.this.isRestoreInTime()) {
                FlexibleAdapter.this.log.d("Removing all deleted items before filtering/updating", new Object[0]);
                this.newItems.removeAll(FlexibleAdapter.this.getDeletedItems());
                if (FlexibleAdapter.this.mDeleteCompleteListener != null) {
                    FlexibleAdapter.this.mDeleteCompleteListener.onDeleteConfirmed(3);
                }
            }
        }

        protected void onCancelled() {
            FlexibleAdapter.this.log.i("FilterAsyncTask cancelled!", new Object[0]);
        }

        protected Void doInBackground(Void ... params) {
            FlexibleAdapter.this.start = System.currentTimeMillis();
            switch (this.what) {
                case 1: {
                    FlexibleAdapter.this.log.d("doInBackground - started UPDATE", new Object[0]);
                    FlexibleAdapter.this.prepareItemsForUpdate(this.newItems);
                    FlexibleAdapter.this.animateDiff(this.newItems, Payload.CHANGE);
                    FlexibleAdapter.this.log.d("doInBackground - ended UPDATE", new Object[0]);
                    break;
                }
                case 2: {
                    FlexibleAdapter.this.log.d("doInBackground - started FILTER", new Object[0]);
                    FlexibleAdapter.this.filterItemsAsync(this.newItems);
                    FlexibleAdapter.this.log.d("doInBackground - ended FILTER", new Object[0]);
                }
            }
            return null;
        }

        protected void onPostExecute(Void result) {
            if (FlexibleAdapter.this.diffResult != null || FlexibleAdapter.this.mNotifications != null) {
                switch (this.what) {
                    case 1: {
                        FlexibleAdapter.this.executeNotifications(Payload.CHANGE);
                        FlexibleAdapter.this.onPostUpdate();
                        break;
                    }
                    case 2: {
                        FlexibleAdapter.this.executeNotifications(Payload.FILTER);
                        FlexibleAdapter.this.onPostFilter();
                    }
                }
            }
            FlexibleAdapter.this.mFilterAsyncTask = null;
        }
    }

    private static class Notification {
        public static final int ADD = 1;
        public static final int CHANGE = 2;
        public static final int REMOVE = 3;
        public static final int MOVE = 4;
        int fromPosition;
        int position;
        int operation;

        public Notification(int position, int operation) {
            this.position = position;
            this.operation = operation;
        }

        public Notification(int fromPosition, int toPosition, int operation) {
            this(toPosition, operation);
            this.fromPosition = fromPosition;
        }

        public String toString() {
            return "Notification{operation=" + this.operation + (this.operation == 4 ? ", fromPosition=" + this.fromPosition : "") + ", position=" + this.position + '}';
        }
    }

    private class RestoreInfo {
        int refPosition = -1;
        int relativePosition = -1;
        T refItem = null;
        T item = null;
        final /* synthetic */ FlexibleAdapter this$0;

        public RestoreInfo(T refItem, T item) {
            this(var1_1, (IFlexible)refItem, (IFlexible)item, -1);
        }

        /*
         * WARNING - Possible parameter corruption
         */
        public RestoreInfo(T refItem, T item, int relativePosition) {
            this.this$0 = (FlexibleAdapter)n;
            this.refItem = refItem;
            this.item = item;
            this.relativePosition = relativePosition;
        }

        public int getRestorePosition(boolean isChild) {
            if (this.refPosition < 0) {
                this.refPosition = this.this$0.getGlobalPositionOf((IFlexible)this.refItem);
            }
            Object item = this.this$0.getItem(this.refPosition);
            if (isChild && this.this$0.isExpandable(item)) {
                this.this$0.recursiveCollapse(this.refPosition, this.this$0.getCurrentChildren((IExpandable)item), 0);
            } else {
                this.refPosition = this.this$0.isExpanded(item) && !isChild ? (this.refPosition += this.this$0.getExpandableList((IExpandable)item, true).size() + 1) : ++this.refPosition;
            }
            return this.refPosition;
        }

        public String toString() {
            return "RestoreInfo[item=" + this.item + ", refItem=" + this.refItem + "]";
        }
    }

    private class AdapterDataObserver
    extends RecyclerView.AdapterDataObserver {
        private AdapterDataObserver() {
        }

        private void adjustPositions(int positionStart, int itemCount) {
            if (FlexibleAdapter.this.adjustSelected) {
                FlexibleAdapter.this.adjustSelected(positionStart, itemCount);
            }
            FlexibleAdapter.this.adjustSelected = true;
        }

        private void updateStickyHeader(int positionStart) {
            int stickyPosition = FlexibleAdapter.this.getStickyPosition();
            if (stickyPosition >= 0 && stickyPosition == positionStart) {
                FlexibleAdapter.this.log.d("updateStickyHeader position=%s", stickyPosition);
                FlexibleAdapter.this.mRecyclerView.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (FlexibleAdapter.this.areHeadersSticky()) {
                            FlexibleAdapter.this.mStickyHeaderHelper.updateOrClearHeader(true);
                        }
                    }
                }, 50L);
            }
        }

        public void onChanged() {
            this.updateStickyHeader(FlexibleAdapter.this.getStickyPosition());
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            this.adjustPositions(positionStart, itemCount);
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            this.adjustPositions(positionStart, -itemCount);
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            this.updateStickyHeader(positionStart);
        }
    }

    public static interface EndlessScrollListener {
        public void noMoreLoad(int var1);

        public void onLoadMore(int var1, int var2);
    }

    public static interface OnStickyHeaderChangeListener {
        public void onStickyHeaderChange(int var1, int var2);
    }

    public static interface OnItemSwipeListener
    extends OnActionStateListener {
        public void onItemSwipe(int var1, int var2);
    }

    public static interface OnItemMoveListener
    extends OnActionStateListener {
        public boolean shouldMoveItem(int var1, int var2);

        public void onItemMove(int var1, int var2);
    }

    public static interface OnActionStateListener {
        public void onActionStateChanged(RecyclerView.ViewHolder var1, int var2);
    }

    public static interface OnItemLongClickListener {
        public void onItemLongClick(int var1);
    }

    public static interface OnItemClickListener {
        public boolean onItemClick(View var1, int var2);
    }

    public static interface OnDeleteCompleteListener {
        public void onDeleteConfirmed(int var1);
    }

    public static interface OnFilterListener {
        public void onUpdateFilterView(int var1);
    }

    public static interface OnUpdateListener {
        public void onUpdateEmptyView(int var1);
    }
}

