/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.util.TypedValue;
import android.view.View;
import eu.davidea.flexibleadapter.R;
import eu.davidea.flexibleadapter.utils.Utils;
import java.util.Arrays;

public final class DrawableUtils {
    @SuppressLint(value={"NewApi"})
    public static void setBackground(View view, Drawable drawable2) {
        if (Utils.hasJellyBean()) {
            view.setBackground(drawable2);
        } else {
            view.setBackgroundDrawable(drawable2);
        }
    }

    public static void setBackground(View view, @DrawableRes int drawableRes) {
        DrawableUtils.setBackground(view, DrawableUtils.getDrawableCompat(view.getContext(), drawableRes));
    }

    public static Drawable getDrawableCompat(Context context, @DrawableRes int drawableRes) {
        try {
            if (Utils.hasLollipop()) {
                return context.getResources().getDrawable(drawableRes, context.getTheme());
            }
            return context.getResources().getDrawable(drawableRes);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static int getSelectableBackground(Context context) {
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.selectableItemBackground, outValue, true);
        return outValue.resourceId;
    }

    public static int getColorControlHighlight(Context context) {
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.colorControlHighlight, outValue, true);
        return outValue.resourceId;
    }

    public static Drawable getSelectableBackgroundCompat(@ColorInt int rippleColor, @ColorInt int normalColor, @ColorInt int pressedColor) {
        if (Utils.hasLollipop()) {
            return new RippleDrawable(ColorStateList.valueOf((int)rippleColor), (Drawable)DrawableUtils.getStateListDrawable(normalColor, pressedColor, true), DrawableUtils.getRippleMask(normalColor));
        }
        return DrawableUtils.getStateListDrawable(normalColor, pressedColor, false);
    }

    private static Drawable getRippleMask(@ColorInt int color) {
        float[] outerRadii = new float[8];
        Arrays.fill(outerRadii, 3.0f);
        RoundRectShape r = new RoundRectShape(outerRadii, null, null);
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)r);
        shapeDrawable.getPaint().setColor(color);
        return shapeDrawable;
    }

    private static StateListDrawable getStateListDrawable(@ColorInt int normalColor, @ColorInt int pressedColor, boolean withRipple) {
        StateListDrawable states = new StateListDrawable();
        if (!withRipple) {
            states.addState(new int[]{16842919}, (Drawable)DrawableUtils.getColorDrawable(pressedColor));
        }
        states.addState(new int[]{16843518}, (Drawable)DrawableUtils.getColorDrawable(pressedColor));
        states.addState(new int[0], (Drawable)DrawableUtils.getColorDrawable(normalColor));
        if (!withRipple) {
            int duration = 200;
            states.setEnterFadeDuration(duration);
            states.setExitFadeDuration(duration);
        }
        return states;
    }

    private static ColorDrawable getColorDrawable(@ColorInt int color) {
        return new ColorDrawable(color);
    }
}

