/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.common;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import eu.davidea.flexibleadapter.FlexibleAdapter;
import eu.davidea.flexibleadapter.items.ISectionable;

public class DividerItemDecoration
extends RecyclerView.ItemDecoration {
    private Drawable mDivider;
    private int mGapWidth;
    private boolean mDrawOver = false;
    private static final int[] ATTRS = new int[]{16843284};

    public DividerItemDecoration(Context context) {
        TypedArray styledAttributes = context.obtainStyledAttributes(ATTRS);
        this.mDivider = styledAttributes.getDrawable(0);
        styledAttributes.recycle();
    }

    public DividerItemDecoration(Context context, int resId) {
        this(context, resId, 0);
    }

    public DividerItemDecoration(@NonNull Context context, @DrawableRes int resId, @IntRange(from=0L) int gapWidth) {
        if (resId > 0) {
            this.mDivider = ContextCompat.getDrawable((Context)context, (int)resId);
        }
        this.setSectionGapWidth((int)(context.getResources().getDisplayMetrics().density * (float)gapWidth));
    }

    public DividerItemDecoration setDrawOver(boolean mDrawOver) {
        this.mDrawOver = mDrawOver;
        return this;
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        if (this.mDivider != null && !this.mDrawOver) {
            this.draw(c, parent, state);
        }
    }

    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        if (this.mDivider != null && this.mDrawOver) {
            this.draw(c, parent, state);
        }
    }

    private void draw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        int left = parent.getPaddingLeft();
        int right = parent.getWidth() - parent.getPaddingRight();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            int top = child.getBottom() + params.bottomMargin + Math.round(ViewCompat.getTranslationY((View)child));
            int bottom = top + this.mDivider.getIntrinsicHeight() + 1;
            this.mDivider.setBounds(left, top, right, bottom);
            this.mDivider.draw(c);
        }
    }

    public void setSectionGapWidth(@IntRange(from=0L) int gapWidth) {
        if (gapWidth < 0) {
            throw new IllegalArgumentException("Invalid section gap width [<0]: " + gapWidth);
        }
        this.mGapWidth = gapWidth;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        int position;
        FlexibleAdapter flexibleAdapter;
        if (this.mGapWidth > 0 && parent.getAdapter() instanceof FlexibleAdapter && (flexibleAdapter = (FlexibleAdapter)parent.getAdapter()).getItem(position = parent.getChildAdapterPosition(view)) instanceof ISectionable && (flexibleAdapter.isHeader(flexibleAdapter.getItem(position + 1)) || position >= parent.getAdapter().getItemCount() - 1)) {
            RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
            int orientation = layoutManager instanceof LinearLayoutManager ? ((LinearLayoutManager)layoutManager).getOrientation() : ((StaggeredGridLayoutManager)layoutManager).getOrientation();
            if (orientation == 1) {
                outRect.set(0, 0, 0, this.mGapWidth);
            } else {
                outRect.set(0, 0, this.mGapWidth, 0);
            }
        }
    }
}

