/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.common;

import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.ViewPropertyAnimatorListener;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SimpleItemAnimator;
import android.view.View;
import java.util.ArrayList;

public abstract class PendingItemAnimator<H extends RecyclerView.ViewHolder>
extends SimpleItemAnimator {
    private ArrayList<H> mPendingRemovals = new ArrayList();
    private ArrayList<H> mPendingAdditions = new ArrayList();
    private ArrayList<MoveInfo> mPendingMoves = new ArrayList();
    private ArrayList<H> mAdditions = new ArrayList();
    private ArrayList<MoveInfo> mMoves = new ArrayList();
    private ArrayList<H> mAddAnimations = new ArrayList();
    private ArrayList<RecyclerView.ViewHolder> mMoveAnimations = new ArrayList();
    private ArrayList<H> mRemoveAnimations = new ArrayList();

    public void runPendingAnimations() {
        boolean additionsPending;
        boolean removalsPending = !this.mPendingRemovals.isEmpty();
        boolean movesPending = !this.mPendingMoves.isEmpty();
        boolean bl = additionsPending = !this.mPendingAdditions.isEmpty();
        if (!(removalsPending || movesPending || additionsPending)) {
            return;
        }
        this.runRemoveAnimation();
        this.runMoveAnimation(removalsPending, movesPending);
        this.runAddAnimation(removalsPending, movesPending, additionsPending);
    }

    protected final void runRemoveAnimation() {
        for (final RecyclerView.ViewHolder holder : this.mPendingRemovals) {
            this.animateRemoveImpl(holder).setDuration(this.getRemoveDuration()).setListener((ViewPropertyAnimatorListener)new ItemAnimatorListener(){

                @Override
                public void onAnimationEnd(View view) {
                    PendingItemAnimator.this.animateRemoveEnded(holder);
                }

                @Override
                public void onAnimationCancel(View view) {
                    PendingItemAnimator.this.onRemoveCanceled(holder);
                }
            }).start();
            this.mRemoveAnimations.add(holder);
        }
        this.mPendingRemovals.clear();
    }

    protected final void runMoveAnimation(boolean removalsPending, boolean movesPending) {
        if (movesPending) {
            this.mMoves.addAll(this.mPendingMoves);
            this.mPendingMoves.clear();
            Runnable mover = new Runnable(){

                @Override
                public void run() {
                    for (final MoveInfo moveInfo : PendingItemAnimator.this.mMoves) {
                        PendingItemAnimator.this.animateMoveImpl(moveInfo.holder, moveInfo.fromX, moveInfo.fromY, moveInfo.toX, moveInfo.toY).setDuration(PendingItemAnimator.this.getMoveDuration()).setListener((ViewPropertyAnimatorListener)new ItemAnimatorListener(){

                            @Override
                            public void onAnimationEnd(View view) {
                                PendingItemAnimator.this.animateMoveEnded(moveInfo.holder);
                            }

                            @Override
                            public void onAnimationCancel(View view) {
                                PendingItemAnimator.this.onMoveCanceled(moveInfo.holder);
                            }
                        }).start();
                        PendingItemAnimator.this.mMoveAnimations.add(moveInfo.holder);
                    }
                    PendingItemAnimator.this.mMoves.clear();
                }
            };
            if (removalsPending) {
                View view = this.mMoves.get((int)0).holder.itemView;
                ViewCompat.postOnAnimationDelayed((View)view, (Runnable)mover, (long)this.getRemoveDuration());
            } else {
                mover.run();
            }
        }
    }

    private final void runAddAnimation(boolean removalsPending, boolean movesPending, boolean additionsPending) {
        if (additionsPending) {
            this.mAdditions.addAll(this.mPendingAdditions);
            this.mPendingAdditions.clear();
            Runnable adder = new Runnable(){

                @Override
                public void run() {
                    for (final RecyclerView.ViewHolder holder : PendingItemAnimator.this.mAdditions) {
                        PendingItemAnimator.this.animateAddImpl(holder).setDuration(PendingItemAnimator.this.getAddDuration()).setListener((ViewPropertyAnimatorListener)new ItemAnimatorListener(){

                            @Override
                            public void onAnimationEnd(View view) {
                                PendingItemAnimator.this.animateAddEnded(holder);
                            }

                            @Override
                            public void onAnimationCancel(View view) {
                                PendingItemAnimator.this.onAddCanceled(holder);
                            }
                        }).start();
                        PendingItemAnimator.this.mAddAnimations.add(holder);
                    }
                    PendingItemAnimator.this.mAdditions.clear();
                }
            };
            if (removalsPending || movesPending) {
                View view = ((RecyclerView.ViewHolder)this.mAdditions.get((int)0)).itemView;
                ViewCompat.postOnAnimationDelayed((View)view, (Runnable)adder, (long)((removalsPending ? this.getRemoveDuration() : 0L) + (movesPending ? this.getMoveDuration() : 0L)));
            } else {
                adder.run();
            }
        }
    }

    public boolean animateRemove(RecyclerView.ViewHolder holder) {
        this.mPendingRemovals.add(holder);
        return this.prepHolderForAnimateRemove(holder);
    }

    protected abstract boolean prepHolderForAnimateRemove(H var1);

    protected abstract ViewPropertyAnimatorCompat animateRemoveImpl(H var1);

    protected abstract void onRemoveCanceled(H var1);

    protected void animateRemoveEnded(H holder) {
        this.dispatchRemoveFinished((RecyclerView.ViewHolder)holder);
        this.mRemoveAnimations.remove(holder);
        this.dispatchFinishedWhenDone();
    }

    public boolean animateAdd(RecyclerView.ViewHolder holder) {
        this.mPendingAdditions.add(holder);
        return this.prepHolderForAnimateAdd(holder);
    }

    protected abstract boolean prepHolderForAnimateAdd(H var1);

    protected abstract ViewPropertyAnimatorCompat animateAddImpl(H var1);

    protected abstract void onAddCanceled(H var1);

    protected void animateAddEnded(H holder) {
        this.dispatchAddFinished((RecyclerView.ViewHolder)holder);
        this.mAddAnimations.remove(holder);
        this.dispatchFinishedWhenDone();
    }

    public boolean animateMove(RecyclerView.ViewHolder holder, int fromX, int fromY, int toX, int toY) {
        this.mPendingMoves.add(new MoveInfo(holder, fromX, fromY, toX, toY));
        return this.prepHolderForAnimateMove(holder, fromX, fromY, toX, toY);
    }

    public boolean animateChange(RecyclerView.ViewHolder oldHolder, RecyclerView.ViewHolder newHolder, int fromLeft, int fromTop, int toLeft, int toTop) {
        return false;
    }

    protected boolean prepHolderForAnimateMove(H holder, int fromX, int fromY, int toX, int toY) {
        View view = ((RecyclerView.ViewHolder)holder).itemView;
        int deltaX = toX - fromX;
        int deltaY = toY - fromY;
        if (deltaX == 0 && deltaY == 0) {
            this.dispatchMoveFinished((RecyclerView.ViewHolder)holder);
            return false;
        }
        if (deltaX != 0) {
            ViewCompat.setTranslationX((View)view, (float)(-deltaX));
        }
        if (deltaY != 0) {
            ViewCompat.setTranslationY((View)view, (float)(-deltaY));
        }
        return true;
    }

    protected ViewPropertyAnimatorCompat animateMoveImpl(RecyclerView.ViewHolder holder, int fromX, int fromY, int toX, int toY) {
        View view = holder.itemView;
        int deltaX = toX - fromX;
        int deltaY = toY - fromY;
        ViewCompat.animate((View)view).cancel();
        if (deltaX != 0) {
            ViewCompat.animate((View)view).translationX(0.0f);
        }
        if (deltaY != 0) {
            ViewCompat.animate((View)view).translationY(0.0f);
        }
        return ViewCompat.animate((View)view).setInterpolator(null).setDuration(this.getMoveDuration());
    }

    protected void onMoveCanceled(RecyclerView.ViewHolder holder) {
        ViewCompat.setTranslationX((View)holder.itemView, (float)0.0f);
        ViewCompat.setTranslationY((View)holder.itemView, (float)0.0f);
    }

    protected void animateMoveEnded(RecyclerView.ViewHolder holder) {
        this.dispatchMoveFinished(holder);
        this.mMoveAnimations.remove(holder);
        this.dispatchFinishedWhenDone();
    }

    public void endAnimation(RecyclerView.ViewHolder item) {
        View view = item.itemView;
        ViewCompat.animate((View)view).cancel();
        if (this.mPendingMoves.contains(item)) {
            ViewCompat.setTranslationY((View)view, (float)0.0f);
            ViewCompat.setTranslationX((View)view, (float)0.0f);
            this.dispatchMoveFinished(item);
            this.mPendingMoves.remove(item);
        }
        if (this.mPendingRemovals.contains(item)) {
            this.dispatchRemoveFinished(item);
            this.mPendingRemovals.remove(item);
        }
        if (this.mPendingAdditions.contains(item)) {
            this.dispatchAddFinished(item);
            this.mPendingAdditions.remove(item);
        }
        if (this.mMoveAnimations.contains(item)) {
            ViewCompat.setTranslationY((View)view, (float)0.0f);
            ViewCompat.setTranslationX((View)view, (float)0.0f);
            this.dispatchMoveFinished(item);
            this.mMoveAnimations.remove(item);
        }
        if (this.mRemoveAnimations.contains(item)) {
            this.dispatchRemoveFinished(item);
            this.mRemoveAnimations.remove(item);
        }
        if (this.mAddAnimations.contains(item)) {
            this.dispatchAddFinished(item);
            this.mAddAnimations.remove(item);
        }
        this.dispatchFinishedWhenDone();
    }

    public boolean isRunning() {
        return !this.mMoveAnimations.isEmpty() || !this.mRemoveAnimations.isEmpty() || !this.mAddAnimations.isEmpty() || !this.mMoves.isEmpty() || !this.mAdditions.isEmpty();
    }

    private void dispatchFinishedWhenDone() {
        if (!this.isRunning()) {
            this.dispatchAnimationsFinished();
        }
    }

    public void endAnimations() {
        View view;
        MoveInfo item;
        int i;
        int count = this.mPendingMoves.size();
        for (i = count - 1; i >= 0; --i) {
            item = this.mPendingMoves.get(i);
            view = item.holder.itemView;
            ViewCompat.animate((View)view).cancel();
            ViewCompat.setTranslationY((View)view, (float)0.0f);
            ViewCompat.setTranslationX((View)view, (float)0.0f);
            this.dispatchMoveFinished(item.holder);
            this.mPendingMoves.remove(item);
        }
        count = this.mPendingRemovals.size();
        for (i = count - 1; i >= 0; --i) {
            item = (RecyclerView.ViewHolder)this.mPendingRemovals.get(i);
            this.dispatchRemoveFinished((RecyclerView.ViewHolder)item);
            this.mPendingRemovals.remove(item);
        }
        count = this.mPendingAdditions.size();
        for (i = count - 1; i >= 0; --i) {
            item = (RecyclerView.ViewHolder)this.mPendingAdditions.get(i);
            this.dispatchAddFinished((RecyclerView.ViewHolder)item);
            this.mPendingAdditions.remove(item);
        }
        if (!this.isRunning()) {
            return;
        }
        count = this.mMoveAnimations.size();
        for (i = count - 1; i >= 0; --i) {
            item = this.mMoveAnimations.get(i);
            view = ((RecyclerView.ViewHolder)item).itemView;
            ViewCompat.animate((View)view).cancel();
            ViewCompat.setTranslationY((View)view, (float)0.0f);
            ViewCompat.setTranslationX((View)view, (float)0.0f);
            this.dispatchMoveFinished((RecyclerView.ViewHolder)item);
            this.mMoveAnimations.remove(item);
        }
        count = this.mRemoveAnimations.size();
        for (i = count - 1; i >= 0; --i) {
            item = (RecyclerView.ViewHolder)this.mRemoveAnimations.get(i);
            view = ((RecyclerView.ViewHolder)item).itemView;
            ViewCompat.animate((View)view).cancel();
            this.dispatchRemoveFinished((RecyclerView.ViewHolder)item);
            this.mRemoveAnimations.remove(item);
        }
        count = this.mAddAnimations.size();
        for (i = count - 1; i >= 0; --i) {
            item = (RecyclerView.ViewHolder)this.mAddAnimations.get(i);
            view = ((RecyclerView.ViewHolder)item).itemView;
            ViewCompat.animate((View)view).cancel();
            this.dispatchAddFinished((RecyclerView.ViewHolder)item);
            this.mAddAnimations.remove(item);
        }
        this.mMoves.clear();
        this.mAdditions.clear();
        this.dispatchAnimationsFinished();
    }

    protected static class ItemAnimatorListener
    implements ViewPropertyAnimatorListener {
        protected ItemAnimatorListener() {
        }

        public void onAnimationStart(View view) {
        }

        public void onAnimationEnd(View view) {
        }

        public void onAnimationCancel(View view) {
        }
    }

    private static class MoveInfo {
        public RecyclerView.ViewHolder holder;
        public int fromX;
        public int fromY;
        public int toX;
        public int toY;

        private MoveInfo(RecyclerView.ViewHolder holder, int fromX, int fromY, int toX, int toY) {
            this.holder = holder;
            this.fromX = fromX;
            this.fromY = fromY;
            this.toX = toX;
            this.toY = toY;
        }
    }
}

