/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.viewholders;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;
import android.util.TypedValue;

public class ViewHolderUIUtils {
    public static StateListDrawable getSelectableBackground(Context ctx, @ColorInt int selected_color, boolean animate) {
        StateListDrawable states = new StateListDrawable();
        ColorDrawable clrActive = new ColorDrawable(selected_color);
        states.addState(new int[]{16843518}, (Drawable)clrActive);
        states.addState(new int[0], ContextCompat.getDrawable((Context)ctx, (int)ViewHolderUIUtils.getSelectableBackground(ctx)));
        if (animate && Build.VERSION.SDK_INT >= 11) {
            int duration = ctx.getResources().getInteger(0x10E0000);
            states.setEnterFadeDuration(duration);
            states.setExitFadeDuration(duration);
        }
        return states;
    }

    public static StateListDrawable getSelectablePressedBackground(Context ctx, @ColorInt int selected_color, int pressed_alpha, boolean animate) {
        StateListDrawable states = ViewHolderUIUtils.getSelectableBackground(ctx, selected_color, animate);
        ColorDrawable clrPressed = new ColorDrawable(ViewHolderUIUtils.adjustAlpha(selected_color, pressed_alpha));
        states.addState(new int[]{16842919}, (Drawable)clrPressed);
        return states;
    }

    public static int adjustAlpha(@ColorInt int color, int alpha) {
        return alpha << 24 | color & 0xFFFFFF;
    }

    public static int getSelectableBackground(Context ctx) {
        if (Build.VERSION.SDK_INT >= 11) {
            TypedValue outValue = new TypedValue();
            return outValue.resourceId;
        }
        TypedValue outValue = new TypedValue();
        ctx.getTheme().resolveAttribute(0x1010130, outValue, true);
        return outValue.resourceId;
    }
}

