/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;

public final class Utils {
    public static boolean hasLollipop() {
        return Build.VERSION.SDK_INT >= 21;
    }

    @TargetApi(value=21)
    public static int fetchAccentColor(Context context, int colorAccent) {
        if (Utils.hasLollipop()) {
            TypedArray androidAttr = context.getTheme().obtainStyledAttributes(new int[]{16843829});
            colorAccent = androidAttr.getColor(0, colorAccent);
            androidAttr.recycle();
        }
        return colorAccent;
    }

    public static int dpToPx(Context context, float dp) {
        float scale = context.getResources().getDisplayMetrics().density;
        return Math.round(dp * scale);
    }
}

