/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.CallSuper;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import eu.davidea.flexibleadapter.FlexibleAnimatorAdapter;
import eu.davidea.flexibleadapter.helpers.ItemTouchHelperCallback;
import eu.davidea.flexibleadapter.items.IExpandable;
import eu.davidea.flexibleadapter.items.IFlexibleItem;
import eu.davidea.flexibleadapter.items.ISectionable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public abstract class FlexibleAdapter<T extends IFlexibleItem>
extends FlexibleAnimatorAdapter
implements ItemTouchHelperCallback.AdapterCallback {
    private static final String TAG = FlexibleAdapter.class.getSimpleName();
    private static final String EXTRA_PARENT = TAG + "_parentSelected";
    private static final String EXTRA_CHILD = TAG + "_childSelected";
    public static final int EXPANDABLE_VIEW_TYPE = -1;
    public static final int SECTION_VIEW_TYPE = -2;
    public static final long UNDO_TIMEOUT = 5000L;
    private List<T> mItems;
    private List<ISectionable> mHeaders;
    protected Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    FlexibleAdapter.this.filterItems((List)message.obj);
                    return true;
                }
                case 1: {
                    OnDeleteCompleteListener listener = (OnDeleteCompleteListener)message.obj;
                    if (listener != null) {
                        listener.onDeleteConfirmed();
                    }
                    FlexibleAdapter.this.emptyBin();
                    return true;
                }
            }
            return false;
        }
    });
    protected List<RemovedItem> mRemovedItems;
    private boolean restoreSelection = false;
    private boolean multiRange = false;
    private boolean adjustRemoved = true;
    private boolean adjustSelected = true;
    protected LayoutInflater mInflater;
    private ArrayMap<Integer, T> mTypeInstances = new ArrayMap();
    private boolean autoMap = false;
    protected String mSearchText = "";
    protected String mOldSearchText = "";
    protected boolean mNotifyChangeOfUnfilteredItems = false;
    protected boolean filtering = false;
    private boolean scrollOnExpand = false;
    private boolean collapseOnExpand = false;
    private boolean childSelected = false;
    private boolean parentSelected = false;
    private boolean longPressDragEnabled = false;
    private boolean handleDragEnabled = true;
    private boolean swipeEnabled = false;
    private ItemTouchHelperCallback mItemTouchHelperCallback;
    private ItemTouchHelper mItemTouchHelper;
    protected OnUpdateListener mUpdateListener;
    public OnItemClickListener mItemClickListener;
    public OnItemLongClickListener mItemLongClickListener;
    protected OnItemMoveListener mItemMoveListener;
    protected OnItemSwipeListener mItemSwipeListener;

    public FlexibleAdapter(@NonNull List<T> items) {
        this(items, null);
    }

    public FlexibleAdapter(@NonNull List<T> items, @Nullable Object listeners) {
        this.mItems = Collections.synchronizedList(items);
        this.mRemovedItems = new ArrayList<RemovedItem>();
        this.expandInitialItems();
        if (listeners instanceof OnUpdateListener) {
            this.mUpdateListener = (OnUpdateListener)listeners;
            this.mUpdateListener.onUpdateEmptyView(this.mItems.size());
        }
        if (listeners instanceof OnItemClickListener) {
            this.mItemClickListener = (OnItemClickListener)listeners;
        }
        if (listeners instanceof OnItemLongClickListener) {
            this.mItemLongClickListener = (OnItemLongClickListener)listeners;
        }
        if (listeners instanceof OnItemMoveListener) {
            this.mItemMoveListener = (OnItemMoveListener)listeners;
        }
        if (listeners instanceof OnItemSwipeListener) {
            this.mItemSwipeListener = (OnItemSwipeListener)listeners;
        }
        this.registerAdapterDataObserver(new ExpandableAdapterDataObserver());
    }

    protected void expandInitialItems() {
        for (int position = 0; position < this.mItems.size(); ++position) {
            IExpandable expandable;
            T item = this.getItem(position);
            this.mapViewTypeFrom(item);
            if (item == null || !this.isExpandable(item) || !(expandable = (IExpandable)item).isExpanded()) continue;
            if (DEBUG) {
                Log.v((String)TAG, (String)("Initially expand item on position " + position));
            }
            List<T> subItems = this.getCurrentChildren(item);
            this.mItems.addAll(position + 1, subItems);
            position += subItems.size();
        }
    }

    @Override
    public void toggleSelection(@IntRange(from=0L) int position) {
        T item = this.getItem(position);
        if (item != null && item.isSelectable()) {
            boolean hasParent;
            boolean bl = hasParent = this.getExpandableOf(item) != null;
            if (!(!this.isExpandable(item) && hasParent || this.childSelected)) {
                this.parentSelected = true;
                super.toggleSelection(position);
            } else if (!this.parentSelected && hasParent) {
                this.childSelected = true;
                super.toggleSelection(position);
            }
        }
        if (this.getSelectedItemCount() == 0) {
            this.childSelected = false;
            this.parentSelected = false;
        }
    }

    @Override
    public void selectAll(Integer ... viewTypes) {
        T item = this.getItem(this.getSelectedPositions().get(0));
        if (this.getSelectedItemCount() > 0 && this.isExpandable(item)) {
            super.selectAll(-1);
        } else {
            super.selectAll(viewTypes);
        }
    }

    @Override
    @CallSuper
    public void clearSelection() {
        this.childSelected = false;
        this.parentSelected = false;
        super.clearSelection();
    }

    public boolean isAnyParentSelected() {
        return this.parentSelected;
    }

    public boolean isAnyChildSelected() {
        return this.childSelected;
    }

    public void updateDataSet(List<T> items) {
        this.mItems = items;
        this.notifyDataSetChanged();
    }

    public final T getItem(@IntRange(from=0L) int position) {
        if (position < 0 || position >= this.mItems.size()) {
            return null;
        }
        return (T)((IFlexibleItem)this.mItems.get(position));
    }

    public long getItemId(int position) {
        return position;
    }

    public final int getItemCount() {
        return this.mItems != null ? this.mItems.size() : 0;
    }

    public int getItemCountOfTypes(Integer ... viewTypes) {
        List<Integer> viewTypeList = Arrays.asList(viewTypes);
        int count = 0;
        for (int i = 0; i < this.mItems.size(); ++i) {
            if ((!this.autoMap || !viewTypeList.contains(((IFlexibleItem)this.mItems.get(i)).getLayoutRes())) && !viewTypeList.contains(this.getItemViewType(i))) continue;
            ++count;
        }
        return count;
    }

    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    public int getGlobalPositionOf(@NonNull T item) {
        return item != null && this.mItems != null && this.mItems.size() > 0 ? this.mItems.indexOf(item) : -1;
    }

    public boolean contains(@NonNull T item) {
        return item != null && this.mItems != null && this.mItems.contains(item);
    }

    public FlexibleAdapter setHeaders(List<ISectionable> mHeaders) {
        return this.withHeaders(mHeaders);
    }

    public FlexibleAdapter withHeaders(List<ISectionable> headers) {
        if (headers != null) {
            if (DEBUG) {
                Log.v((String)TAG, (String)("Settings " + headers.size() + " mHeaders"));
            }
            this.mHeaders = headers;
        }
        return this;
    }

    public FlexibleAdapter addHeader(@NonNull ISectionable headerItem) {
        if (headerItem == null) {
            Log.e((String)TAG, (String)"Cannot add null Header!");
            return this;
        }
        this.mHeaders.add(headerItem);
        if (!headerItem.isHidden()) {
            this.showHeader(headerItem);
        } else {
            this.mapViewTypeFrom(headerItem);
        }
        return this;
    }

    public List<ISectionable> getHeadersList() {
        return this.mHeaders;
    }

    public List<Integer> getHeadersActualPositions() {
        ArrayList<Integer> list = new ArrayList<Integer>(this.mHeaders.size());
        for (int i = 0; i < this.mItems.size(); ++i) {
            if (!(this.mItems.get(i) instanceof ISectionable)) continue;
            list.add(i);
        }
        return list;
    }

    public void showAllHeaders() {
        this.multiRange = true;
        for (int i = this.mHeaders.size() - 1; i >= 0; --i) {
            this.showHeader(this.mHeaders.get(i));
        }
        this.multiRange = false;
    }

    public void hideAllHeaders() {
        this.multiRange = true;
        for (int i = this.mHeaders.size() - 1; i >= 0; --i) {
            this.hideHeader(this.mHeaders.get(i));
        }
        this.multiRange = false;
    }

    private void showHeader(@NonNull ISectionable header) {
        int position = this.getGlobalPositionOf(header.getAttachedItem());
        if (position < 0) {
            Log.e((String)TAG, (String)("Cannot add Header. Cannot find item to which attach the Header! headerItem=" + header));
            return;
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("Showing header " + position + "=" + header));
        }
        header.setHidden(false);
        this.addItem(position, header);
    }

    private void hideHeader(@NonNull ISectionable header) {
        int position = this.getGlobalPositionOf(header);
        if (DEBUG) {
            Log.v((String)TAG, (String)("Hiding header actual position " + position + "=" + header));
        }
        if (position >= 0) {
            header.setHidden(true);
            this.mItems.remove(position);
            this.notifyItemRemoved(position);
        }
    }

    public void deleteHeader(ISectionable header) {
        int index = this.mHeaders.indexOf(header);
        if (DEBUG) {
            Log.v((String)TAG, (String)("Deleting header " + header));
        }
        if (index >= 0) {
            this.hideHeader(this.mHeaders.get(index));
            this.mHeaders.remove(index);
        }
    }

    public int getItemViewType(int position) {
        this.autoMap = true;
        T item = this.getItem(position);
        assert (item != null);
        return item.getLayoutRes();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (this.mInflater == null) {
            this.mInflater = LayoutInflater.from((Context)parent.getContext());
        }
        return this.getViewTypeInstance(viewType).createViewHolder(this, this.mInflater, parent);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        this.onBindViewHolder(holder, position, Collections.unmodifiableList(new ArrayList()));
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position, List payloads) {
        holder.itemView.setActivated(this.isSelected(position));
        T item = this.getItem(position);
        if (item != null) {
            item.bindViewHolder(this, (RecyclerView.ViewHolder)holder, position, payloads);
        }
    }

    public void setAutoCollapseOnExpand(boolean collapseOnExpand) {
        this.collapseOnExpand = collapseOnExpand;
    }

    public void setAutoScrollOnExpand(boolean scrollOnExpand) {
        this.scrollOnExpand = scrollOnExpand;
    }

    public boolean isExpanded(@IntRange(from=0L) int position) {
        T item = this.getItem(position);
        if (this.isExpandable(item)) {
            IExpandable expandable = (IExpandable)item;
            return expandable.isExpanded();
        }
        return false;
    }

    public boolean isExpandable(T item) {
        return item != null && item instanceof IExpandable;
    }

    public IExpandable getExpandableOf(@NonNull T child) {
        for (IFlexibleItem parent : this.mItems) {
            IExpandable expandable;
            if (parent == child) {
                return null;
            }
            if (!this.isExpandable(parent) || !(expandable = (IExpandable)parent).isExpanded() || expandable.getSubItems() == null) continue;
            List list = expandable.getSubItems();
            for (IFlexibleItem subItem : list) {
                if (subItem.isHidden() || !subItem.equals(child)) continue;
                return expandable;
            }
        }
        return null;
    }

    public int getExpandablePositionOf(@NonNull T child) {
        return this.getGlobalPositionOf(this.getExpandableOf(child));
    }

    public List<T> getSiblingsOf(@NonNull T child) {
        return this.getExpandableList(this.getExpandableOf(child));
    }

    public int getRelativePositionOf(@NonNull T child) {
        return this.getSiblingsOf(child).indexOf(child);
    }

    public List<T> getExpandedItems() {
        ArrayList<IFlexibleItem> expandedItems = new ArrayList<IFlexibleItem>();
        for (IFlexibleItem item : this.mItems) {
            if (!this.isExpandable(item) || !((IExpandable)item).isExpanded()) continue;
            expandedItems.add(item);
        }
        return expandedItems;
    }

    public List<Integer> getExpandedPositions() {
        ArrayList<Integer> expandedPositions = new ArrayList<Integer>();
        for (int i = 0; i < this.mItems.size() - 1; ++i) {
            IFlexibleItem item = (IFlexibleItem)this.mItems.get(i);
            if (!this.isExpandable(item) || !((IExpandable)item).isExpanded()) continue;
            expandedPositions.add(i);
        }
        return expandedPositions;
    }

    public int expand(@IntRange(from=0L) int position) {
        return this.expand(position, false);
    }

    private int expand(int position, boolean expandAll) {
        T item = this.getItem(position);
        if (item == null || !this.isExpandable(item)) {
            return 0;
        }
        IExpandable expandable = (IExpandable)item;
        if (DEBUG) {
            Log.v((String)TAG, (String)("Request to Expand on position " + position + " expanded " + expandable.isExpanded() + " ExpandedItems=" + this.getExpandedPositions()));
        }
        int subItemsCount = 0;
        if (!expandable.isExpanded() && !this.parentSelected && expandable.getSubItems() != null && expandable.getSubItems().size() > 0) {
            if (this.collapseOnExpand && !expandAll && this.collapseAll() > 0) {
                position = this.getGlobalPositionOf(item);
            }
            List<T> subItems = this.getExpandableList(expandable);
            this.mItems.addAll(position + 1, subItems);
            subItemsCount = subItems.size();
            expandable.setExpanded(true);
            this.mapViewTypesFrom(subItems);
            if (this.scrollOnExpand && !expandAll) {
                final int pos = position;
                final int count = subItemsCount;
                Handler animatorHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

                    public boolean handleMessage(Message message) {
                        FlexibleAdapter.this.autoScroll(pos, count);
                        return true;
                    }
                });
                animatorHandler.sendMessageDelayed(Message.obtain((Handler)this.mHandler), 150L);
            }
            this.notifyItemRangeInserted(position + 1, subItemsCount);
            if (DEBUG) {
                Log.v((String)TAG, (String)("Expanded " + subItemsCount + " subItems on position=" + position + " ExpandedItems=" + this.getExpandedPositions()));
            }
        }
        return subItemsCount;
    }

    public int expandAll() {
        int expanded = 0;
        for (int i = 0; i < this.mItems.size() - 1; ++i) {
            if (this.expand(i, true) <= 0) continue;
            ++expanded;
        }
        return expanded;
    }

    public int collapse(@IntRange(from=0L) int position) {
        T item = this.getItem(position);
        if (item == null || !this.isExpandable(item)) {
            return 0;
        }
        IExpandable expandable = (IExpandable)item;
        if (DEBUG) {
            Log.v((String)TAG, (String)("Request to Collapse on position " + position + " ExpandedItems=" + this.getExpandedPositions()));
        }
        int subItemsCount = 0;
        int recursiveCount = 0;
        if (expandable.isExpanded() && (!this.hasSubItemsSelected(expandable) || this.isExpandablePendingRemove(position))) {
            List<T> subItems = this.getExpandableList(expandable);
            recursiveCount = this.recursiveCollapse(subItems);
            this.mItems.removeAll(subItems);
            subItemsCount = subItems.size();
            expandable.setExpanded(false);
            this.notifyItemRangeRemoved(position + 1, subItemsCount);
            if (DEBUG) {
                Log.v((String)TAG, (String)("Collapsed " + subItemsCount + " subItems on position=" + position + " ExpandedItems=" + this.getExpandedPositions()));
            }
        }
        return subItemsCount + recursiveCount;
    }

    private int recursiveCollapse(List<T> subItems) {
        int collapsed = 0;
        for (IFlexibleItem subItem : subItems) {
            if (!this.isExpandable(subItem) || !((IExpandable)subItem).isExpanded()) continue;
            if (DEBUG) {
                Log.v((String)TAG, (String)("Recursive collapsing on expandable subItem " + subItem));
            }
            collapsed += this.collapse(this.getGlobalPositionOf(subItem));
        }
        return collapsed;
    }

    public int collapseAll() {
        int collapsed = 0;
        for (int i = this.mItems.size() - 1; i >= 0; --i) {
            if (this.collapse(i) <= 0) continue;
            ++collapsed;
        }
        return collapsed;
    }

    public void updateItem(@IntRange(from=0L) int position, @NonNull T item, Object payload) {
        if (position < 0 && position >= this.mItems.size()) {
            Log.e((String)TAG, (String)"Cannot updateItem on position out of OutOfBounds!");
            return;
        }
        this.mItems.set(position, item);
        if (DEBUG) {
            Log.v((String)TAG, (String)("updateItem notifyItemChanged on position " + position));
        }
        this.notifyItemChanged(position, payload);
    }

    public void addItemWithDelay(final @IntRange(from=0L) int position, @NonNull T item, @IntRange(from=0L) long delay) {
        this.mHandler.postDelayed(new Runnable((IFlexibleItem)item){
            final /* synthetic */ IFlexibleItem val$item;
            {
                this.val$item = iFlexibleItem;
            }

            @Override
            public void run() {
                if (FlexibleAdapter.this.addItem(position, this.val$item)) {
                    FlexibleAdapter.this.mRecyclerView.scrollToPosition(Math.min(Math.max(0, position), FlexibleAdapter.this.mItems.size() - 1));
                }
            }
        }, delay);
    }

    public boolean addItem(@IntRange(from=0L) int position, @NonNull T item) {
        if (position < 0) {
            Log.e((String)TAG, (String)"Cannot addItem on negative position!");
            return false;
        }
        if (item == null) {
            Log.e((String)TAG, (String)"No items to add!");
            return false;
        }
        if (position < this.mItems.size()) {
            if (DEBUG) {
                Log.v((String)TAG, (String)("addItem notifyItemInserted on position " + position));
            }
            this.mItems.add(position, item);
        } else {
            if (DEBUG) {
                Log.v((String)TAG, (String)"addItem notifyItemInserted on last position");
            }
            this.mItems.add(item);
            position = this.mItems.size();
        }
        this.mapViewTypeFrom(item);
        this.notifyItemInserted(position);
        if (this.mUpdateListener != null && !this.multiRange) {
            this.mUpdateListener.onUpdateEmptyView(this.getItemCount());
        }
        return true;
    }

    public boolean addItems(@IntRange(from=0L) int position, @NonNull List<T> items) {
        if (position < 0) {
            Log.e((String)TAG, (String)"Cannot addItems on negative position!");
            return false;
        }
        if (items == null || items.isEmpty()) {
            Log.e((String)TAG, (String)"No items to add!");
            return false;
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("addItems position=" + position + " itemCount=" + items.size()));
        }
        if (position < this.mItems.size()) {
            this.mItems.addAll(position, items);
        } else {
            this.mItems.addAll(items);
        }
        this.mapViewTypesFrom(items);
        this.notifyItemRangeInserted(position, items.size());
        if (this.mUpdateListener != null && !this.multiRange) {
            this.mUpdateListener.onUpdateEmptyView(this.getItemCount());
        }
        return true;
    }

    public boolean addSubItem(@IntRange(from=0L) int parentPosition, @IntRange(from=0L) int subPosition, @NonNull T item) {
        return this.addSubItem(parentPosition, subPosition, item, false, false);
    }

    public boolean addSubItem(@IntRange(from=0L) int parentPosition, @IntRange(from=0L) int subPosition, @NonNull T item, boolean expandParent, boolean notifyParentChanged) {
        T parent = this.getItem(parentPosition);
        boolean added = false;
        if (parent != null && this.isExpandable(parent)) {
            IExpandable expandable = (IExpandable)parent;
            if (expandParent && !expandable.isExpanded()) {
                this.expand(parentPosition);
            }
            if (expandable.isExpanded()) {
                this.addItem(parentPosition + 1 + Math.max(0, subPosition), item);
                added = true;
            }
            this.mapViewTypeFrom(item);
            if (notifyParentChanged) {
                this.notifyItemChanged(parentPosition, expandable);
            }
        }
        return added;
    }

    public void removeItem(@IntRange(from=0L) int position) {
        this.removeItem(position, false);
    }

    public void removeItem(@IntRange(from=0L) int position, boolean notifyParentChanged) {
        if (position < 0 && position >= this.mItems.size()) {
            Log.e((String)TAG, (String)"Cannot removeItem on position out of OutOfBounds!");
            return;
        }
        T item = this.getItem(position);
        assert (item != null);
        IExpandable parent = this.getExpandableOf(item);
        if (this.isExpandable(item) || parent == null) {
            this.createRemovedItem(position, item);
            if (DEBUG) {
                if (parent == null) {
                    Log.v((String)TAG, (String)("removeItem Item:" + item));
                } else {
                    Log.v((String)TAG, (String)("removeItem ExpandableItem:" + item));
                }
            }
        } else {
            int parentPosition = this.createRemovedSubItem(parent, item, notifyParentChanged);
            if (DEBUG) {
                Log.v((String)TAG, (String)("removeItem NonExpandableItem:" + item));
            }
            if (notifyParentChanged) {
                this.notifyItemChanged(parentPosition, parent);
            }
        }
        this.mItems.remove(position);
        this.getSelectedPositions().remove(new Integer(position));
        this.notifyItemRemoved(position);
        if (this.mUpdateListener != null && !this.multiRange) {
            this.mUpdateListener.onUpdateEmptyView(this.getItemCount());
        }
    }

    public void removeItems(List<Integer> selectedPositions) {
        this.removeItems(selectedPositions, false);
    }

    public void removeItems(List<Integer> selectedPositions, boolean notifyParentChanged) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("removeItems selectedPositions=" + selectedPositions + " notifyParentChanged=" + notifyParentChanged));
        }
        if (selectedPositions == null || selectedPositions.isEmpty()) {
            return;
        }
        Collections.sort(selectedPositions, new Comparator<Integer>(){

            @Override
            public int compare(Integer lhs, Integer rhs) {
                return rhs - lhs;
            }
        });
        if (DEBUG) {
            Log.v((String)TAG, (String)("removeItems after reverse sort selectedPositions=" + selectedPositions));
        }
        int positionStart = 0;
        int itemCount = 0;
        int lastPosition = selectedPositions.get(0);
        this.multiRange = true;
        for (Integer position : selectedPositions) {
            if (lastPosition - itemCount == position) {
                ++itemCount;
                positionStart = position;
            } else {
                if (itemCount > 0) {
                    this.removeRange(positionStart, itemCount, notifyParentChanged);
                }
                positionStart = lastPosition = position.intValue();
                itemCount = 1;
            }
            this.collapse(position);
        }
        this.multiRange = false;
        if (itemCount > 0) {
            this.removeRange(positionStart, itemCount, notifyParentChanged);
        }
    }

    public void removeRange(int positionStart, int itemCount) {
        this.removeRange(positionStart, itemCount, false);
    }

    public void removeRange(int positionStart, int itemCount, boolean notifyParentChanged) {
        int initialCount = this.getItemCount();
        if (DEBUG) {
            Log.v((String)TAG, (String)("removeRange positionStart=" + positionStart + " itemCount=" + itemCount));
        }
        if (positionStart < 0 || positionStart + itemCount > initialCount) {
            Log.e((String)TAG, (String)"Cannot removeRange with positionStart out of OutOfBounds!");
            return;
        }
        int parentPosition = -1;
        IExpandable parent = null;
        for (int position = positionStart + itemCount - 1; position >= positionStart; --position) {
            T item = this.getItem(position);
            assert (item != null);
            if (parent == null) {
                parent = this.getExpandableOf(item);
            }
            if (this.isExpandable(item) || parent == null) {
                this.createRemovedItem(position, item);
            } else {
                parentPosition = this.createRemovedSubItem(parent, item, notifyParentChanged);
            }
            this.mItems.remove(position);
        }
        if (parentPosition >= 0) {
            this.adjustSelected = false;
            this.notifyItemRangeRemoved(positionStart, itemCount);
            if (notifyParentChanged) {
                this.notifyItemChanged(parentPosition, parent);
            }
        } else {
            this.adjustRemoved = false;
            this.notifyItemRangeRemoved(positionStart, itemCount);
        }
        if (this.mUpdateListener != null && !this.multiRange && initialCount != this.getItemCount()) {
            this.mUpdateListener.onUpdateEmptyView(this.getItemCount());
        }
    }

    public void removeAllSelectedItems() {
        this.removeItems(this.getSelectedPositions());
    }

    public void removeAllSelectedItems(boolean notifyParentChanged) {
        this.removeItems(this.getSelectedPositions(), notifyParentChanged);
    }

    public boolean isRestoreWithSelection() {
        return this.restoreSelection;
    }

    public void setRestoreSelectionOnUndo(boolean restoreSelection) {
        this.restoreSelection = restoreSelection;
    }

    public void restoreDeletedItems() {
        this.stopUndoTimer();
        Collections.sort(this.mRemovedItems, new Comparator<RemovedItem>(){

            @Override
            public int compare(RemovedItem lhs, RemovedItem rhs) {
                return rhs.parentPosition - lhs.parentPosition;
            }
        });
        this.multiRange = true;
        int initialCount = this.getItemCount();
        if (this.restoreSelection) {
            this.clearSelection();
        }
        for (int i = this.mRemovedItems.size() - 1; i >= 0; --i) {
            boolean added;
            RemovedItem removedItem = this.mRemovedItems.get(i);
            if (removedItem.relativePosition >= 0) {
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Restore Child " + removedItem));
                }
                if (this.hasSearchText() && !this.filterObject(removedItem.item, this.getSearchText())) continue;
                added = this.addSubItem(removedItem.parentPosition, removedItem.relativePosition, removedItem.item, false, removedItem.notifyParentChanged);
            } else {
                this.adjustRemoved = false;
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Restore Parent " + removedItem));
                }
                if (this.hasSearchText() && !this.filterExpandableObject(removedItem.item, this.getSearchText())) continue;
                added = this.addItem(removedItem.parentPosition, removedItem.item);
            }
            removedItem.item.setHidden(false);
            if (!this.restoreSelection || !added) continue;
            if (removedItem.item instanceof IExpandable || this.getExpandableOf(removedItem.item) == null) {
                this.parentSelected = true;
                this.getSelectedPositions().add(removedItem.parentPosition);
                continue;
            }
            this.childSelected = true;
            this.getSelectedPositions().add(removedItem.parentPosition + 1 + removedItem.relativePosition);
        }
        if (DEBUG && this.restoreSelection) {
            Log.v((String)TAG, (String)("Selected positions after restore " + this.getSelectedPositions()));
        }
        this.multiRange = false;
        if (this.mUpdateListener != null && initialCount != this.getItemCount()) {
            this.mUpdateListener.onUpdateEmptyView(this.getItemCount());
        }
        this.emptyBin();
    }

    public synchronized void emptyBin() {
        this.mRemovedItems.clear();
    }

    public void startUndoTimer(OnDeleteCompleteListener listener) {
        this.startUndoTimer(0L, listener);
    }

    public void startUndoTimer(long timeout, OnDeleteCompleteListener listener) {
        this.mHandler.removeMessages(1);
        this.mHandler.sendMessageDelayed(Message.obtain((Handler)this.mHandler, (int)1, (Object)listener), timeout > 0L ? timeout : 5000L);
    }

    protected void stopUndoTimer() {
        this.mHandler.removeCallbacksAndMessages(null);
    }

    public boolean isRestoreInTime() {
        return this.mRemovedItems != null && this.mRemovedItems.size() > 0;
    }

    public List<T> getDeletedItems() {
        ArrayList deletedItems = new ArrayList();
        for (RemovedItem removedItem : this.mRemovedItems) {
            deletedItems.add(removedItem.item);
        }
        return deletedItems;
    }

    public List<Integer> getDeletedPositions() {
        ArrayList<Integer> deletedItems = new ArrayList<Integer>();
        for (RemovedItem removedItem : this.mRemovedItems) {
            if (deletedItems.contains(removedItem.parentPosition)) continue;
            deletedItems.add(removedItem.parentPosition);
        }
        return deletedItems;
    }

    public IExpandable getExpandableOfDeletedChild(T child) {
        for (RemovedItem removedItem : this.mRemovedItems) {
            if (!removedItem.item.equals(child)) continue;
            return removedItem.expandable;
        }
        return null;
    }

    public List<T> getDeletedChildren(int parentPosition) {
        ArrayList deletedChild = new ArrayList();
        for (RemovedItem removedItem : this.mRemovedItems) {
            if (removedItem.parentPosition != parentPosition || removedItem.relativePosition < 0) continue;
            deletedChild.add(removedItem.item);
        }
        return deletedChild;
    }

    public List<T> getCurrentChildren(T item) {
        if (item == null || !this.isExpandable(item)) {
            return new ArrayList();
        }
        IExpandable expandable = (IExpandable)item;
        if (expandable.getSubItems() == null) {
            return new ArrayList();
        }
        ArrayList subItems = new ArrayList(expandable.getSubItems());
        if (this.mRemovedItems.size() > 0) {
            subItems.removeAll(this.getDeletedChildren(this.getGlobalPositionOf(item)));
        }
        return subItems;
    }

    private boolean isExpandablePendingRemove(int parentPosition) {
        for (RemovedItem removedItem : this.mRemovedItems) {
            if (removedItem.parentPosition != parentPosition) continue;
            return true;
        }
        return false;
    }

    private RemovedItem getPendingRemovedItem(T item) {
        for (RemovedItem removedItem : this.mRemovedItems) {
            if (!removedItem.item.equals(item)) continue;
            return removedItem;
        }
        return null;
    }

    public boolean hasSearchText() {
        return this.mSearchText != null && this.mSearchText.length() > 0;
    }

    public String getSearchText() {
        return this.mSearchText;
    }

    public void setSearchText(String searchText) {
        this.mSearchText = searchText != null ? searchText.trim().toLowerCase(Locale.getDefault()) : "";
    }

    public final void setNotifyChangeOfUnfilteredItems(boolean notifyChange) {
        this.mNotifyChangeOfUnfilteredItems = notifyChange;
    }

    public void filterItems(@NonNull List<T> unfilteredItems, @IntRange(from=0L) long delay) {
        this.mHandler.removeMessages(0);
        this.mHandler.sendMessageDelayed(Message.obtain((Handler)this.mHandler, (int)0, unfilteredItems), delay > 0L ? delay : 0L);
    }

    public synchronized void filterItems(@NonNull List<T> unfilteredItems) {
        List<Object> values = new ArrayList();
        this.filtering = true;
        int initialCount = this.getItemCount();
        if (this.hasSearchText()) {
            int newOriginalPosition = -1;
            for (IFlexibleItem item : unfilteredItems) {
                IExpandable expandable;
                if (!this.filterExpandableObject(item, this.getSearchText())) continue;
                RemovedItem removedItem = this.getPendingRemovedItem(item);
                if (removedItem != null) {
                    removedItem.parentPosition = ++newOriginalPosition;
                    continue;
                }
                values.add(item);
                ++newOriginalPosition;
                if (!this.isExpandable(item) || !(expandable = (IExpandable)item).isExpanded()) continue;
                ArrayList<IFlexibleItem> filteredSubItems = new ArrayList<IFlexibleItem>();
                List subItems = expandable.getSubItems();
                for (IFlexibleItem subItem : subItems) {
                    if (subItem.isHidden()) continue;
                    filteredSubItems.add(subItem);
                }
                this.mapViewTypesFrom(filteredSubItems);
                values.addAll(filteredSubItems);
                newOriginalPosition += filteredSubItems.size();
            }
        } else {
            values = unfilteredItems;
            if (!this.mRemovedItems.isEmpty()) {
                for (RemovedItem removedItem : this.mRemovedItems) {
                    removedItem.parentPosition = values.indexOf(removedItem.item);
                }
                values.removeAll(this.getDeletedItems());
            }
            this.resetFilterFlags(values);
        }
        if (!this.mOldSearchText.equalsIgnoreCase(this.mSearchText)) {
            this.mOldSearchText = this.mSearchText;
            this.animateTo(values);
        } else {
            this.mItems = values;
        }
        this.filtering = false;
        if (this.mUpdateListener != null && initialCount != this.getItemCount()) {
            this.mUpdateListener.onUpdateEmptyView(this.getItemCount());
        }
    }

    private boolean filterExpandableObject(T item, String constraint) {
        boolean filtered = false;
        if (this.isExpandable(item)) {
            IExpandable expandable = (IExpandable)item;
            expandable.setExpanded(false);
            Iterator<T> i$ = this.getCurrentChildren(item).iterator();
            while (i$.hasNext()) {
                IFlexibleItem subItem;
                subItem.setHidden(!this.filterObject(subItem = (IFlexibleItem)i$.next(), constraint));
                if (filtered || subItem.isHidden()) continue;
                filtered = true;
            }
            expandable.setExpanded(filtered);
        }
        return filtered || this.filterObject(item, constraint);
    }

    protected boolean filterObject(T item, String constraint) {
        String[] words;
        String valueText = item.toString().toLowerCase();
        if (valueText.startsWith(constraint)) {
            return true;
        }
        for (String word : words = valueText.split(" ")) {
            if (!word.startsWith(constraint)) continue;
            return true;
        }
        return false;
    }

    public List<T> animateTo(List<T> models) {
        this.applyAndAnimateRemovals(this.mItems, models);
        this.applyAndAnimateAdditions(this.mItems, models);
        return this.mItems;
    }

    protected void applyAndAnimateRemovals(List<T> from, List<T> newItems) {
        int out = 0;
        for (int i = from.size() - 1; i >= 0; --i) {
            IFlexibleItem item = (IFlexibleItem)from.get(i);
            if (!newItems.contains(item)) {
                if (DEBUG) {
                    Log.v((String)TAG, (String)("animateRemovals remove position=" + i + " item=" + item));
                }
                from.remove(i);
                this.notifyItemRemoved(i);
                ++out;
                continue;
            }
            if (!DEBUG) continue;
            Log.v((String)TAG, (String)("animateRemovals   keep position=" + i + " item=" + item));
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("animateRemovals total out=" + out + " in=" + newItems.size()));
        }
    }

    protected void applyAndAnimateAdditions(List<T> from, List<T> newItems) {
        int out = 0;
        int count = newItems.size();
        for (int i = 0; i < count; ++i) {
            IFlexibleItem item = (IFlexibleItem)newItems.get(i);
            if (!from.contains(item)) {
                if (DEBUG) {
                    Log.v((String)TAG, (String)("animateAdditions  add position=" + i + " item=" + item));
                }
                from.add(i, item);
                this.notifyItemInserted(i);
                continue;
            }
            if (!this.mNotifyChangeOfUnfilteredItems) continue;
            ++out;
            this.notifyItemChanged(i);
            if (!DEBUG) continue;
            Log.v((String)TAG, (String)("animateAdditions keep position=" + i + " item=" + item));
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("animateAdditions total out=" + out + " in=" + newItems.size()));
        }
    }

    public final ItemTouchHelper getItemTouchHelper() {
        this.initializeItemTouchHelper();
        return this.mItemTouchHelper;
    }

    public boolean isLongPressDragEnabled() {
        return this.mItemTouchHelperCallback.isLongPressDragEnabled();
    }

    public final void setLongPressDragEnabled(boolean longPressDragEnabled) {
        this.initializeItemTouchHelper();
        this.longPressDragEnabled = longPressDragEnabled;
        this.mItemTouchHelperCallback.setLongPressDragEnabled(longPressDragEnabled);
    }

    public boolean isHandleDragEnabled() {
        return this.handleDragEnabled;
    }

    public void setHandleDragEnabled(boolean handleDragEnabled) {
        this.handleDragEnabled = handleDragEnabled;
    }

    public final boolean isSwipeEnabled() {
        return this.mItemTouchHelperCallback.isItemViewSwipeEnabled();
    }

    public final void setSwipeEnabled(boolean swipeEnabled) {
        this.initializeItemTouchHelper();
        this.swipeEnabled = swipeEnabled;
        this.mItemTouchHelperCallback.setSwipeEnabled(swipeEnabled);
    }

    @CallSuper
    public void moveItem(int fromPosition, int toPosition) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("moveItem from=" + fromPosition + "[" + (this.isSelected(fromPosition) ? "selected" : "unselected") + "] to=" + toPosition + "[" + (this.isSelected(toPosition) ? "selected" : "unselected") + "]"));
            Log.v((String)TAG, (String)("moveItem fromItem=" + this.getItem(fromPosition) + " toItem=" + this.getItem(toPosition)));
        }
        Collections.swap(this.mItems, fromPosition, toPosition);
        if (this.isSelected(fromPosition) && !this.isSelected(toPosition) || !this.isSelected(fromPosition) && this.isSelected(toPosition)) {
            super.toggleSelection(fromPosition);
            super.toggleSelection(toPosition);
        }
        this.notifyItemMoved(fromPosition, toPosition);
    }

    @Override
    public boolean shouldMove(int fromPosition, int toPosition) {
        return true;
    }

    @Override
    @CallSuper
    public boolean onItemMove(int fromPosition, int toPosition) {
        this.moveItem(fromPosition, toPosition);
        if (this.mItemMoveListener != null) {
            this.mItemMoveListener.onItemMove(fromPosition, toPosition);
        }
        return true;
    }

    @Override
    @CallSuper
    public void onItemSwiped(int position, int direction) {
        if (this.mItemSwipeListener != null) {
            this.mItemSwipeListener.onItemSwipe(position, direction);
        }
    }

    private void initializeItemTouchHelper() {
        if (this.mItemTouchHelper == null) {
            if (this.mRecyclerView == null) {
                throw new IllegalStateException("RecyclerView cannot be null. Enabling LongPressDrag or Swipe must be done after the Adapter is added to the RecyclerView.");
            }
            this.mItemTouchHelperCallback = new ItemTouchHelperCallback(this);
            this.mItemTouchHelper = new ItemTouchHelper((ItemTouchHelper.Callback)this.mItemTouchHelperCallback);
            this.mItemTouchHelper.attachToRecyclerView(this.mRecyclerView);
        }
    }

    private void mapViewTypesFrom(Iterable<T> items) {
        if (items != null) {
            for (IFlexibleItem item : items) {
                this.mapViewTypeFrom(item);
            }
        }
    }

    private void mapViewTypeFrom(T item) {
        if (item != null && !this.mTypeInstances.containsKey((Object)item.getLayoutRes())) {
            this.mTypeInstances.put((Object)item.getLayoutRes(), item);
        }
    }

    private T getViewTypeInstance(int viewType) {
        return (T)((IFlexibleItem)this.mTypeInstances.get((Object)viewType));
    }

    private void resetFilterFlags(List<T> items) {
        for (IFlexibleItem item : items) {
            if (!this.isExpandable(item)) continue;
            IExpandable expandable = (IExpandable)item;
            expandable.setExpanded(false);
            List subItems = expandable.getSubItems();
            for (IFlexibleItem subItem : subItems) {
                subItem.setHidden(false);
            }
        }
    }

    private int createRemovedSubItem(IExpandable parent, T item, boolean notifyParentChanged) {
        int parentPosition = this.getGlobalPositionOf(parent);
        List<T> siblings = this.getExpandableList(parent);
        int childPosition = siblings.indexOf(item);
        item.setHidden(true);
        this.mRemovedItems.add(new RemovedItem<T>(parentPosition, childPosition, parent, item, notifyParentChanged));
        if (DEBUG) {
            Log.v((String)TAG, (String)("Recycled Child " + this.mRemovedItems.get(this.mRemovedItems.size() - 1) + " with Parent position=" + parentPosition));
        }
        return parentPosition;
    }

    private void createRemovedItem(int position, T item) {
        if (this.isExpandable(item) && ((IExpandable)item).isExpanded()) {
            this.collapse(position);
        }
        item.setHidden(true);
        this.mRemovedItems.add(new RemovedItem<T>(position, item));
        if (DEBUG) {
            Log.v((String)TAG, (String)("Recycled Parent " + this.mRemovedItems.get(this.mRemovedItems.size() - 1) + " on position=" + position));
        }
    }

    private List<T> getExpandableList(IExpandable parent) {
        ArrayList<IFlexibleItem> subItems = new ArrayList<IFlexibleItem>();
        if (parent != null && parent.getSubItems() != null) {
            List allSubItems = parent.getSubItems();
            for (IFlexibleItem subItem : allSubItems) {
                if (subItem.isHidden()) continue;
                subItems.add(subItem);
            }
        }
        return subItems;
    }

    private boolean hasSubItemsSelected(IExpandable item) {
        for (IFlexibleItem subItem : this.getExpandableList(item)) {
            if (!this.isSelected(this.getGlobalPositionOf(subItem))) continue;
            return true;
        }
        return false;
    }

    private void autoScroll(int position, int subItemsCount) {
        int firstVisibleItem = ((LinearLayoutManager)this.mRecyclerView.getLayoutManager()).findFirstCompletelyVisibleItemPosition();
        int lastVisibleItem = ((LinearLayoutManager)this.mRecyclerView.getLayoutManager()).findLastCompletelyVisibleItemPosition();
        int itemsToShow = position + subItemsCount - lastVisibleItem;
        if (DEBUG) {
            Log.v((String)TAG, (String)("itemsToShow=" + itemsToShow + " firstVisibleItem=" + firstVisibleItem + " lastVisibleItem=" + lastVisibleItem + " RvChildCount=" + this.mRecyclerView.getChildCount()));
        }
        if (itemsToShow > 0) {
            int scrollMax = position - firstVisibleItem;
            int scrollMin = Math.max(0, position + subItemsCount - lastVisibleItem);
            int scrollBy = Math.min(scrollMax, scrollMin);
            int fix = 0;
            int scrollTo = firstVisibleItem + scrollBy - fix;
            if (DEBUG) {
                Log.v((String)TAG, (String)("scrollMin=" + scrollMin + " scrollMax=" + scrollMax + " scrollBy=" + scrollBy + " scrollTo=" + scrollTo + " fix=" + fix));
            }
            this.mRecyclerView.smoothScrollToPosition(scrollTo);
        } else if (position < firstVisibleItem) {
            this.mRecyclerView.smoothScrollToPosition(position);
        }
    }

    private void adjustSelected(int startPosition, int itemCount) {
        List<Integer> selectedPositions = this.getSelectedPositions();
        boolean adjusted = false;
        for (Integer position : selectedPositions) {
            if (position < startPosition) continue;
            if (DEBUG) {
                Log.v((String)TAG, (String)("Adjust Selected position " + position + " to " + Math.max(position + itemCount, startPosition)));
            }
            selectedPositions.set(selectedPositions.indexOf(position), Math.max(position + itemCount, startPosition));
            adjusted = true;
        }
        if (DEBUG && adjusted) {
            Log.v((String)TAG, (String)("AdjustedSelected=" + this.getSelectedPositions()));
        }
    }

    private void adjustRemoved(int startPosition, int itemCount) {
        boolean adjusted = false;
        int skipped = 0;
        for (int i = this.mRemovedItems.size() - 1; i >= 0; --i) {
            RemovedItem removedItem = this.mRemovedItems.get(i);
            if (removedItem.parentPosition >= startPosition + skipped) {
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Adjust Removed startPosition " + (startPosition + skipped) + " / parentPosition " + removedItem.parentPosition + " to " + Math.max(removedItem.parentPosition + itemCount, startPosition) + (removedItem.relativePosition >= 0 ? " for childPosition " + removedItem.relativePosition : "")));
                }
                removedItem.parentPosition = Math.max(removedItem.parentPosition + itemCount, startPosition);
                adjusted = true;
                continue;
            }
            if (!(removedItem.item instanceof IExpandable)) continue;
            ++skipped;
        }
        if (DEBUG && adjusted) {
            Log.v((String)TAG, (String)("AdjustedRemoved=" + this.getDeletedPositions()));
        }
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (DEBUG) {
            Log.v((String)TAG, (String)"SaveInstanceState for expanded items");
        }
        outState.putBoolean(EXTRA_CHILD, this.childSelected);
        outState.putBoolean(EXTRA_PARENT, this.parentSelected);
    }

    @Override
    public void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.parentSelected = savedInstanceState.getBoolean(EXTRA_PARENT);
        this.childSelected = savedInstanceState.getBoolean(EXTRA_CHILD);
    }

    private static class RemovedItem<T extends IFlexibleItem> {
        int parentPosition = -1;
        int relativePosition = -1;
        IExpandable expandable = null;
        T item = null;
        boolean notifyParentChanged = false;

        public RemovedItem(int parentPosition, T item) {
            this(parentPosition, -1, null, item, false);
        }

        public RemovedItem(int parentPosition, int relativePosition, IExpandable expandable, T item, boolean notifyParentChanged) {
            this.parentPosition = parentPosition;
            this.relativePosition = relativePosition;
            this.expandable = expandable;
            this.item = item;
            this.notifyParentChanged = notifyParentChanged;
        }

        public void adjustBy(int itemCount) {
            this.parentPosition += itemCount;
        }

        public String toString() {
            return "RemovedItem[parentPosition=" + this.parentPosition + ", relativePosition=" + this.relativePosition + ", item=" + this.item + "]";
        }
    }

    private class ExpandableAdapterDataObserver
    extends RecyclerView.AdapterDataObserver {
        private ExpandableAdapterDataObserver() {
        }

        private void adjustPositions(int positionStart, int itemCount) {
            if (!FlexibleAdapter.this.filtering) {
                if (FlexibleAdapter.this.adjustSelected) {
                    FlexibleAdapter.this.adjustSelected(positionStart, itemCount);
                }
                if (FlexibleAdapter.this.adjustRemoved) {
                    FlexibleAdapter.this.adjustRemoved(positionStart, itemCount);
                }
                FlexibleAdapter.this.adjustSelected = (FlexibleAdapter.this.adjustRemoved = true);
            }
        }

        public void onChanged() {
            FlexibleAdapter.this.expandInitialItems();
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            this.adjustPositions(positionStart, itemCount);
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            this.adjustPositions(positionStart, -itemCount);
        }
    }

    public static interface OnItemSwipeListener {
        public void onItemSwipe(int var1, int var2);
    }

    public static interface OnItemMoveListener {
        public void onItemMove(int var1, int var2);
    }

    public static interface OnItemLongClickListener {
        public void onItemLongClick(int var1);
    }

    public static interface OnItemClickListener {
        public boolean onItemClick(int var1);
    }

    public static interface OnDeleteCompleteListener {
        public void onDeleteConfirmed();
    }

    public static interface OnUpdateListener {
        public void onUpdateEmptyView(int var1);
    }
}

