/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.viewholders;

import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.v4.view.MotionEventCompat;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import eu.davidea.flexibleadapter.FlexibleAdapter;
import eu.davidea.flexibleadapter.helpers.ItemTouchHelperCallback;
import eu.davidea.flexibleadapter.utils.Utils;

public abstract class FlexibleViewHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener,
View.OnLongClickListener,
View.OnTouchListener,
ItemTouchHelperCallback.ViewHolderCallback {
    private static final String TAG = FlexibleViewHolder.class.getSimpleName();
    protected final FlexibleAdapter mAdapter;
    protected int mActionState = 0;
    private boolean mLongClickSkipped = false;

    public FlexibleViewHolder(View view, FlexibleAdapter adapter) {
        super(view);
        this.mAdapter = adapter;
        this.itemView.setOnClickListener((View.OnClickListener)this);
        this.itemView.setOnLongClickListener((View.OnLongClickListener)this);
    }

    @CallSuper
    public void onClick(View view) {
        if (this.mAdapter.mItemClickListener != null && this.mActionState == 0) {
            int position = this.getAdapterPosition();
            if (FlexibleAdapter.DEBUG) {
                Log.v((String)TAG, (String)("onClick on position " + position + " mode=" + this.mAdapter.getMode()));
            }
            if (this.mAdapter.mItemClickListener.onItemClick(position) && (!this.mAdapter.isSelected(position) && this.itemView.isActivated() || this.mAdapter.isSelected(position) && !this.itemView.isActivated())) {
                this.toggleActivation();
            }
        }
    }

    @CallSuper
    public boolean onLongClick(View view) {
        if (FlexibleAdapter.DEBUG) {
            Log.v((String)TAG, (String)("onLongClick on position " + this.getAdapterPosition() + " mode=" + this.mAdapter.getMode()));
        }
        if (this.mAdapter.mItemLongClickListener != null && !this.mAdapter.isLongPressDragEnabled()) {
            this.mAdapter.mItemLongClickListener.onItemLongClick(this.getAdapterPosition());
            this.toggleActivation();
            return true;
        }
        this.mLongClickSkipped = true;
        return false;
    }

    public boolean onTouch(View view, MotionEvent event) {
        if (FlexibleAdapter.DEBUG) {
            Log.v((String)TAG, (String)("onTouch with DragHandleView on position " + this.getAdapterPosition() + " mode=" + this.mAdapter.getMode()));
        }
        if (MotionEventCompat.getActionMasked((MotionEvent)event) == 0 && this.mAdapter.isHandleDragEnabled()) {
            this.mAdapter.getItemTouchHelper().startDrag((RecyclerView.ViewHolder)this);
        }
        return false;
    }

    protected final void setDragHandleView(@NonNull View view) {
        if (view != null) {
            view.setOnTouchListener((View.OnTouchListener)this);
        }
    }

    @CallSuper
    protected void toggleActivation() {
        this.itemView.setActivated(this.mAdapter.isSelected(this.getAdapterPosition()));
    }

    protected float getElevation() {
        return Utils.dpToPx(this.itemView.getContext(), 8.0f);
    }

    @Override
    @CallSuper
    public void onActionStateChanged(int position, int actionState) {
        this.mActionState = actionState;
        if (FlexibleAdapter.DEBUG) {
            Log.v((String)TAG, (String)("onActionStateChanged position=" + position + " mode=" + this.mAdapter.getMode() + " actionState=" + (actionState == 1 ? "Swipe(1)" : "Drag(2)")));
        }
        if (actionState == 2) {
            if (!this.mAdapter.isSelected(position)) {
                if (this.mAdapter.mItemLongClickListener != null && (this.mLongClickSkipped || this.mAdapter.getMode() == 2)) {
                    this.mLongClickSkipped = false;
                    this.mAdapter.mItemLongClickListener.onItemLongClick(position);
                } else {
                    this.mAdapter.toggleSelection(position);
                }
            }
            if (!this.mAdapter.isSelected(position) && this.itemView.isActivated() || this.mAdapter.isSelected(position) && !this.itemView.isActivated()) {
                this.toggleActivation();
            }
            if (Utils.hasLollipop()) {
                this.itemView.setElevation(this.getElevation());
            }
        }
    }

    @Override
    @CallSuper
    public void onItemReleased(int position) {
        if (FlexibleAdapter.DEBUG) {
            Log.v((String)TAG, (String)("onItemReleased position=" + position + " mode=" + this.mAdapter.getMode() + " actionState=" + (this.mActionState == 1 ? "Swipe(1)" : "Drag(2)")));
        }
        if (this.mAdapter.getMode() != 2) {
            if (this.mAdapter.isSelected(position)) {
                this.mAdapter.toggleSelection(position);
            }
            if (this.itemView.isActivated()) {
                this.toggleActivation();
            }
        }
        if (Utils.hasLollipop()) {
            this.itemView.setElevation(0.0f);
        }
        this.mActionState = 0;
    }
}

