/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter.items;

import android.util.SparseArray;
import eu.davidea.flexibleadapter.items.AbstractFlexibleItem;
import eu.davidea.flexibleadapter.items.IExpandableItem;
import eu.davidea.viewholders.ExpandableViewHolder;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractExpandableItem<T extends IExpandableItem<T>, VH extends ExpandableViewHolder>
extends AbstractFlexibleItem<T>
implements IExpandableItem<T> {
    T mParent;
    boolean mExpanded = false;
    boolean mExpandable = false;
    List<T> mSubItems;
    SparseArray<T> mRemovedItems = new SparseArray();

    @Override
    public boolean isExpandable() {
        return this.mExpandable;
    }

    @Override
    public void setExpandable(boolean expandable) {
        this.mExpandable = expandable;
    }

    @Override
    public boolean isExpanded() {
        return this.mExpanded;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.mExpanded = expanded;
    }

    public void setInitiallyExpanded(boolean expanded) {
        this.mExpanded = expanded;
    }

    public T getParent() {
        return this.mParent;
    }

    @Override
    public final void setParent(T item) {
        this.mParent = item;
    }

    public boolean hasSubItems() {
        return this.mSubItems != null && this.mSubItems.size() > 0;
    }

    @Override
    public List<T> getSubItems() {
        return this.mSubItems;
    }

    public void setSubItems(List<T> items) {
        for (IExpandableItem item : items) {
            item.setParent(this);
        }
        this.mSubItems = new ArrayList<T>(items);
    }

    @Override
    public int getSubItemsCount() {
        return this.mSubItems != null ? this.mSubItems.size() : 0;
    }

    public T getSubItem(int position) {
        if (this.mSubItems != null && position >= 0 && position < this.mSubItems.size()) {
            return (T)((IExpandableItem)this.mSubItems.get(position));
        }
        return null;
    }

    public int getSubItemPosition(T item) {
        return this.mSubItems.indexOf(item);
    }

    public void addSubItem(T item) {
        if (this.mSubItems == null) {
            this.mSubItems = new ArrayList<T>();
        }
        item.setParent((AbstractExpandableItem)this);
        this.mSubItems.add(item);
    }

    public void addSubItem(int position, T item) {
        if (this.mSubItems != null && position >= 0 && position < this.mSubItems.size()) {
            item.setParent((AbstractExpandableItem)this);
            this.mSubItems.add(position, item);
        } else {
            this.addSubItem(item);
        }
    }

    public boolean contains(T item) {
        return this.mSubItems != null && this.mSubItems.contains(item);
    }

    public boolean removeSubItem(T item) {
        int position = this.mSubItems.indexOf(item);
        if (this.mSubItems != null && position >= 0) {
            this.mRemovedItems.put(position, item);
            return this.mSubItems.remove(item);
        }
        return false;
    }

    public boolean removeSubItem(int position) {
        if (this.mSubItems != null && position >= 0 && position < this.mSubItems.size()) {
            this.mRemovedItems.put(position, this.mSubItems.remove(position));
            return true;
        }
        return false;
    }

    public void restoreDeletedSubItems() {
        for (int i = 0; i < this.mRemovedItems.size(); ++i) {
            int position = this.mRemovedItems.keyAt(i);
            if (position < 0) continue;
            this.addSubItem(position, (IExpandableItem)this.mRemovedItems.get(position));
        }
    }

    public String toString() {
        return ", mExpanded=" + this.mExpanded + ", mExpandable=" + this.mExpandable + ", mSubItems=" + (this.mSubItems != null ? Integer.valueOf(this.mSubItems.size()) : "null");
    }
}

