/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.util.SparseArray;
import android.view.ViewGroup;
import eu.davidea.flexibleadapter.FlexibleAdapter;
import eu.davidea.flexibleadapter.items.IExpandableItem;
import eu.davidea.viewholders.ExpandableViewHolder;
import eu.davidea.viewholders.FlexibleViewHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public abstract class FlexibleExpandableAdapter<EVH extends ExpandableViewHolder, T extends IExpandableItem<T>>
extends FlexibleAdapter<FlexibleViewHolder, T> {
    private static final String TAG = FlexibleExpandableAdapter.class.getSimpleName();
    private static final String EXTRA_PARENT = TAG + "_parentSelected";
    private static final String EXTRA_CHILD = TAG + "_childSelected";
    public static final int EXPANDABLE_VIEW_TYPE = -1;
    private SparseArray<List<T>> expandedItems = new SparseArray();
    private List<RemovedItem> removedItems = new ArrayList<RemovedItem>();
    boolean childSelected = false;
    boolean parentSelected = false;
    boolean scrollOnExpand = false;
    boolean collapseOnExpand = false;
    boolean adjustRemoved = true;
    boolean adjustSelected = true;
    boolean filtering = false;

    public FlexibleExpandableAdapter(@NonNull List<T> items) {
        this(items, null);
    }

    public FlexibleExpandableAdapter(@NonNull List<T> items, Object listener) {
        super(items, listener);
        this.expandInitialItems();
        this.registerAdapterDataObserver(new ExpandableAdapterDataObserver());
    }

    protected void expandInitialItems() {
        for (int i = 0; i < this.mItems.size(); ++i) {
            IExpandableItem item = (IExpandableItem)this.getItem(i);
            if (item == null || !item.isExpanded() || item.getSubItemsCount() <= 0) continue;
            if (DEBUG) {
                Log.v((String)TAG, (String)("Initially expand item on position " + i));
            }
            List<IExpandableItem> subItems = this.getCurrentChildren(item);
            this.expandedItems.put(i, subItems);
            this.mItems.addAll(i + 1, subItems);
            i += subItems.size();
        }
    }

    @Override
    public void toggleSelection(int position) {
        IExpandableItem item = (IExpandableItem)this.getItem(position);
        if (item != null && item.isSelectable()) {
            if (item.isExpandable() && !this.childSelected) {
                this.parentSelected = true;
                super.toggleSelection(position);
            } else if (!item.isExpandable() && !this.parentSelected) {
                this.childSelected = true;
                super.toggleSelection(position);
            }
        }
        if (this.getSelectedItemCount() == 0) {
            this.childSelected = false;
            this.parentSelected = false;
        }
    }

    @Override
    public void selectAll(Integer ... viewTypes) {
        IExpandableItem item = (IExpandableItem)this.getItem(this.getSelectedPositions().get(0));
        if (this.getSelectedItemCount() > 0 && item != null && item.isExpandable()) {
            super.selectAll(-1);
        } else {
            super.selectAll(viewTypes);
        }
    }

    @Override
    @CallSuper
    public void clearSelection() {
        this.childSelected = false;
        this.parentSelected = false;
        super.clearSelection();
    }

    public boolean isAnyParentSelected() {
        return this.parentSelected;
    }

    public boolean isAnyChildSelected() {
        return this.childSelected;
    }

    public void setAutoCollapseOnExpand(boolean collapseOnExpand) {
        this.collapseOnExpand = collapseOnExpand;
    }

    public void setAutoScrollOnExpand(boolean scrollOnExpand) {
        this.scrollOnExpand = scrollOnExpand;
    }

    public boolean isExpanded(int position) {
        return this.expandedItems.indexOfKey(position) >= 0;
    }

    public boolean isExpandable(int position) {
        IExpandableItem item = (IExpandableItem)this.getItem(position);
        return item != null && item.isExpandable();
    }

    public T getExpandableOf(T child) {
        return (T)((IExpandableItem)this.getItem(this.getExpandablePositionOf(child)));
    }

    public int getExpandablePositionOf(T child) {
        int index = this.getExpandableIndexOf(child);
        if (index >= 0) {
            return this.expandedItems.keyAt(this.getExpandableIndexOf(child));
        }
        return -1;
    }

    public int getRelativePositionOf(T child) {
        return this.getSiblingsOf(child).indexOf(child);
    }

    public List<T> getSiblingsOf(T child) {
        int index = this.getExpandableIndexOf(child);
        if (index >= 0) {
            return (List)this.expandedItems.valueAt(index);
        }
        return new ArrayList();
    }

    public List<T> getExpandedItems() {
        int length = this.expandedItems.size();
        ArrayList expandedItems = new ArrayList(length);
        for (int i = 0; i < length; ++i) {
            expandedItems.add(this.getItem(this.expandedItems.keyAt(i)));
        }
        return expandedItems;
    }

    public List<Integer> getExpandedPositions() {
        int length = this.expandedItems.size();
        ArrayList<Integer> expandedItems = new ArrayList<Integer>(length);
        for (int i = 0; i < length; ++i) {
            expandedItems.add(this.expandedItems.keyAt(i));
        }
        return expandedItems;
    }

    public int getItemViewType(int position) {
        IExpandableItem item = (IExpandableItem)this.getItem(position);
        if (item != null && item.isExpandable()) {
            return -1;
        }
        return super.getItemViewType(position);
    }

    public abstract EVH onCreateExpandableViewHolder(ViewGroup var1, int var2);

    public abstract FlexibleViewHolder onCreateFlexibleViewHolder(ViewGroup var1, int var2);

    @Override
    public final FlexibleViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == -1) {
            return this.onCreateExpandableViewHolder(parent, viewType);
        }
        return this.onCreateFlexibleViewHolder(parent, viewType);
    }

    public abstract void onBindExpandableViewHolder(EVH var1, int var2);

    public abstract void onBindFlexibleViewHolder(FlexibleViewHolder var1, int var2);

    @Override
    public final void onBindViewHolder(FlexibleViewHolder holder, int position) {
        if (this.getItemViewType(position) == -1) {
            this.onBindExpandableViewHolder((ExpandableViewHolder)holder, position);
        } else {
            this.onBindFlexibleViewHolder(holder, position);
        }
    }

    public int expand(int position) {
        return this.expand(position, false);
    }

    private int expand(int position, boolean expandAll) {
        IExpandableItem item = (IExpandableItem)this.getItem(position);
        if (DEBUG) {
            Log.v((String)TAG, (String)("Request to Expand on position " + position + " expanded " + (item != null ? Boolean.valueOf(item.isExpanded()) : "false") + " ExpandedItems=" + this.getExpandedPositions()));
        }
        int subItemsCount = 0;
        if (item != null && item.isExpandable() && !item.isExpanded() && item.getSubItemsCount() > 0 && !this.parentSelected) {
            if (this.collapseOnExpand && !expandAll && this.collapseAll() > 0) {
                position = this.getGlobalPositionOf(item);
            }
            List<IExpandableItem> subItems = this.getCurrentChildren(item);
            this.mItems.addAll(position + 1, subItems);
            subItemsCount = subItems.size();
            item.setExpanded(true);
            this.expandedItems.put(position, subItems);
            if (this.scrollOnExpand) {
                final int pos = position;
                final int count = subItemsCount;
                Handler animatorHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

                    public boolean handleMessage(Message message) {
                        FlexibleExpandableAdapter.this.autoScroll(pos, count);
                        return true;
                    }
                });
                animatorHandler.sendMessageDelayed(Message.obtain((Handler)this.mHandler), 150L);
            }
            this.notifyItemRangeInserted(position + 1, subItemsCount);
            if (DEBUG) {
                Log.v((String)TAG, (String)("Expanded " + subItemsCount + " subItems on position=" + position + " ExpandedItems=" + this.getExpandedPositions()));
            }
        }
        return subItemsCount;
    }

    public int expandAll() {
        int expanded = 0;
        for (int i = 0; i < this.mItems.size() - 1; ++i) {
            if (this.expand(i, true) <= 0) continue;
            ++expanded;
        }
        return expanded;
    }

    public int collapse(int position) {
        Log.v((String)TAG, (String)("Request to Collapse on position " + position + " ExpandedItems=" + this.getExpandedPositions()));
        IExpandableItem item = (IExpandableItem)this.getItem(position);
        int subItemsCount = 0;
        if (item != null && item.isExpandable() && item.isExpanded() && (!this.hasSubItemsSelected(position) || this.isExpandablePendingRemove(position))) {
            List<T> subItems = this.getExpandableList(position);
            this.mItems.removeAll(subItems);
            subItemsCount = subItems.size();
            item.setExpanded(false);
            int indexOfKey = this.expandedItems.indexOfKey(position);
            if (indexOfKey >= 0) {
                this.expandedItems.removeAt(indexOfKey);
            }
            this.notifyItemRangeRemoved(position + 1, subItemsCount);
            if (DEBUG) {
                Log.v((String)TAG, (String)("Collapsed " + subItemsCount + " subItems on position=" + position + " ExpandedItems=" + this.getExpandedPositions()));
            }
        }
        return subItemsCount;
    }

    public int collapseAll() {
        int collapsed = 0;
        for (int i = this.expandedItems.size() - 1; i >= 0; --i) {
            if (this.collapse(this.expandedItems.keyAt(i)) <= 0) continue;
            ++collapsed;
        }
        return collapsed;
    }

    public boolean addSubItem(int parentPosition, int subPosition, @NonNull T item) {
        return this.addSubItem(parentPosition, subPosition, item, false, false);
    }

    public boolean addSubItem(int parentPosition, int subPosition, @NonNull T item, boolean expandParent, boolean notifyParentChanged) {
        IExpandableItem parent = (IExpandableItem)this.getItem(parentPosition);
        boolean added = false;
        if (parent != null && parent.isExpandable() && !item.isExpandable()) {
            if (expandParent && !parent.isExpanded()) {
                this.expand(parentPosition);
            }
            if (parent.isExpanded()) {
                this.addItemIn(this.getExpandableList(parentPosition), subPosition, item);
                super.addItem(parentPosition + 1 + Math.max(0, subPosition), item);
                added = true;
            }
            if (notifyParentChanged) {
                this.notifyItemChanged(parentPosition);
            }
        }
        return added;
    }

    private boolean addItemIn(List<T> list, int position, T item) {
        if (list == null) {
            list = new ArrayList<T>(1);
        }
        if (position >= 0 && position < list.size()) {
            list.add(position, item);
        } else {
            list.add(item);
        }
        return true;
    }

    public void addExpandableItem(int position, @NonNull T expandableItem) {
        super.addItem(position, expandableItem);
    }

    @Override
    public void removeItem(int position) {
        this.removeItem(position, false);
    }

    public void removeItem(int position, boolean notifyParentChanged) {
        IExpandableItem item = (IExpandableItem)this.getItem(position);
        if (item == null) {
            Log.w((String)TAG, (String)"Cannot removeItem on position out of OutOfBound!");
            return;
        }
        if (!item.isExpandable()) {
            if (DEBUG) {
                Log.v((String)TAG, (String)("removeItem Child:" + this.removedItems));
            }
            int parentPosition = this.createRemovedSubItem(item, notifyParentChanged);
            if (notifyParentChanged) {
                this.notifyItemChanged(parentPosition);
            }
        } else {
            if (DEBUG) {
                Log.v((String)TAG, (String)("removeItem Parent:" + this.removedItems));
            }
            this.createRemovedItem(position, item);
        }
        super.removeItem(position);
    }

    @Override
    public void removeItems(List<Integer> selectedPositions) {
        this.removeItems(selectedPositions, false);
    }

    public void removeItems(List<Integer> selectedPositions, boolean notifyParentChanged) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("removeItems selectedPositions=" + selectedPositions + " notifyParentChanged=" + notifyParentChanged));
        }
        if (selectedPositions == null || selectedPositions.isEmpty()) {
            return;
        }
        Collections.sort(selectedPositions, new Comparator<Integer>(){

            @Override
            public int compare(Integer lhs, Integer rhs) {
                return rhs - lhs;
            }
        });
        if (DEBUG) {
            Log.v((String)TAG, (String)("removeItems after reverse sort selectedPositions=" + selectedPositions));
        }
        int positionStart = 0;
        int itemCount = 0;
        int lastPosition = selectedPositions.get(0);
        this.isMultiRange = true;
        for (Integer position : selectedPositions) {
            if (lastPosition - itemCount == position) {
                ++itemCount;
                positionStart = position;
            } else {
                if (itemCount > 0) {
                    this.removeRange(positionStart, itemCount, notifyParentChanged);
                }
                positionStart = lastPosition = position.intValue();
                itemCount = 1;
            }
            this.collapse(position);
        }
        this.isMultiRange = false;
        if (itemCount > 0) {
            this.removeRange(positionStart, itemCount, notifyParentChanged);
        }
    }

    @Override
    public void removeRange(int positionStart, int itemCount) {
        this.removeRange(positionStart, itemCount, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRange(int positionStart, int itemCount, boolean notifyParentChanged) {
        int initialCount = this.getItemCount();
        if (DEBUG) {
            Log.v((String)TAG, (String)("removeRange positionStart=" + positionStart + " itemCount=" + itemCount));
        }
        if (positionStart < 0 || positionStart + itemCount > initialCount) {
            Log.w((String)TAG, (String)"Cannot removeRange with positionStart out of OutOfBounds!");
            return;
        }
        int parentPosition = -1;
        for (int position = positionStart + itemCount - 1; position >= positionStart; --position) {
            IExpandableItem item = (IExpandableItem)this.getItem(position);
            if (item == null) continue;
            if (!item.isExpandable()) {
                parentPosition = this.createRemovedSubItem(item, notifyParentChanged);
            } else {
                this.createRemovedItem(position, item);
            }
            Object object = this.mLock;
            synchronized (object) {
                this.mItems.remove(position);
                continue;
            }
        }
        if (parentPosition >= 0) {
            this.adjustSelected = false;
            this.notifyItemRangeRemoved(positionStart, itemCount);
            if (notifyParentChanged) {
                this.notifyItemChanged(parentPosition);
            }
        } else {
            this.adjustRemoved = false;
            this.notifyItemRangeRemoved(positionStart, itemCount);
        }
        if (this.mUpdateListener != null && !this.isMultiRange && initialCount != this.getItemCount()) {
            this.mUpdateListener.onUpdateEmptyView(this.getItemCount());
        }
    }

    @Override
    public void removeAllSelectedItems() {
        this.removeAllSelectedItems(false);
    }

    public void removeAllSelectedItems(boolean notifyParentChanged) {
        this.removeItems(this.getSelectedPositions(), notifyParentChanged);
    }

    @Override
    public boolean shouldMove(int fromPosition, int toPosition) {
        boolean move = false;
        return true;
    }

    @Override
    public boolean onItemMove(int fromPosition, int toPosition) {
        return super.onItemMove(fromPosition, toPosition);
    }

    private boolean isExpandablePendingRemove(int parentPosition) {
        for (RemovedItem removedItem : this.removedItems) {
            if (removedItem.parentPosition != parentPosition) continue;
            return true;
        }
        return false;
    }

    private boolean isItemPendingRemove(T item) {
        for (RemovedItem removedItem : this.removedItems) {
            if (!removedItem.item.equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void restoreDeletedItems() {
        this.stopUndoTimer();
        Collections.sort(this.removedItems, new Comparator<RemovedItem>(){

            @Override
            public int compare(RemovedItem lhs, RemovedItem rhs) {
                return rhs.parentPosition - lhs.parentPosition;
            }
        });
        this.isMultiRange = true;
        int initialCount = this.getItemCount();
        for (int i = this.removedItems.size() - 1; i >= 0; --i) {
            boolean added;
            RemovedItem removedItem = this.removedItems.get(i);
            if (!removedItem.item.isExpandable()) {
                this.adjustSelected = false;
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Restore Child " + removedItem));
                }
                if (this.hasSearchText() && !super.filterObject(removedItem.item, this.getSearchText())) continue;
                added = this.addSubItem(removedItem.parentPosition, removedItem.relativePosition, removedItem.item, false, removedItem.notifyParentChanged);
            } else {
                this.adjustRemoved = false;
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Restore Parent " + removedItem));
                }
                if (this.hasSearchText() && !this.filterObject((T)removedItem.item, this.getSearchText())) continue;
                added = this.addItem(removedItem.parentPosition, removedItem.item);
            }
            if (!this.mRestoreSelection || !added) continue;
            if (!removedItem.item.isExpandable()) {
                this.childSelected = true;
                this.getSelectedPositions().add(removedItem.parentPosition + 1 + removedItem.relativePosition);
                continue;
            }
            this.parentSelected = true;
            this.getSelectedPositions().add(removedItem.parentPosition);
        }
        if (DEBUG && this.mRestoreSelection) {
            Log.v((String)TAG, (String)("Selected positions after restore " + this.getSelectedPositions()));
        }
        this.isMultiRange = false;
        if (this.mUpdateListener != null && initialCount != this.getItemCount()) {
            this.mUpdateListener.onUpdateEmptyView(this.getItemCount());
        }
        this.emptyBin();
    }

    @Override
    public synchronized void emptyBin() {
        super.emptyBin();
        this.removedItems.clear();
    }

    @Override
    public List<T> getDeletedItems() {
        ArrayList deletedItems = new ArrayList();
        for (RemovedItem removedItem : this.removedItems) {
            deletedItems.add(removedItem.item);
        }
        return deletedItems;
    }

    @Override
    public List<Integer> getDeletedPositions() {
        ArrayList<Integer> deletedItems = new ArrayList<Integer>();
        for (RemovedItem removedItem : this.removedItems) {
            if (deletedItems.contains(removedItem.parentPosition)) continue;
            deletedItems.add(removedItem.parentPosition);
        }
        return deletedItems;
    }

    public List<T> getDeletedChildren(int parentPosition) {
        ArrayList deletedChild = new ArrayList();
        for (RemovedItem removedItem : this.removedItems) {
            if (removedItem.parentPosition != parentPosition || removedItem.relativePosition < 0) continue;
            deletedChild.add(removedItem.item);
        }
        return deletedChild;
    }

    public List<T> getCurrentChildren(T item) {
        if (item == null || !item.isExpandable() || item.getSubItems() == null) {
            return new ArrayList();
        }
        ArrayList subItems = new ArrayList(item.getSubItems());
        if (this.removedItems.size() > 0) {
            subItems.removeAll(this.getDeletedChildren(this.getGlobalPositionOf(item)));
        }
        return subItems;
    }

    @Override
    public synchronized void filterItems(@NonNull List<T> unfilteredItems) {
        List<Object> values = new ArrayList();
        this.filtering = true;
        int position = 0;
        int initialCount = this.getItemCount();
        this.expandedItems.clear();
        if (this.hasSearchText()) {
            for (IExpandableItem iExpandableItem : unfilteredItems) {
                if (!this.filterObject((T)iExpandableItem, this.getSearchText()) || this.isItemPendingRemove(iExpandableItem)) continue;
                values.add(iExpandableItem);
                if (iExpandableItem.isExpanded()) {
                    ArrayList<IExpandableItem> subItems = new ArrayList<IExpandableItem>();
                    this.expandedItems.put(position, subItems);
                    for (IExpandableItem subItem : iExpandableItem.getSubItems()) {
                        if (this.isItemPendingRemove(subItem) || subItem.isHidden()) continue;
                        subItems.add(subItem);
                    }
                    values.addAll(subItems);
                    position += subItems.size();
                }
                ++position;
            }
            if (DEBUG) {
                Log.v((String)TAG, (String)("filterItems ExpandedItems=" + this.getExpandedPositions()));
            }
        } else {
            values = unfilteredItems;
            if (!this.removedItems.isEmpty()) {
                values.removeAll(this.getDeletedItems());
            }
            for (IExpandableItem iExpandableItem : values) {
                iExpandableItem.setExpanded(false);
            }
        }
        if (!this.mOldSearchText.equalsIgnoreCase(this.mSearchText)) {
            this.mOldSearchText = this.mSearchText;
            this.animateTo(values);
        } else {
            this.mItems = values;
        }
        this.filtering = false;
        if (this.mUpdateListener != null && initialCount != this.getItemCount()) {
            this.mUpdateListener.onUpdateEmptyView(this.getItemCount());
        }
    }

    @Override
    protected boolean filterObject(T item, String constraint) {
        boolean filtered = false;
        item.setExpanded(false);
        Iterator<T> i$ = this.getCurrentChildren(item).iterator();
        while (i$.hasNext()) {
            IExpandableItem subItem;
            subItem.setHidden(!super.filterObject(subItem = (IExpandableItem)i$.next(), constraint));
            if (filtered || subItem.isHidden()) continue;
            filtered = true;
        }
        item.setExpanded(filtered);
        return filtered || super.filterObject(item, constraint);
    }

    private int createRemovedSubItem(T item, boolean notifyParentChanged) {
        int index = this.getExpandableIndexOf(item);
        int parentPosition = this.expandedItems.keyAt(index);
        List siblings = (List)this.expandedItems.valueAt(index);
        int childPosition = siblings.indexOf(item);
        this.removedItems.add(new RemovedItem<T>(parentPosition, childPosition, item, notifyParentChanged));
        siblings.remove(childPosition);
        if (DEBUG) {
            Log.v((String)TAG, (String)("New RemovedItem Child " + this.removedItems.get(this.removedItems.size() - 1)));
        }
        return parentPosition;
    }

    private void createRemovedItem(int position, T item) {
        if (item.isExpanded()) {
            this.collapse(position);
        }
        this.removedItems.add(new RemovedItem<T>(position, item));
        if (DEBUG) {
            Log.v((String)TAG, (String)("New RemovedItem Parent " + this.removedItems.get(this.removedItems.size() - 1)));
        }
    }

    private int getExpandableIndexOf(T child) {
        if (!child.isExpandable()) {
            for (int i = 0; i < this.expandedItems.size(); ++i) {
                if (!((List)this.expandedItems.valueAt(i)).contains(child)) continue;
                return i;
            }
        }
        return -1;
    }

    private List<T> getExpandableList(int expandablePosition) {
        int index = this.expandedItems.indexOfKey(expandablePosition);
        if (index >= 0) {
            return (List)this.expandedItems.valueAt(index);
        }
        return new ArrayList();
    }

    private boolean hasSubItemsSelected(int position) {
        for (IExpandableItem subItem : this.getExpandableList(position)) {
            if (!this.isSelected(this.getGlobalPositionOf(subItem))) continue;
            return true;
        }
        return false;
    }

    private void autoScroll(int position, int subItemsCount) {
        int firstVisibleItem = ((LinearLayoutManager)this.mRecyclerView.getLayoutManager()).findFirstCompletelyVisibleItemPosition();
        int lastVisibleItem = ((LinearLayoutManager)this.mRecyclerView.getLayoutManager()).findLastCompletelyVisibleItemPosition();
        int itemsToShow = position + subItemsCount - lastVisibleItem;
        if (DEBUG) {
            Log.v((String)TAG, (String)("itemsToShow=" + itemsToShow + " firstVisibleItem=" + firstVisibleItem + " lastVisibleItem=" + lastVisibleItem + " RvChildCount=" + this.mRecyclerView.getChildCount()));
        }
        if (itemsToShow > 0) {
            int scrollMax = position - firstVisibleItem;
            int scrollMin = Math.max(0, position + subItemsCount - lastVisibleItem);
            int scrollBy = Math.min(scrollMax, scrollMin);
            int fix = 0;
            int scrollTo = firstVisibleItem + scrollBy - fix;
            if (DEBUG) {
                Log.v((String)TAG, (String)("scrollMin=" + scrollMin + " scrollMax=" + scrollMax + " scrollBy=" + scrollBy + " scrollTo=" + scrollTo + " fix=" + fix));
            }
            this.mRecyclerView.smoothScrollToPosition(scrollTo);
        } else if (position < firstVisibleItem) {
            this.mRecyclerView.smoothScrollToPosition(position);
        }
    }

    private void adjustSelected(int startPosition, int itemCount) {
        List<Integer> selectedPositions = this.getSelectedPositions();
        boolean adjusted = false;
        for (Integer position : selectedPositions) {
            if (position < startPosition) continue;
            if (DEBUG) {
                Log.v((String)TAG, (String)("Adjust Selected position " + position + " to " + Math.max(position + itemCount, startPosition)));
            }
            selectedPositions.set(selectedPositions.indexOf(position), Math.max(position + itemCount, startPosition));
            adjusted = true;
        }
        if (DEBUG && adjusted) {
            Log.v((String)TAG, (String)("AdjustedSelected=" + this.getSelectedPositions()));
        }
    }

    private void adjustExpanded(int startPosition, int itemCount) {
        boolean adjusted = false;
        for (int i = 0; i < this.expandedItems.size(); ++i) {
            int position = this.expandedItems.keyAt(i);
            if (position < startPosition) continue;
            if (DEBUG) {
                Log.v((String)TAG, (String)("Adjust Expanded from position " + position + " to " + (position + itemCount)));
            }
            this.expandedItems.put(position + itemCount, this.expandedItems.get(position));
            this.expandedItems.remove(position);
            adjusted = true;
        }
        if (DEBUG && adjusted) {
            Log.v((String)TAG, (String)("AdjustedExpanded=" + this.getExpandedPositions()));
        }
    }

    private void adjustRemoved(int startPosition, int itemCount) {
        boolean adjusted = false;
        int skipped = 0;
        for (int i = this.removedItems.size() - 1; i >= 0; --i) {
            RemovedItem removedItem = this.removedItems.get(i);
            if (removedItem.parentPosition >= startPosition + skipped) {
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Adjust Removed startPosition " + (startPosition + skipped) + " / parentPosition " + removedItem.parentPosition + " to " + Math.max(removedItem.parentPosition + itemCount, startPosition) + (removedItem.relativePosition >= 0 ? " for childPosition " + removedItem.relativePosition : "")));
                }
                removedItem.parentPosition = Math.max(removedItem.parentPosition + itemCount, startPosition);
                adjusted = true;
                continue;
            }
            if (!removedItem.item.isExpandable()) continue;
            ++skipped;
        }
        if (DEBUG && adjusted) {
            Log.v((String)TAG, (String)("AdjustedRemoved=" + this.getDeletedPositions()));
        }
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (DEBUG) {
            Log.v((String)TAG, (String)"SaveInstanceState for expanded items");
        }
        outState.putBoolean(EXTRA_CHILD, this.childSelected);
        outState.putBoolean(EXTRA_PARENT, this.parentSelected);
    }

    @Override
    public void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.parentSelected = savedInstanceState.getBoolean(EXTRA_PARENT);
        this.childSelected = savedInstanceState.getBoolean(EXTRA_CHILD);
    }

    private static class RemovedItem<T extends IExpandableItem<T>> {
        int parentPosition = -1;
        int relativePosition = -1;
        T item = null;
        boolean notifyParentChanged = false;

        public RemovedItem(int parentPosition, T item) {
            this(parentPosition, -1, item, false);
        }

        public RemovedItem(int parentPosition, int relativePosition, T item, boolean notifyParentChanged) {
            this.parentPosition = parentPosition;
            this.relativePosition = relativePosition;
            this.item = item;
            this.notifyParentChanged = notifyParentChanged;
        }

        public String toString() {
            return "RemovedItem[parentPosition=" + this.parentPosition + ", relativePosition=" + this.relativePosition + ", item=" + this.item + "]";
        }
    }

    private class ExpandableAdapterDataObserver
    extends RecyclerView.AdapterDataObserver {
        private ExpandableAdapterDataObserver() {
        }

        private void adjustPositions(int positionStart, int itemCount) {
            if (!FlexibleExpandableAdapter.this.filtering) {
                FlexibleExpandableAdapter.this.adjustExpanded(positionStart, itemCount);
                if (FlexibleExpandableAdapter.this.adjustSelected) {
                    FlexibleExpandableAdapter.this.adjustSelected(positionStart, itemCount);
                }
                if (FlexibleExpandableAdapter.this.adjustRemoved) {
                    FlexibleExpandableAdapter.this.adjustRemoved(positionStart, itemCount);
                }
                FlexibleExpandableAdapter.this.adjustRemoved = true;
                FlexibleExpandableAdapter.this.adjustSelected = true;
            }
        }

        public void onChanged() {
            FlexibleExpandableAdapter.this.expandInitialItems();
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            this.adjustPositions(positionStart, itemCount);
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            this.adjustPositions(positionStart, -itemCount);
        }
    }
}

