/*
 * Decompiled with CFR 0.152.
 */
package eu.davidea.flexibleadapter;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.CallSuper;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.util.Log;
import android.util.SparseArray;
import android.view.ViewGroup;
import eu.davidea.flexibleadapter.FlexibleAnimatorAdapter;
import eu.davidea.flexibleadapter.helpers.ItemTouchHelperCallback;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public abstract class FlexibleAdapter<VH extends RecyclerView.ViewHolder, T>
extends FlexibleAnimatorAdapter<VH>
implements ItemTouchHelperCallback.AdapterCallback {
    private static final String TAG = FlexibleAdapter.class.getSimpleName();
    public static final long UNDO_TIMEOUT = 5000L;
    protected List<T> mItems;
    protected boolean isMultiRange = false;
    protected final Object mLock = new Object();
    protected List<T> mDeletedItems;
    protected List<Integer> mOriginalPositions;
    protected SparseArray<T> mRemovedItems;
    protected boolean mRestoreSelection = false;
    protected Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    FlexibleAdapter.this.filterItems((List)message.obj);
                    return true;
                }
                case 1: {
                    OnDeleteCompleteListener listener = (OnDeleteCompleteListener)message.obj;
                    if (listener != null) {
                        listener.onDeleteConfirmed();
                    }
                    FlexibleAdapter.this.emptyBin();
                    return true;
                }
            }
            return false;
        }
    });
    protected String mSearchText = "";
    protected String mOldSearchText = "";
    protected boolean mNotifyChangeOfUnfilteredItems = false;
    private ItemTouchHelperCallback mItemTouchHelperCallback;
    private ItemTouchHelper mItemTouchHelper;
    protected OnUpdateListener mUpdateListener;
    public OnItemClickListener mItemClickListener;
    public OnItemLongClickListener mItemLongClickListener;
    protected OnItemMoveListener mItemMoveListener;
    protected OnItemSwipeListener mItemSwipeListener;

    public FlexibleAdapter(@NonNull List<T> items) {
        this(items, null);
    }

    public FlexibleAdapter(@NonNull List<T> items, @Nullable Object listeners) {
        this.mItems = items;
        if (listeners instanceof OnUpdateListener) {
            this.mUpdateListener = (OnUpdateListener)listeners;
            this.mUpdateListener.onUpdateEmptyView(this.mItems.size());
        }
        if (listeners instanceof OnItemClickListener) {
            this.mItemClickListener = (OnItemClickListener)listeners;
        }
        if (listeners instanceof OnItemLongClickListener) {
            this.mItemLongClickListener = (OnItemLongClickListener)listeners;
        }
        if (listeners instanceof OnItemMoveListener) {
            this.mItemMoveListener = (OnItemMoveListener)listeners;
        }
        if (listeners instanceof OnItemSwipeListener) {
            this.mItemSwipeListener = (OnItemSwipeListener)listeners;
        }
    }

    public void updateDataSet() {
        this.updateDataSet(null);
    }

    public abstract void updateDataSet(String var1);

    public final T getItem(int position) {
        if (position < 0 || position >= this.mItems.size()) {
            return null;
        }
        return this.mItems.get(position);
    }

    public final int getItemCount() {
        return this.mItems != null ? this.mItems.size() : 0;
    }

    public int getItemCountOfType(int viewType) {
        int count = 0;
        for (int i = 0; i < this.mItems.size(); ++i) {
            if (this.getItemViewType(i) != viewType) continue;
            ++count;
        }
        return count;
    }

    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    public int getGlobalPositionOf(@NonNull T item) {
        return this.mItems != null && this.mItems.size() > 0 ? this.mItems.indexOf(item) : -1;
    }

    public boolean contains(@NonNull T item) {
        return this.mItems != null && this.mItems.contains(item);
    }

    public abstract VH onCreateViewHolder(ViewGroup var1, int var2);

    public abstract void onBindViewHolder(VH var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateItem(int position, @NonNull T item) {
        if (position < 0) {
            Log.w((String)TAG, (String)"Cannot updateItem on negative position");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mItems.set(position, item);
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("updateItem notifyItemChanged on position " + position));
        }
        this.notifyItemChanged(position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addItem(int position, @NonNull T item) {
        if (position < 0) {
            Log.w((String)TAG, (String)"Cannot addItem on negative position");
            return false;
        }
        if (position < this.mItems.size()) {
            if (DEBUG) {
                Log.v((String)TAG, (String)("addItem notifyItemInserted on position " + position));
            }
            Object object = this.mLock;
            synchronized (object) {
                this.mItems.add(position, item);
            }
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)"addItem notifyItemInserted on last position");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mItems.add(item);
        }
        position = this.mItems.size();
        this.notifyItemInserted(position);
        if (this.mUpdateListener != null && !this.isMultiRange) {
            this.mUpdateListener.onUpdateEmptyView(this.getItemCount());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addItems(int position, List<T> items) {
        if (position < 0) {
            Log.w((String)TAG, (String)"Cannot addItems on negative position");
            return false;
        }
        if (items == null || items.isEmpty()) {
            Log.w((String)TAG, (String)"No items to add");
            return false;
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("addItems position=" + position + " itemCount=" + items.size()));
        }
        Object object = this.mLock;
        synchronized (object) {
            this.addAllItemsIn(this.mItems, position, items);
        }
        this.notifyItemRangeInserted(position, items.size());
        if (this.mUpdateListener != null && !this.isMultiRange) {
            this.mUpdateListener.onUpdateEmptyView(this.getItemCount());
        }
        return true;
    }

    protected boolean addAllItemsIn(List<T> list, int position, List<T> items) {
        if (items == null || items.isEmpty()) {
            return false;
        }
        if (list == null) {
            list = new ArrayList<T>(items.size());
        }
        if (position >= 0 && position < list.size()) {
            list.addAll(position, items);
        } else {
            list.addAll(items);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItem(int position) {
        if (position < 0 && position >= this.mItems.size()) {
            Log.w((String)TAG, (String)"Cannot removeItem on position out of OutOfBounds!");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.saveDeletedItem(position, this.mItems.remove(position));
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("removeItem notifyItemRemoved on position " + position));
        }
        this.notifyItemRemoved(position);
        if (this.mUpdateListener != null && !this.isMultiRange) {
            this.mUpdateListener.onUpdateEmptyView(this.getItemCount());
        }
    }

    public void removeItems(List<Integer> selectedPositions) {
        if (DEBUG) {
            Log.v((String)TAG, (String)"removeItems reverse Sorting positions");
        }
        Collections.sort(selectedPositions, new Comparator<Integer>(){

            @Override
            public int compare(Integer lhs, Integer rhs) {
                return rhs - lhs;
            }
        });
        this.isMultiRange = true;
        while (!selectedPositions.isEmpty()) {
            int count;
            if (selectedPositions.size() == 1) {
                this.removeItem(selectedPositions.get(0));
                selectedPositions.remove(0);
                continue;
            }
            if (DEBUG) {
                Log.v((String)TAG, (String)("removeItems current selection " + this.getSelectedPositions()));
            }
            for (count = 1; selectedPositions.size() > count && selectedPositions.get(count).equals(selectedPositions.get(count - 1) - 1); ++count) {
            }
            if (count == 1) {
                this.removeItem(selectedPositions.get(0));
            } else {
                this.removeRange(selectedPositions.get(count - 1), count);
            }
            for (int i = 0; i < count; ++i) {
                selectedPositions.remove(0);
            }
        }
        this.isMultiRange = false;
        if (this.mUpdateListener != null) {
            this.mUpdateListener.onUpdateEmptyView(this.getItemCount());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRange(int positionStart, int itemCount) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("removeRange positionStart=" + positionStart + " itemCount=" + itemCount));
        }
        for (int i = 0; i < itemCount; ++i) {
            Object object = this.mLock;
            synchronized (object) {
                this.saveDeletedItem(positionStart, this.mItems.remove(positionStart));
                continue;
            }
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)"removeRange notifyItemRangeRemoved");
        }
        this.notifyItemRangeRemoved(positionStart, itemCount);
    }

    public void removeAllSelectedItems() {
        this.removeItems(this.getSelectedPositions());
    }

    public void saveDeletedItem(int position, @NonNull T item) {
        if (this.mDeletedItems == null) {
            this.mDeletedItems = new ArrayList<T>();
            this.mOriginalPositions = new ArrayList<Integer>();
            this.mRemovedItems = new SparseArray();
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("Recycled " + item + " on position=" + position));
        }
        this.mDeletedItems.add(item);
        this.mOriginalPositions.add(position);
        this.mRemovedItems.put(position, item);
    }

    public List<T> getDeletedItems() {
        return this.mDeletedItems;
    }

    public List<Integer> getDeletedPositions() {
        return this.mOriginalPositions;
    }

    public boolean isRestoreInTime() {
        return this.mDeletedItems != null && this.mDeletedItems.size() > 0;
    }

    public boolean isRestoreWithSelection() {
        return this.mRestoreSelection;
    }

    public void setRestoreSelectionOnUndo(boolean restoreSelection) {
        this.mRestoreSelection = restoreSelection;
    }

    public void restoreDeletedItems() {
        this.stopUndoTimer();
        for (int i = this.mOriginalPositions.size() - 1; i >= 0; --i) {
            T item = this.mDeletedItems.get(i);
            Object item2 = this.mRemovedItems.get(this.mRemovedItems.keyAt(i));
            if (DEBUG) {
                Log.v((String)TAG, (String)("Restoring item " + item + " on position " + this.mOriginalPositions.get(i)));
            }
            if (DEBUG) {
                Log.v((String)TAG, (String)("Restoring item2 " + item2 + " on position " + this.mRemovedItems.keyAt(i)));
            }
            if (this.hasSearchText() && !this.filterObject(item, this.getSearchText())) continue;
            this.addItem(this.mOriginalPositions.get(i), item);
            if (!this.mRestoreSelection) continue;
            this.getSelectedPositions().add(this.mOriginalPositions.get(i));
        }
        this.emptyBin();
    }

    public synchronized void emptyBin() {
        if (this.mDeletedItems != null) {
            this.mDeletedItems.clear();
            this.mOriginalPositions.clear();
            this.mRemovedItems.clear();
        }
    }

    public void startUndoTimer(OnDeleteCompleteListener listener) {
        this.startUndoTimer(0L, listener);
    }

    public void startUndoTimer(long timeout, OnDeleteCompleteListener listener) {
        this.mHandler.removeMessages(1);
        this.mHandler.sendMessageDelayed(Message.obtain((Handler)this.mHandler, (int)1, (Object)listener), timeout > 0L ? timeout : 5000L);
    }

    protected void stopUndoTimer() {
        this.mHandler.removeCallbacksAndMessages(null);
    }

    public boolean hasSearchText() {
        return this.mSearchText != null && this.mSearchText.length() > 0;
    }

    public String getSearchText() {
        return this.mSearchText;
    }

    public void setSearchText(String searchText) {
        this.mSearchText = searchText != null ? searchText.trim().toLowerCase(Locale.getDefault()) : "";
    }

    public final void setNotifyChangeOfUnfilteredItems(boolean notifyChange) {
        this.mNotifyChangeOfUnfilteredItems = notifyChange;
    }

    public void filterItems(@NonNull List<T> unfilteredItems, @IntRange(from=0L) long delay) {
        this.mHandler.removeMessages(0);
        this.mHandler.sendMessageDelayed(Message.obtain((Handler)this.mHandler, (int)0, unfilteredItems), delay > 0L ? delay : 0L);
    }

    public synchronized void filterItems(@NonNull List<T> unfilteredItems) {
        List<Object> values = new ArrayList();
        int initialCount = this.getItemCount();
        if (this.hasSearchText()) {
            int newOriginalPosition = -1;
            int oldOriginalPosition = -1;
            for (T item : unfilteredItems) {
                if (!this.filterObject(item, this.getSearchText())) continue;
                if (this.mDeletedItems != null && this.mDeletedItems.contains(item)) {
                    int index = this.mDeletedItems.indexOf(item);
                    if (this.mOriginalPositions.get(index) != oldOriginalPosition) {
                        ++newOriginalPosition;
                        oldOriginalPosition = this.mOriginalPositions.get(index);
                    }
                    this.mOriginalPositions.set(index, newOriginalPosition + this.mItems.size());
                    continue;
                }
                values.add(item);
            }
        } else {
            values = unfilteredItems;
            if (this.mDeletedItems != null && !this.mDeletedItems.isEmpty()) {
                this.mOriginalPositions = new ArrayList<Integer>(this.mDeletedItems.size());
                for (T item : this.mDeletedItems) {
                    this.mOriginalPositions.add(values.indexOf(item));
                }
                values.removeAll(this.mDeletedItems);
            }
        }
        if (!this.mOldSearchText.equalsIgnoreCase(this.mSearchText)) {
            this.mOldSearchText = this.mSearchText;
            this.animateTo(values);
        } else {
            this.mItems = values;
        }
        if (this.mUpdateListener != null && initialCount != this.getItemCount()) {
            this.mUpdateListener.onUpdateEmptyView(this.getItemCount());
        }
    }

    protected boolean filterObject(T item, String constraint) {
        String[] words;
        String valueText = item.toString().toLowerCase();
        if (valueText.startsWith(constraint)) {
            return true;
        }
        for (String word : words = valueText.split(" ")) {
            if (!word.startsWith(constraint)) continue;
            return true;
        }
        return false;
    }

    public List<T> animateTo(List<T> models) {
        this.applyAndAnimateRemovals(this.mItems, models);
        this.applyAndAnimateAdditions(this.mItems, models);
        this.applyAndAnimateMovedItems(this.mItems, models);
        return this.mItems;
    }

    protected void applyAndAnimateRemovals(List<T> from, List<T> newItems) {
        int out = 0;
        for (int i = from.size() - 1; i >= 0; --i) {
            T item = from.get(i);
            if (!newItems.contains(item)) {
                if (DEBUG) {
                    Log.v((String)TAG, (String)("animateRemovals remove position=" + i + " item=" + item));
                }
                from.remove(i);
                this.notifyItemRemoved(i);
                ++out;
                continue;
            }
            if (!DEBUG) continue;
            Log.v((String)TAG, (String)("animateRemovals   keep position=" + i + " item=" + item));
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("animateRemovals total out=" + out + " in=" + newItems.size()));
        }
    }

    protected void applyAndAnimateAdditions(List<T> from, List<T> newItems) {
        int out = 0;
        int count = newItems.size();
        for (int i = 0; i < count; ++i) {
            T item = newItems.get(i);
            if (!from.contains(item)) {
                if (DEBUG) {
                    Log.v((String)TAG, (String)("animateAdditions  add position=" + i + " item=" + item));
                }
                from.add(i, item);
                this.notifyItemInserted(i);
                continue;
            }
            if (!this.mNotifyChangeOfUnfilteredItems) continue;
            ++out;
            this.notifyItemChanged(i);
            if (!DEBUG) continue;
            Log.v((String)TAG, (String)("animateAdditions keep position=" + i + " item=" + item));
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("animateAdditions total out=" + out + " in=" + newItems.size()));
        }
    }

    protected void applyAndAnimateMovedItems(List<T> from, List<T> newItems) {
        for (int toPosition = newItems.size() - 1; toPosition >= 0; --toPosition) {
            T item = newItems.get(toPosition);
            int fromPosition = from.indexOf(item);
            if (fromPosition < 0 || fromPosition == toPosition) continue;
            if (DEBUG) {
                Log.v((String)TAG, (String)("animateMovedItems from=" + toPosition + " to=" + toPosition));
            }
            from.add(toPosition, from.remove(fromPosition));
            this.moveItem(fromPosition, toPosition);
        }
    }

    public final ItemTouchHelper getItemTouchHelper() {
        this.initializeItemTouchHelper();
        return this.mItemTouchHelper;
    }

    public final void setLongPressDragEnabled(boolean longPressDragEnabled) {
        this.initializeItemTouchHelper();
        this.mItemTouchHelperCallback.setLongPressDragEnabled(longPressDragEnabled);
    }

    public boolean isLongPressDragEnabled() {
        return this.mItemTouchHelperCallback.isLongPressDragEnabled();
    }

    public boolean isHandleDragEnabled() {
        return true;
    }

    public final void setSwipeEnabled(boolean swipeEnabled) {
        this.initializeItemTouchHelper();
        this.mItemTouchHelperCallback.setSwipeEnabled(swipeEnabled);
    }

    public final boolean isSwipeEnabled() {
        return this.mItemTouchHelperCallback.isItemViewSwipeEnabled();
    }

    @CallSuper
    public void moveItem(int fromPosition, int toPosition) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("moveItem from=" + fromPosition + "[" + (this.isSelected(fromPosition) ? "selected" : "unselected") + "] to=" + toPosition + "[" + (this.isSelected(toPosition) ? "selected" : "unselected") + "]"));
            Log.v((String)TAG, (String)("moveItem fromItem=" + this.getItem(fromPosition) + " toItem=" + this.getItem(toPosition)));
        }
        Collections.swap(this.mItems, fromPosition, toPosition);
        if (this.isSelected(fromPosition) && !this.isSelected(toPosition) || !this.isSelected(fromPosition) && this.isSelected(toPosition)) {
            super.toggleSelection(fromPosition);
            super.toggleSelection(toPosition);
        }
        this.notifyItemMoved(fromPosition, toPosition);
    }

    @Override
    public boolean shouldMove(int fromPosition, int toPosition) {
        return true;
    }

    @Override
    @CallSuper
    public boolean onItemMove(int fromPosition, int toPosition) {
        this.moveItem(fromPosition, toPosition);
        if (this.mItemMoveListener != null) {
            this.mItemMoveListener.onItemMove(fromPosition, toPosition);
        }
        return true;
    }

    @Override
    @CallSuper
    public void onItemSwiped(int position, int direction) {
        if (this.mItemSwipeListener != null) {
            this.mItemSwipeListener.onItemSwipe(position, direction);
        }
    }

    private void initializeItemTouchHelper() {
        if (this.mItemTouchHelper == null) {
            if (this.mRecyclerView == null) {
                throw new IllegalStateException("RecyclerView cannot be null. Enabling LongPressDrag or Swipe must be done after the Adapter is added to the RecyclerView.");
            }
            this.mItemTouchHelperCallback = new ItemTouchHelperCallback(this);
            this.mItemTouchHelper = new ItemTouchHelper((ItemTouchHelper.Callback)this.mItemTouchHelperCallback);
            this.mItemTouchHelper.attachToRecyclerView(this.mRecyclerView);
        }
    }

    public static interface OnItemSwipeListener {
        public void onItemSwipe(int var1, int var2);
    }

    public static interface OnItemMoveListener {
        public void onItemMove(int var1, int var2);
    }

    public static interface OnItemLongClickListener {
        public void onItemLongClick(int var1);
    }

    public static interface OnItemClickListener {
        public boolean onItemClick(int var1);
    }

    public static interface OnDeleteCompleteListener {
        public void onDeleteConfirmed();
    }

    public static interface OnUpdateListener {
        public void onUpdateEmptyView(int var1);
    }
}

